/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.navigation;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.jsdl.action.ActionBuilder;
import com.jgoodies.common.jsdl.icon.IconValue;
import com.jgoodies.common.jsdl.internal.WrappedAction;
import com.jgoodies.common.jsdl.util.IconUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.common.swing.internal.AncestorSupport;
import com.jgoodies.components.JGSearchField;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.fluent.navigation.NavigationBar;
import com.jgoodies.fluent.navigation.NavigationPane;
import com.jgoodies.fluent.navigation.SplitView;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.navigation.Page;
import com.jgoodies.navigation.PageFrame;
import com.jgoodies.navigation.PageModel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class NavigationView
extends Bean {
    public static final NavigationViewDisplayMode DEFAULT_DISPLAY_MODE = NavigationViewDisplayMode.LEFT_COMPACT;
    public static final int DEFAULT_COMPACT_MODE_THRESHOLD_WIDTH = 640;
    public static final int DEFAULT_EXPANDED_MODE_THRESHOLD_WIDTH = 1000;
    public static final String PROPERTY_PANE_TITLE = "paneTitle";
    public static final String PROPERTY_HEADER = "header";
    public static final String PROPERTY_CONTENT = "content";
    public static final String PROPERTY_PANE_OPEN_WHEN_LEFT = "paneOpenWhenLeft";
    public static final String PROPERTY_DISPLAY_MODE = "displayMode";
    public static final String PROPERTY_BACK_BUTTON_VISIBLE = "backButtonVisible";
    public static final String PROPERTY_MENU_BUTTON_VISIBLE = "menuButtonVisible";
    public static final String PROPERTY_COMPACT_MODE_THRESHOLD_WIDTH = "compactModeThresholdWidth";
    public static final String PROPERTY_EXPANDED_MODE_THRESHOLD_WIDTH = "expandedModeThresholdWidth";
    private final PageModel pageModel;
    private final Theme theme;
    private NavigationViewDisplayMode displayMode;
    private NavigationViewDisplayMode effectiveDisplayMode;
    private String paneTitle;
    private boolean backButtonVisible = true;
    private boolean menuButtonVisible = true;
    private JGSearchField optionalSearchField;
    private NavigationItem settingsItem;
    private JComponent header;
    private JComponent content;
    private int compactModeThresholdWidth = 640;
    private int expandedModeThresholdWidth = 1000;
    private final List<Action> headerActions = new ArrayList<Action>();
    private final List<NavigationElement> elements = new ArrayList<NavigationElement>();
    private final List<Action> footerActions = new ArrayList<Action>();
    private final SplitView splitView;
    private JPanel panel;
    private boolean paneOpenWhenLeft = true;

    NavigationView(PageModel pageModel, NavigationViewDisplayMode displayMode, Theme theme) {
        this.pageModel = pageModel;
        this.theme = Preconditions.checkNotNull(theme, "The %s must not be null.", "theme");
        this.splitView = new SplitView(SplitView.SplitViewDisplayMode.COMPACT_INLINE);
        this.setDisplayMode(Preconditions.checkNotNull(displayMode, "The %s must not be null.", PROPERTY_DISPLAY_MODE));
    }

    public String getPaneTitle() {
        return this.paneTitle;
    }

    public void setPaneTitle(String newTitle) {
        this.paneTitle = newTitle;
        this.firePropertyChange(PROPERTY_PANE_TITLE, this.paneTitle, this.paneTitle);
        this.rebuild();
    }

    public JComponent getHeader() {
        return this.header;
    }

    public void setHeader(JComponent newHeader) {
        this.header = newHeader;
        this.firePropertyChange(PROPERTY_HEADER, this.header, this.header);
        this.rebuild();
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setContent(JComponent newContent) {
        Preconditions.checkNotNull(newContent, "The %s must not be null.", PROPERTY_CONTENT);
        this.content = newContent;
        this.firePropertyChange(PROPERTY_CONTENT, this.content, this.content);
        this.rebuild();
    }

    public NavigationViewDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(NavigationViewDisplayMode newMode) {
        Preconditions.checkNotNull(newMode, "The %s must not be null.", PROPERTY_DISPLAY_MODE);
        NavigationViewDisplayMode oldMode = this.displayMode;
        if (oldMode == newMode) {
            return;
        }
        this.displayMode = newMode;
        this.updateEffectiveDisplayMode();
        this.firePropertyChange(PROPERTY_DISPLAY_MODE, (Object)oldMode, (Object)newMode);
    }

    public boolean isBackButtonVisible() {
        return this.backButtonVisible;
    }

    public void setBackButtonVisible(boolean visible) {
        this.backButtonVisible = visible;
        this.firePropertyChange(PROPERTY_BACK_BUTTON_VISIBLE, this.backButtonVisible, this.backButtonVisible);
        this.rebuild();
    }

    public boolean isMenuButtonVisible() {
        return this.menuButtonVisible;
    }

    public void setMenuButtonVisible(boolean visible) {
        this.menuButtonVisible = visible;
        this.firePropertyChange(PROPERTY_MENU_BUTTON_VISIBLE, this.menuButtonVisible, this.menuButtonVisible);
        this.rebuild();
    }

    public int getCompactModeThresholdWidth() {
        return this.compactModeThresholdWidth;
    }

    public void setCompactModeThresholdWidth(int width) {
        this.compactModeThresholdWidth = width;
        this.firePropertyChange(PROPERTY_COMPACT_MODE_THRESHOLD_WIDTH, this.compactModeThresholdWidth, this.compactModeThresholdWidth);
        this.rebuild();
    }

    public int getExpandedModeThresholdWidth() {
        return this.expandedModeThresholdWidth;
    }

    public void setExpandedModeThresholdWidth(int width) {
        this.expandedModeThresholdWidth = width;
        this.firePropertyChange(PROPERTY_EXPANDED_MODE_THRESHOLD_WIDTH, this.expandedModeThresholdWidth, this.expandedModeThresholdWidth);
        this.rebuild();
    }

    public boolean isPaneOpen() {
        return this.splitView.isPaneOpen();
    }

    public void setPaneOpen(boolean open) {
        this.splitView.setPaneOpen(open);
        if (this.effectiveDisplayMode == NavigationViewDisplayMode.LEFT) {
            this.setPaneOpenWhenLeft(open);
        }
    }

    public boolean getPaneOpenWhenLeft() {
        return this.paneOpenWhenLeft;
    }

    public void setPaneOpenWhenLeft(boolean open) {
        this.paneOpenWhenLeft = open;
        this.firePropertyChange(PROPERTY_PANE_OPEN_WHEN_LEFT, this.paneOpenWhenLeft, this.paneOpenWhenLeft);
        if (this.effectiveDisplayMode == NavigationViewDisplayMode.LEFT) {
            this.splitView.setPaneOpen(open);
        }
    }

    public JComponent getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(null);
            this.panel.setOpaque(false);
            this.panel.addHierarchyListener(evt -> {
                if ((evt.getChangeFlags() & 4L) != 0L) {
                    this.updateEffectiveDisplayMode();
                }
            });
            this.panel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    NavigationView.this.updateEffectiveDisplayMode();
                }
            });
            this.rebuild();
        }
        return this.panel;
    }

    void addHeader(Action action) {
        this.headerActions.add(action);
    }

    void addElement(NavigationElement element) {
        this.elements.add(element);
    }

    void addFooter(Action action) {
        this.footerActions.add(action);
    }

    void setSearchField(JGSearchField searchField) {
        this.optionalSearchField = searchField;
    }

    void setSettings(NavigationItem settingsItem) {
        this.settingsItem = settingsItem;
    }

    private void rebuild() {
        if (this.panel == null) {
            return;
        }
        this.panel.removeAll();
        if (this.effectiveDisplayMode == NavigationViewDisplayMode.TOP) {
            this.buildTop();
        } else {
            this.buildLeft();
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void buildTop() {
        ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:0:grow", new Object[0])).rows("p, f:0:g", new Object[0])).panel(this.panel)).add(this.buildPane(NavigationPane.LayoutMode.TOP)).xy(1, 1)).add(this.buildContentWithHeader(false)).xy(1, 2);
    }

    private void buildLeft() {
        this.updateSplitViewMode();
        JComponent pane = this.buildPane(this.effectiveDisplayMode == NavigationViewDisplayMode.LEFT_MINIMAL ? NavigationPane.LayoutMode.LEFT_MINIMAL_OPEN : NavigationPane.LayoutMode.LEFT_OPEN);
        JComponent compactPane = this.buildPane(this.effectiveDisplayMode == NavigationViewDisplayMode.LEFT_MINIMAL ? NavigationPane.LayoutMode.LEFT_MINIMAL : NavigationPane.LayoutMode.LEFT_COMPACT);
        boolean needsPhantomSpacer = this.isMenuButtonVisible() && this.effectiveDisplayMode == NavigationViewDisplayMode.LEFT_MINIMAL;
        JComponent content = this.buildContentWithHeader(needsPhantomSpacer);
        this.splitView.setPaneAndContent(pane, compactPane, content);
        if (this.effectiveDisplayMode == NavigationViewDisplayMode.LEFT) {
            this.setPaneOpen(this.paneOpenWhenLeft);
        }
        ((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:0:grow", new Object[0])).rows("f:0:g", new Object[0])).panel(this.panel)).add(this.splitView).xy(1, 1);
    }

    private JComponent buildPane(NavigationPane.LayoutMode layoutMode) {
        NavigationPane pane = new NavigationPane(layoutMode, this.theme, this.pageModel);
        if (layoutMode.isLeftMinimal()) {
            if (this.isMenuButtonVisible()) {
                pane.addMenuButton(layoutMode.isLeftOpen() ? this.getPaneTitle() : null, this::onMenuButtonPerformed);
            }
            return pane.buildPanel();
        }
        if (layoutMode == NavigationPane.LayoutMode.LEFT_MINIMAL_OPEN) {
            if (this.isMenuButtonVisible()) {
                pane.addMenuButton(layoutMode.isLeftOpen() ? this.getPaneTitle() : null, this::onMenuButtonPerformed);
            }
            if (this.isBackButtonVisible()) {
                pane.addBackButton();
            }
        } else {
            if (this.isBackButtonVisible() && layoutMode.hasBackButton()) {
                pane.addBackButton();
            }
            if (this.isMenuButtonVisible() && layoutMode.isLeft()) {
                pane.addMenuButton(layoutMode.isLeftOpen() ? this.getPaneTitle() : null, this::onMenuButtonPerformed);
            }
        }
        for (Action action : this.headerActions) {
            pane.addHeader(action);
        }
        if (this.optionalSearchField != null) {
            pane.addSearchField(this.optionalSearchField, evt -> this.onSearchButtonPerformed(evt, this.optionalSearchField));
        }
        pane.addNavigationElements(this.elements);
        for (Action action : this.footerActions) {
            pane.addFooter(action);
        }
        if (this.settingsItem != null) {
            pane.addSettings(this.settingsItem);
        }
        return pane.buildPanel();
    }

    private JComponent buildContentWithHeader(boolean phantomMenuButton) {
        if (!phantomMenuButton) {
            return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:default:grow", new Object[0])).rows("p, f:d:g", new Object[0])).add(this.header).xy(1, 1)).add(this.content).xy(1, 2)).build();
        }
        JComponent effectiveHeader = this.header;
        if (effectiveHeader == null) {
            effectiveHeader = new JPanel(null);
            effectiveHeader.setBackground(this.theme.background());
        }
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("48epx, fill:default:grow", new Object[0])).rows("f:[48epx, p], f:d:g", new Object[0])).add(effectiveHeader).xy(2, 1)).add(this.content).xyw(1, 2, 2)).build();
    }

    private void onMenuButtonPerformed(ActionEvent evt) {
        this.setPaneOpen(!this.isPaneOpen());
    }

    private void onSearchButtonPerformed(ActionEvent evt, JComponent searchField) {
        this.splitView.setPaneOpen(true);
        searchField.requestFocusInWindow();
    }

    private void updateSplitViewMode() {
        if (this.effectiveDisplayMode == null) {
            return;
        }
        switch (this.effectiveDisplayMode) {
            case LEFT: {
                this.splitView.setDisplayMode(SplitView.SplitViewDisplayMode.COMPACT_INLINE);
                break;
            }
            case LEFT_COMPACT: {
                this.splitView.setDisplayMode(SplitView.SplitViewDisplayMode.COMPACT_OVERLAY);
                this.splitView.setPaneOpen(false);
                break;
            }
            case LEFT_MINIMAL: {
                this.splitView.setDisplayMode(SplitView.SplitViewDisplayMode.OVERLAY);
                this.splitView.setPaneOpen(false);
                break;
            }
            case TOP: {
                break;
            }
            case AUTO: {
                break;
            }
        }
    }

    private void updateEffectiveDisplayMode() {
        if (this.panel == null) {
            return;
        }
        if (this.panel.getParent() == null) {
            return;
        }
        this.setEffectiveDisplayMode(this.toEffective(this.getDisplayMode()));
    }

    private void setEffectiveDisplayMode(NavigationViewDisplayMode newMode) {
        NavigationViewDisplayMode oldMode = this.effectiveDisplayMode;
        if (oldMode == newMode) {
            return;
        }
        if (oldMode == NavigationViewDisplayMode.LEFT) {
            this.paneOpenWhenLeft = this.isPaneOpen();
        }
        this.effectiveDisplayMode = newMode;
        this.rebuild();
    }

    private NavigationViewDisplayMode toEffective(NavigationViewDisplayMode mode) {
        Window window;
        if (mode != NavigationViewDisplayMode.AUTO) {
            return mode;
        }
        if (this.panel == null) {
            return NavigationViewDisplayMode.LEFT_COMPACT;
        }
        int width = this.panel.getWidth();
        if (width == 0 && (window = AncestorSupport.getWindowFor(this.panel)) != null) {
            width = window.getWidth();
        }
        if (width < this.compactModeThresholdWidth) {
            return NavigationViewDisplayMode.LEFT_MINIMAL;
        }
        if (width < this.expandedModeThresholdWidth) {
            return NavigationViewDisplayMode.LEFT_COMPACT;
        }
        return NavigationViewDisplayMode.LEFT;
    }

    public static final class Builder {
        private PageModel pageModel;
        private NavigationViewDisplayMode displayMode = NavigationViewDisplayMode.LEFT_COMPACT;
        private final IFluentResources fluentResources = FluentResources.getInstance();
        private Theme theme = this.fluentResources.getTheme();
        private NavigationView target;
        private JComponent optionalOverlay;

        public Builder pageModel(PageModel pageModel) {
            this.pageModel = pageModel;
            return this;
        }

        public Builder displayMode(NavigationViewDisplayMode mode) {
            this.displayMode = mode;
            return this;
        }

        public Builder theme(Theme theme) {
            this.theme = theme;
            return this;
        }

        public Builder backButtonVisible(boolean visible) {
            this.getTarget().setBackButtonVisible(visible);
            return this;
        }

        public Builder menuButtonVisible(boolean visible) {
            this.getTarget().setMenuButtonVisible(visible);
            return this;
        }

        public Builder compactModeThresholdWidth(int width) {
            this.getTarget().setCompactModeThresholdWidth(width);
            return this;
        }

        public Builder expandedModeThresholdWidth(int width) {
            this.getTarget().setExpandedModeThresholdWidth(width);
            return this;
        }

        public Builder paneTitle(String title) {
            this.getTarget().setPaneTitle(title);
            return this;
        }

        public Builder paneOpenWhenLeft(boolean open) {
            this.getTarget().setPaneOpenWhenLeft(open);
            return this;
        }

        public Builder header(Action action) {
            this.getTarget().addHeader(action);
            return this;
        }

        public Builder search(JGSearchField searchField) {
            this.getTarget().setSearchField(searchField);
            return this;
        }

        public Builder itemHeader(String name) {
            this.getTarget().addElement(new NavigationItemHeader(name));
            return this;
        }

        public Builder item(Page page) {
            Icon icon = page instanceof Page.AbstractPage ? ((Page.AbstractPage)page).getIcon() : null;
            this.getTarget().addElement(new NavigationItem(icon, null, page));
            return this;
        }

        public Builder item(Icon icon, Page page) {
            this.getTarget().addElement(new NavigationItem(icon, null, page));
            return this;
        }

        public Builder item(IconValue icon, Page page) {
            return this.item(icon.toIcon(), page);
        }

        public Builder item(Icon icon, String name, Page page) {
            this.getTarget().addElement(new NavigationItem(icon, name, page));
            return this;
        }

        public Builder item(IconValue icon, String name, Page page) {
            return this.item(icon.toIcon(), name, page);
        }

        public Builder item(boolean expression, IconValue icon, Page page) {
            return expression ? this.item(icon, page) : this;
        }

        public Builder item(boolean expression, Icon icon, String name, Page page) {
            return expression ? this.item(icon, name, page) : this;
        }

        public Builder separator() {
            this.getTarget().addElement(new NavigationSeparator());
            return this;
        }

        public Builder footer(Action action) {
            this.getTarget().addFooter(new ClosePaneAction(action));
            return this;
        }

        public Builder settings(Page page) {
            Icon icon = this.fluentResources.getNavigationViewSettingsIcon();
            this.getTarget().setSettings(new NavigationItem(icon, null, page));
            return this;
        }

        public Builder settings(String displayString, Consumer<ActionEvent> handler) {
            Icon icon = this.fluentResources.getNavigationViewSettingsIcon();
            return this.footer(new ActionBuilder().smallIcon(IconUtils.pad(icon, ScreenScaling.physicalInsets(0, 3, 0, 0))).text(displayString, new Object[0]).shortDescription(displayString, new Object[0]).handler(handler).build());
        }

        public Builder header(JComponent header) {
            this.getTarget().setHeader(header);
            return this;
        }

        public Builder headerNavigation() {
            return this.header(new NavigationBar(this.getPageModel()).buildPanel());
        }

        public Builder overlay(JComponent optionalOverlay) {
            this.optionalOverlay = optionalOverlay;
            return this;
        }

        public NavigationView build() {
            this.getTarget().setContent(this.buildContentWithOverlay());
            return this.target;
        }

        private JComponent buildContentWithOverlay() {
            PageFrame rawContent = new PageFrame(this.pageModel);
            if (this.optionalOverlay == null) {
                return rawContent;
            }
            return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:pref:grow", new Object[0])).rows("f:p:g", new Object[0])).add(this.optionalOverlay).xy(1, 1, "left, bottom")).add(rawContent).xy(1, 1)).build();
        }

        private NavigationView getTarget() {
            if (this.target == null) {
                this.target = new NavigationView(this.getPageModel(), this.displayMode, this.theme);
            }
            return this.target;
        }

        private PageModel getPageModel() {
            return Preconditions.checkNotNull(this.pageModel, "You must provide a page model before.");
        }
    }

    static final class ClosePaneAction
    extends WrappedAction {
        public ClosePaneAction(Action delegate) {
            super(delegate);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NavigationPane.closeOverlayPane(evt);
            this.delegateActionPerformed(evt);
        }
    }

    static interface NavigationElement {
    }

    static final class NavigationItem
    implements NavigationElement {
        final Icon icon;
        final String name;
        final Page page;

        NavigationItem(Icon icon, String name, Page page) {
            this.icon = icon;
            this.name = name;
            this.page = page;
        }
    }

    static final class NavigationItemHeader
    implements NavigationElement {
        final String name;

        NavigationItemHeader(String name) {
            this.name = name;
        }
    }

    static final class NavigationSeparator
    implements NavigationElement {
        NavigationSeparator() {
        }
    }

    public static enum NavigationViewDisplayMode {
        AUTO,
        LEFT,
        LEFT_COMPACT,
        LEFT_MINIMAL,
        TOP;


        public boolean isLeft() {
            return this != TOP;
        }

        public boolean isTop() {
            return this == TOP;
        }

        public static NavigationViewDisplayMode of(String name, NavigationViewDisplayMode defaultResult) {
            if ("TOP".equalsIgnoreCase(name)) {
                return TOP;
            }
            if ("AUTO".equalsIgnoreCase(name)) {
                return AUTO;
            }
            if ("LEFT".equalsIgnoreCase(name)) {
                return LEFT;
            }
            if ("LEFT_COMPACT".equalsIgnoreCase(name)) {
                return LEFT_COMPACT;
            }
            if ("LEFT_MINIMAL".equalsIgnoreCase(name)) {
                return LEFT_COMPACT;
            }
            return defaultResult;
        }
    }
}

