/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.PropertyAccessException;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public final class PropertyAccessor {
    private final String propertyName;
    private final Method readMethod;
    private final Method writeMethod;

    public PropertyAccessor(String propertyName, Method readMethod, Method writeMethod) {
        Preconditions.checkNotNull(propertyName, "The %s must not be null.", "property name");
        Preconditions.checkArgument(readMethod != null || writeMethod != null, "Either the reader or writer must not be null.");
        this.propertyName = propertyName;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyType() {
        return this.readMethod != null ? this.readMethod.getReturnType() : this.writeMethod.getParameterTypes()[0];
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public boolean isReadOnly() {
        return this.writeMethod == null;
    }

    public boolean isWriteOnly() {
        return this.readMethod == null;
    }

    public Object getValue(Object bean) {
        Preconditions.checkNotNull(bean, "The %s must not be null.", "bean");
        if (this.isWriteOnly()) {
            throw PropertyAccessException.createReadAccessException(bean, this, this.createMissingGetterCause(bean));
        }
        try {
            return this.readMethod.invoke(bean, (Object[])null);
        }
        catch (InvocationTargetException e) {
            throw PropertyAccessException.createReadAccessException(bean, this, e.getCause());
        }
        catch (IllegalAccessException e) {
            throw PropertyAccessException.createReadAccessException(bean, this, e);
        }
    }

    public void setValue(Object bean, Object newValue) throws PropertyVetoException {
        Preconditions.checkNotNull(bean, "The %s must not be null.", "bean");
        if (this.isReadOnly()) {
            throw PropertyAccessException.createWriteAccessException(bean, newValue, this, this.createMissingSetterCause(bean));
        }
        try {
            this.writeMethod.invoke(bean, newValue);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PropertyVetoException) {
                throw (PropertyVetoException)cause;
            }
            throw PropertyAccessException.createWriteAccessException(bean, newValue, this, cause);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw PropertyAccessException.createWriteAccessException(bean, newValue, this, e);
        }
    }

    private String createMissingGetterCause(Object bean) {
        boolean isBooleanProperty = this.getPropertyType() == Boolean.class || this.getPropertyType() == Boolean.TYPE;
        String methodName1 = this.formatAccessorMethodSignature(bean, "is", null);
        String methodName2 = this.formatAccessorMethodSignature(bean, "get", null);
        String typicalMethodOrMethods = isBooleanProperty ? methodName1 + " or " + methodName2 : methodName2;
        return String.format("The bean property is write-only; the bean class has no public getter method, typically %s.", typicalMethodOrMethods);
    }

    private String createMissingSetterCause(Object bean) {
        String methodName = this.formatAccessorMethodSignature(bean, "set", this.getPropertyType());
        return String.format("The bean property is read-only; the bean class has no public setter method, typically %s.", methodName);
    }

    private String formatAccessorMethodSignature(Object bean, String methodPrefix, Class<?> methodParamType) {
        return String.format("%1$s#%2$s%3$s(%4$s)", bean.getClass().getSimpleName(), methodPrefix, this.capitalizedPropertyName(), methodParamType == null ? "" : methodParamType.getSimpleName());
    }

    private String capitalizedPropertyName() {
        return this.getPropertyName().substring(0, 1).toUpperCase() + this.getPropertyName().substring(1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyAccessor other = (PropertyAccessor)obj;
        if (!Objects.equals(this.propertyName, other.propertyName)) {
            return false;
        }
        if (!Objects.equals(this.readMethod, other.readMethod)) {
            return false;
        }
        return Objects.equals(this.writeMethod, other.writeMethod);
    }

    public int hashCode() {
        return Objects.hash(this.propertyName, this.readMethod, this.writeMethod);
    }
}

