/******************************************/
/* Includes                               */
/******************************************/

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <dirent.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <math.h>
#include <limits.h>
#include <errno.h>
#include <signal.h>

#if defined(PARANOID)
#include <assert.h>
#endif /* defined(PARANOID) */

#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/time.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#include <X11/keysym.h>

//#include <regex.h>
#include <pthread.h>
#include "wmgeneral.h"
#include "xpm/wmping-default.xpm"
#include "xpm/wmping-lcd.xpm"
#include "xpm/wmping-neon1.xpm"
#include "xpm/wmping-neon2.xpm"
#include "xpm/wmping-rainbow.xpm"

/******************************************/
/* Defines                                */
/******************************************/

#define WMPING_VERSION "0.2"

/*
 * XXX: I shouldn't really use this WMPING_BUFLENGTH variable but scanf is so
 * lame and it'll take me a while to write a replacement.
 */
#define WMPING_BUFLENGTH 1024


/******************************************/
/* Globals                                */
/******************************************/

/*
 * Number and default artistic styles.
 */
int nstyles = 5;
int style = 0;

char *process_command = 0;

char wmping_mask_bits[64*64];
int wmping_mask_width = 64;
int wmping_mask_height = 64;

int update_rate = 1000000;
int refresh_rate = 50000000;
unsigned short packets = 5;
unsigned short pingTime = 60;
struct data
{
    char* name;
    char* vis_name;
    int status;
} main_data[4];

extern char **environ;

char *ProgName;

pthread_t pthread;

int f_ping(char* hostname);
void* pingProc(void*);
void quitproc(int);

/******************************************/
/* Structures                             */
/******************************************/

struct {
    char **pixmap;
    char *description;
} styles[] = {
    { wmping_default_xpm, "Light emitting diode (default)" },
    { wmping_lcd_xpm, "Liquid crystal display" },
    { wmping_rainbow_xpm, "Rainbow display" },
    { wmping_neon1_xpm, "Neon lights" },
    { wmping_neon2_xpm, "More neon lights" },
};


/******************************************/
/* Functions                              */
/******************************************/

void wmping_routine(int, char **);
inline void draw_pings(void);
void draw_onoff(int on, int dy);
void draw_bar(int, int, int, int, float, int, int);
inline void blit_string(char *, int, int);
void usage(void);
inline void printversion(void);
void readconf();
void createDefaultCfg(char* cfgfile);
/******************************************/
/* Main                                   */
/******************************************/

int main(int argc, char *argv[]) {
    int i;

    /*
     * Parse Command Line
     */

    ProgName = argv[0];
    if (strlen(ProgName) >= 5)
	ProgName += strlen(ProgName) - 5;

    for (i = 1; i<argc; i++) {
	char *arg = argv[i];

	if (*arg=='-') {
	    switch (arg[1]) {
	    case 'd' :
		if (strcmp(arg+1, "display")) {
		    usage();
		    exit(1);
		}
		break;
	    case 'g' :
		if (strcmp(arg+1, "geometry")) {
		    usage();
		    exit(1);
		}
		break;
	    case 'v' :
		printversion();
		exit(0);
		break;
	    default:
		usage();
		exit(0);
		break;
	    }
	}
    }

    signal(SIGINT, quitproc);

    for(i = 0; i < 4; i++)
    {
	main_data[i].status = 0;
	main_data[i].name = NULL;
        main_data[i].vis_name = NULL;
    }

    readconf();
    wmping_routine(argc, argv);

    return 0;
}

void readconf()
{
    FILE *f = NULL;
    struct stat stat_val;
    int i;
    char* tokens[10];
    char line[512];
    int mode = 0;
    unsigned lineN =0;
    unsigned long t_ul;
    char cfgfile[512];
    unsigned int hostCount = 0;
    char str_err[1024];

    char *tmp_str = getenv("HOME");
    if(tmp_str)
       sprintf(cfgfile, "%s/.wmpingrc", tmp_str);
    else
	sprintf(cfgfile, "./.wmpingrc");

    if(!stat(cfgfile, &stat_val))
    {
        if ((f = fopen(cfgfile,"r")))
        {
            while(fgets(line, 512, f))
	    {
                lineN++;
		i=0;
		tokens[i]=strtok(line," \n\t");
		while(tokens[i] && i < 10 )
		{
		    tokens[++i]=strtok(NULL," \n\t");
		}
		if((i > 0 && tokens[0][0] == '#') || i < 1)
		{
		    // coments
                    continue;
		}
	        if (i==1)
		{
		    if(!strcmp(tokens[0], "[global]"))
		    {
			mode = 1;
		    }
		    if(!strcmp(tokens[0], "[host]"))
		    {
			hostCount++;
			if(hostCount < 5)
			    mode = 2;
			else
                            mode = 0;

		    }
		}
		else if(i == 3)
		{
		    if(strcmp(tokens[1],"="))
		    {
			sprintf(str_err, "Not correct format of configuration file ( %s ): line %u", cfgfile, lineN);
			fprintf(stderr, str_err);
                        exit(-1);
		    }

		    switch(mode)
		    {
		    case 1:
			// [global]
			if(!strcmp(tokens[0],"packets"))
			{
			    t_ul = strtoul(tokens[2], NULL, 10);
                            if(t_ul > 0)
				packets = (unsigned short)t_ul;
			}
			else if(!strcmp(tokens[0],"pingrefresh"))
			{
			    t_ul = strtoul(tokens[2], NULL, 10);
                            if(t_ul > 0)
				pingTime = (int)t_ul;
			}
			if(!strcmp(tokens[0],"style"))
			{
			    t_ul = strtoul(tokens[2], NULL, 10);
                            if(t_ul > 0)
			    {
				style = (unsigned short)t_ul;
				if(style < 0 || style > nstyles - 1)
                                    style = 0;
			    }
			}

			break;
		    case 2:
			// [host]
			if(!strcmp(tokens[0],"hostname"))
			{
			    main_data[hostCount-1].name = (char*) malloc(strlen(tokens[2])+1);
			    strcpy(main_data[hostCount-1].name, tokens[2]);
			}
			else if(!strcmp(tokens[0],"alias"))
			{
			    main_data[hostCount-1].vis_name = (char*) malloc(strlen(tokens[2])+1);
			    strcpy(main_data[hostCount-1].vis_name, tokens[2]);
			}

			break;
		    }
		}
		else
		{
		    sprintf(str_err, "Not correct format of configuration file ( %s ): line %u", cfgfile, lineN);
		    fprintf(stderr, str_err);
		    exit(-1);

		}
	    }
	}
        else
	{
	    sprintf(str_err, "Error open configuration file ( %s ): %s", cfgfile, strerror(errno));
	    fprintf(stderr, str_err);
	    fprintf(stderr, "\n Create default configuration file\n");
	    createDefaultCfg(cfgfile);
	}
    }
    else
    {
	sprintf(str_err, "Error open configuration file ( %s ): %s", cfgfile, strerror(errno));
	fprintf(stderr, str_err);
	fprintf(stderr, "\n Create default configuration file\n");
	createDefaultCfg(cfgfile);
    }

    if(f)
        fclose(f);

}

void createDefaultCfg(char* cfgfile)
{
    FILE *f;
    if ((f = fopen(cfgfile,"w+")))
    {
	fprintf(f, "###################################### \n");
	fprintf(f, "#                                    #  \n");
	fprintf(f, "#   wmping-0.1                       #  \n");
	fprintf(f, "#                                    #  \n");
	fprintf(f, "#     Default configuration file     #  \n");
	fprintf(f, "#                                    #  \n");
	fprintf(f, "###################################### \n");

	fprintf(f, "# global section\n");
	fprintf(f, "[global] \n");
	fprintf(f, "\n");
	fprintf(f, "# Style\n");
	fprintf(f, "style = 0\n");
	fprintf(f, "# Number of packets sendedd during ping the host\n");
	fprintf(f, "packets = 5\n");
	fprintf(f, "\n");
	fprintf(f, "# time out between ping the host in sec\n");
	fprintf(f, "pingrefresh = 60\n");
	fprintf(f, "\n");
	fprintf(f, "\n");
	fprintf(f, "# host settings \n");
	fprintf(f, "[host] \n");
	fprintf(f, "# hostname - is a name or ip of pinging host \n");
	fprintf(f, "hostname = localhost \n");
        fprintf(f, "# alias is a displayed hostname \n");
	fprintf(f, "alias = localhost\n");
	fprintf(f, "\n");

	fprintf(f, "\n[host] \n");
	fprintf(f, "hostname = localhost \n");
	fprintf(f, "alias = local2\n");
	fprintf(f, "\n");

	fprintf(f, "\n[host] \n");
	fprintf(f, "hostname = localhost \n");
	fprintf(f, "alias = local3\n");
	fprintf(f, "\n");

	fprintf(f, "\n[host] \n");
	fprintf(f, "hostname = sample\n");
	fprintf(f, "alias = sample\n");
	fprintf(f, "\n");

	fclose(f);
	chown(cfgfile, getuid(), -1);
    }

    main_data[0].name = (char*) malloc(strlen("localhost")+1);
    strcpy(main_data[0].name, "localhost");
    main_data[0].vis_name = (char*) malloc(strlen("localhost")+1);
    strcpy(main_data[0].vis_name, "localhost");

    main_data[1].name = (char*) malloc(strlen("localhost")+1);
    strcpy(main_data[1].name, "localhost");
    main_data[1].vis_name = (char*) malloc(strlen("local2")+1);
    strcpy(main_data[1].vis_name, "local2");

    main_data[2].name = (char*) malloc(strlen("localhost")+1);
    strcpy(main_data[2].name, "localhost");
    main_data[2].vis_name = (char*) malloc(strlen("local3")+1);
    strcpy(main_data[2].vis_name, "local3");

    main_data[3].name = (char*) malloc(strlen("sample")+1);
    strcpy(main_data[3].name, "sample");
    main_data[3].vis_name = (char*) malloc(strlen("sample")+1);
    strcpy(main_data[3].vis_name, "sample");


}
/******************************************/
/* Main routine                           */
/******************************************/

void wmping_routine(int argc, char **argv) {
    XEvent Event;
    struct timeval tv={0,0};
    struct timeval last={0,0};
    int count = update_rate;
    struct timespec req={0, refresh_rate};
    struct timespec rem;
    int ret;

    createXBMfromXPM(wmping_mask_bits, styles[style].pixmap, wmping_mask_width, wmping_mask_height);

    openXwindow(argc, argv, styles[style].pixmap, wmping_mask_bits, wmping_mask_width, wmping_mask_height);

    pthread_create(&pthread, NULL, (void *(*)(void *))&pingProc, NULL);

    while (1) {

	waitpid(0, NULL, WNOHANG);

	if (count>=update_rate) {
	    memcpy(&last,&tv,sizeof(tv));

	    /*
	     * Update display
	     */
	    draw_pings();

	    RedrawWindow();
	    count = 0;
	}

	/*
	 * X Events
	 */
	while (XPending(display)) {
	    XNextEvent(display, &Event);
	    switch (Event.type) {
		case Expose:
		    RedrawWindow();
		    break;
		case DestroyNotify:
		    XCloseDisplay(display);
		    exit(0);
		case ButtonPress:
#if defined(LINUX)
		    if (Event.xbutton.button==1)
		    {
		     //   mode = !mode;
		    }
#endif
		    if (Event.xbutton.button==2)
		    {

		    }
		    if (Event.xbutton.button==3 && process_command)
		    {
		     //   execCommand(process_command);
		    }
		    break;
	    }
	}

        ret = 1;
	while(ret)
	{
	    ret = nanosleep(&req, &rem);
	    if(ret == -1)
	    {
		if( errno == EINTR)
		{
		    nanosleep(&rem, &rem);
		}
		else
		{
                    break;
		}
	    }

	}
//	usleep(refresh_rate);
	count = count + refresh_rate;
    }
}

/******************************************/
/* Generate display                       */
/******************************************/

void draw_pings() {
    int i;
  //  int res;
    /*
     * Invalidate time stamps
     */
    for (i = 0; i<4; ++i)
    {
	//draw_bar(0, 97, 55, 6, 0, 4, 13+i*20);
//        res = f_ping(main_data[i].name);
        if(main_data[i].name)
	{
	    draw_onoff(main_data[i].status > 0 ? 1 : 0, 4+i*15);
	}

	if(main_data[i].vis_name)
	    blit_string(main_data[i].vis_name,4,4+i*15);
	else
	    blit_string(main_data[i].name,4,4+i*15);
    }
}

/******************************************/
/* Draw on off state                      */
/******************************************/

void draw_onoff(int on, int y)
{
    switch(on)
    {
    case 0:
	copyXPMArea(6, 97, 6, 7, 52, y);
	break;
    case 1:
	copyXPMArea(0, 97, 6, 7, 52, y);
	break;
    default:
	copyXPMArea(12, 97, 6, 7, 52, y);
        break;
    }
}


/******************************************/
/* Blit bar at co-ordinates               */
/******************************************/

void draw_bar(int sx, int sy, int w, int h, float percent, int dx, int dy) {
    int tx;

    if (percent<=100)
	tx = w * (float)percent / 100;
    else
	tx = w;

    if (tx>0)
	copyXPMArea(sx, sy, tx, h, dx, dy);
    if (tx<w)
	copyXPMArea(sx+tx, sy+h, w-tx, h, dx+tx, dy);
}

/******************************************/
/* Blit string at co-ordinates            */
/******************************************/

void blit_string(char *name, int x, int y) {
    int	i;
    int	c;
    int	k;

    k = x;
    for ( i = 0; name && name[i] && i < 8; i++) {
	c = toupper(name[i]); 
	if (c >= 'A' && c <= 'J') {   
	    c -= 'A';
	    copyXPMArea(c*6,73,6,7,k,y);
	} else if (c>='K' && c<='T') {
	    c -= 'K';
	    copyXPMArea(c*6,81,6,7,k,y);
	} else if (c>='U' && c<='Z') {
	    c -= 'U';
	    copyXPMArea(c*6,89,6,7,k,y);
	} else if (c>='0' && c<='9') { 
	    c -= '0';
	    copyXPMArea(c*6,65,6,7,k,y);
	} else {
	    copyXPMArea(36,89,6,7,k,y);
	}
	k += 6;
    }
    if(i < 9)
    {
	for (; i < 8; i++)
	{
	    copyXPMArea(36,89,6,7,k,y);
            k += 6;
	}
    }
}

void* pingProc(void* p)
{
    struct timespec req={pingTime, 0};
    struct timespec rem;
    int ret;
    int i;

    while (1)
    {
	for(i =0; i < 4; i++)
	{
            if(main_data[i].name)
		main_data[i].status = f_ping(main_data[i].name);
	}

	ret = 1;
	while(ret)
	{
	    ret = nanosleep(&req, &rem);
	    if(ret == -1)
	    {
		if( errno == EINTR)
		{
		    nanosleep(&rem, &rem);
		}
		else
		{
		    break;
		}
	    }
	}
    }

}
/******************************************/
/* Usage                                  */
/******************************************/

void usage(void) {
    fprintf(stderr,"\n WMping - Serge Velichkevych <serg@cad.kiev.ua>\n\n");
    fprintf(stderr,"usage:\n");
    fprintf(stderr,"    -display <display name>\n");
    fprintf(stderr,"    -geometry +XPOS+YPOS      initial window position\n");
    fprintf(stderr,"    -v                        print version number\n");
    fprintf(stderr,"\n");
}

/******************************************/
/* Print version                          */
/******************************************/

void printversion(void) {
    fprintf(stderr, "wmping v%s\n",WMPING_VERSION);
}

void quitproc(int sig)
{
    int i;
    for(i = 0; i < 4; i++)
    {
	if(main_data[i].name)
	    free(main_data[i].name);
	if(main_data[i].vis_name)
            free(main_data[i].vis_name);
    }

    printf("\nBye... \n");
    _exit(0);
}
