// Code generated by gen.go; DO NOT EDIT.

package githubv4

// ActorType represents the actor's type.
type ActorType string

// The actor's type.
const (
	ActorTypeUser ActorType = "USER" // Indicates a user actor.
	ActorTypeTeam ActorType = "TEAM" // Indicates a team actor.
)

// AuditLogOrderField represents properties by which Audit Log connections can be ordered.
type AuditLogOrderField string

// Properties by which Audit Log connections can be ordered.
const (
	AuditLogOrderFieldCreatedAt AuditLogOrderField = "CREATED_AT" // Order audit log entries by timestamp.
)

// CheckAnnotationLevel represents represents an annotation's information level.
type CheckAnnotationLevel string

// Represents an annotation's information level.
const (
	CheckAnnotationLevelFailure CheckAnnotationLevel = "FAILURE" // An annotation indicating an inescapable error.
	CheckAnnotationLevelNotice  CheckAnnotationLevel = "NOTICE"  // An annotation indicating some information.
	CheckAnnotationLevelWarning CheckAnnotationLevel = "WARNING" // An annotation indicating an ignorable error.
)

// CheckConclusionState represents the possible states for a check suite or run conclusion.
type CheckConclusionState string

// The possible states for a check suite or run conclusion.
const (
	CheckConclusionStateActionRequired CheckConclusionState = "ACTION_REQUIRED" // The check suite or run requires action.
	CheckConclusionStateTimedOut       CheckConclusionState = "TIMED_OUT"       // The check suite or run has timed out.
	CheckConclusionStateCancelled      CheckConclusionState = "CANCELLED"       // The check suite or run has been cancelled.
	CheckConclusionStateFailure        CheckConclusionState = "FAILURE"         // The check suite or run has failed.
	CheckConclusionStateSuccess        CheckConclusionState = "SUCCESS"         // The check suite or run has succeeded.
	CheckConclusionStateNeutral        CheckConclusionState = "NEUTRAL"         // The check suite or run was neutral.
	CheckConclusionStateSkipped        CheckConclusionState = "SKIPPED"         // The check suite or run was skipped.
	CheckConclusionStateStartupFailure CheckConclusionState = "STARTUP_FAILURE" // The check suite or run has failed at startup.
	CheckConclusionStateStale          CheckConclusionState = "STALE"           // The check suite or run was marked stale by GitHub. Only GitHub can use this conclusion.
)

// CheckRunState represents the possible states of a check run in a status rollup.
type CheckRunState string

// The possible states of a check run in a status rollup.
const (
	CheckRunStateActionRequired CheckRunState = "ACTION_REQUIRED" // The check run requires action.
	CheckRunStateCancelled      CheckRunState = "CANCELLED"       // The check run has been cancelled.
	CheckRunStateCompleted      CheckRunState = "COMPLETED"       // The check run has been completed.
	CheckRunStateFailure        CheckRunState = "FAILURE"         // The check run has failed.
	CheckRunStateInProgress     CheckRunState = "IN_PROGRESS"     // The check run is in progress.
	CheckRunStateNeutral        CheckRunState = "NEUTRAL"         // The check run was neutral.
	CheckRunStatePending        CheckRunState = "PENDING"         // The check run is in pending state.
	CheckRunStateQueued         CheckRunState = "QUEUED"          // The check run has been queued.
	CheckRunStateSkipped        CheckRunState = "SKIPPED"         // The check run was skipped.
	CheckRunStateStale          CheckRunState = "STALE"           // The check run was marked stale by GitHub. Only GitHub can use this conclusion.
	CheckRunStateStartupFailure CheckRunState = "STARTUP_FAILURE" // The check run has failed at startup.
	CheckRunStateSuccess        CheckRunState = "SUCCESS"         // The check run has succeeded.
	CheckRunStateTimedOut       CheckRunState = "TIMED_OUT"       // The check run has timed out.
	CheckRunStateWaiting        CheckRunState = "WAITING"         // The check run is in waiting state.
)

// CheckRunType represents the possible types of check runs.
type CheckRunType string

// The possible types of check runs.
const (
	CheckRunTypeAll    CheckRunType = "ALL"    // Every check run available.
	CheckRunTypeLatest CheckRunType = "LATEST" // The latest check run.
)

// CheckStatusState represents the possible states for a check suite or run status.
type CheckStatusState string

// The possible states for a check suite or run status.
const (
	CheckStatusStateRequested  CheckStatusState = "REQUESTED"   // The check suite or run has been requested.
	CheckStatusStateQueued     CheckStatusState = "QUEUED"      // The check suite or run has been queued.
	CheckStatusStateInProgress CheckStatusState = "IN_PROGRESS" // The check suite or run is in progress.
	CheckStatusStateCompleted  CheckStatusState = "COMPLETED"   // The check suite or run has been completed.
	CheckStatusStateWaiting    CheckStatusState = "WAITING"     // The check suite or run is in waiting state.
	CheckStatusStatePending    CheckStatusState = "PENDING"     // The check suite or run is in pending state.
)

// CollaboratorAffiliation represents collaborators affiliation level with a subject.
type CollaboratorAffiliation string

// Collaborators affiliation level with a subject.
const (
	CollaboratorAffiliationOutside CollaboratorAffiliation = "OUTSIDE" // All outside collaborators of an organization-owned subject.
	CollaboratorAffiliationDirect  CollaboratorAffiliation = "DIRECT"  // All collaborators with permissions to an organization-owned subject, regardless of organization membership status.
	CollaboratorAffiliationAll     CollaboratorAffiliation = "ALL"     // All collaborators the authenticated user can see.
)

// CommentAuthorAssociation represents a comment author association with repository.
type CommentAuthorAssociation string

// A comment author association with repository.
const (
	CommentAuthorAssociationMember               CommentAuthorAssociation = "MEMBER"                 // Author is a member of the organization that owns the repository.
	CommentAuthorAssociationOwner                CommentAuthorAssociation = "OWNER"                  // Author is the owner of the repository.
	CommentAuthorAssociationMannequin            CommentAuthorAssociation = "MANNEQUIN"              // Author is a placeholder for an unclaimed user.
	CommentAuthorAssociationCollaborator         CommentAuthorAssociation = "COLLABORATOR"           // Author has been invited to collaborate on the repository.
	CommentAuthorAssociationContributor          CommentAuthorAssociation = "CONTRIBUTOR"            // Author has previously committed to the repository.
	CommentAuthorAssociationFirstTimeContributor CommentAuthorAssociation = "FIRST_TIME_CONTRIBUTOR" // Author has not previously committed to the repository.
	CommentAuthorAssociationFirstTimer           CommentAuthorAssociation = "FIRST_TIMER"            // Author has not previously committed to GitHub.
	CommentAuthorAssociationNone                 CommentAuthorAssociation = "NONE"                   // Author has no association with the repository.
)

// CommentCannotUpdateReason represents the possible errors that will prevent a user from updating a comment.
type CommentCannotUpdateReason string

// The possible errors that will prevent a user from updating a comment.
const (
	CommentCannotUpdateReasonArchived              CommentCannotUpdateReason = "ARCHIVED"                // Unable to create comment because repository is archived.
	CommentCannotUpdateReasonInsufficientAccess    CommentCannotUpdateReason = "INSUFFICIENT_ACCESS"     // You must be the author or have write access to this repository to update this comment.
	CommentCannotUpdateReasonLocked                CommentCannotUpdateReason = "LOCKED"                  // Unable to create comment because issue is locked.
	CommentCannotUpdateReasonLoginRequired         CommentCannotUpdateReason = "LOGIN_REQUIRED"          // You must be logged in to update this comment.
	CommentCannotUpdateReasonMaintenance           CommentCannotUpdateReason = "MAINTENANCE"             // Repository is under maintenance.
	CommentCannotUpdateReasonVerifiedEmailRequired CommentCannotUpdateReason = "VERIFIED_EMAIL_REQUIRED" // At least one email address must be verified to update this comment.
	CommentCannotUpdateReasonDenied                CommentCannotUpdateReason = "DENIED"                  // You cannot update this comment.
)

// CommitContributionOrderField represents properties by which commit contribution connections can be ordered.
type CommitContributionOrderField string

// Properties by which commit contribution connections can be ordered.
const (
	CommitContributionOrderFieldOccurredAt  CommitContributionOrderField = "OCCURRED_AT"  // Order commit contributions by when they were made.
	CommitContributionOrderFieldCommitCount CommitContributionOrderField = "COMMIT_COUNT" // Order commit contributions by how many commits they represent.
)

// ComparisonStatus represents the status of a git comparison between two refs.
type ComparisonStatus string

// The status of a git comparison between two refs.
const (
	ComparisonStatusDiverged  ComparisonStatus = "DIVERGED"  // The head ref is both ahead and behind of the base ref, indicating git history has diverged.
	ComparisonStatusAhead     ComparisonStatus = "AHEAD"     // The head ref is ahead of the base ref.
	ComparisonStatusBehind    ComparisonStatus = "BEHIND"    // The head ref is behind the base ref.
	ComparisonStatusIdentical ComparisonStatus = "IDENTICAL" // The head ref and base ref are identical.
)

// ContributionLevel represents varying levels of contributions from none to many.
type ContributionLevel string

// Varying levels of contributions from none to many.
const (
	ContributionLevelNone           ContributionLevel = "NONE"            // No contributions occurred.
	ContributionLevelFirstQuartile  ContributionLevel = "FIRST_QUARTILE"  // Lowest 25% of days of contributions.
	ContributionLevelSecondQuartile ContributionLevel = "SECOND_QUARTILE" // Second lowest 25% of days of contributions. More contributions than the first quartile.
	ContributionLevelThirdQuartile  ContributionLevel = "THIRD_QUARTILE"  // Second highest 25% of days of contributions. More contributions than second quartile, less than the fourth quartile.
	ContributionLevelFourthQuartile ContributionLevel = "FOURTH_QUARTILE" // Highest 25% of days of contributions. More contributions than the third quartile.
)

// DefaultRepositoryPermissionField represents the possible base permissions for repositories.
type DefaultRepositoryPermissionField string

// The possible base permissions for repositories.
const (
	DefaultRepositoryPermissionFieldNone  DefaultRepositoryPermissionField = "NONE"  // No access.
	DefaultRepositoryPermissionFieldRead  DefaultRepositoryPermissionField = "READ"  // Can read repos by default.
	DefaultRepositoryPermissionFieldWrite DefaultRepositoryPermissionField = "WRITE" // Can read and write repos by default.
	DefaultRepositoryPermissionFieldAdmin DefaultRepositoryPermissionField = "ADMIN" // Can read, write, and administrate repos by default.
)

// DependencyGraphEcosystem represents the possible ecosystems of a dependency graph package.
type DependencyGraphEcosystem string

// The possible ecosystems of a dependency graph package.
const (
	DependencyGraphEcosystemRubygems DependencyGraphEcosystem = "RUBYGEMS" // Ruby gems hosted at RubyGems.org.
	DependencyGraphEcosystemNpm      DependencyGraphEcosystem = "NPM"      // JavaScript packages hosted at npmjs.com.
	DependencyGraphEcosystemPip      DependencyGraphEcosystem = "PIP"      // Python packages hosted at PyPI.org.
	DependencyGraphEcosystemMaven    DependencyGraphEcosystem = "MAVEN"    // Java artifacts hosted at the Maven central repository.
	DependencyGraphEcosystemNuget    DependencyGraphEcosystem = "NUGET"    // .NET packages hosted at the NuGet Gallery.
	DependencyGraphEcosystemComposer DependencyGraphEcosystem = "COMPOSER" // PHP packages hosted at packagist.org.
	DependencyGraphEcosystemGo       DependencyGraphEcosystem = "GO"       // Go modules.
	DependencyGraphEcosystemActions  DependencyGraphEcosystem = "ACTIONS"  // GitHub Actions.
	DependencyGraphEcosystemRust     DependencyGraphEcosystem = "RUST"     // Rust crates.
	DependencyGraphEcosystemPub      DependencyGraphEcosystem = "PUB"      // Dart packages hosted at pub.dev.
	DependencyGraphEcosystemSwift    DependencyGraphEcosystem = "SWIFT"    // Swift packages.
)

// DeploymentOrderField represents properties by which deployment connections can be ordered.
type DeploymentOrderField string

// Properties by which deployment connections can be ordered.
const (
	DeploymentOrderFieldCreatedAt DeploymentOrderField = "CREATED_AT" // Order collection by creation time.
)

// DeploymentProtectionRuleType represents the possible protection rule types.
type DeploymentProtectionRuleType string

// The possible protection rule types.
const (
	DeploymentProtectionRuleTypeRequiredReviewers DeploymentProtectionRuleType = "REQUIRED_REVIEWERS" // Required reviewers.
	DeploymentProtectionRuleTypeWaitTimer         DeploymentProtectionRuleType = "WAIT_TIMER"         // Wait timer.
)

// DeploymentReviewState represents the possible states for a deployment review.
type DeploymentReviewState string

// The possible states for a deployment review.
const (
	DeploymentReviewStateApproved DeploymentReviewState = "APPROVED" // The deployment was approved.
	DeploymentReviewStateRejected DeploymentReviewState = "REJECTED" // The deployment was rejected.
)

// DeploymentState represents the possible states in which a deployment can be.
type DeploymentState string

// The possible states in which a deployment can be.
const (
	DeploymentStateAbandoned  DeploymentState = "ABANDONED"   // The pending deployment was not updated after 30 minutes.
	DeploymentStateActive     DeploymentState = "ACTIVE"      // The deployment is currently active.
	DeploymentStateDestroyed  DeploymentState = "DESTROYED"   // An inactive transient deployment.
	DeploymentStateError      DeploymentState = "ERROR"       // The deployment experienced an error.
	DeploymentStateFailure    DeploymentState = "FAILURE"     // The deployment has failed.
	DeploymentStateInactive   DeploymentState = "INACTIVE"    // The deployment is inactive.
	DeploymentStatePending    DeploymentState = "PENDING"     // The deployment is pending.
	DeploymentStateSuccess    DeploymentState = "SUCCESS"     // The deployment was successful.
	DeploymentStateQueued     DeploymentState = "QUEUED"      // The deployment has queued.
	DeploymentStateInProgress DeploymentState = "IN_PROGRESS" // The deployment is in progress.
	DeploymentStateWaiting    DeploymentState = "WAITING"     // The deployment is waiting.
)

// DeploymentStatusState represents the possible states for a deployment status.
type DeploymentStatusState string

// The possible states for a deployment status.
const (
	DeploymentStatusStatePending    DeploymentStatusState = "PENDING"     // The deployment is pending.
	DeploymentStatusStateSuccess    DeploymentStatusState = "SUCCESS"     // The deployment was successful.
	DeploymentStatusStateFailure    DeploymentStatusState = "FAILURE"     // The deployment has failed.
	DeploymentStatusStateInactive   DeploymentStatusState = "INACTIVE"    // The deployment is inactive.
	DeploymentStatusStateError      DeploymentStatusState = "ERROR"       // The deployment experienced an error.
	DeploymentStatusStateQueued     DeploymentStatusState = "QUEUED"      // The deployment is queued.
	DeploymentStatusStateInProgress DeploymentStatusState = "IN_PROGRESS" // The deployment is in progress.
	DeploymentStatusStateWaiting    DeploymentStatusState = "WAITING"     // The deployment is waiting.
)

// DiffSide represents the possible sides of a diff.
type DiffSide string

// The possible sides of a diff.
const (
	DiffSideLeft  DiffSide = "LEFT"  // The left side of the diff.
	DiffSideRight DiffSide = "RIGHT" // The right side of the diff.
)

// DiscussionCloseReason represents the possible reasons for closing a discussion.
type DiscussionCloseReason string

// The possible reasons for closing a discussion.
const (
	DiscussionCloseReasonResolved  DiscussionCloseReason = "RESOLVED"  // The discussion has been resolved.
	DiscussionCloseReasonOutdated  DiscussionCloseReason = "OUTDATED"  // The discussion is no longer relevant.
	DiscussionCloseReasonDuplicate DiscussionCloseReason = "DUPLICATE" // The discussion is a duplicate of another.
)

// DiscussionOrderField represents properties by which discussion connections can be ordered.
type DiscussionOrderField string

// Properties by which discussion connections can be ordered.
const (
	DiscussionOrderFieldCreatedAt DiscussionOrderField = "CREATED_AT" // Order discussions by creation time.
	DiscussionOrderFieldUpdatedAt DiscussionOrderField = "UPDATED_AT" // Order discussions by most recent modification time.
)

// DiscussionPollOptionOrderField represents properties by which discussion poll option connections can be ordered.
type DiscussionPollOptionOrderField string

// Properties by which discussion poll option connections can be ordered.
const (
	DiscussionPollOptionOrderFieldAuthoredOrder DiscussionPollOptionOrderField = "AUTHORED_ORDER" // Order poll options by the order that the poll author specified when creating the poll.
	DiscussionPollOptionOrderFieldVoteCount     DiscussionPollOptionOrderField = "VOTE_COUNT"     // Order poll options by the number of votes it has.
)

// DiscussionState represents the possible states of a discussion.
type DiscussionState string

// The possible states of a discussion.
const (
	DiscussionStateOpen   DiscussionState = "OPEN"   // A discussion that is open.
	DiscussionStateClosed DiscussionState = "CLOSED" // A discussion that has been closed.
)

// DiscussionStateReason represents the possible state reasons of a discussion.
type DiscussionStateReason string

// The possible state reasons of a discussion.
const (
	DiscussionStateReasonResolved  DiscussionStateReason = "RESOLVED"  // The discussion has been resolved.
	DiscussionStateReasonOutdated  DiscussionStateReason = "OUTDATED"  // The discussion is no longer relevant.
	DiscussionStateReasonDuplicate DiscussionStateReason = "DUPLICATE" // The discussion is a duplicate of another.
	DiscussionStateReasonReopened  DiscussionStateReason = "REOPENED"  // The discussion was reopened.
)

// DismissReason represents the possible reasons that a Dependabot alert was dismissed.
type DismissReason string

// The possible reasons that a Dependabot alert was dismissed.
const (
	DismissReasonFixStarted    DismissReason = "FIX_STARTED"    // A fix has already been started.
	DismissReasonNoBandwidth   DismissReason = "NO_BANDWIDTH"   // No bandwidth to fix this.
	DismissReasonTolerableRisk DismissReason = "TOLERABLE_RISK" // Risk is tolerable to this project.
	DismissReasonInaccurate    DismissReason = "INACCURATE"     // This alert is inaccurate or incorrect.
	DismissReasonNotUsed       DismissReason = "NOT_USED"       // Vulnerable code is not actually used.
)

// EnterpriseAdministratorInvitationOrderField represents properties by which enterprise administrator invitation connections can be ordered.
type EnterpriseAdministratorInvitationOrderField string

// Properties by which enterprise administrator invitation connections can be ordered.
const (
	EnterpriseAdministratorInvitationOrderFieldCreatedAt EnterpriseAdministratorInvitationOrderField = "CREATED_AT" // Order enterprise administrator member invitations by creation time.
)

// EnterpriseAdministratorRole represents the possible administrator roles in an enterprise account.
type EnterpriseAdministratorRole string

// The possible administrator roles in an enterprise account.
const (
	EnterpriseAdministratorRoleOwner          EnterpriseAdministratorRole = "OWNER"           // Represents an owner of the enterprise account.
	EnterpriseAdministratorRoleBillingManager EnterpriseAdministratorRole = "BILLING_MANAGER" // Represents a billing manager of the enterprise account.
)

// EnterpriseAllowPrivateRepositoryForkingPolicyValue represents the possible values for the enterprise allow private repository forking policy value.
type EnterpriseAllowPrivateRepositoryForkingPolicyValue string

// The possible values for the enterprise allow private repository forking policy value.
const (
	EnterpriseAllowPrivateRepositoryForkingPolicyValueEnterpriseOrganizations             EnterpriseAllowPrivateRepositoryForkingPolicyValue = "ENTERPRISE_ORGANIZATIONS"               // Members can fork a repository to an organization within this enterprise.
	EnterpriseAllowPrivateRepositoryForkingPolicyValueSameOrganization                    EnterpriseAllowPrivateRepositoryForkingPolicyValue = "SAME_ORGANIZATION"                      // Members can fork a repository only within the same organization (intra-org).
	EnterpriseAllowPrivateRepositoryForkingPolicyValueSameOrganizationUserAccounts        EnterpriseAllowPrivateRepositoryForkingPolicyValue = "SAME_ORGANIZATION_USER_ACCOUNTS"        // Members can fork a repository to their user account or within the same organization.
	EnterpriseAllowPrivateRepositoryForkingPolicyValueEnterpriseOrganizationsUserAccounts EnterpriseAllowPrivateRepositoryForkingPolicyValue = "ENTERPRISE_ORGANIZATIONS_USER_ACCOUNTS" // Members can fork a repository to their enterprise-managed user account or an organization inside this enterprise.
	EnterpriseAllowPrivateRepositoryForkingPolicyValueUserAccounts                        EnterpriseAllowPrivateRepositoryForkingPolicyValue = "USER_ACCOUNTS"                          // Members can fork a repository to their user account.
	EnterpriseAllowPrivateRepositoryForkingPolicyValueEverywhere                          EnterpriseAllowPrivateRepositoryForkingPolicyValue = "EVERYWHERE"                             // Members can fork a repository to their user account or an organization, either inside or outside of this enterprise.
)

// EnterpriseDefaultRepositoryPermissionSettingValue represents the possible values for the enterprise base repository permission setting.
type EnterpriseDefaultRepositoryPermissionSettingValue string

// The possible values for the enterprise base repository permission setting.
const (
	EnterpriseDefaultRepositoryPermissionSettingValueNoPolicy EnterpriseDefaultRepositoryPermissionSettingValue = "NO_POLICY" // Organizations in the enterprise choose base repository permissions for their members.
	EnterpriseDefaultRepositoryPermissionSettingValueAdmin    EnterpriseDefaultRepositoryPermissionSettingValue = "ADMIN"     // Organization members will be able to clone, pull, push, and add new collaborators to all organization repositories.
	EnterpriseDefaultRepositoryPermissionSettingValueWrite    EnterpriseDefaultRepositoryPermissionSettingValue = "WRITE"     // Organization members will be able to clone, pull, and push all organization repositories.
	EnterpriseDefaultRepositoryPermissionSettingValueRead     EnterpriseDefaultRepositoryPermissionSettingValue = "READ"      // Organization members will be able to clone and pull all organization repositories.
	EnterpriseDefaultRepositoryPermissionSettingValueNone     EnterpriseDefaultRepositoryPermissionSettingValue = "NONE"      // Organization members will only be able to clone and pull public repositories.
)

// EnterpriseEnabledDisabledSettingValue represents the possible values for an enabled/disabled enterprise setting.
type EnterpriseEnabledDisabledSettingValue string

// The possible values for an enabled/disabled enterprise setting.
const (
	EnterpriseEnabledDisabledSettingValueEnabled  EnterpriseEnabledDisabledSettingValue = "ENABLED"   // The setting is enabled for organizations in the enterprise.
	EnterpriseEnabledDisabledSettingValueDisabled EnterpriseEnabledDisabledSettingValue = "DISABLED"  // The setting is disabled for organizations in the enterprise.
	EnterpriseEnabledDisabledSettingValueNoPolicy EnterpriseEnabledDisabledSettingValue = "NO_POLICY" // There is no policy set for organizations in the enterprise.
)

// EnterpriseEnabledSettingValue represents the possible values for an enabled/no policy enterprise setting.
type EnterpriseEnabledSettingValue string

// The possible values for an enabled/no policy enterprise setting.
const (
	EnterpriseEnabledSettingValueEnabled  EnterpriseEnabledSettingValue = "ENABLED"   // The setting is enabled for organizations in the enterprise.
	EnterpriseEnabledSettingValueNoPolicy EnterpriseEnabledSettingValue = "NO_POLICY" // There is no policy set for organizations in the enterprise.
)

// EnterpriseMemberOrderField represents properties by which enterprise member connections can be ordered.
type EnterpriseMemberOrderField string

// Properties by which enterprise member connections can be ordered.
const (
	EnterpriseMemberOrderFieldLogin     EnterpriseMemberOrderField = "LOGIN"      // Order enterprise members by login.
	EnterpriseMemberOrderFieldCreatedAt EnterpriseMemberOrderField = "CREATED_AT" // Order enterprise members by creation time.
)

// EnterpriseMembersCanCreateRepositoriesSettingValue represents the possible values for the enterprise members can create repositories setting.
type EnterpriseMembersCanCreateRepositoriesSettingValue string

// The possible values for the enterprise members can create repositories setting.
const (
	EnterpriseMembersCanCreateRepositoriesSettingValueNoPolicy EnterpriseMembersCanCreateRepositoriesSettingValue = "NO_POLICY" // Organization owners choose whether to allow members to create repositories.
	EnterpriseMembersCanCreateRepositoriesSettingValueAll      EnterpriseMembersCanCreateRepositoriesSettingValue = "ALL"       // Members will be able to create public and private repositories.
	EnterpriseMembersCanCreateRepositoriesSettingValuePublic   EnterpriseMembersCanCreateRepositoriesSettingValue = "PUBLIC"    // Members will be able to create only public repositories.
	EnterpriseMembersCanCreateRepositoriesSettingValuePrivate  EnterpriseMembersCanCreateRepositoriesSettingValue = "PRIVATE"   // Members will be able to create only private repositories.
	EnterpriseMembersCanCreateRepositoriesSettingValueDisabled EnterpriseMembersCanCreateRepositoriesSettingValue = "DISABLED"  // Members will not be able to create public or private repositories.
)

// EnterpriseMembersCanMakePurchasesSettingValue represents the possible values for the members can make purchases setting.
type EnterpriseMembersCanMakePurchasesSettingValue string

// The possible values for the members can make purchases setting.
const (
	EnterpriseMembersCanMakePurchasesSettingValueEnabled  EnterpriseMembersCanMakePurchasesSettingValue = "ENABLED"  // The setting is enabled for organizations in the enterprise.
	EnterpriseMembersCanMakePurchasesSettingValueDisabled EnterpriseMembersCanMakePurchasesSettingValue = "DISABLED" // The setting is disabled for organizations in the enterprise.
)

// EnterpriseMembershipType represents the possible values we have for filtering Platform::Objects::User#enterprises.
type EnterpriseMembershipType string

// The possible values we have for filtering Platform::Objects::User#enterprises.
const (
	EnterpriseMembershipTypeAll            EnterpriseMembershipType = "ALL"             // Returns all enterprises in which the user is a member, admin, or billing manager.
	EnterpriseMembershipTypeAdmin          EnterpriseMembershipType = "ADMIN"           // Returns all enterprises in which the user is an admin.
	EnterpriseMembershipTypeBillingManager EnterpriseMembershipType = "BILLING_MANAGER" // Returns all enterprises in which the user is a billing manager.
	EnterpriseMembershipTypeOrgMembership  EnterpriseMembershipType = "ORG_MEMBERSHIP"  // Returns all enterprises in which the user is a member of an org that is owned by the enterprise.
)

// EnterpriseOrderField represents properties by which enterprise connections can be ordered.
type EnterpriseOrderField string

// Properties by which enterprise connections can be ordered.
const (
	EnterpriseOrderFieldName EnterpriseOrderField = "NAME" // Order enterprises by name.
)

// EnterpriseServerInstallationOrderField represents properties by which Enterprise Server installation connections can be ordered.
type EnterpriseServerInstallationOrderField string

// Properties by which Enterprise Server installation connections can be ordered.
const (
	EnterpriseServerInstallationOrderFieldHostName     EnterpriseServerInstallationOrderField = "HOST_NAME"     // Order Enterprise Server installations by host name.
	EnterpriseServerInstallationOrderFieldCustomerName EnterpriseServerInstallationOrderField = "CUSTOMER_NAME" // Order Enterprise Server installations by customer name.
	EnterpriseServerInstallationOrderFieldCreatedAt    EnterpriseServerInstallationOrderField = "CREATED_AT"    // Order Enterprise Server installations by creation time.
)

// EnterpriseServerUserAccountEmailOrderField represents properties by which Enterprise Server user account email connections can be ordered.
type EnterpriseServerUserAccountEmailOrderField string

// Properties by which Enterprise Server user account email connections can be ordered.
const (
	EnterpriseServerUserAccountEmailOrderFieldEmail EnterpriseServerUserAccountEmailOrderField = "EMAIL" // Order emails by email.
)

// EnterpriseServerUserAccountOrderField represents properties by which Enterprise Server user account connections can be ordered.
type EnterpriseServerUserAccountOrderField string

// Properties by which Enterprise Server user account connections can be ordered.
const (
	EnterpriseServerUserAccountOrderFieldLogin           EnterpriseServerUserAccountOrderField = "LOGIN"             // Order user accounts by login.
	EnterpriseServerUserAccountOrderFieldRemoteCreatedAt EnterpriseServerUserAccountOrderField = "REMOTE_CREATED_AT" // Order user accounts by creation time on the Enterprise Server installation.
)

// EnterpriseServerUserAccountsUploadOrderField represents properties by which Enterprise Server user accounts upload connections can be ordered.
type EnterpriseServerUserAccountsUploadOrderField string

// Properties by which Enterprise Server user accounts upload connections can be ordered.
const (
	EnterpriseServerUserAccountsUploadOrderFieldCreatedAt EnterpriseServerUserAccountsUploadOrderField = "CREATED_AT" // Order user accounts uploads by creation time.
)

// EnterpriseServerUserAccountsUploadSyncState represents synchronization state of the Enterprise Server user accounts upload.
type EnterpriseServerUserAccountsUploadSyncState string

// Synchronization state of the Enterprise Server user accounts upload.
const (
	EnterpriseServerUserAccountsUploadSyncStatePending EnterpriseServerUserAccountsUploadSyncState = "PENDING" // The synchronization of the upload is pending.
	EnterpriseServerUserAccountsUploadSyncStateSuccess EnterpriseServerUserAccountsUploadSyncState = "SUCCESS" // The synchronization of the upload succeeded.
	EnterpriseServerUserAccountsUploadSyncStateFailure EnterpriseServerUserAccountsUploadSyncState = "FAILURE" // The synchronization of the upload failed.
)

// EnterpriseUserAccountMembershipRole represents the possible roles for enterprise membership.
type EnterpriseUserAccountMembershipRole string

// The possible roles for enterprise membership.
const (
	EnterpriseUserAccountMembershipRoleMember       EnterpriseUserAccountMembershipRole = "MEMBER"       // The user is a member of an organization in the enterprise.
	EnterpriseUserAccountMembershipRoleOwner        EnterpriseUserAccountMembershipRole = "OWNER"        // The user is an owner of an organization in the enterprise.
	EnterpriseUserAccountMembershipRoleUnaffiliated EnterpriseUserAccountMembershipRole = "UNAFFILIATED" // The user is not an owner of the enterprise, and not a member or owner of any organizations in the enterprise; only for EMU-enabled enterprises.
)

// EnterpriseUserDeployment represents the possible GitHub Enterprise deployments where this user can exist.
type EnterpriseUserDeployment string

// The possible GitHub Enterprise deployments where this user can exist.
const (
	EnterpriseUserDeploymentCloud  EnterpriseUserDeployment = "CLOUD"  // The user is part of a GitHub Enterprise Cloud deployment.
	EnterpriseUserDeploymentServer EnterpriseUserDeployment = "SERVER" // The user is part of a GitHub Enterprise Server deployment.
)

// EnvironmentOrderField represents properties by which environments connections can be ordered.
type EnvironmentOrderField string

// Properties by which environments connections can be ordered.
const (
	EnvironmentOrderFieldName EnvironmentOrderField = "NAME" // Order environments by name.
)

// FileViewedState represents the possible viewed states of a file .
type FileViewedState string

// The possible viewed states of a file .
const (
	FileViewedStateDismissed FileViewedState = "DISMISSED" // The file has new changes since last viewed.
	FileViewedStateViewed    FileViewedState = "VIEWED"    // The file has been marked as viewed.
	FileViewedStateUnviewed  FileViewedState = "UNVIEWED"  // The file has not been marked as viewed.
)

// FundingPlatform represents the possible funding platforms for repository funding links.
type FundingPlatform string

// The possible funding platforms for repository funding links.
const (
	FundingPlatformGitHub          FundingPlatform = "GITHUB"           // GitHub funding platform.
	FundingPlatformPatreon         FundingPlatform = "PATREON"          // Patreon funding platform.
	FundingPlatformOpenCollective  FundingPlatform = "OPEN_COLLECTIVE"  // Open Collective funding platform.
	FundingPlatformKoFi            FundingPlatform = "KO_FI"            // Ko-fi funding platform.
	FundingPlatformTidelift        FundingPlatform = "TIDELIFT"         // Tidelift funding platform.
	FundingPlatformCommunityBridge FundingPlatform = "COMMUNITY_BRIDGE" // Community Bridge funding platform.
	FundingPlatformLiberapay       FundingPlatform = "LIBERAPAY"        // Liberapay funding platform.
	FundingPlatformIssueHunt       FundingPlatform = "ISSUEHUNT"        // IssueHunt funding platform.
	FundingPlatformLFXCrowdfunding FundingPlatform = "LFX_CROWDFUNDING" // LFX Crowdfunding funding platform.
	FundingPlatformPolar           FundingPlatform = "POLAR"            // Polar funding platform.
	FundingPlatformBuyMeACoffee    FundingPlatform = "BUY_ME_A_COFFEE"  // Buy Me a Coffee funding platform.
	FundingPlatformCustom          FundingPlatform = "CUSTOM"           // Custom funding platform.
)

// GistOrderField represents properties by which gist connections can be ordered.
type GistOrderField string

// Properties by which gist connections can be ordered.
const (
	GistOrderFieldCreatedAt GistOrderField = "CREATED_AT" // Order gists by creation time.
	GistOrderFieldUpdatedAt GistOrderField = "UPDATED_AT" // Order gists by update time.
	GistOrderFieldPushedAt  GistOrderField = "PUSHED_AT"  // Order gists by push time.
)

// GistPrivacy represents the privacy of a Gist.
type GistPrivacy string

// The privacy of a Gist.
const (
	GistPrivacyPublic GistPrivacy = "PUBLIC" // Public.
	GistPrivacySecret GistPrivacy = "SECRET" // Secret.
	GistPrivacyAll    GistPrivacy = "ALL"    // Gists that are public and secret.
)

// GitSignatureState represents the state of a Git signature.
type GitSignatureState string

// The state of a Git signature.
const (
	GitSignatureStateValid                GitSignatureState = "VALID"                 // Valid signature and verified by GitHub.
	GitSignatureStateInvalid              GitSignatureState = "INVALID"               // Invalid signature.
	GitSignatureStateMalformedSig         GitSignatureState = "MALFORMED_SIG"         // Malformed signature.
	GitSignatureStateUnknownKey           GitSignatureState = "UNKNOWN_KEY"           // Key used for signing not known to GitHub.
	GitSignatureStateBadEmail             GitSignatureState = "BAD_EMAIL"             // Invalid email used for signing.
	GitSignatureStateUnverifiedEmail      GitSignatureState = "UNVERIFIED_EMAIL"      // Email used for signing unverified on GitHub.
	GitSignatureStateNoUser               GitSignatureState = "NO_USER"               // Email used for signing not known to GitHub.
	GitSignatureStateUnknownSigType       GitSignatureState = "UNKNOWN_SIG_TYPE"      // Unknown signature type.
	GitSignatureStateUnsigned             GitSignatureState = "UNSIGNED"              // Unsigned.
	GitSignatureStateGpgverifyUnavailable GitSignatureState = "GPGVERIFY_UNAVAILABLE" // Internal error - the GPG verification service is unavailable at the moment.
	GitSignatureStateGpgverifyError       GitSignatureState = "GPGVERIFY_ERROR"       // Internal error - the GPG verification service misbehaved.
	GitSignatureStateNotSigningKey        GitSignatureState = "NOT_SIGNING_KEY"       // The usage flags for the key that signed this don't allow signing.
	GitSignatureStateExpiredKey           GitSignatureState = "EXPIRED_KEY"           // Signing key expired.
	GitSignatureStateOcspPending          GitSignatureState = "OCSP_PENDING"          // Valid signature, pending certificate revocation checking.
	GitSignatureStateOcspError            GitSignatureState = "OCSP_ERROR"            // Valid signature, though certificate revocation check failed.
	GitSignatureStateBadCert              GitSignatureState = "BAD_CERT"              // The signing certificate or its chain could not be verified.
	GitSignatureStateOcspRevoked          GitSignatureState = "OCSP_REVOKED"          // One or more certificates in chain has been revoked.
)

// IdentityProviderConfigurationState represents the possible states in which authentication can be configured with an identity provider.
type IdentityProviderConfigurationState string

// The possible states in which authentication can be configured with an identity provider.
const (
	IdentityProviderConfigurationStateEnforced     IdentityProviderConfigurationState = "ENFORCED"     // Authentication with an identity provider is configured and enforced.
	IdentityProviderConfigurationStateConfigured   IdentityProviderConfigurationState = "CONFIGURED"   // Authentication with an identity provider is configured but not enforced.
	IdentityProviderConfigurationStateUnconfigured IdentityProviderConfigurationState = "UNCONFIGURED" // Authentication with an identity provider is not configured.
)

// IpAllowListEnabledSettingValue represents the possible values for the IP allow list enabled setting.
type IpAllowListEnabledSettingValue string

// The possible values for the IP allow list enabled setting.
const (
	IpAllowListEnabledSettingValueEnabled  IpAllowListEnabledSettingValue = "ENABLED"  // The setting is enabled for the owner.
	IpAllowListEnabledSettingValueDisabled IpAllowListEnabledSettingValue = "DISABLED" // The setting is disabled for the owner.
)

// IpAllowListEntryOrderField represents properties by which IP allow list entry connections can be ordered.
type IpAllowListEntryOrderField string

// Properties by which IP allow list entry connections can be ordered.
const (
	IpAllowListEntryOrderFieldCreatedAt      IpAllowListEntryOrderField = "CREATED_AT"       // Order IP allow list entries by creation time.
	IpAllowListEntryOrderFieldAllowListValue IpAllowListEntryOrderField = "ALLOW_LIST_VALUE" // Order IP allow list entries by the allow list value.
)

// IpAllowListForInstalledAppsEnabledSettingValue represents the possible values for the IP allow list configuration for installed GitHub Apps setting.
type IpAllowListForInstalledAppsEnabledSettingValue string

// The possible values for the IP allow list configuration for installed GitHub Apps setting.
const (
	IpAllowListForInstalledAppsEnabledSettingValueEnabled  IpAllowListForInstalledAppsEnabledSettingValue = "ENABLED"  // The setting is enabled for the owner.
	IpAllowListForInstalledAppsEnabledSettingValueDisabled IpAllowListForInstalledAppsEnabledSettingValue = "DISABLED" // The setting is disabled for the owner.
)

// IssueClosedStateReason represents the possible state reasons of a closed issue.
type IssueClosedStateReason string

// The possible state reasons of a closed issue.
const (
	IssueClosedStateReasonCompleted  IssueClosedStateReason = "COMPLETED"   // An issue that has been closed as completed.
	IssueClosedStateReasonNotPlanned IssueClosedStateReason = "NOT_PLANNED" // An issue that has been closed as not planned.
)

// IssueCommentOrderField represents properties by which issue comment connections can be ordered.
type IssueCommentOrderField string

// Properties by which issue comment connections can be ordered.
const (
	IssueCommentOrderFieldUpdatedAt IssueCommentOrderField = "UPDATED_AT" // Order issue comments by update time.
)

// IssueOrderField represents properties by which issue connections can be ordered.
type IssueOrderField string

// Properties by which issue connections can be ordered.
const (
	IssueOrderFieldCreatedAt IssueOrderField = "CREATED_AT" // Order issues by creation time.
	IssueOrderFieldUpdatedAt IssueOrderField = "UPDATED_AT" // Order issues by update time.
	IssueOrderFieldComments  IssueOrderField = "COMMENTS"   // Order issues by comment count.
)

// IssueState represents the possible states of an issue.
type IssueState string

// The possible states of an issue.
const (
	IssueStateOpen   IssueState = "OPEN"   // An issue that is still open.
	IssueStateClosed IssueState = "CLOSED" // An issue that has been closed.
)

// IssueStateReason represents the possible state reasons of an issue.
type IssueStateReason string

// The possible state reasons of an issue.
const (
	IssueStateReasonReopened   IssueStateReason = "REOPENED"    // An issue that has been reopened.
	IssueStateReasonNotPlanned IssueStateReason = "NOT_PLANNED" // An issue that has been closed as not planned.
	IssueStateReasonCompleted  IssueStateReason = "COMPLETED"   // An issue that has been closed as completed.
)

// IssueTimelineItemsItemType represents the possible item types found in a timeline.
type IssueTimelineItemsItemType string

// The possible item types found in a timeline.
const (
	IssueTimelineItemsItemTypeIssueComment               IssueTimelineItemsItemType = "ISSUE_COMMENT"                  // Represents a comment on an Issue.
	IssueTimelineItemsItemTypeCrossReferencedEvent       IssueTimelineItemsItemType = "CROSS_REFERENCED_EVENT"         // Represents a mention made by one issue or pull request to another.
	IssueTimelineItemsItemTypeAddedToProjectEvent        IssueTimelineItemsItemType = "ADDED_TO_PROJECT_EVENT"         // Represents a 'added_to_project' event on a given issue or pull request.
	IssueTimelineItemsItemTypeAssignedEvent              IssueTimelineItemsItemType = "ASSIGNED_EVENT"                 // Represents an 'assigned' event on any assignable object.
	IssueTimelineItemsItemTypeClosedEvent                IssueTimelineItemsItemType = "CLOSED_EVENT"                   // Represents a 'closed' event on any `Closable`.
	IssueTimelineItemsItemTypeCommentDeletedEvent        IssueTimelineItemsItemType = "COMMENT_DELETED_EVENT"          // Represents a 'comment_deleted' event on a given issue or pull request.
	IssueTimelineItemsItemTypeConnectedEvent             IssueTimelineItemsItemType = "CONNECTED_EVENT"                // Represents a 'connected' event on a given issue or pull request.
	IssueTimelineItemsItemTypeConvertedNoteToIssueEvent  IssueTimelineItemsItemType = "CONVERTED_NOTE_TO_ISSUE_EVENT"  // Represents a 'converted_note_to_issue' event on a given issue or pull request.
	IssueTimelineItemsItemTypeConvertedToDiscussionEvent IssueTimelineItemsItemType = "CONVERTED_TO_DISCUSSION_EVENT"  // Represents a 'converted_to_discussion' event on a given issue.
	IssueTimelineItemsItemTypeDemilestonedEvent          IssueTimelineItemsItemType = "DEMILESTONED_EVENT"             // Represents a 'demilestoned' event on a given issue or pull request.
	IssueTimelineItemsItemTypeDisconnectedEvent          IssueTimelineItemsItemType = "DISCONNECTED_EVENT"             // Represents a 'disconnected' event on a given issue or pull request.
	IssueTimelineItemsItemTypeLabeledEvent               IssueTimelineItemsItemType = "LABELED_EVENT"                  // Represents a 'labeled' event on a given issue or pull request.
	IssueTimelineItemsItemTypeLockedEvent                IssueTimelineItemsItemType = "LOCKED_EVENT"                   // Represents a 'locked' event on a given issue or pull request.
	IssueTimelineItemsItemTypeMarkedAsDuplicateEvent     IssueTimelineItemsItemType = "MARKED_AS_DUPLICATE_EVENT"      // Represents a 'marked_as_duplicate' event on a given issue or pull request.
	IssueTimelineItemsItemTypeMentionedEvent             IssueTimelineItemsItemType = "MENTIONED_EVENT"                // Represents a 'mentioned' event on a given issue or pull request.
	IssueTimelineItemsItemTypeMilestonedEvent            IssueTimelineItemsItemType = "MILESTONED_EVENT"               // Represents a 'milestoned' event on a given issue or pull request.
	IssueTimelineItemsItemTypeMovedColumnsInProjectEvent IssueTimelineItemsItemType = "MOVED_COLUMNS_IN_PROJECT_EVENT" // Represents a 'moved_columns_in_project' event on a given issue or pull request.
	IssueTimelineItemsItemTypePinnedEvent                IssueTimelineItemsItemType = "PINNED_EVENT"                   // Represents a 'pinned' event on a given issue or pull request.
	IssueTimelineItemsItemTypeReferencedEvent            IssueTimelineItemsItemType = "REFERENCED_EVENT"               // Represents a 'referenced' event on a given `ReferencedSubject`.
	IssueTimelineItemsItemTypeRemovedFromProjectEvent    IssueTimelineItemsItemType = "REMOVED_FROM_PROJECT_EVENT"     // Represents a 'removed_from_project' event on a given issue or pull request.
	IssueTimelineItemsItemTypeRenamedTitleEvent          IssueTimelineItemsItemType = "RENAMED_TITLE_EVENT"            // Represents a 'renamed' event on a given issue or pull request.
	IssueTimelineItemsItemTypeReopenedEvent              IssueTimelineItemsItemType = "REOPENED_EVENT"                 // Represents a 'reopened' event on any `Closable`.
	IssueTimelineItemsItemTypeSubscribedEvent            IssueTimelineItemsItemType = "SUBSCRIBED_EVENT"               // Represents a 'subscribed' event on a given `Subscribable`.
	IssueTimelineItemsItemTypeTransferredEvent           IssueTimelineItemsItemType = "TRANSFERRED_EVENT"              // Represents a 'transferred' event on a given issue or pull request.
	IssueTimelineItemsItemTypeUnassignedEvent            IssueTimelineItemsItemType = "UNASSIGNED_EVENT"               // Represents an 'unassigned' event on any assignable object.
	IssueTimelineItemsItemTypeUnlabeledEvent             IssueTimelineItemsItemType = "UNLABELED_EVENT"                // Represents an 'unlabeled' event on a given issue or pull request.
	IssueTimelineItemsItemTypeUnlockedEvent              IssueTimelineItemsItemType = "UNLOCKED_EVENT"                 // Represents an 'unlocked' event on a given issue or pull request.
	IssueTimelineItemsItemTypeUserBlockedEvent           IssueTimelineItemsItemType = "USER_BLOCKED_EVENT"             // Represents a 'user_blocked' event on a given user.
	IssueTimelineItemsItemTypeUnmarkedAsDuplicateEvent   IssueTimelineItemsItemType = "UNMARKED_AS_DUPLICATE_EVENT"    // Represents an 'unmarked_as_duplicate' event on a given issue or pull request.
	IssueTimelineItemsItemTypeUnpinnedEvent              IssueTimelineItemsItemType = "UNPINNED_EVENT"                 // Represents an 'unpinned' event on a given issue or pull request.
	IssueTimelineItemsItemTypeUnsubscribedEvent          IssueTimelineItemsItemType = "UNSUBSCRIBED_EVENT"             // Represents an 'unsubscribed' event on a given `Subscribable`.
)

// LabelOrderField represents properties by which label connections can be ordered.
type LabelOrderField string

// Properties by which label connections can be ordered.
const (
	LabelOrderFieldName      LabelOrderField = "NAME"       // Order labels by name.
	LabelOrderFieldCreatedAt LabelOrderField = "CREATED_AT" // Order labels by creation time.
)

// LanguageOrderField represents properties by which language connections can be ordered.
type LanguageOrderField string

// Properties by which language connections can be ordered.
const (
	LanguageOrderFieldSize LanguageOrderField = "SIZE" // Order languages by the size of all files containing the language.
)

// LockReason represents the possible reasons that an issue or pull request was locked.
type LockReason string

// The possible reasons that an issue or pull request was locked.
const (
	LockReasonOffTopic  LockReason = "OFF_TOPIC"  // The issue or pull request was locked because the conversation was off-topic.
	LockReasonTooHeated LockReason = "TOO_HEATED" // The issue or pull request was locked because the conversation was too heated.
	LockReasonResolved  LockReason = "RESOLVED"   // The issue or pull request was locked because the conversation was resolved.
	LockReasonSpam      LockReason = "SPAM"       // The issue or pull request was locked because the conversation was spam.
)

// MannequinOrderField represents properties by which mannequins can be ordered.
type MannequinOrderField string

// Properties by which mannequins can be ordered.
const (
	MannequinOrderFieldLogin     MannequinOrderField = "LOGIN"      // Order mannequins alphabetically by their source login.
	MannequinOrderFieldCreatedAt MannequinOrderField = "CREATED_AT" // Order mannequins why when they were created.
)

// MergeCommitMessage represents the possible default commit messages for merges.
type MergeCommitMessage string

// The possible default commit messages for merges.
const (
	MergeCommitMessagePrTitle MergeCommitMessage = "PR_TITLE" // Default to the pull request's title.
	MergeCommitMessagePrBody  MergeCommitMessage = "PR_BODY"  // Default to the pull request's body.
	MergeCommitMessageBlank   MergeCommitMessage = "BLANK"    // Default to a blank commit message.
)

// MergeCommitTitle represents the possible default commit titles for merges.
type MergeCommitTitle string

// The possible default commit titles for merges.
const (
	MergeCommitTitlePrTitle      MergeCommitTitle = "PR_TITLE"      // Default to the pull request's title.
	MergeCommitTitleMergeMessage MergeCommitTitle = "MERGE_MESSAGE" // Default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
)

// MergeQueueEntryState represents the possible states for a merge queue entry.
type MergeQueueEntryState string

// The possible states for a merge queue entry.
const (
	MergeQueueEntryStateQueued         MergeQueueEntryState = "QUEUED"          // The entry is currently queued.
	MergeQueueEntryStateAwaitingChecks MergeQueueEntryState = "AWAITING_CHECKS" // The entry is currently waiting for checks to pass.
	MergeQueueEntryStateMergeable      MergeQueueEntryState = "MERGEABLE"       // The entry is currently mergeable.
	MergeQueueEntryStateUnmergeable    MergeQueueEntryState = "UNMERGEABLE"     // The entry is currently unmergeable.
	MergeQueueEntryStateLocked         MergeQueueEntryState = "LOCKED"          // The entry is currently locked.
)

// MergeQueueMergingStrategy represents the possible merging strategies for a merge queue.
type MergeQueueMergingStrategy string

// The possible merging strategies for a merge queue.
const (
	MergeQueueMergingStrategyAllgreen  MergeQueueMergingStrategy = "ALLGREEN"  // Entries only allowed to merge if they are passing.
	MergeQueueMergingStrategyHeadgreen MergeQueueMergingStrategy = "HEADGREEN" // Failing Entires are allowed to merge if they are with a passing entry.
)

// MergeStateStatus represents detailed status information about a pull request merge.
type MergeStateStatus string

// Detailed status information about a pull request merge.
const (
	MergeStateStatusDirty    MergeStateStatus = "DIRTY"     // The merge commit cannot be cleanly created.
	MergeStateStatusUnknown  MergeStateStatus = "UNKNOWN"   // The state cannot currently be determined.
	MergeStateStatusBlocked  MergeStateStatus = "BLOCKED"   // The merge is blocked.
	MergeStateStatusBehind   MergeStateStatus = "BEHIND"    // The head ref is out of date.
	MergeStateStatusDraft    MergeStateStatus = "DRAFT"     // The merge is blocked due to the pull request being a draft.
	MergeStateStatusUnstable MergeStateStatus = "UNSTABLE"  // Mergeable with non-passing commit status.
	MergeStateStatusHasHooks MergeStateStatus = "HAS_HOOKS" // Mergeable with passing commit status and pre-receive hooks.
	MergeStateStatusClean    MergeStateStatus = "CLEAN"     // Mergeable and passing commit status.
)

// MergeableState represents whether or not a PullRequest can be merged.
type MergeableState string

// Whether or not a PullRequest can be merged.
const (
	MergeableStateMergeable   MergeableState = "MERGEABLE"   // The pull request can be merged.
	MergeableStateConflicting MergeableState = "CONFLICTING" // The pull request cannot be merged due to merge conflicts.
	MergeableStateUnknown     MergeableState = "UNKNOWN"     // The mergeability of the pull request is still being calculated.
)

// MigrationSourceType represents represents the different GitHub Enterprise Importer (GEI) migration sources.
type MigrationSourceType string

// Represents the different GitHub Enterprise Importer (GEI) migration sources.
const (
	MigrationSourceTypeAzureDevOps     MigrationSourceType = "AZURE_DEVOPS"     // An Azure DevOps migration source.
	MigrationSourceTypeBitbucketServer MigrationSourceType = "BITBUCKET_SERVER" // A Bitbucket Server migration source.
	MigrationSourceTypeGitHubArchive   MigrationSourceType = "GITHUB_ARCHIVE"   // A GitHub Migration API source.
)

// MigrationState represents the GitHub Enterprise Importer (GEI) migration state.
type MigrationState string

// The GitHub Enterprise Importer (GEI) migration state.
const (
	MigrationStateNotStarted        MigrationState = "NOT_STARTED"        // The migration has not started.
	MigrationStateQueued            MigrationState = "QUEUED"             // The migration has been queued.
	MigrationStateInProgress        MigrationState = "IN_PROGRESS"        // The migration is in progress.
	MigrationStateSucceeded         MigrationState = "SUCCEEDED"          // The migration has succeeded.
	MigrationStateFailed            MigrationState = "FAILED"             // The migration has failed.
	MigrationStatePendingValidation MigrationState = "PENDING_VALIDATION" // The migration needs to have its credentials validated.
	MigrationStateFailedValidation  MigrationState = "FAILED_VALIDATION"  // The migration has invalid credentials.
)

// MilestoneOrderField represents properties by which milestone connections can be ordered.
type MilestoneOrderField string

// Properties by which milestone connections can be ordered.
const (
	MilestoneOrderFieldDueDate   MilestoneOrderField = "DUE_DATE"   // Order milestones by when they are due.
	MilestoneOrderFieldCreatedAt MilestoneOrderField = "CREATED_AT" // Order milestones by when they were created.
	MilestoneOrderFieldUpdatedAt MilestoneOrderField = "UPDATED_AT" // Order milestones by when they were last updated.
	MilestoneOrderFieldNumber    MilestoneOrderField = "NUMBER"     // Order milestones by their number.
)

// MilestoneState represents the possible states of a milestone.
type MilestoneState string

// The possible states of a milestone.
const (
	MilestoneStateOpen   MilestoneState = "OPEN"   // A milestone that is still open.
	MilestoneStateClosed MilestoneState = "CLOSED" // A milestone that has been closed.
)

// NotificationRestrictionSettingValue represents the possible values for the notification restriction setting.
type NotificationRestrictionSettingValue string

// The possible values for the notification restriction setting.
const (
	NotificationRestrictionSettingValueEnabled  NotificationRestrictionSettingValue = "ENABLED"  // The setting is enabled for the owner.
	NotificationRestrictionSettingValueDisabled NotificationRestrictionSettingValue = "DISABLED" // The setting is disabled for the owner.
)

// OIDCProviderType represents the OIDC identity provider type.
type OIDCProviderType string

// The OIDC identity provider type.
const (
	OIDCProviderTypeAad OIDCProviderType = "AAD" // Azure Active Directory.
)

// OauthApplicationCreateAuditEntryState represents the state of an OAuth application when it was created.
type OauthApplicationCreateAuditEntryState string

// The state of an OAuth application when it was created.
const (
	OauthApplicationCreateAuditEntryStateActive          OauthApplicationCreateAuditEntryState = "ACTIVE"           // The OAuth application was active and allowed to have OAuth Accesses.
	OauthApplicationCreateAuditEntryStateSuspended       OauthApplicationCreateAuditEntryState = "SUSPENDED"        // The OAuth application was suspended from generating OAuth Accesses due to abuse or security concerns.
	OauthApplicationCreateAuditEntryStatePendingDeletion OauthApplicationCreateAuditEntryState = "PENDING_DELETION" // The OAuth application was in the process of being deleted.
)

// OperationType represents the corresponding operation type for the action.
type OperationType string

// The corresponding operation type for the action.
const (
	OperationTypeAccess         OperationType = "ACCESS"         // An existing resource was accessed.
	OperationTypeAuthentication OperationType = "AUTHENTICATION" // A resource performed an authentication event.
	OperationTypeCreate         OperationType = "CREATE"         // A new resource was created.
	OperationTypeModify         OperationType = "MODIFY"         // An existing resource was modified.
	OperationTypeRemove         OperationType = "REMOVE"         // An existing resource was removed.
	OperationTypeRestore        OperationType = "RESTORE"        // An existing resource was restored.
	OperationTypeTransfer       OperationType = "TRANSFER"       // An existing resource was transferred between multiple resources.
)

// OrderDirection represents possible directions in which to order a list of items when provided an `orderBy` argument.
type OrderDirection string

// Possible directions in which to order a list of items when provided an `orderBy` argument.
const (
	OrderDirectionAsc  OrderDirection = "ASC"  // Specifies an ascending order for a given `orderBy` argument.
	OrderDirectionDesc OrderDirection = "DESC" // Specifies a descending order for a given `orderBy` argument.
)

// OrgAddMemberAuditEntryPermission represents the permissions available to members on an Organization.
type OrgAddMemberAuditEntryPermission string

// The permissions available to members on an Organization.
const (
	OrgAddMemberAuditEntryPermissionRead  OrgAddMemberAuditEntryPermission = "READ"  // Can read and clone repositories.
	OrgAddMemberAuditEntryPermissionAdmin OrgAddMemberAuditEntryPermission = "ADMIN" // Can read, clone, push, and add collaborators to repositories.
)

// OrgCreateAuditEntryBillingPlan represents the billing plans available for organizations.
type OrgCreateAuditEntryBillingPlan string

// The billing plans available for organizations.
const (
	OrgCreateAuditEntryBillingPlanFree          OrgCreateAuditEntryBillingPlan = "FREE"            // Free Plan.
	OrgCreateAuditEntryBillingPlanBusiness      OrgCreateAuditEntryBillingPlan = "BUSINESS"        // Team Plan.
	OrgCreateAuditEntryBillingPlanBusinessPlus  OrgCreateAuditEntryBillingPlan = "BUSINESS_PLUS"   // Enterprise Cloud Plan.
	OrgCreateAuditEntryBillingPlanUnlimited     OrgCreateAuditEntryBillingPlan = "UNLIMITED"       // Legacy Unlimited Plan.
	OrgCreateAuditEntryBillingPlanTieredPerSeat OrgCreateAuditEntryBillingPlan = "TIERED_PER_SEAT" // Tiered Per Seat Plan.
)

// OrgEnterpriseOwnerOrderField represents properties by which enterprise owners can be ordered.
type OrgEnterpriseOwnerOrderField string

// Properties by which enterprise owners can be ordered.
const (
	OrgEnterpriseOwnerOrderFieldLogin OrgEnterpriseOwnerOrderField = "LOGIN" // Order enterprise owners by login.
)

// OrgRemoveBillingManagerAuditEntryReason represents the reason a billing manager was removed from an Organization.
type OrgRemoveBillingManagerAuditEntryReason string

// The reason a billing manager was removed from an Organization.
const (
	OrgRemoveBillingManagerAuditEntryReasonTwoFactorRequirementNonCompliance          OrgRemoveBillingManagerAuditEntryReason = "TWO_FACTOR_REQUIREMENT_NON_COMPLIANCE"           // The organization required 2FA of its billing managers and this user did not have 2FA enabled.
	OrgRemoveBillingManagerAuditEntryReasonSamlExternalIdentityMissing                OrgRemoveBillingManagerAuditEntryReason = "SAML_EXTERNAL_IDENTITY_MISSING"                  // SAML external identity missing.
	OrgRemoveBillingManagerAuditEntryReasonSamlSsoEnforcementRequiresExternalIdentity OrgRemoveBillingManagerAuditEntryReason = "SAML_SSO_ENFORCEMENT_REQUIRES_EXTERNAL_IDENTITY" // SAML SSO enforcement requires an external identity.
)

// OrgRemoveMemberAuditEntryMembershipType represents the type of membership a user has with an Organization.
type OrgRemoveMemberAuditEntryMembershipType string

// The type of membership a user has with an Organization.
const (
	OrgRemoveMemberAuditEntryMembershipTypeSuspended           OrgRemoveMemberAuditEntryMembershipType = "SUSPENDED"            // A suspended member.
	OrgRemoveMemberAuditEntryMembershipTypeDirectMember        OrgRemoveMemberAuditEntryMembershipType = "DIRECT_MEMBER"        // A direct member is a user that is a member of the Organization.
	OrgRemoveMemberAuditEntryMembershipTypeAdmin               OrgRemoveMemberAuditEntryMembershipType = "ADMIN"                // Organization owners have full access and can change several settings, including the names of repositories that belong to the Organization and Owners team membership. In addition, organization owners can delete the organization and all of its repositories.
	OrgRemoveMemberAuditEntryMembershipTypeBillingManager      OrgRemoveMemberAuditEntryMembershipType = "BILLING_MANAGER"      // A billing manager is a user who manages the billing settings for the Organization, such as updating payment information.
	OrgRemoveMemberAuditEntryMembershipTypeUnaffiliated        OrgRemoveMemberAuditEntryMembershipType = "UNAFFILIATED"         // An unaffiliated collaborator is a person who is not a member of the Organization and does not have access to any repositories in the Organization.
	OrgRemoveMemberAuditEntryMembershipTypeOutsideCollaborator OrgRemoveMemberAuditEntryMembershipType = "OUTSIDE_COLLABORATOR" // An outside collaborator is a person who isn't explicitly a member of the Organization, but who has Read, Write, or Admin permissions to one or more repositories in the organization.
)

// OrgRemoveMemberAuditEntryReason represents the reason a member was removed from an Organization.
type OrgRemoveMemberAuditEntryReason string

// The reason a member was removed from an Organization.
const (
	OrgRemoveMemberAuditEntryReasonTwoFactorRequirementNonCompliance          OrgRemoveMemberAuditEntryReason = "TWO_FACTOR_REQUIREMENT_NON_COMPLIANCE"           // The organization required 2FA of its billing managers and this user did not have 2FA enabled.
	OrgRemoveMemberAuditEntryReasonSamlExternalIdentityMissing                OrgRemoveMemberAuditEntryReason = "SAML_EXTERNAL_IDENTITY_MISSING"                  // SAML external identity missing.
	OrgRemoveMemberAuditEntryReasonSamlSsoEnforcementRequiresExternalIdentity OrgRemoveMemberAuditEntryReason = "SAML_SSO_ENFORCEMENT_REQUIRES_EXTERNAL_IDENTITY" // SAML SSO enforcement requires an external identity.
	OrgRemoveMemberAuditEntryReasonUserAccountDeleted                         OrgRemoveMemberAuditEntryReason = "USER_ACCOUNT_DELETED"                            // User account has been deleted.
	OrgRemoveMemberAuditEntryReasonTwoFactorAccountRecovery                   OrgRemoveMemberAuditEntryReason = "TWO_FACTOR_ACCOUNT_RECOVERY"                     // User was removed from organization during account recovery.
)

// OrgRemoveOutsideCollaboratorAuditEntryMembershipType represents the type of membership a user has with an Organization.
type OrgRemoveOutsideCollaboratorAuditEntryMembershipType string

// The type of membership a user has with an Organization.
const (
	OrgRemoveOutsideCollaboratorAuditEntryMembershipTypeOutsideCollaborator OrgRemoveOutsideCollaboratorAuditEntryMembershipType = "OUTSIDE_COLLABORATOR" // An outside collaborator is a person who isn't explicitly a member of the Organization, but who has Read, Write, or Admin permissions to one or more repositories in the organization.
	OrgRemoveOutsideCollaboratorAuditEntryMembershipTypeUnaffiliated        OrgRemoveOutsideCollaboratorAuditEntryMembershipType = "UNAFFILIATED"         // An unaffiliated collaborator is a person who is not a member of the Organization and does not have access to any repositories in the organization.
	OrgRemoveOutsideCollaboratorAuditEntryMembershipTypeBillingManager      OrgRemoveOutsideCollaboratorAuditEntryMembershipType = "BILLING_MANAGER"      // A billing manager is a user who manages the billing settings for the Organization, such as updating payment information.
)

// OrgRemoveOutsideCollaboratorAuditEntryReason represents the reason an outside collaborator was removed from an Organization.
type OrgRemoveOutsideCollaboratorAuditEntryReason string

// The reason an outside collaborator was removed from an Organization.
const (
	OrgRemoveOutsideCollaboratorAuditEntryReasonTwoFactorRequirementNonCompliance OrgRemoveOutsideCollaboratorAuditEntryReason = "TWO_FACTOR_REQUIREMENT_NON_COMPLIANCE" // The organization required 2FA of its billing managers and this user did not have 2FA enabled.
	OrgRemoveOutsideCollaboratorAuditEntryReasonSamlExternalIdentityMissing       OrgRemoveOutsideCollaboratorAuditEntryReason = "SAML_EXTERNAL_IDENTITY_MISSING"        // SAML external identity missing.
)

// OrgUpdateDefaultRepositoryPermissionAuditEntryPermission represents the default permission a repository can have in an Organization.
type OrgUpdateDefaultRepositoryPermissionAuditEntryPermission string

// The default permission a repository can have in an Organization.
const (
	OrgUpdateDefaultRepositoryPermissionAuditEntryPermissionRead  OrgUpdateDefaultRepositoryPermissionAuditEntryPermission = "READ"  // Can read and clone repositories.
	OrgUpdateDefaultRepositoryPermissionAuditEntryPermissionWrite OrgUpdateDefaultRepositoryPermissionAuditEntryPermission = "WRITE" // Can read, clone and push to repositories.
	OrgUpdateDefaultRepositoryPermissionAuditEntryPermissionAdmin OrgUpdateDefaultRepositoryPermissionAuditEntryPermission = "ADMIN" // Can read, clone, push, and add collaborators to repositories.
	OrgUpdateDefaultRepositoryPermissionAuditEntryPermissionNone  OrgUpdateDefaultRepositoryPermissionAuditEntryPermission = "NONE"  // No default permission value.
)

// OrgUpdateMemberAuditEntryPermission represents the permissions available to members on an Organization.
type OrgUpdateMemberAuditEntryPermission string

// The permissions available to members on an Organization.
const (
	OrgUpdateMemberAuditEntryPermissionRead  OrgUpdateMemberAuditEntryPermission = "READ"  // Can read and clone repositories.
	OrgUpdateMemberAuditEntryPermissionAdmin OrgUpdateMemberAuditEntryPermission = "ADMIN" // Can read, clone, push, and add collaborators to repositories.
)

// OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility represents the permissions available for repository creation on an Organization.
type OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility string

// The permissions available for repository creation on an Organization.
const (
	OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibilityAll             OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility = "ALL"              // All organization members are restricted from creating any repositories.
	OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibilityPublic          OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility = "PUBLIC"           // All organization members are restricted from creating public repositories.
	OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibilityNone            OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility = "NONE"             // All organization members are allowed to create any repositories.
	OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibilityPrivate         OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility = "PRIVATE"          // All organization members are restricted from creating private repositories.
	OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibilityInternal        OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility = "INTERNAL"         // All organization members are restricted from creating internal repositories.
	OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibilityPublicInternal  OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility = "PUBLIC_INTERNAL"  // All organization members are restricted from creating public or internal repositories.
	OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibilityPrivateInternal OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility = "PRIVATE_INTERNAL" // All organization members are restricted from creating private or internal repositories.
	OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibilityPublicPrivate   OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility = "PUBLIC_PRIVATE"   // All organization members are restricted from creating public or private repositories.
)

// OrganizationInvitationRole represents the possible organization invitation roles.
type OrganizationInvitationRole string

// The possible organization invitation roles.
const (
	OrganizationInvitationRoleDirectMember   OrganizationInvitationRole = "DIRECT_MEMBER"   // The user is invited to be a direct member of the organization.
	OrganizationInvitationRoleAdmin          OrganizationInvitationRole = "ADMIN"           // The user is invited to be an admin of the organization.
	OrganizationInvitationRoleBillingManager OrganizationInvitationRole = "BILLING_MANAGER" // The user is invited to be a billing manager of the organization.
	OrganizationInvitationRoleReinstate      OrganizationInvitationRole = "REINSTATE"       // The user's previous role will be reinstated.
)

// OrganizationInvitationSource represents the possible organization invitation sources.
type OrganizationInvitationSource string

// The possible organization invitation sources.
const (
	OrganizationInvitationSourceUnknown OrganizationInvitationSource = "UNKNOWN" // The invitation was sent before this feature was added.
	OrganizationInvitationSourceMember  OrganizationInvitationSource = "MEMBER"  // The invitation was created from the web interface or from API.
	OrganizationInvitationSourceSCIM    OrganizationInvitationSource = "SCIM"    // The invitation was created from SCIM.
)

// OrganizationInvitationType represents the possible organization invitation types.
type OrganizationInvitationType string

// The possible organization invitation types.
const (
	OrganizationInvitationTypeUser  OrganizationInvitationType = "USER"  // The invitation was to an existing user.
	OrganizationInvitationTypeEmail OrganizationInvitationType = "EMAIL" // The invitation was to an email address.
)

// OrganizationMemberRole represents the possible roles within an organization for its members.
type OrganizationMemberRole string

// The possible roles within an organization for its members.
const (
	OrganizationMemberRoleMember OrganizationMemberRole = "MEMBER" // The user is a member of the organization.
	OrganizationMemberRoleAdmin  OrganizationMemberRole = "ADMIN"  // The user is an administrator of the organization.
)

// OrganizationMembersCanCreateRepositoriesSettingValue represents the possible values for the members can create repositories setting on an organization.
type OrganizationMembersCanCreateRepositoriesSettingValue string

// The possible values for the members can create repositories setting on an organization.
const (
	OrganizationMembersCanCreateRepositoriesSettingValueAll      OrganizationMembersCanCreateRepositoriesSettingValue = "ALL"      // Members will be able to create public and private repositories.
	OrganizationMembersCanCreateRepositoriesSettingValuePrivate  OrganizationMembersCanCreateRepositoriesSettingValue = "PRIVATE"  // Members will be able to create only private repositories.
	OrganizationMembersCanCreateRepositoriesSettingValueInternal OrganizationMembersCanCreateRepositoriesSettingValue = "INTERNAL" // Members will be able to create only internal repositories.
	OrganizationMembersCanCreateRepositoriesSettingValueDisabled OrganizationMembersCanCreateRepositoriesSettingValue = "DISABLED" // Members will not be able to create public or private repositories.
)

// OrganizationMigrationState represents the Octoshift Organization migration state.
type OrganizationMigrationState string

// The Octoshift Organization migration state.
const (
	OrganizationMigrationStateNotStarted        OrganizationMigrationState = "NOT_STARTED"         // The Octoshift migration has not started.
	OrganizationMigrationStateQueued            OrganizationMigrationState = "QUEUED"              // The Octoshift migration has been queued.
	OrganizationMigrationStateInProgress        OrganizationMigrationState = "IN_PROGRESS"         // The Octoshift migration is in progress.
	OrganizationMigrationStatePreRepoMigration  OrganizationMigrationState = "PRE_REPO_MIGRATION"  // The Octoshift migration is performing pre repository migrations.
	OrganizationMigrationStateRepoMigration     OrganizationMigrationState = "REPO_MIGRATION"      // The Octoshift org migration is performing repository migrations.
	OrganizationMigrationStatePostRepoMigration OrganizationMigrationState = "POST_REPO_MIGRATION" // The Octoshift migration is performing post repository migrations.
	OrganizationMigrationStateSucceeded         OrganizationMigrationState = "SUCCEEDED"           // The Octoshift migration has succeeded.
	OrganizationMigrationStateFailed            OrganizationMigrationState = "FAILED"              // The Octoshift migration has failed.
	OrganizationMigrationStatePendingValidation OrganizationMigrationState = "PENDING_VALIDATION"  // The Octoshift migration needs to have its credentials validated.
	OrganizationMigrationStateFailedValidation  OrganizationMigrationState = "FAILED_VALIDATION"   // The Octoshift migration has invalid credentials.
)

// OrganizationOrderField represents properties by which organization connections can be ordered.
type OrganizationOrderField string

// Properties by which organization connections can be ordered.
const (
	OrganizationOrderFieldCreatedAt OrganizationOrderField = "CREATED_AT" // Order organizations by creation time.
	OrganizationOrderFieldLogin     OrganizationOrderField = "LOGIN"      // Order organizations by login.
)

// PackageFileOrderField represents properties by which package file connections can be ordered.
type PackageFileOrderField string

// Properties by which package file connections can be ordered.
const (
	PackageFileOrderFieldCreatedAt PackageFileOrderField = "CREATED_AT" // Order package files by creation time.
)

// PackageOrderField represents properties by which package connections can be ordered.
type PackageOrderField string

// Properties by which package connections can be ordered.
const (
	PackageOrderFieldCreatedAt PackageOrderField = "CREATED_AT" // Order packages by creation time.
)

// PackageType represents the possible types of a package.
type PackageType string

// The possible types of a package.
const (
	PackageTypeNpm      PackageType = "NPM"      // An npm package.
	PackageTypeRubygems PackageType = "RUBYGEMS" // A rubygems package.
	PackageTypeMaven    PackageType = "MAVEN"    // A maven package.
	PackageTypeDocker   PackageType = "DOCKER"   // A docker image.
	PackageTypeDebian   PackageType = "DEBIAN"   // A debian package.
	PackageTypeNuget    PackageType = "NUGET"    // A nuget package.
	PackageTypePypi     PackageType = "PYPI"     // A python package.
)

// PackageVersionOrderField represents properties by which package version connections can be ordered.
type PackageVersionOrderField string

// Properties by which package version connections can be ordered.
const (
	PackageVersionOrderFieldCreatedAt PackageVersionOrderField = "CREATED_AT" // Order package versions by creation time.
)

// PatchStatus represents the possible types of patch statuses.
type PatchStatus string

// The possible types of patch statuses.
const (
	PatchStatusAdded    PatchStatus = "ADDED"    // The file was added. Git status 'A'.
	PatchStatusDeleted  PatchStatus = "DELETED"  // The file was deleted. Git status 'D'.
	PatchStatusRenamed  PatchStatus = "RENAMED"  // The file was renamed. Git status 'R'.
	PatchStatusCopied   PatchStatus = "COPIED"   // The file was copied. Git status 'C'.
	PatchStatusModified PatchStatus = "MODIFIED" // The file's contents were changed. Git status 'M'.
	PatchStatusChanged  PatchStatus = "CHANGED"  // The file's type was changed. Git status 'T'.
)

// PinnableItemType represents represents items that can be pinned to a profile page or dashboard.
type PinnableItemType string

// Represents items that can be pinned to a profile page or dashboard.
const (
	PinnableItemTypeRepository   PinnableItemType = "REPOSITORY"   // A repository.
	PinnableItemTypeGist         PinnableItemType = "GIST"         // A gist.
	PinnableItemTypeIssue        PinnableItemType = "ISSUE"        // An issue.
	PinnableItemTypeProject      PinnableItemType = "PROJECT"      // A project.
	PinnableItemTypePullRequest  PinnableItemType = "PULL_REQUEST" // A pull request.
	PinnableItemTypeUser         PinnableItemType = "USER"         // A user.
	PinnableItemTypeOrganization PinnableItemType = "ORGANIZATION" // An organization.
	PinnableItemTypeTeam         PinnableItemType = "TEAM"         // A team.
)

// PinnedDiscussionGradient represents preconfigured gradients that may be used to style discussions pinned within a repository.
type PinnedDiscussionGradient string

// Preconfigured gradients that may be used to style discussions pinned within a repository.
const (
	PinnedDiscussionGradientRedOrange   PinnedDiscussionGradient = "RED_ORANGE"   // A gradient of red to orange.
	PinnedDiscussionGradientBlueMint    PinnedDiscussionGradient = "BLUE_MINT"    // A gradient of blue to mint.
	PinnedDiscussionGradientBluePurple  PinnedDiscussionGradient = "BLUE_PURPLE"  // A gradient of blue to purple.
	PinnedDiscussionGradientPinkBlue    PinnedDiscussionGradient = "PINK_BLUE"    // A gradient of pink to blue.
	PinnedDiscussionGradientPurpleCoral PinnedDiscussionGradient = "PURPLE_CORAL" // A gradient of purple to coral.
)

// PinnedDiscussionPattern represents preconfigured background patterns that may be used to style discussions pinned within a repository.
type PinnedDiscussionPattern string

// Preconfigured background patterns that may be used to style discussions pinned within a repository.
const (
	PinnedDiscussionPatternDotFill   PinnedDiscussionPattern = "DOT_FILL"   // A solid dot pattern.
	PinnedDiscussionPatternPlus      PinnedDiscussionPattern = "PLUS"       // A plus sign pattern.
	PinnedDiscussionPatternZap       PinnedDiscussionPattern = "ZAP"        // A lightning bolt pattern.
	PinnedDiscussionPatternChevronUp PinnedDiscussionPattern = "CHEVRON_UP" // An upward-facing chevron pattern.
	PinnedDiscussionPatternDot       PinnedDiscussionPattern = "DOT"        // A hollow dot pattern.
	PinnedDiscussionPatternHeartFill PinnedDiscussionPattern = "HEART_FILL" // A heart pattern.
)

// ProjectCardArchivedState represents the possible archived states of a project card.
type ProjectCardArchivedState string

// The possible archived states of a project card.
const (
	ProjectCardArchivedStateArchived    ProjectCardArchivedState = "ARCHIVED"     // A project card that is archived.
	ProjectCardArchivedStateNotArchived ProjectCardArchivedState = "NOT_ARCHIVED" // A project card that is not archived.
)

// ProjectCardState represents various content states of a ProjectCard.
type ProjectCardState string

// Various content states of a ProjectCard.
const (
	ProjectCardStateContentOnly ProjectCardState = "CONTENT_ONLY" // The card has content only.
	ProjectCardStateNoteOnly    ProjectCardState = "NOTE_ONLY"    // The card has a note only.
	ProjectCardStateRedacted    ProjectCardState = "REDACTED"     // The card is redacted.
)

// ProjectColumnPurpose represents the semantic purpose of the column - todo, in progress, or done.
type ProjectColumnPurpose string

// The semantic purpose of the column - todo, in progress, or done.
const (
	ProjectColumnPurposeTodo       ProjectColumnPurpose = "TODO"        // The column contains cards still to be worked on.
	ProjectColumnPurposeInProgress ProjectColumnPurpose = "IN_PROGRESS" // The column contains cards which are currently being worked on.
	ProjectColumnPurposeDone       ProjectColumnPurpose = "DONE"        // The column contains cards which are complete.
)

// ProjectOrderField represents properties by which project connections can be ordered.
type ProjectOrderField string

// Properties by which project connections can be ordered.
const (
	ProjectOrderFieldCreatedAt ProjectOrderField = "CREATED_AT" // Order projects by creation time.
	ProjectOrderFieldUpdatedAt ProjectOrderField = "UPDATED_AT" // Order projects by update time.
	ProjectOrderFieldName      ProjectOrderField = "NAME"       // Order projects by name.
)

// ProjectState represents state of the project; either 'open' or 'closed'.
type ProjectState string

// State of the project; either 'open' or 'closed'.
const (
	ProjectStateOpen   ProjectState = "OPEN"   // The project is open.
	ProjectStateClosed ProjectState = "CLOSED" // The project is closed.
)

// ProjectTemplate represents gitHub-provided templates for Projects.
type ProjectTemplate string

// GitHub-provided templates for Projects.
const (
	ProjectTemplateBasicKanban            ProjectTemplate = "BASIC_KANBAN"             // Create a board with columns for To do, In progress and Done.
	ProjectTemplateAutomatedKanbanV2      ProjectTemplate = "AUTOMATED_KANBAN_V2"      // Create a board with v2 triggers to automatically move cards across To do, In progress and Done columns.
	ProjectTemplateAutomatedReviewsKanban ProjectTemplate = "AUTOMATED_REVIEWS_KANBAN" // Create a board with triggers to automatically move cards across columns with review automation.
	ProjectTemplateBugTriage              ProjectTemplate = "BUG_TRIAGE"               // Create a board to triage and prioritize bugs with To do, priority, and Done columns.
)

// ProjectV2CustomFieldType represents the type of a project field.
type ProjectV2CustomFieldType string

// The type of a project field.
const (
	ProjectV2CustomFieldTypeText         ProjectV2CustomFieldType = "TEXT"          // Text.
	ProjectV2CustomFieldTypeSingleSelect ProjectV2CustomFieldType = "SINGLE_SELECT" // Single Select.
	ProjectV2CustomFieldTypeNumber       ProjectV2CustomFieldType = "NUMBER"        // Number.
	ProjectV2CustomFieldTypeDate         ProjectV2CustomFieldType = "DATE"          // Date.
)

// ProjectV2FieldOrderField represents properties by which project v2 field connections can be ordered.
type ProjectV2FieldOrderField string

// Properties by which project v2 field connections can be ordered.
const (
	ProjectV2FieldOrderFieldPosition  ProjectV2FieldOrderField = "POSITION"   // Order project v2 fields by position.
	ProjectV2FieldOrderFieldCreatedAt ProjectV2FieldOrderField = "CREATED_AT" // Order project v2 fields by creation time.
	ProjectV2FieldOrderFieldName      ProjectV2FieldOrderField = "NAME"       // Order project v2 fields by name.
)

// ProjectV2FieldType represents the type of a project field.
type ProjectV2FieldType string

// The type of a project field.
const (
	ProjectV2FieldTypeAssignees          ProjectV2FieldType = "ASSIGNEES"            // Assignees.
	ProjectV2FieldTypeLinkedPullRequests ProjectV2FieldType = "LINKED_PULL_REQUESTS" // Linked Pull Requests.
	ProjectV2FieldTypeReviewers          ProjectV2FieldType = "REVIEWERS"            // Reviewers.
	ProjectV2FieldTypeLabels             ProjectV2FieldType = "LABELS"               // Labels.
	ProjectV2FieldTypeMilestone          ProjectV2FieldType = "MILESTONE"            // Milestone.
	ProjectV2FieldTypeRepository         ProjectV2FieldType = "REPOSITORY"           // Repository.
	ProjectV2FieldTypeTitle              ProjectV2FieldType = "TITLE"                // Title.
	ProjectV2FieldTypeText               ProjectV2FieldType = "TEXT"                 // Text.
	ProjectV2FieldTypeSingleSelect       ProjectV2FieldType = "SINGLE_SELECT"        // Single Select.
	ProjectV2FieldTypeNumber             ProjectV2FieldType = "NUMBER"               // Number.
	ProjectV2FieldTypeDate               ProjectV2FieldType = "DATE"                 // Date.
	ProjectV2FieldTypeIteration          ProjectV2FieldType = "ITERATION"            // Iteration.
	ProjectV2FieldTypeTracks             ProjectV2FieldType = "TRACKS"               // Tracks.
	ProjectV2FieldTypeTrackedBy          ProjectV2FieldType = "TRACKED_BY"           // Tracked by.
)

// ProjectV2ItemFieldValueOrderField represents properties by which project v2 item field value connections can be ordered.
type ProjectV2ItemFieldValueOrderField string

// Properties by which project v2 item field value connections can be ordered.
const (
	ProjectV2ItemFieldValueOrderFieldPosition ProjectV2ItemFieldValueOrderField = "POSITION" // Order project v2 item field values by the their position in the project.
)

// ProjectV2ItemOrderField represents properties by which project v2 item connections can be ordered.
type ProjectV2ItemOrderField string

// Properties by which project v2 item connections can be ordered.
const (
	ProjectV2ItemOrderFieldPosition ProjectV2ItemOrderField = "POSITION" // Order project v2 items by the their position in the project.
)

// ProjectV2ItemType represents the type of a project item.
type ProjectV2ItemType string

// The type of a project item.
const (
	ProjectV2ItemTypeIssue       ProjectV2ItemType = "ISSUE"        // Issue.
	ProjectV2ItemTypePullRequest ProjectV2ItemType = "PULL_REQUEST" // Pull Request.
	ProjectV2ItemTypeDraftIssue  ProjectV2ItemType = "DRAFT_ISSUE"  // Draft Issue.
	ProjectV2ItemTypeRedacted    ProjectV2ItemType = "REDACTED"     // Redacted Item.
)

// ProjectV2OrderField represents properties by which projects can be ordered.
type ProjectV2OrderField string

// Properties by which projects can be ordered.
const (
	ProjectV2OrderFieldTitle     ProjectV2OrderField = "TITLE"      // The project's title.
	ProjectV2OrderFieldNumber    ProjectV2OrderField = "NUMBER"     // The project's number.
	ProjectV2OrderFieldUpdatedAt ProjectV2OrderField = "UPDATED_AT" // The project's date and time of update.
	ProjectV2OrderFieldCreatedAt ProjectV2OrderField = "CREATED_AT" // The project's date and time of creation.
)

// ProjectV2Roles represents the possible roles of a collaborator on a project.
type ProjectV2Roles string

// The possible roles of a collaborator on a project.
const (
	ProjectV2RolesNone   ProjectV2Roles = "NONE"   // The collaborator has no direct access to the project.
	ProjectV2RolesReader ProjectV2Roles = "READER" // The collaborator can view the project.
	ProjectV2RolesWriter ProjectV2Roles = "WRITER" // The collaborator can view and edit the project.
	ProjectV2RolesAdmin  ProjectV2Roles = "ADMIN"  // The collaborator can view, edit, and maange the settings of the project.
)

// ProjectV2SingleSelectFieldOptionColor represents the display color of a single-select field option.
type ProjectV2SingleSelectFieldOptionColor string

// The display color of a single-select field option.
const (
	ProjectV2SingleSelectFieldOptionColorGray   ProjectV2SingleSelectFieldOptionColor = "GRAY"   // GRAY.
	ProjectV2SingleSelectFieldOptionColorBlue   ProjectV2SingleSelectFieldOptionColor = "BLUE"   // BLUE.
	ProjectV2SingleSelectFieldOptionColorGreen  ProjectV2SingleSelectFieldOptionColor = "GREEN"  // GREEN.
	ProjectV2SingleSelectFieldOptionColorYellow ProjectV2SingleSelectFieldOptionColor = "YELLOW" // YELLOW.
	ProjectV2SingleSelectFieldOptionColorOrange ProjectV2SingleSelectFieldOptionColor = "ORANGE" // ORANGE.
	ProjectV2SingleSelectFieldOptionColorRed    ProjectV2SingleSelectFieldOptionColor = "RED"    // RED.
	ProjectV2SingleSelectFieldOptionColorPink   ProjectV2SingleSelectFieldOptionColor = "PINK"   // PINK.
	ProjectV2SingleSelectFieldOptionColorPurple ProjectV2SingleSelectFieldOptionColor = "PURPLE" // PURPLE.
)

// ProjectV2State represents the possible states of a project v2.
type ProjectV2State string

// The possible states of a project v2.
const (
	ProjectV2StateOpen   ProjectV2State = "OPEN"   // A project v2 that is still open.
	ProjectV2StateClosed ProjectV2State = "CLOSED" // A project v2 that has been closed.
)

// ProjectV2ViewLayout represents the layout of a project v2 view.
type ProjectV2ViewLayout string

// The layout of a project v2 view.
const (
	ProjectV2ViewLayoutBoardLayout   ProjectV2ViewLayout = "BOARD_LAYOUT"   // Board layout.
	ProjectV2ViewLayoutTableLayout   ProjectV2ViewLayout = "TABLE_LAYOUT"   // Table layout.
	ProjectV2ViewLayoutRoadmapLayout ProjectV2ViewLayout = "ROADMAP_LAYOUT" // Roadmap layout.
)

// ProjectV2ViewOrderField represents properties by which project v2 view connections can be ordered.
type ProjectV2ViewOrderField string

// Properties by which project v2 view connections can be ordered.
const (
	ProjectV2ViewOrderFieldPosition  ProjectV2ViewOrderField = "POSITION"   // Order project v2 views by position.
	ProjectV2ViewOrderFieldCreatedAt ProjectV2ViewOrderField = "CREATED_AT" // Order project v2 views by creation time.
	ProjectV2ViewOrderFieldName      ProjectV2ViewOrderField = "NAME"       // Order project v2 views by name.
)

// ProjectV2WorkflowsOrderField represents properties by which project workflows can be ordered.
type ProjectV2WorkflowsOrderField string

// Properties by which project workflows can be ordered.
const (
	ProjectV2WorkflowsOrderFieldName      ProjectV2WorkflowsOrderField = "NAME"       // The name of the workflow.
	ProjectV2WorkflowsOrderFieldNumber    ProjectV2WorkflowsOrderField = "NUMBER"     // The number of the workflow.
	ProjectV2WorkflowsOrderFieldUpdatedAt ProjectV2WorkflowsOrderField = "UPDATED_AT" // The date and time of the workflow update.
	ProjectV2WorkflowsOrderFieldCreatedAt ProjectV2WorkflowsOrderField = "CREATED_AT" // The date and time of the workflow creation.
)

// PullRequestBranchUpdateMethod represents the possible methods for updating a pull request's head branch with the base branch.
type PullRequestBranchUpdateMethod string

// The possible methods for updating a pull request's head branch with the base branch.
const (
	PullRequestBranchUpdateMethodMerge  PullRequestBranchUpdateMethod = "MERGE"  // Update branch via merge.
	PullRequestBranchUpdateMethodRebase PullRequestBranchUpdateMethod = "REBASE" // Update branch via rebase.
)

// PullRequestMergeMethod represents represents available types of methods to use when merging a pull request.
type PullRequestMergeMethod string

// Represents available types of methods to use when merging a pull request.
const (
	PullRequestMergeMethodMerge  PullRequestMergeMethod = "MERGE"  // Add all commits from the head branch to the base branch with a merge commit.
	PullRequestMergeMethodSquash PullRequestMergeMethod = "SQUASH" // Combine all commits from the head branch into a single commit in the base branch.
	PullRequestMergeMethodRebase PullRequestMergeMethod = "REBASE" // Add all commits from the head branch onto the base branch individually.
)

// PullRequestOrderField represents properties by which pull_requests connections can be ordered.
type PullRequestOrderField string

// Properties by which pull_requests connections can be ordered.
const (
	PullRequestOrderFieldCreatedAt PullRequestOrderField = "CREATED_AT" // Order pull_requests by creation time.
	PullRequestOrderFieldUpdatedAt PullRequestOrderField = "UPDATED_AT" // Order pull_requests by update time.
)

// PullRequestReviewCommentState represents the possible states of a pull request review comment.
type PullRequestReviewCommentState string

// The possible states of a pull request review comment.
const (
	PullRequestReviewCommentStatePending   PullRequestReviewCommentState = "PENDING"   // A comment that is part of a pending review.
	PullRequestReviewCommentStateSubmitted PullRequestReviewCommentState = "SUBMITTED" // A comment that is part of a submitted review.
)

// PullRequestReviewDecision represents the review status of a pull request.
type PullRequestReviewDecision string

// The review status of a pull request.
const (
	PullRequestReviewDecisionChangesRequested PullRequestReviewDecision = "CHANGES_REQUESTED" // Changes have been requested on the pull request.
	PullRequestReviewDecisionApproved         PullRequestReviewDecision = "APPROVED"          // The pull request has received an approving review.
	PullRequestReviewDecisionReviewRequired   PullRequestReviewDecision = "REVIEW_REQUIRED"   // A review is required before the pull request can be merged.
)

// PullRequestReviewEvent represents the possible events to perform on a pull request review.
type PullRequestReviewEvent string

// The possible events to perform on a pull request review.
const (
	PullRequestReviewEventComment        PullRequestReviewEvent = "COMMENT"         // Submit general feedback without explicit approval.
	PullRequestReviewEventApprove        PullRequestReviewEvent = "APPROVE"         // Submit feedback and approve merging these changes.
	PullRequestReviewEventRequestChanges PullRequestReviewEvent = "REQUEST_CHANGES" // Submit feedback that must be addressed before merging.
	PullRequestReviewEventDismiss        PullRequestReviewEvent = "DISMISS"         // Dismiss review so it now longer effects merging.
)

// PullRequestReviewState represents the possible states of a pull request review.
type PullRequestReviewState string

// The possible states of a pull request review.
const (
	PullRequestReviewStatePending          PullRequestReviewState = "PENDING"           // A review that has not yet been submitted.
	PullRequestReviewStateCommented        PullRequestReviewState = "COMMENTED"         // An informational review.
	PullRequestReviewStateApproved         PullRequestReviewState = "APPROVED"          // A review allowing the pull request to merge.
	PullRequestReviewStateChangesRequested PullRequestReviewState = "CHANGES_REQUESTED" // A review blocking the pull request from merging.
	PullRequestReviewStateDismissed        PullRequestReviewState = "DISMISSED"         // A review that has been dismissed.
)

// PullRequestReviewThreadSubjectType represents the possible subject types of a pull request review comment.
type PullRequestReviewThreadSubjectType string

// The possible subject types of a pull request review comment.
const (
	PullRequestReviewThreadSubjectTypeLine PullRequestReviewThreadSubjectType = "LINE" // A comment that has been made against the line of a pull request.
	PullRequestReviewThreadSubjectTypeFile PullRequestReviewThreadSubjectType = "FILE" // A comment that has been made against the file of a pull request.
)

// PullRequestState represents the possible states of a pull request.
type PullRequestState string

// The possible states of a pull request.
const (
	PullRequestStateOpen   PullRequestState = "OPEN"   // A pull request that is still open.
	PullRequestStateClosed PullRequestState = "CLOSED" // A pull request that has been closed without being merged.
	PullRequestStateMerged PullRequestState = "MERGED" // A pull request that has been closed by being merged.
)

// PullRequestTimelineItemsItemType represents the possible item types found in a timeline.
type PullRequestTimelineItemsItemType string

// The possible item types found in a timeline.
const (
	PullRequestTimelineItemsItemTypePullRequestCommit                 PullRequestTimelineItemsItemType = "PULL_REQUEST_COMMIT"                   // Represents a Git commit part of a pull request.
	PullRequestTimelineItemsItemTypePullRequestCommitCommentThread    PullRequestTimelineItemsItemType = "PULL_REQUEST_COMMIT_COMMENT_THREAD"    // Represents a commit comment thread part of a pull request.
	PullRequestTimelineItemsItemTypePullRequestReview                 PullRequestTimelineItemsItemType = "PULL_REQUEST_REVIEW"                   // A review object for a given pull request.
	PullRequestTimelineItemsItemTypePullRequestReviewThread           PullRequestTimelineItemsItemType = "PULL_REQUEST_REVIEW_THREAD"            // A threaded list of comments for a given pull request.
	PullRequestTimelineItemsItemTypePullRequestRevisionMarker         PullRequestTimelineItemsItemType = "PULL_REQUEST_REVISION_MARKER"          // Represents the latest point in the pull request timeline for which the viewer has seen the pull request's commits.
	PullRequestTimelineItemsItemTypeAutomaticBaseChangeFailedEvent    PullRequestTimelineItemsItemType = "AUTOMATIC_BASE_CHANGE_FAILED_EVENT"    // Represents a 'automatic_base_change_failed' event on a given pull request.
	PullRequestTimelineItemsItemTypeAutomaticBaseChangeSucceededEvent PullRequestTimelineItemsItemType = "AUTOMATIC_BASE_CHANGE_SUCCEEDED_EVENT" // Represents a 'automatic_base_change_succeeded' event on a given pull request.
	PullRequestTimelineItemsItemTypeAutoMergeDisabledEvent            PullRequestTimelineItemsItemType = "AUTO_MERGE_DISABLED_EVENT"             // Represents a 'auto_merge_disabled' event on a given pull request.
	PullRequestTimelineItemsItemTypeAutoMergeEnabledEvent             PullRequestTimelineItemsItemType = "AUTO_MERGE_ENABLED_EVENT"              // Represents a 'auto_merge_enabled' event on a given pull request.
	PullRequestTimelineItemsItemTypeAutoRebaseEnabledEvent            PullRequestTimelineItemsItemType = "AUTO_REBASE_ENABLED_EVENT"             // Represents a 'auto_rebase_enabled' event on a given pull request.
	PullRequestTimelineItemsItemTypeAutoSquashEnabledEvent            PullRequestTimelineItemsItemType = "AUTO_SQUASH_ENABLED_EVENT"             // Represents a 'auto_squash_enabled' event on a given pull request.
	PullRequestTimelineItemsItemTypeBaseRefChangedEvent               PullRequestTimelineItemsItemType = "BASE_REF_CHANGED_EVENT"                // Represents a 'base_ref_changed' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeBaseRefForcePushedEvent           PullRequestTimelineItemsItemType = "BASE_REF_FORCE_PUSHED_EVENT"           // Represents a 'base_ref_force_pushed' event on a given pull request.
	PullRequestTimelineItemsItemTypeBaseRefDeletedEvent               PullRequestTimelineItemsItemType = "BASE_REF_DELETED_EVENT"                // Represents a 'base_ref_deleted' event on a given pull request.
	PullRequestTimelineItemsItemTypeDeployedEvent                     PullRequestTimelineItemsItemType = "DEPLOYED_EVENT"                        // Represents a 'deployed' event on a given pull request.
	PullRequestTimelineItemsItemTypeDeploymentEnvironmentChangedEvent PullRequestTimelineItemsItemType = "DEPLOYMENT_ENVIRONMENT_CHANGED_EVENT"  // Represents a 'deployment_environment_changed' event on a given pull request.
	PullRequestTimelineItemsItemTypeHeadRefDeletedEvent               PullRequestTimelineItemsItemType = "HEAD_REF_DELETED_EVENT"                // Represents a 'head_ref_deleted' event on a given pull request.
	PullRequestTimelineItemsItemTypeHeadRefForcePushedEvent           PullRequestTimelineItemsItemType = "HEAD_REF_FORCE_PUSHED_EVENT"           // Represents a 'head_ref_force_pushed' event on a given pull request.
	PullRequestTimelineItemsItemTypeHeadRefRestoredEvent              PullRequestTimelineItemsItemType = "HEAD_REF_RESTORED_EVENT"               // Represents a 'head_ref_restored' event on a given pull request.
	PullRequestTimelineItemsItemTypeMergedEvent                       PullRequestTimelineItemsItemType = "MERGED_EVENT"                          // Represents a 'merged' event on a given pull request.
	PullRequestTimelineItemsItemTypeReviewDismissedEvent              PullRequestTimelineItemsItemType = "REVIEW_DISMISSED_EVENT"                // Represents a 'review_dismissed' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeReviewRequestedEvent              PullRequestTimelineItemsItemType = "REVIEW_REQUESTED_EVENT"                // Represents an 'review_requested' event on a given pull request.
	PullRequestTimelineItemsItemTypeReviewRequestRemovedEvent         PullRequestTimelineItemsItemType = "REVIEW_REQUEST_REMOVED_EVENT"          // Represents an 'review_request_removed' event on a given pull request.
	PullRequestTimelineItemsItemTypeReadyForReviewEvent               PullRequestTimelineItemsItemType = "READY_FOR_REVIEW_EVENT"                // Represents a 'ready_for_review' event on a given pull request.
	PullRequestTimelineItemsItemTypeConvertToDraftEvent               PullRequestTimelineItemsItemType = "CONVERT_TO_DRAFT_EVENT"                // Represents a 'convert_to_draft' event on a given pull request.
	PullRequestTimelineItemsItemTypeAddedToMergeQueueEvent            PullRequestTimelineItemsItemType = "ADDED_TO_MERGE_QUEUE_EVENT"            // Represents an 'added_to_merge_queue' event on a given pull request.
	PullRequestTimelineItemsItemTypeRemovedFromMergeQueueEvent        PullRequestTimelineItemsItemType = "REMOVED_FROM_MERGE_QUEUE_EVENT"        // Represents a 'removed_from_merge_queue' event on a given pull request.
	PullRequestTimelineItemsItemTypeIssueComment                      PullRequestTimelineItemsItemType = "ISSUE_COMMENT"                         // Represents a comment on an Issue.
	PullRequestTimelineItemsItemTypeCrossReferencedEvent              PullRequestTimelineItemsItemType = "CROSS_REFERENCED_EVENT"                // Represents a mention made by one issue or pull request to another.
	PullRequestTimelineItemsItemTypeAddedToProjectEvent               PullRequestTimelineItemsItemType = "ADDED_TO_PROJECT_EVENT"                // Represents a 'added_to_project' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeAssignedEvent                     PullRequestTimelineItemsItemType = "ASSIGNED_EVENT"                        // Represents an 'assigned' event on any assignable object.
	PullRequestTimelineItemsItemTypeClosedEvent                       PullRequestTimelineItemsItemType = "CLOSED_EVENT"                          // Represents a 'closed' event on any `Closable`.
	PullRequestTimelineItemsItemTypeCommentDeletedEvent               PullRequestTimelineItemsItemType = "COMMENT_DELETED_EVENT"                 // Represents a 'comment_deleted' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeConnectedEvent                    PullRequestTimelineItemsItemType = "CONNECTED_EVENT"                       // Represents a 'connected' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeConvertedNoteToIssueEvent         PullRequestTimelineItemsItemType = "CONVERTED_NOTE_TO_ISSUE_EVENT"         // Represents a 'converted_note_to_issue' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeConvertedToDiscussionEvent        PullRequestTimelineItemsItemType = "CONVERTED_TO_DISCUSSION_EVENT"         // Represents a 'converted_to_discussion' event on a given issue.
	PullRequestTimelineItemsItemTypeDemilestonedEvent                 PullRequestTimelineItemsItemType = "DEMILESTONED_EVENT"                    // Represents a 'demilestoned' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeDisconnectedEvent                 PullRequestTimelineItemsItemType = "DISCONNECTED_EVENT"                    // Represents a 'disconnected' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeLabeledEvent                      PullRequestTimelineItemsItemType = "LABELED_EVENT"                         // Represents a 'labeled' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeLockedEvent                       PullRequestTimelineItemsItemType = "LOCKED_EVENT"                          // Represents a 'locked' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeMarkedAsDuplicateEvent            PullRequestTimelineItemsItemType = "MARKED_AS_DUPLICATE_EVENT"             // Represents a 'marked_as_duplicate' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeMentionedEvent                    PullRequestTimelineItemsItemType = "MENTIONED_EVENT"                       // Represents a 'mentioned' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeMilestonedEvent                   PullRequestTimelineItemsItemType = "MILESTONED_EVENT"                      // Represents a 'milestoned' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeMovedColumnsInProjectEvent        PullRequestTimelineItemsItemType = "MOVED_COLUMNS_IN_PROJECT_EVENT"        // Represents a 'moved_columns_in_project' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypePinnedEvent                       PullRequestTimelineItemsItemType = "PINNED_EVENT"                          // Represents a 'pinned' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeReferencedEvent                   PullRequestTimelineItemsItemType = "REFERENCED_EVENT"                      // Represents a 'referenced' event on a given `ReferencedSubject`.
	PullRequestTimelineItemsItemTypeRemovedFromProjectEvent           PullRequestTimelineItemsItemType = "REMOVED_FROM_PROJECT_EVENT"            // Represents a 'removed_from_project' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeRenamedTitleEvent                 PullRequestTimelineItemsItemType = "RENAMED_TITLE_EVENT"                   // Represents a 'renamed' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeReopenedEvent                     PullRequestTimelineItemsItemType = "REOPENED_EVENT"                        // Represents a 'reopened' event on any `Closable`.
	PullRequestTimelineItemsItemTypeSubscribedEvent                   PullRequestTimelineItemsItemType = "SUBSCRIBED_EVENT"                      // Represents a 'subscribed' event on a given `Subscribable`.
	PullRequestTimelineItemsItemTypeTransferredEvent                  PullRequestTimelineItemsItemType = "TRANSFERRED_EVENT"                     // Represents a 'transferred' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeUnassignedEvent                   PullRequestTimelineItemsItemType = "UNASSIGNED_EVENT"                      // Represents an 'unassigned' event on any assignable object.
	PullRequestTimelineItemsItemTypeUnlabeledEvent                    PullRequestTimelineItemsItemType = "UNLABELED_EVENT"                       // Represents an 'unlabeled' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeUnlockedEvent                     PullRequestTimelineItemsItemType = "UNLOCKED_EVENT"                        // Represents an 'unlocked' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeUserBlockedEvent                  PullRequestTimelineItemsItemType = "USER_BLOCKED_EVENT"                    // Represents a 'user_blocked' event on a given user.
	PullRequestTimelineItemsItemTypeUnmarkedAsDuplicateEvent          PullRequestTimelineItemsItemType = "UNMARKED_AS_DUPLICATE_EVENT"           // Represents an 'unmarked_as_duplicate' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeUnpinnedEvent                     PullRequestTimelineItemsItemType = "UNPINNED_EVENT"                        // Represents an 'unpinned' event on a given issue or pull request.
	PullRequestTimelineItemsItemTypeUnsubscribedEvent                 PullRequestTimelineItemsItemType = "UNSUBSCRIBED_EVENT"                    // Represents an 'unsubscribed' event on a given `Subscribable`.
)

// PullRequestUpdateState represents the possible target states when updating a pull request.
type PullRequestUpdateState string

// The possible target states when updating a pull request.
const (
	PullRequestUpdateStateOpen   PullRequestUpdateState = "OPEN"   // A pull request that is still open.
	PullRequestUpdateStateClosed PullRequestUpdateState = "CLOSED" // A pull request that has been closed without being merged.
)

// ReactionContent represents emojis that can be attached to Issues, Pull Requests and Comments.
type ReactionContent string

// Emojis that can be attached to Issues, Pull Requests and Comments.
const (
	ReactionContentThumbsUp   ReactionContent = "THUMBS_UP"   // Represents the `:+1:` emoji.
	ReactionContentThumbsDown ReactionContent = "THUMBS_DOWN" // Represents the `:-1:` emoji.
	ReactionContentLaugh      ReactionContent = "LAUGH"       // Represents the `:laugh:` emoji.
	ReactionContentHooray     ReactionContent = "HOORAY"      // Represents the `:hooray:` emoji.
	ReactionContentConfused   ReactionContent = "CONFUSED"    // Represents the `:confused:` emoji.
	ReactionContentHeart      ReactionContent = "HEART"       // Represents the `:heart:` emoji.
	ReactionContentRocket     ReactionContent = "ROCKET"      // Represents the `:rocket:` emoji.
	ReactionContentEyes       ReactionContent = "EYES"        // Represents the `:eyes:` emoji.
)

// ReactionOrderField represents a list of fields that reactions can be ordered by.
type ReactionOrderField string

// A list of fields that reactions can be ordered by.
const (
	ReactionOrderFieldCreatedAt ReactionOrderField = "CREATED_AT" // Allows ordering a list of reactions by when they were created.
)

// RefOrderField represents properties by which ref connections can be ordered.
type RefOrderField string

// Properties by which ref connections can be ordered.
const (
	RefOrderFieldTagCommitDate RefOrderField = "TAG_COMMIT_DATE" // Order refs by underlying commit date if the ref prefix is refs/tags/.
	RefOrderFieldAlphabetical  RefOrderField = "ALPHABETICAL"    // Order refs by their alphanumeric name.
)

// ReleaseOrderField represents properties by which release connections can be ordered.
type ReleaseOrderField string

// Properties by which release connections can be ordered.
const (
	ReleaseOrderFieldCreatedAt ReleaseOrderField = "CREATED_AT" // Order releases by creation time.
	ReleaseOrderFieldName      ReleaseOrderField = "NAME"       // Order releases alphabetically by name.
)

// RepoAccessAuditEntryVisibility represents the privacy of a repository.
type RepoAccessAuditEntryVisibility string

// The privacy of a repository.
const (
	RepoAccessAuditEntryVisibilityInternal RepoAccessAuditEntryVisibility = "INTERNAL" // The repository is visible only to users in the same business.
	RepoAccessAuditEntryVisibilityPrivate  RepoAccessAuditEntryVisibility = "PRIVATE"  // The repository is visible only to those with explicit access.
	RepoAccessAuditEntryVisibilityPublic   RepoAccessAuditEntryVisibility = "PUBLIC"   // The repository is visible to everyone.
)

// RepoAddMemberAuditEntryVisibility represents the privacy of a repository.
type RepoAddMemberAuditEntryVisibility string

// The privacy of a repository.
const (
	RepoAddMemberAuditEntryVisibilityInternal RepoAddMemberAuditEntryVisibility = "INTERNAL" // The repository is visible only to users in the same business.
	RepoAddMemberAuditEntryVisibilityPrivate  RepoAddMemberAuditEntryVisibility = "PRIVATE"  // The repository is visible only to those with explicit access.
	RepoAddMemberAuditEntryVisibilityPublic   RepoAddMemberAuditEntryVisibility = "PUBLIC"   // The repository is visible to everyone.
)

// RepoArchivedAuditEntryVisibility represents the privacy of a repository.
type RepoArchivedAuditEntryVisibility string

// The privacy of a repository.
const (
	RepoArchivedAuditEntryVisibilityInternal RepoArchivedAuditEntryVisibility = "INTERNAL" // The repository is visible only to users in the same business.
	RepoArchivedAuditEntryVisibilityPrivate  RepoArchivedAuditEntryVisibility = "PRIVATE"  // The repository is visible only to those with explicit access.
	RepoArchivedAuditEntryVisibilityPublic   RepoArchivedAuditEntryVisibility = "PUBLIC"   // The repository is visible to everyone.
)

// RepoChangeMergeSettingAuditEntryMergeType represents the merge options available for pull requests to this repository.
type RepoChangeMergeSettingAuditEntryMergeType string

// The merge options available for pull requests to this repository.
const (
	RepoChangeMergeSettingAuditEntryMergeTypeMerge  RepoChangeMergeSettingAuditEntryMergeType = "MERGE"  // The pull request is added to the base branch in a merge commit.
	RepoChangeMergeSettingAuditEntryMergeTypeRebase RepoChangeMergeSettingAuditEntryMergeType = "REBASE" // Commits from the pull request are added onto the base branch individually without a merge commit.
	RepoChangeMergeSettingAuditEntryMergeTypeSquash RepoChangeMergeSettingAuditEntryMergeType = "SQUASH" // The pull request's commits are squashed into a single commit before they are merged to the base branch.
)

// RepoCreateAuditEntryVisibility represents the privacy of a repository.
type RepoCreateAuditEntryVisibility string

// The privacy of a repository.
const (
	RepoCreateAuditEntryVisibilityInternal RepoCreateAuditEntryVisibility = "INTERNAL" // The repository is visible only to users in the same business.
	RepoCreateAuditEntryVisibilityPrivate  RepoCreateAuditEntryVisibility = "PRIVATE"  // The repository is visible only to those with explicit access.
	RepoCreateAuditEntryVisibilityPublic   RepoCreateAuditEntryVisibility = "PUBLIC"   // The repository is visible to everyone.
)

// RepoDestroyAuditEntryVisibility represents the privacy of a repository.
type RepoDestroyAuditEntryVisibility string

// The privacy of a repository.
const (
	RepoDestroyAuditEntryVisibilityInternal RepoDestroyAuditEntryVisibility = "INTERNAL" // The repository is visible only to users in the same business.
	RepoDestroyAuditEntryVisibilityPrivate  RepoDestroyAuditEntryVisibility = "PRIVATE"  // The repository is visible only to those with explicit access.
	RepoDestroyAuditEntryVisibilityPublic   RepoDestroyAuditEntryVisibility = "PUBLIC"   // The repository is visible to everyone.
)

// RepoRemoveMemberAuditEntryVisibility represents the privacy of a repository.
type RepoRemoveMemberAuditEntryVisibility string

// The privacy of a repository.
const (
	RepoRemoveMemberAuditEntryVisibilityInternal RepoRemoveMemberAuditEntryVisibility = "INTERNAL" // The repository is visible only to users in the same business.
	RepoRemoveMemberAuditEntryVisibilityPrivate  RepoRemoveMemberAuditEntryVisibility = "PRIVATE"  // The repository is visible only to those with explicit access.
	RepoRemoveMemberAuditEntryVisibilityPublic   RepoRemoveMemberAuditEntryVisibility = "PUBLIC"   // The repository is visible to everyone.
)

// ReportedContentClassifiers represents the reasons a piece of content can be reported or minimized.
type ReportedContentClassifiers string

// The reasons a piece of content can be reported or minimized.
const (
	ReportedContentClassifiersSpam      ReportedContentClassifiers = "SPAM"      // A spammy piece of content.
	ReportedContentClassifiersAbuse     ReportedContentClassifiers = "ABUSE"     // An abusive or harassing piece of content.
	ReportedContentClassifiersOffTopic  ReportedContentClassifiers = "OFF_TOPIC" // An irrelevant piece of content.
	ReportedContentClassifiersOutdated  ReportedContentClassifiers = "OUTDATED"  // An outdated piece of content.
	ReportedContentClassifiersDuplicate ReportedContentClassifiers = "DUPLICATE" // A duplicated piece of content.
	ReportedContentClassifiersResolved  ReportedContentClassifiers = "RESOLVED"  // The content has been resolved.
)

// RepositoryAffiliation represents the affiliation of a user to a repository.
type RepositoryAffiliation string

// The affiliation of a user to a repository.
const (
	RepositoryAffiliationOwner              RepositoryAffiliation = "OWNER"               // Repositories that are owned by the authenticated user.
	RepositoryAffiliationCollaborator       RepositoryAffiliation = "COLLABORATOR"        // Repositories that the user has been added to as a collaborator.
	RepositoryAffiliationOrganizationMember RepositoryAffiliation = "ORGANIZATION_MEMBER" // Repositories that the user has access to through being a member of an organization. This includes every repository on every team that the user is on.
)

// RepositoryContributionType represents the reason a repository is listed as 'contributed'.
type RepositoryContributionType string

// The reason a repository is listed as 'contributed'.
const (
	RepositoryContributionTypeCommit            RepositoryContributionType = "COMMIT"              // Created a commit.
	RepositoryContributionTypeIssue             RepositoryContributionType = "ISSUE"               // Created an issue.
	RepositoryContributionTypePullRequest       RepositoryContributionType = "PULL_REQUEST"        // Created a pull request.
	RepositoryContributionTypeRepository        RepositoryContributionType = "REPOSITORY"          // Created the repository.
	RepositoryContributionTypePullRequestReview RepositoryContributionType = "PULL_REQUEST_REVIEW" // Reviewed a pull request.
)

// RepositoryInteractionLimit represents a repository interaction limit.
type RepositoryInteractionLimit string

// A repository interaction limit.
const (
	RepositoryInteractionLimitExistingUsers     RepositoryInteractionLimit = "EXISTING_USERS"     // Users that have recently created their account will be unable to interact with the repository.
	RepositoryInteractionLimitContributorsOnly  RepositoryInteractionLimit = "CONTRIBUTORS_ONLY"  // Users that have not previously committed to a repository’s default branch will be unable to interact with the repository.
	RepositoryInteractionLimitCollaboratorsOnly RepositoryInteractionLimit = "COLLABORATORS_ONLY" // Users that are not collaborators will not be able to interact with the repository.
	RepositoryInteractionLimitNoLimit           RepositoryInteractionLimit = "NO_LIMIT"           // No interaction limits are enabled.
)

// RepositoryInteractionLimitExpiry represents the length for a repository interaction limit to be enabled for.
type RepositoryInteractionLimitExpiry string

// The length for a repository interaction limit to be enabled for.
const (
	RepositoryInteractionLimitExpiryOneDay    RepositoryInteractionLimitExpiry = "ONE_DAY"    // The interaction limit will expire after 1 day.
	RepositoryInteractionLimitExpiryThreeDays RepositoryInteractionLimitExpiry = "THREE_DAYS" // The interaction limit will expire after 3 days.
	RepositoryInteractionLimitExpiryOneWeek   RepositoryInteractionLimitExpiry = "ONE_WEEK"   // The interaction limit will expire after 1 week.
	RepositoryInteractionLimitExpiryOneMonth  RepositoryInteractionLimitExpiry = "ONE_MONTH"  // The interaction limit will expire after 1 month.
	RepositoryInteractionLimitExpirySixMonths RepositoryInteractionLimitExpiry = "SIX_MONTHS" // The interaction limit will expire after 6 months.
)

// RepositoryInteractionLimitOrigin represents indicates where an interaction limit is configured.
type RepositoryInteractionLimitOrigin string

// Indicates where an interaction limit is configured.
const (
	RepositoryInteractionLimitOriginRepository   RepositoryInteractionLimitOrigin = "REPOSITORY"   // A limit that is configured at the repository level.
	RepositoryInteractionLimitOriginOrganization RepositoryInteractionLimitOrigin = "ORGANIZATION" // A limit that is configured at the organization level.
	RepositoryInteractionLimitOriginUser         RepositoryInteractionLimitOrigin = "USER"         // A limit that is configured at the user-wide level.
)

// RepositoryInvitationOrderField represents properties by which repository invitation connections can be ordered.
type RepositoryInvitationOrderField string

// Properties by which repository invitation connections can be ordered.
const (
	RepositoryInvitationOrderFieldCreatedAt RepositoryInvitationOrderField = "CREATED_AT" // Order repository invitations by creation time.
)

// RepositoryLockReason represents the possible reasons a given repository could be in a locked state.
type RepositoryLockReason string

// The possible reasons a given repository could be in a locked state.
const (
	RepositoryLockReasonMoving                RepositoryLockReason = "MOVING"                 // The repository is locked due to a move.
	RepositoryLockReasonBilling               RepositoryLockReason = "BILLING"                // The repository is locked due to a billing related reason.
	RepositoryLockReasonRename                RepositoryLockReason = "RENAME"                 // The repository is locked due to a rename.
	RepositoryLockReasonMigrating             RepositoryLockReason = "MIGRATING"              // The repository is locked due to a migration.
	RepositoryLockReasonTradeRestriction      RepositoryLockReason = "TRADE_RESTRICTION"      // The repository is locked due to a trade controls related reason.
	RepositoryLockReasonTransferringOwnership RepositoryLockReason = "TRANSFERRING_OWNERSHIP" // The repository is locked due to an ownership transfer.
)

// RepositoryMigrationOrderDirection represents possible directions in which to order a list of repository migrations when provided an `orderBy` argument.
type RepositoryMigrationOrderDirection string

// Possible directions in which to order a list of repository migrations when provided an `orderBy` argument.
const (
	RepositoryMigrationOrderDirectionAsc  RepositoryMigrationOrderDirection = "ASC"  // Specifies an ascending order for a given `orderBy` argument.
	RepositoryMigrationOrderDirectionDesc RepositoryMigrationOrderDirection = "DESC" // Specifies a descending order for a given `orderBy` argument.
)

// RepositoryMigrationOrderField represents properties by which repository migrations can be ordered.
type RepositoryMigrationOrderField string

// Properties by which repository migrations can be ordered.
const (
	RepositoryMigrationOrderFieldCreatedAt RepositoryMigrationOrderField = "CREATED_AT" // Order mannequins why when they were created.
)

// RepositoryOrderField represents properties by which repository connections can be ordered.
type RepositoryOrderField string

// Properties by which repository connections can be ordered.
const (
	RepositoryOrderFieldCreatedAt  RepositoryOrderField = "CREATED_AT" // Order repositories by creation time.
	RepositoryOrderFieldUpdatedAt  RepositoryOrderField = "UPDATED_AT" // Order repositories by update time.
	RepositoryOrderFieldPushedAt   RepositoryOrderField = "PUSHED_AT"  // Order repositories by push time.
	RepositoryOrderFieldName       RepositoryOrderField = "NAME"       // Order repositories by name.
	RepositoryOrderFieldStargazers RepositoryOrderField = "STARGAZERS" // Order repositories by number of stargazers.
)

// RepositoryPermission represents the access level to a repository.
type RepositoryPermission string

// The access level to a repository.
const (
	RepositoryPermissionAdmin    RepositoryPermission = "ADMIN"    // Can read, clone, and push to this repository. Can also manage issues, pull requests, and repository settings, including adding collaborators.
	RepositoryPermissionMaintain RepositoryPermission = "MAINTAIN" // Can read, clone, and push to this repository. They can also manage issues, pull requests, and some repository settings.
	RepositoryPermissionWrite    RepositoryPermission = "WRITE"    // Can read, clone, and push to this repository. Can also manage issues and pull requests.
	RepositoryPermissionTriage   RepositoryPermission = "TRIAGE"   // Can read and clone this repository. Can also manage issues and pull requests.
	RepositoryPermissionRead     RepositoryPermission = "READ"     // Can read and clone this repository. Can also open and comment on issues and pull requests.
)

// RepositoryPrivacy represents the privacy of a repository.
type RepositoryPrivacy string

// The privacy of a repository.
const (
	RepositoryPrivacyPublic  RepositoryPrivacy = "PUBLIC"  // Public.
	RepositoryPrivacyPrivate RepositoryPrivacy = "PRIVATE" // Private.
)

// RepositoryRuleOrderField represents properties by which repository rule connections can be ordered.
type RepositoryRuleOrderField string

// Properties by which repository rule connections can be ordered.
const (
	RepositoryRuleOrderFieldUpdatedAt RepositoryRuleOrderField = "UPDATED_AT" // Order repository rules by updated time.
	RepositoryRuleOrderFieldCreatedAt RepositoryRuleOrderField = "CREATED_AT" // Order repository rules by created time.
	RepositoryRuleOrderFieldType      RepositoryRuleOrderField = "TYPE"       // Order repository rules by type.
)

// RepositoryRuleType represents the rule types supported in rulesets.
type RepositoryRuleType string

// The rule types supported in rulesets.
const (
	RepositoryRuleTypeCreation                       RepositoryRuleType = "CREATION"                          // Only allow users with bypass permission to create matching refs.
	RepositoryRuleTypeUpdate                         RepositoryRuleType = "UPDATE"                            // Only allow users with bypass permission to update matching refs.
	RepositoryRuleTypeDeletion                       RepositoryRuleType = "DELETION"                          // Only allow users with bypass permissions to delete matching refs.
	RepositoryRuleTypeRequiredLinearHistory          RepositoryRuleType = "REQUIRED_LINEAR_HISTORY"           // Prevent merge commits from being pushed to matching refs.
	RepositoryRuleTypeMergeQueue                     RepositoryRuleType = "MERGE_QUEUE"                       // Merges must be performed via a merge queue.
	RepositoryRuleTypeRequiredReviewThreadResolution RepositoryRuleType = "REQUIRED_REVIEW_THREAD_RESOLUTION" // When enabled, all conversations on code must be resolved before a pull request can be merged into a branch that matches this rule.
	RepositoryRuleTypeRequiredDeployments            RepositoryRuleType = "REQUIRED_DEPLOYMENTS"              // Choose which environments must be successfully deployed to before refs can be pushed into a ref that matches this rule.
	RepositoryRuleTypeRequiredSignatures             RepositoryRuleType = "REQUIRED_SIGNATURES"               // Commits pushed to matching refs must have verified signatures.
	RepositoryRuleTypePullRequest                    RepositoryRuleType = "PULL_REQUEST"                      // Require all commits be made to a non-target branch and submitted via a pull request before they can be merged.
	RepositoryRuleTypeRequiredStatusChecks           RepositoryRuleType = "REQUIRED_STATUS_CHECKS"            // Choose which status checks must pass before the ref is updated. When enabled, commits must first be pushed to another ref where the checks pass.
	RepositoryRuleTypeRequiredWorkflowStatusChecks   RepositoryRuleType = "REQUIRED_WORKFLOW_STATUS_CHECKS"   // Require all commits be made to a non-target branch and submitted via a pull request and required workflow checks to pass before they can be merged.
	RepositoryRuleTypeNonFastForward                 RepositoryRuleType = "NON_FAST_FORWARD"                  // Prevent users with push access from force pushing to refs.
	RepositoryRuleTypeAuthorization                  RepositoryRuleType = "AUTHORIZATION"                     // Authorization.
	RepositoryRuleTypeTag                            RepositoryRuleType = "TAG"                               // Tag.
	RepositoryRuleTypeMergeQueueLockedRef            RepositoryRuleType = "MERGE_QUEUE_LOCKED_REF"            // Merge queue locked ref.
	RepositoryRuleTypeLockBranch                     RepositoryRuleType = "LOCK_BRANCH"                       // Branch is read-only. Users cannot push to the branch.
	RepositoryRuleTypeMaxRefUpdates                  RepositoryRuleType = "MAX_REF_UPDATES"                   // Max ref updates.
	RepositoryRuleTypeCommitMessagePattern           RepositoryRuleType = "COMMIT_MESSAGE_PATTERN"            // Commit message pattern.
	RepositoryRuleTypeCommitAuthorEmailPattern       RepositoryRuleType = "COMMIT_AUTHOR_EMAIL_PATTERN"       // Commit author email pattern.
	RepositoryRuleTypeCommitterEmailPattern          RepositoryRuleType = "COMMITTER_EMAIL_PATTERN"           // Committer email pattern.
	RepositoryRuleTypeBranchNamePattern              RepositoryRuleType = "BRANCH_NAME_PATTERN"               // Branch name pattern.
	RepositoryRuleTypeTagNamePattern                 RepositoryRuleType = "TAG_NAME_PATTERN"                  // Tag name pattern.
	RepositoryRuleTypeFilePathRestriction            RepositoryRuleType = "FILE_PATH_RESTRICTION"             // Prevent commits that include changes in specified file paths from being pushed to the commit graph. NOTE: Thie rule is in beta and subject to change.
	RepositoryRuleTypeMaxFilePathLength              RepositoryRuleType = "MAX_FILE_PATH_LENGTH"              // Prevent commits that include file paths that exceed a specified character limit from being pushed to the commit graph. NOTE: Thie rule is in beta and subject to change.
	RepositoryRuleTypeFileExtensionRestriction       RepositoryRuleType = "FILE_EXTENSION_RESTRICTION"        // Prevent commits that include files with specified file extensions from being pushed to the commit graph. NOTE: Thie rule is in beta and subject to change.
	RepositoryRuleTypeMaxFileSize                    RepositoryRuleType = "MAX_FILE_SIZE"                     // Prevent commits that exceed a specified file size limit from being pushed to the commit. NOTE: Thie rule is in beta and subject to change.
	RepositoryRuleTypeWorkflows                      RepositoryRuleType = "WORKFLOWS"                         // Require all changes made to a targeted branch to pass the specified workflows before they can be merged.
	RepositoryRuleTypeSecretScanning                 RepositoryRuleType = "SECRET_SCANNING"                   // Secret scanning.
	RepositoryRuleTypeWorkflowUpdates                RepositoryRuleType = "WORKFLOW_UPDATES"                  // Workflow files cannot be modified.
)

// RepositoryRulesetBypassActorBypassMode represents the bypass mode for a specific actor on a ruleset.
type RepositoryRulesetBypassActorBypassMode string

// The bypass mode for a specific actor on a ruleset.
const (
	RepositoryRulesetBypassActorBypassModeAlways      RepositoryRulesetBypassActorBypassMode = "ALWAYS"       // The actor can always bypass rules.
	RepositoryRulesetBypassActorBypassModePullRequest RepositoryRulesetBypassActorBypassMode = "PULL_REQUEST" // The actor can only bypass rules via a pull request.
)

// RepositoryRulesetTarget represents the targets supported for rulesets. NOTE: The push target is in beta and subject to change.
type RepositoryRulesetTarget string

// The targets supported for rulesets. NOTE: The push target is in beta and subject to change.
const (
	RepositoryRulesetTargetBranch RepositoryRulesetTarget = "BRANCH" // Branch.
	RepositoryRulesetTargetTag    RepositoryRulesetTarget = "TAG"    // Tag.
	RepositoryRulesetTargetPush   RepositoryRulesetTarget = "PUSH"   // Push.
)

// RepositoryVisibility represents the repository's visibility level.
type RepositoryVisibility string

// The repository's visibility level.
const (
	RepositoryVisibilityPrivate  RepositoryVisibility = "PRIVATE"  // The repository is visible only to those with explicit access.
	RepositoryVisibilityPublic   RepositoryVisibility = "PUBLIC"   // The repository is visible to everyone.
	RepositoryVisibilityInternal RepositoryVisibility = "INTERNAL" // The repository is visible only to users in the same business.
)

// RepositoryVulnerabilityAlertDependencyScope represents the possible scopes of an alert's dependency.
type RepositoryVulnerabilityAlertDependencyScope string

// The possible scopes of an alert's dependency.
const (
	RepositoryVulnerabilityAlertDependencyScopeRuntime     RepositoryVulnerabilityAlertDependencyScope = "RUNTIME"     // A dependency that is leveraged during application runtime.
	RepositoryVulnerabilityAlertDependencyScopeDevelopment RepositoryVulnerabilityAlertDependencyScope = "DEVELOPMENT" // A dependency that is only used in development.
)

// RepositoryVulnerabilityAlertState represents the possible states of an alert.
type RepositoryVulnerabilityAlertState string

// The possible states of an alert.
const (
	RepositoryVulnerabilityAlertStateOpen          RepositoryVulnerabilityAlertState = "OPEN"           // An alert that is still open.
	RepositoryVulnerabilityAlertStateFixed         RepositoryVulnerabilityAlertState = "FIXED"          // An alert that has been resolved by a code change.
	RepositoryVulnerabilityAlertStateDismissed     RepositoryVulnerabilityAlertState = "DISMISSED"      // An alert that has been manually closed by a user.
	RepositoryVulnerabilityAlertStateAutoDismissed RepositoryVulnerabilityAlertState = "AUTO_DISMISSED" // An alert that has been automatically closed by Dependabot.
)

// RequestableCheckStatusState represents the possible states that can be requested when creating a check run.
type RequestableCheckStatusState string

// The possible states that can be requested when creating a check run.
const (
	RequestableCheckStatusStateQueued     RequestableCheckStatusState = "QUEUED"      // The check suite or run has been queued.
	RequestableCheckStatusStateInProgress RequestableCheckStatusState = "IN_PROGRESS" // The check suite or run is in progress.
	RequestableCheckStatusStateCompleted  RequestableCheckStatusState = "COMPLETED"   // The check suite or run has been completed.
	RequestableCheckStatusStateWaiting    RequestableCheckStatusState = "WAITING"     // The check suite or run is in waiting state.
	RequestableCheckStatusStatePending    RequestableCheckStatusState = "PENDING"     // The check suite or run is in pending state.
)

// RoleInOrganization represents possible roles a user may have in relation to an organization.
type RoleInOrganization string

// Possible roles a user may have in relation to an organization.
const (
	RoleInOrganizationOwner        RoleInOrganization = "OWNER"         // A user with full administrative access to the organization.
	RoleInOrganizationDirectMember RoleInOrganization = "DIRECT_MEMBER" // A user who is a direct member of the organization.
	RoleInOrganizationUnaffiliated RoleInOrganization = "UNAFFILIATED"  // A user who is unaffiliated with the organization.
)

// RuleEnforcement represents the level of enforcement for a rule or ruleset.
type RuleEnforcement string

// The level of enforcement for a rule or ruleset.
const (
	RuleEnforcementDisabled RuleEnforcement = "DISABLED" // Do not evaluate or enforce rules.
	RuleEnforcementActive   RuleEnforcement = "ACTIVE"   // Rules will be enforced.
	RuleEnforcementEvaluate RuleEnforcement = "EVALUATE" // Allow admins to test rules before enforcing them. Admins can view insights on the Rule Insights page (`evaluate` is only available with GitHub Enterprise).
)

// SamlDigestAlgorithm represents the possible digest algorithms used to sign SAML requests for an identity provider.
type SamlDigestAlgorithm string

// The possible digest algorithms used to sign SAML requests for an identity provider.
const (
	SamlDigestAlgorithmSha1   SamlDigestAlgorithm = "SHA1"   // SHA1.
	SamlDigestAlgorithmSha256 SamlDigestAlgorithm = "SHA256" // SHA256.
	SamlDigestAlgorithmSha384 SamlDigestAlgorithm = "SHA384" // SHA384.
	SamlDigestAlgorithmSha512 SamlDigestAlgorithm = "SHA512" // SHA512.
)

// SamlSignatureAlgorithm represents the possible signature algorithms used to sign SAML requests for a Identity Provider.
type SamlSignatureAlgorithm string

// The possible signature algorithms used to sign SAML requests for a Identity Provider.
const (
	SamlSignatureAlgorithmRsaSha1   SamlSignatureAlgorithm = "RSA_SHA1"   // RSA-SHA1.
	SamlSignatureAlgorithmRsaSha256 SamlSignatureAlgorithm = "RSA_SHA256" // RSA-SHA256.
	SamlSignatureAlgorithmRsaSha384 SamlSignatureAlgorithm = "RSA_SHA384" // RSA-SHA384.
	SamlSignatureAlgorithmRsaSha512 SamlSignatureAlgorithm = "RSA_SHA512" // RSA-SHA512.
)

// SavedReplyOrderField represents properties by which saved reply connections can be ordered.
type SavedReplyOrderField string

// Properties by which saved reply connections can be ordered.
const (
	SavedReplyOrderFieldUpdatedAt SavedReplyOrderField = "UPDATED_AT" // Order saved reply by when they were updated.
)

// SearchType represents represents the individual results of a search.
type SearchType string

// Represents the individual results of a search.
const (
	SearchTypeIssue      SearchType = "ISSUE"      // Returns results matching issues in repositories.
	SearchTypeRepository SearchType = "REPOSITORY" // Returns results matching repositories.
	SearchTypeUser       SearchType = "USER"       // Returns results matching users and organizations on GitHub.
	SearchTypeDiscussion SearchType = "DISCUSSION" // Returns matching discussions in repositories.
)

// SecurityAdvisoryClassification represents classification of the advisory.
type SecurityAdvisoryClassification string

// Classification of the advisory.
const (
	SecurityAdvisoryClassificationGeneral SecurityAdvisoryClassification = "GENERAL" // Classification of general advisories.
	SecurityAdvisoryClassificationMalware SecurityAdvisoryClassification = "MALWARE" // Classification of malware advisories.
)

// SecurityAdvisoryEcosystem represents the possible ecosystems of a security vulnerability's package.
type SecurityAdvisoryEcosystem string

// The possible ecosystems of a security vulnerability's package.
const (
	SecurityAdvisoryEcosystemComposer SecurityAdvisoryEcosystem = "COMPOSER" // PHP packages hosted at packagist.org.
	SecurityAdvisoryEcosystemErlang   SecurityAdvisoryEcosystem = "ERLANG"   // Erlang/Elixir packages hosted at hex.pm.
	SecurityAdvisoryEcosystemActions  SecurityAdvisoryEcosystem = "ACTIONS"  // GitHub Actions.
	SecurityAdvisoryEcosystemGo       SecurityAdvisoryEcosystem = "GO"       // Go modules.
	SecurityAdvisoryEcosystemMaven    SecurityAdvisoryEcosystem = "MAVEN"    // Java artifacts hosted at the Maven central repository.
	SecurityAdvisoryEcosystemNpm      SecurityAdvisoryEcosystem = "NPM"      // JavaScript packages hosted at npmjs.com.
	SecurityAdvisoryEcosystemNuget    SecurityAdvisoryEcosystem = "NUGET"    // .NET packages hosted at the NuGet Gallery.
	SecurityAdvisoryEcosystemPip      SecurityAdvisoryEcosystem = "PIP"      // Python packages hosted at PyPI.org.
	SecurityAdvisoryEcosystemPub      SecurityAdvisoryEcosystem = "PUB"      // Dart packages hosted at pub.dev.
	SecurityAdvisoryEcosystemRubygems SecurityAdvisoryEcosystem = "RUBYGEMS" // Ruby gems hosted at RubyGems.org.
	SecurityAdvisoryEcosystemRust     SecurityAdvisoryEcosystem = "RUST"     // Rust crates.
	SecurityAdvisoryEcosystemSwift    SecurityAdvisoryEcosystem = "SWIFT"    // Swift packages.
)

// SecurityAdvisoryIdentifierType represents identifier formats available for advisories.
type SecurityAdvisoryIdentifierType string

// Identifier formats available for advisories.
const (
	SecurityAdvisoryIdentifierTypeCve  SecurityAdvisoryIdentifierType = "CVE"  // Common Vulnerabilities and Exposures Identifier.
	SecurityAdvisoryIdentifierTypeGhsa SecurityAdvisoryIdentifierType = "GHSA" // GitHub Security Advisory ID.
)

// SecurityAdvisoryOrderField represents properties by which security advisory connections can be ordered.
type SecurityAdvisoryOrderField string

// Properties by which security advisory connections can be ordered.
const (
	SecurityAdvisoryOrderFieldPublishedAt SecurityAdvisoryOrderField = "PUBLISHED_AT" // Order advisories by publication time.
	SecurityAdvisoryOrderFieldUpdatedAt   SecurityAdvisoryOrderField = "UPDATED_AT"   // Order advisories by update time.
)

// SecurityAdvisorySeverity represents severity of the vulnerability.
type SecurityAdvisorySeverity string

// Severity of the vulnerability.
const (
	SecurityAdvisorySeverityLow      SecurityAdvisorySeverity = "LOW"      // Low.
	SecurityAdvisorySeverityModerate SecurityAdvisorySeverity = "MODERATE" // Moderate.
	SecurityAdvisorySeverityHigh     SecurityAdvisorySeverity = "HIGH"     // High.
	SecurityAdvisorySeverityCritical SecurityAdvisorySeverity = "CRITICAL" // Critical.
)

// SecurityVulnerabilityOrderField represents properties by which security vulnerability connections can be ordered.
type SecurityVulnerabilityOrderField string

// Properties by which security vulnerability connections can be ordered.
const (
	SecurityVulnerabilityOrderFieldUpdatedAt SecurityVulnerabilityOrderField = "UPDATED_AT" // Order vulnerability by update time.
)

// SocialAccountProvider represents software or company that hosts social media accounts.
type SocialAccountProvider string

// Software or company that hosts social media accounts.
const (
	SocialAccountProviderGeneric   SocialAccountProvider = "GENERIC"   // Catch-all for social media providers that do not yet have specific handling.
	SocialAccountProviderFacebook  SocialAccountProvider = "FACEBOOK"  // Social media and networking website.
	SocialAccountProviderHometown  SocialAccountProvider = "HOMETOWN"  // Fork of Mastodon with a greater focus on local posting.
	SocialAccountProviderInstagram SocialAccountProvider = "INSTAGRAM" // Social media website with a focus on photo and video sharing.
	SocialAccountProviderLinkedIn  SocialAccountProvider = "LINKEDIN"  // Professional networking website.
	SocialAccountProviderMastodon  SocialAccountProvider = "MASTODON"  // Open-source federated microblogging service.
	SocialAccountProviderReddit    SocialAccountProvider = "REDDIT"    // Social news aggregation and discussion website.
	SocialAccountProviderTwitch    SocialAccountProvider = "TWITCH"    // Live-streaming service.
	SocialAccountProviderTwitter   SocialAccountProvider = "TWITTER"   // Microblogging website.
	SocialAccountProviderYouTube   SocialAccountProvider = "YOUTUBE"   // Online video platform.
	SocialAccountProviderNpm       SocialAccountProvider = "NPM"       // JavaScript package registry.
)

// SponsorAndLifetimeValueOrderField represents properties by which sponsor and lifetime value connections can be ordered.
type SponsorAndLifetimeValueOrderField string

// Properties by which sponsor and lifetime value connections can be ordered.
const (
	SponsorAndLifetimeValueOrderFieldSponsorLogin     SponsorAndLifetimeValueOrderField = "SPONSOR_LOGIN"     // Order results by the sponsor's login (username).
	SponsorAndLifetimeValueOrderFieldSponsorRelevance SponsorAndLifetimeValueOrderField = "SPONSOR_RELEVANCE" // Order results by the sponsor's relevance to the viewer.
	SponsorAndLifetimeValueOrderFieldLifetimeValue    SponsorAndLifetimeValueOrderField = "LIFETIME_VALUE"    // Order results by how much money the sponsor has paid in total.
)

// SponsorOrderField represents properties by which sponsor connections can be ordered.
type SponsorOrderField string

// Properties by which sponsor connections can be ordered.
const (
	SponsorOrderFieldLogin     SponsorOrderField = "LOGIN"     // Order sponsorable entities by login (username).
	SponsorOrderFieldRelevance SponsorOrderField = "RELEVANCE" // Order sponsors by their relevance to the viewer.
)

// SponsorableOrderField represents properties by which sponsorable connections can be ordered.
type SponsorableOrderField string

// Properties by which sponsorable connections can be ordered.
const (
	SponsorableOrderFieldLogin SponsorableOrderField = "LOGIN" // Order sponsorable entities by login (username).
)

// SponsorsActivityAction represents the possible actions that GitHub Sponsors activities can represent.
type SponsorsActivityAction string

// The possible actions that GitHub Sponsors activities can represent.
const (
	SponsorsActivityActionNewSponsorship       SponsorsActivityAction = "NEW_SPONSORSHIP"        // The activity was starting a sponsorship.
	SponsorsActivityActionCancelledSponsorship SponsorsActivityAction = "CANCELLED_SPONSORSHIP"  // The activity was cancelling a sponsorship.
	SponsorsActivityActionTierChange           SponsorsActivityAction = "TIER_CHANGE"            // The activity was changing the sponsorship tier, either directly by the sponsor or by a scheduled/pending change.
	SponsorsActivityActionRefund               SponsorsActivityAction = "REFUND"                 // The activity was funds being refunded to the sponsor or GitHub.
	SponsorsActivityActionPendingChange        SponsorsActivityAction = "PENDING_CHANGE"         // The activity was scheduling a downgrade or cancellation.
	SponsorsActivityActionSponsorMatchDisabled SponsorsActivityAction = "SPONSOR_MATCH_DISABLED" // The activity was disabling matching for a previously matched sponsorship.
)

// SponsorsActivityOrderField represents properties by which GitHub Sponsors activity connections can be ordered.
type SponsorsActivityOrderField string

// Properties by which GitHub Sponsors activity connections can be ordered.
const (
	SponsorsActivityOrderFieldTimestamp SponsorsActivityOrderField = "TIMESTAMP" // Order activities by when they happened.
)

// SponsorsActivityPeriod represents the possible time periods for which Sponsors activities can be requested.
type SponsorsActivityPeriod string

// The possible time periods for which Sponsors activities can be requested.
const (
	SponsorsActivityPeriodDay   SponsorsActivityPeriod = "DAY"   // The previous calendar day.
	SponsorsActivityPeriodWeek  SponsorsActivityPeriod = "WEEK"  // The previous seven days.
	SponsorsActivityPeriodMonth SponsorsActivityPeriod = "MONTH" // The previous thirty days.
	SponsorsActivityPeriodAll   SponsorsActivityPeriod = "ALL"   // Don't restrict the activity to any date range, include all activity.
)

// SponsorsCountryOrRegionCode represents represents countries or regions for billing and residence for a GitHub Sponsors profile.
type SponsorsCountryOrRegionCode string

// Represents countries or regions for billing and residence for a GitHub Sponsors profile.
const (
	SponsorsCountryOrRegionCodeAF SponsorsCountryOrRegionCode = "AF" // Afghanistan.
	SponsorsCountryOrRegionCodeAX SponsorsCountryOrRegionCode = "AX" // Åland.
	SponsorsCountryOrRegionCodeAL SponsorsCountryOrRegionCode = "AL" // Albania.
	SponsorsCountryOrRegionCodeDZ SponsorsCountryOrRegionCode = "DZ" // Algeria.
	SponsorsCountryOrRegionCodeAS SponsorsCountryOrRegionCode = "AS" // American Samoa.
	SponsorsCountryOrRegionCodeAD SponsorsCountryOrRegionCode = "AD" // Andorra.
	SponsorsCountryOrRegionCodeAO SponsorsCountryOrRegionCode = "AO" // Angola.
	SponsorsCountryOrRegionCodeAI SponsorsCountryOrRegionCode = "AI" // Anguilla.
	SponsorsCountryOrRegionCodeAQ SponsorsCountryOrRegionCode = "AQ" // Antarctica.
	SponsorsCountryOrRegionCodeAG SponsorsCountryOrRegionCode = "AG" // Antigua and Barbuda.
	SponsorsCountryOrRegionCodeAR SponsorsCountryOrRegionCode = "AR" // Argentina.
	SponsorsCountryOrRegionCodeAM SponsorsCountryOrRegionCode = "AM" // Armenia.
	SponsorsCountryOrRegionCodeAW SponsorsCountryOrRegionCode = "AW" // Aruba.
	SponsorsCountryOrRegionCodeAU SponsorsCountryOrRegionCode = "AU" // Australia.
	SponsorsCountryOrRegionCodeAT SponsorsCountryOrRegionCode = "AT" // Austria.
	SponsorsCountryOrRegionCodeAZ SponsorsCountryOrRegionCode = "AZ" // Azerbaijan.
	SponsorsCountryOrRegionCodeBS SponsorsCountryOrRegionCode = "BS" // Bahamas.
	SponsorsCountryOrRegionCodeBH SponsorsCountryOrRegionCode = "BH" // Bahrain.
	SponsorsCountryOrRegionCodeBD SponsorsCountryOrRegionCode = "BD" // Bangladesh.
	SponsorsCountryOrRegionCodeBB SponsorsCountryOrRegionCode = "BB" // Barbados.
	SponsorsCountryOrRegionCodeBY SponsorsCountryOrRegionCode = "BY" // Belarus.
	SponsorsCountryOrRegionCodeBE SponsorsCountryOrRegionCode = "BE" // Belgium.
	SponsorsCountryOrRegionCodeBZ SponsorsCountryOrRegionCode = "BZ" // Belize.
	SponsorsCountryOrRegionCodeBJ SponsorsCountryOrRegionCode = "BJ" // Benin.
	SponsorsCountryOrRegionCodeBM SponsorsCountryOrRegionCode = "BM" // Bermuda.
	SponsorsCountryOrRegionCodeBT SponsorsCountryOrRegionCode = "BT" // Bhutan.
	SponsorsCountryOrRegionCodeBO SponsorsCountryOrRegionCode = "BO" // Bolivia.
	SponsorsCountryOrRegionCodeBQ SponsorsCountryOrRegionCode = "BQ" // Bonaire, Sint Eustatius and Saba.
	SponsorsCountryOrRegionCodeBA SponsorsCountryOrRegionCode = "BA" // Bosnia and Herzegovina.
	SponsorsCountryOrRegionCodeBW SponsorsCountryOrRegionCode = "BW" // Botswana.
	SponsorsCountryOrRegionCodeBV SponsorsCountryOrRegionCode = "BV" // Bouvet Island.
	SponsorsCountryOrRegionCodeBR SponsorsCountryOrRegionCode = "BR" // Brazil.
	SponsorsCountryOrRegionCodeIO SponsorsCountryOrRegionCode = "IO" // British Indian Ocean Territory.
	SponsorsCountryOrRegionCodeBN SponsorsCountryOrRegionCode = "BN" // Brunei Darussalam.
	SponsorsCountryOrRegionCodeBG SponsorsCountryOrRegionCode = "BG" // Bulgaria.
	SponsorsCountryOrRegionCodeBF SponsorsCountryOrRegionCode = "BF" // Burkina Faso.
	SponsorsCountryOrRegionCodeBI SponsorsCountryOrRegionCode = "BI" // Burundi.
	SponsorsCountryOrRegionCodeKH SponsorsCountryOrRegionCode = "KH" // Cambodia.
	SponsorsCountryOrRegionCodeCM SponsorsCountryOrRegionCode = "CM" // Cameroon.
	SponsorsCountryOrRegionCodeCA SponsorsCountryOrRegionCode = "CA" // Canada.
	SponsorsCountryOrRegionCodeCV SponsorsCountryOrRegionCode = "CV" // Cape Verde.
	SponsorsCountryOrRegionCodeKY SponsorsCountryOrRegionCode = "KY" // Cayman Islands.
	SponsorsCountryOrRegionCodeCF SponsorsCountryOrRegionCode = "CF" // Central African Republic.
	SponsorsCountryOrRegionCodeTD SponsorsCountryOrRegionCode = "TD" // Chad.
	SponsorsCountryOrRegionCodeCL SponsorsCountryOrRegionCode = "CL" // Chile.
	SponsorsCountryOrRegionCodeCN SponsorsCountryOrRegionCode = "CN" // China.
	SponsorsCountryOrRegionCodeCX SponsorsCountryOrRegionCode = "CX" // Christmas Island.
	SponsorsCountryOrRegionCodeCC SponsorsCountryOrRegionCode = "CC" // Cocos (Keeling) Islands.
	SponsorsCountryOrRegionCodeCO SponsorsCountryOrRegionCode = "CO" // Colombia.
	SponsorsCountryOrRegionCodeKM SponsorsCountryOrRegionCode = "KM" // Comoros.
	SponsorsCountryOrRegionCodeCG SponsorsCountryOrRegionCode = "CG" // Congo (Brazzaville).
	SponsorsCountryOrRegionCodeCD SponsorsCountryOrRegionCode = "CD" // Congo (Kinshasa).
	SponsorsCountryOrRegionCodeCK SponsorsCountryOrRegionCode = "CK" // Cook Islands.
	SponsorsCountryOrRegionCodeCR SponsorsCountryOrRegionCode = "CR" // Costa Rica.
	SponsorsCountryOrRegionCodeCI SponsorsCountryOrRegionCode = "CI" // Côte d'Ivoire.
	SponsorsCountryOrRegionCodeHR SponsorsCountryOrRegionCode = "HR" // Croatia.
	SponsorsCountryOrRegionCodeCW SponsorsCountryOrRegionCode = "CW" // Curaçao.
	SponsorsCountryOrRegionCodeCY SponsorsCountryOrRegionCode = "CY" // Cyprus.
	SponsorsCountryOrRegionCodeCZ SponsorsCountryOrRegionCode = "CZ" // Czech Republic.
	SponsorsCountryOrRegionCodeDK SponsorsCountryOrRegionCode = "DK" // Denmark.
	SponsorsCountryOrRegionCodeDJ SponsorsCountryOrRegionCode = "DJ" // Djibouti.
	SponsorsCountryOrRegionCodeDM SponsorsCountryOrRegionCode = "DM" // Dominica.
	SponsorsCountryOrRegionCodeDO SponsorsCountryOrRegionCode = "DO" // Dominican Republic.
	SponsorsCountryOrRegionCodeEC SponsorsCountryOrRegionCode = "EC" // Ecuador.
	SponsorsCountryOrRegionCodeEG SponsorsCountryOrRegionCode = "EG" // Egypt.
	SponsorsCountryOrRegionCodeSV SponsorsCountryOrRegionCode = "SV" // El Salvador.
	SponsorsCountryOrRegionCodeGQ SponsorsCountryOrRegionCode = "GQ" // Equatorial Guinea.
	SponsorsCountryOrRegionCodeER SponsorsCountryOrRegionCode = "ER" // Eritrea.
	SponsorsCountryOrRegionCodeEE SponsorsCountryOrRegionCode = "EE" // Estonia.
	SponsorsCountryOrRegionCodeET SponsorsCountryOrRegionCode = "ET" // Ethiopia.
	SponsorsCountryOrRegionCodeFK SponsorsCountryOrRegionCode = "FK" // Falkland Islands.
	SponsorsCountryOrRegionCodeFO SponsorsCountryOrRegionCode = "FO" // Faroe Islands.
	SponsorsCountryOrRegionCodeFJ SponsorsCountryOrRegionCode = "FJ" // Fiji.
	SponsorsCountryOrRegionCodeFI SponsorsCountryOrRegionCode = "FI" // Finland.
	SponsorsCountryOrRegionCodeFR SponsorsCountryOrRegionCode = "FR" // France.
	SponsorsCountryOrRegionCodeGF SponsorsCountryOrRegionCode = "GF" // French Guiana.
	SponsorsCountryOrRegionCodePF SponsorsCountryOrRegionCode = "PF" // French Polynesia.
	SponsorsCountryOrRegionCodeTF SponsorsCountryOrRegionCode = "TF" // French Southern Lands.
	SponsorsCountryOrRegionCodeGA SponsorsCountryOrRegionCode = "GA" // Gabon.
	SponsorsCountryOrRegionCodeGM SponsorsCountryOrRegionCode = "GM" // Gambia.
	SponsorsCountryOrRegionCodeGE SponsorsCountryOrRegionCode = "GE" // Georgia.
	SponsorsCountryOrRegionCodeDE SponsorsCountryOrRegionCode = "DE" // Germany.
	SponsorsCountryOrRegionCodeGH SponsorsCountryOrRegionCode = "GH" // Ghana.
	SponsorsCountryOrRegionCodeGI SponsorsCountryOrRegionCode = "GI" // Gibraltar.
	SponsorsCountryOrRegionCodeGR SponsorsCountryOrRegionCode = "GR" // Greece.
	SponsorsCountryOrRegionCodeGL SponsorsCountryOrRegionCode = "GL" // Greenland.
	SponsorsCountryOrRegionCodeGD SponsorsCountryOrRegionCode = "GD" // Grenada.
	SponsorsCountryOrRegionCodeGP SponsorsCountryOrRegionCode = "GP" // Guadeloupe.
	SponsorsCountryOrRegionCodeGU SponsorsCountryOrRegionCode = "GU" // Guam.
	SponsorsCountryOrRegionCodeGT SponsorsCountryOrRegionCode = "GT" // Guatemala.
	SponsorsCountryOrRegionCodeGG SponsorsCountryOrRegionCode = "GG" // Guernsey.
	SponsorsCountryOrRegionCodeGN SponsorsCountryOrRegionCode = "GN" // Guinea.
	SponsorsCountryOrRegionCodeGW SponsorsCountryOrRegionCode = "GW" // Guinea-Bissau.
	SponsorsCountryOrRegionCodeGY SponsorsCountryOrRegionCode = "GY" // Guyana.
	SponsorsCountryOrRegionCodeHT SponsorsCountryOrRegionCode = "HT" // Haiti.
	SponsorsCountryOrRegionCodeHM SponsorsCountryOrRegionCode = "HM" // Heard and McDonald Islands.
	SponsorsCountryOrRegionCodeHN SponsorsCountryOrRegionCode = "HN" // Honduras.
	SponsorsCountryOrRegionCodeHK SponsorsCountryOrRegionCode = "HK" // Hong Kong.
	SponsorsCountryOrRegionCodeHU SponsorsCountryOrRegionCode = "HU" // Hungary.
	SponsorsCountryOrRegionCodeIS SponsorsCountryOrRegionCode = "IS" // Iceland.
	SponsorsCountryOrRegionCodeIN SponsorsCountryOrRegionCode = "IN" // India.
	SponsorsCountryOrRegionCodeID SponsorsCountryOrRegionCode = "ID" // Indonesia.
	SponsorsCountryOrRegionCodeIR SponsorsCountryOrRegionCode = "IR" // Iran.
	SponsorsCountryOrRegionCodeIQ SponsorsCountryOrRegionCode = "IQ" // Iraq.
	SponsorsCountryOrRegionCodeIE SponsorsCountryOrRegionCode = "IE" // Ireland.
	SponsorsCountryOrRegionCodeIM SponsorsCountryOrRegionCode = "IM" // Isle of Man.
	SponsorsCountryOrRegionCodeIL SponsorsCountryOrRegionCode = "IL" // Israel.
	SponsorsCountryOrRegionCodeIT SponsorsCountryOrRegionCode = "IT" // Italy.
	SponsorsCountryOrRegionCodeJM SponsorsCountryOrRegionCode = "JM" // Jamaica.
	SponsorsCountryOrRegionCodeJP SponsorsCountryOrRegionCode = "JP" // Japan.
	SponsorsCountryOrRegionCodeJE SponsorsCountryOrRegionCode = "JE" // Jersey.
	SponsorsCountryOrRegionCodeJO SponsorsCountryOrRegionCode = "JO" // Jordan.
	SponsorsCountryOrRegionCodeKZ SponsorsCountryOrRegionCode = "KZ" // Kazakhstan.
	SponsorsCountryOrRegionCodeKE SponsorsCountryOrRegionCode = "KE" // Kenya.
	SponsorsCountryOrRegionCodeKI SponsorsCountryOrRegionCode = "KI" // Kiribati.
	SponsorsCountryOrRegionCodeKR SponsorsCountryOrRegionCode = "KR" // Korea, South.
	SponsorsCountryOrRegionCodeKW SponsorsCountryOrRegionCode = "KW" // Kuwait.
	SponsorsCountryOrRegionCodeKG SponsorsCountryOrRegionCode = "KG" // Kyrgyzstan.
	SponsorsCountryOrRegionCodeLA SponsorsCountryOrRegionCode = "LA" // Laos.
	SponsorsCountryOrRegionCodeLV SponsorsCountryOrRegionCode = "LV" // Latvia.
	SponsorsCountryOrRegionCodeLB SponsorsCountryOrRegionCode = "LB" // Lebanon.
	SponsorsCountryOrRegionCodeLS SponsorsCountryOrRegionCode = "LS" // Lesotho.
	SponsorsCountryOrRegionCodeLR SponsorsCountryOrRegionCode = "LR" // Liberia.
	SponsorsCountryOrRegionCodeLY SponsorsCountryOrRegionCode = "LY" // Libya.
	SponsorsCountryOrRegionCodeLI SponsorsCountryOrRegionCode = "LI" // Liechtenstein.
	SponsorsCountryOrRegionCodeLT SponsorsCountryOrRegionCode = "LT" // Lithuania.
	SponsorsCountryOrRegionCodeLU SponsorsCountryOrRegionCode = "LU" // Luxembourg.
	SponsorsCountryOrRegionCodeMO SponsorsCountryOrRegionCode = "MO" // Macau.
	SponsorsCountryOrRegionCodeMK SponsorsCountryOrRegionCode = "MK" // Macedonia.
	SponsorsCountryOrRegionCodeMG SponsorsCountryOrRegionCode = "MG" // Madagascar.
	SponsorsCountryOrRegionCodeMW SponsorsCountryOrRegionCode = "MW" // Malawi.
	SponsorsCountryOrRegionCodeMY SponsorsCountryOrRegionCode = "MY" // Malaysia.
	SponsorsCountryOrRegionCodeMV SponsorsCountryOrRegionCode = "MV" // Maldives.
	SponsorsCountryOrRegionCodeML SponsorsCountryOrRegionCode = "ML" // Mali.
	SponsorsCountryOrRegionCodeMT SponsorsCountryOrRegionCode = "MT" // Malta.
	SponsorsCountryOrRegionCodeMH SponsorsCountryOrRegionCode = "MH" // Marshall Islands.
	SponsorsCountryOrRegionCodeMQ SponsorsCountryOrRegionCode = "MQ" // Martinique.
	SponsorsCountryOrRegionCodeMR SponsorsCountryOrRegionCode = "MR" // Mauritania.
	SponsorsCountryOrRegionCodeMU SponsorsCountryOrRegionCode = "MU" // Mauritius.
	SponsorsCountryOrRegionCodeYT SponsorsCountryOrRegionCode = "YT" // Mayotte.
	SponsorsCountryOrRegionCodeMX SponsorsCountryOrRegionCode = "MX" // Mexico.
	SponsorsCountryOrRegionCodeFM SponsorsCountryOrRegionCode = "FM" // Micronesia.
	SponsorsCountryOrRegionCodeMD SponsorsCountryOrRegionCode = "MD" // Moldova.
	SponsorsCountryOrRegionCodeMC SponsorsCountryOrRegionCode = "MC" // Monaco.
	SponsorsCountryOrRegionCodeMN SponsorsCountryOrRegionCode = "MN" // Mongolia.
	SponsorsCountryOrRegionCodeME SponsorsCountryOrRegionCode = "ME" // Montenegro.
	SponsorsCountryOrRegionCodeMS SponsorsCountryOrRegionCode = "MS" // Montserrat.
	SponsorsCountryOrRegionCodeMA SponsorsCountryOrRegionCode = "MA" // Morocco.
	SponsorsCountryOrRegionCodeMZ SponsorsCountryOrRegionCode = "MZ" // Mozambique.
	SponsorsCountryOrRegionCodeMM SponsorsCountryOrRegionCode = "MM" // Myanmar.
	SponsorsCountryOrRegionCodeNA SponsorsCountryOrRegionCode = "NA" // Namibia.
	SponsorsCountryOrRegionCodeNR SponsorsCountryOrRegionCode = "NR" // Nauru.
	SponsorsCountryOrRegionCodeNP SponsorsCountryOrRegionCode = "NP" // Nepal.
	SponsorsCountryOrRegionCodeNL SponsorsCountryOrRegionCode = "NL" // Netherlands.
	SponsorsCountryOrRegionCodeNC SponsorsCountryOrRegionCode = "NC" // New Caledonia.
	SponsorsCountryOrRegionCodeNZ SponsorsCountryOrRegionCode = "NZ" // New Zealand.
	SponsorsCountryOrRegionCodeNI SponsorsCountryOrRegionCode = "NI" // Nicaragua.
	SponsorsCountryOrRegionCodeNE SponsorsCountryOrRegionCode = "NE" // Niger.
	SponsorsCountryOrRegionCodeNG SponsorsCountryOrRegionCode = "NG" // Nigeria.
	SponsorsCountryOrRegionCodeNU SponsorsCountryOrRegionCode = "NU" // Niue.
	SponsorsCountryOrRegionCodeNF SponsorsCountryOrRegionCode = "NF" // Norfolk Island.
	SponsorsCountryOrRegionCodeMP SponsorsCountryOrRegionCode = "MP" // Northern Mariana Islands.
	SponsorsCountryOrRegionCodeNO SponsorsCountryOrRegionCode = "NO" // Norway.
	SponsorsCountryOrRegionCodeOM SponsorsCountryOrRegionCode = "OM" // Oman.
	SponsorsCountryOrRegionCodePK SponsorsCountryOrRegionCode = "PK" // Pakistan.
	SponsorsCountryOrRegionCodePW SponsorsCountryOrRegionCode = "PW" // Palau.
	SponsorsCountryOrRegionCodePS SponsorsCountryOrRegionCode = "PS" // Palestine.
	SponsorsCountryOrRegionCodePA SponsorsCountryOrRegionCode = "PA" // Panama.
	SponsorsCountryOrRegionCodePG SponsorsCountryOrRegionCode = "PG" // Papua New Guinea.
	SponsorsCountryOrRegionCodePY SponsorsCountryOrRegionCode = "PY" // Paraguay.
	SponsorsCountryOrRegionCodePE SponsorsCountryOrRegionCode = "PE" // Peru.
	SponsorsCountryOrRegionCodePH SponsorsCountryOrRegionCode = "PH" // Philippines.
	SponsorsCountryOrRegionCodePN SponsorsCountryOrRegionCode = "PN" // Pitcairn.
	SponsorsCountryOrRegionCodePL SponsorsCountryOrRegionCode = "PL" // Poland.
	SponsorsCountryOrRegionCodePT SponsorsCountryOrRegionCode = "PT" // Portugal.
	SponsorsCountryOrRegionCodePR SponsorsCountryOrRegionCode = "PR" // Puerto Rico.
	SponsorsCountryOrRegionCodeQA SponsorsCountryOrRegionCode = "QA" // Qatar.
	SponsorsCountryOrRegionCodeRE SponsorsCountryOrRegionCode = "RE" // Reunion.
	SponsorsCountryOrRegionCodeRO SponsorsCountryOrRegionCode = "RO" // Romania.
	SponsorsCountryOrRegionCodeRU SponsorsCountryOrRegionCode = "RU" // Russian Federation.
	SponsorsCountryOrRegionCodeRW SponsorsCountryOrRegionCode = "RW" // Rwanda.
	SponsorsCountryOrRegionCodeBL SponsorsCountryOrRegionCode = "BL" // Saint Barthélemy.
	SponsorsCountryOrRegionCodeSH SponsorsCountryOrRegionCode = "SH" // Saint Helena.
	SponsorsCountryOrRegionCodeKN SponsorsCountryOrRegionCode = "KN" // Saint Kitts and Nevis.
	SponsorsCountryOrRegionCodeLC SponsorsCountryOrRegionCode = "LC" // Saint Lucia.
	SponsorsCountryOrRegionCodeMF SponsorsCountryOrRegionCode = "MF" // Saint Martin (French part).
	SponsorsCountryOrRegionCodePM SponsorsCountryOrRegionCode = "PM" // Saint Pierre and Miquelon.
	SponsorsCountryOrRegionCodeVC SponsorsCountryOrRegionCode = "VC" // Saint Vincent and the Grenadines.
	SponsorsCountryOrRegionCodeWS SponsorsCountryOrRegionCode = "WS" // Samoa.
	SponsorsCountryOrRegionCodeSM SponsorsCountryOrRegionCode = "SM" // San Marino.
	SponsorsCountryOrRegionCodeST SponsorsCountryOrRegionCode = "ST" // Sao Tome and Principe.
	SponsorsCountryOrRegionCodeSA SponsorsCountryOrRegionCode = "SA" // Saudi Arabia.
	SponsorsCountryOrRegionCodeSN SponsorsCountryOrRegionCode = "SN" // Senegal.
	SponsorsCountryOrRegionCodeRS SponsorsCountryOrRegionCode = "RS" // Serbia.
	SponsorsCountryOrRegionCodeSC SponsorsCountryOrRegionCode = "SC" // Seychelles.
	SponsorsCountryOrRegionCodeSL SponsorsCountryOrRegionCode = "SL" // Sierra Leone.
	SponsorsCountryOrRegionCodeSG SponsorsCountryOrRegionCode = "SG" // Singapore.
	SponsorsCountryOrRegionCodeSX SponsorsCountryOrRegionCode = "SX" // Sint Maarten (Dutch part).
	SponsorsCountryOrRegionCodeSK SponsorsCountryOrRegionCode = "SK" // Slovakia.
	SponsorsCountryOrRegionCodeSI SponsorsCountryOrRegionCode = "SI" // Slovenia.
	SponsorsCountryOrRegionCodeSB SponsorsCountryOrRegionCode = "SB" // Solomon Islands.
	SponsorsCountryOrRegionCodeSO SponsorsCountryOrRegionCode = "SO" // Somalia.
	SponsorsCountryOrRegionCodeZA SponsorsCountryOrRegionCode = "ZA" // South Africa.
	SponsorsCountryOrRegionCodeGS SponsorsCountryOrRegionCode = "GS" // South Georgia and South Sandwich Islands.
	SponsorsCountryOrRegionCodeSS SponsorsCountryOrRegionCode = "SS" // South Sudan.
	SponsorsCountryOrRegionCodeES SponsorsCountryOrRegionCode = "ES" // Spain.
	SponsorsCountryOrRegionCodeLK SponsorsCountryOrRegionCode = "LK" // Sri Lanka.
	SponsorsCountryOrRegionCodeSD SponsorsCountryOrRegionCode = "SD" // Sudan.
	SponsorsCountryOrRegionCodeSR SponsorsCountryOrRegionCode = "SR" // Suriname.
	SponsorsCountryOrRegionCodeSJ SponsorsCountryOrRegionCode = "SJ" // Svalbard and Jan Mayen Islands.
	SponsorsCountryOrRegionCodeSZ SponsorsCountryOrRegionCode = "SZ" // Swaziland.
	SponsorsCountryOrRegionCodeSE SponsorsCountryOrRegionCode = "SE" // Sweden.
	SponsorsCountryOrRegionCodeCH SponsorsCountryOrRegionCode = "CH" // Switzerland.
	SponsorsCountryOrRegionCodeTW SponsorsCountryOrRegionCode = "TW" // Taiwan.
	SponsorsCountryOrRegionCodeTJ SponsorsCountryOrRegionCode = "TJ" // Tajikistan.
	SponsorsCountryOrRegionCodeTZ SponsorsCountryOrRegionCode = "TZ" // Tanzania.
	SponsorsCountryOrRegionCodeTH SponsorsCountryOrRegionCode = "TH" // Thailand.
	SponsorsCountryOrRegionCodeTL SponsorsCountryOrRegionCode = "TL" // Timor-Leste.
	SponsorsCountryOrRegionCodeTG SponsorsCountryOrRegionCode = "TG" // Togo.
	SponsorsCountryOrRegionCodeTK SponsorsCountryOrRegionCode = "TK" // Tokelau.
	SponsorsCountryOrRegionCodeTO SponsorsCountryOrRegionCode = "TO" // Tonga.
	SponsorsCountryOrRegionCodeTT SponsorsCountryOrRegionCode = "TT" // Trinidad and Tobago.
	SponsorsCountryOrRegionCodeTN SponsorsCountryOrRegionCode = "TN" // Tunisia.
	SponsorsCountryOrRegionCodeTR SponsorsCountryOrRegionCode = "TR" // Türkiye.
	SponsorsCountryOrRegionCodeTM SponsorsCountryOrRegionCode = "TM" // Turkmenistan.
	SponsorsCountryOrRegionCodeTC SponsorsCountryOrRegionCode = "TC" // Turks and Caicos Islands.
	SponsorsCountryOrRegionCodeTV SponsorsCountryOrRegionCode = "TV" // Tuvalu.
	SponsorsCountryOrRegionCodeUG SponsorsCountryOrRegionCode = "UG" // Uganda.
	SponsorsCountryOrRegionCodeUA SponsorsCountryOrRegionCode = "UA" // Ukraine.
	SponsorsCountryOrRegionCodeAE SponsorsCountryOrRegionCode = "AE" // United Arab Emirates.
	SponsorsCountryOrRegionCodeGB SponsorsCountryOrRegionCode = "GB" // United Kingdom.
	SponsorsCountryOrRegionCodeUM SponsorsCountryOrRegionCode = "UM" // United States Minor Outlying Islands.
	SponsorsCountryOrRegionCodeUS SponsorsCountryOrRegionCode = "US" // United States of America.
	SponsorsCountryOrRegionCodeUY SponsorsCountryOrRegionCode = "UY" // Uruguay.
	SponsorsCountryOrRegionCodeUZ SponsorsCountryOrRegionCode = "UZ" // Uzbekistan.
	SponsorsCountryOrRegionCodeVU SponsorsCountryOrRegionCode = "VU" // Vanuatu.
	SponsorsCountryOrRegionCodeVA SponsorsCountryOrRegionCode = "VA" // Vatican City.
	SponsorsCountryOrRegionCodeVE SponsorsCountryOrRegionCode = "VE" // Venezuela.
	SponsorsCountryOrRegionCodeVN SponsorsCountryOrRegionCode = "VN" // Vietnam.
	SponsorsCountryOrRegionCodeVG SponsorsCountryOrRegionCode = "VG" // Virgin Islands, British.
	SponsorsCountryOrRegionCodeVI SponsorsCountryOrRegionCode = "VI" // Virgin Islands, U.S.
	SponsorsCountryOrRegionCodeWF SponsorsCountryOrRegionCode = "WF" // Wallis and Futuna Islands.
	SponsorsCountryOrRegionCodeEH SponsorsCountryOrRegionCode = "EH" // Western Sahara.
	SponsorsCountryOrRegionCodeYE SponsorsCountryOrRegionCode = "YE" // Yemen.
	SponsorsCountryOrRegionCodeZM SponsorsCountryOrRegionCode = "ZM" // Zambia.
	SponsorsCountryOrRegionCodeZW SponsorsCountryOrRegionCode = "ZW" // Zimbabwe.
)

// SponsorsGoalKind represents the different kinds of goals a GitHub Sponsors member can have.
type SponsorsGoalKind string

// The different kinds of goals a GitHub Sponsors member can have.
const (
	SponsorsGoalKindTotalSponsorsCount       SponsorsGoalKind = "TOTAL_SPONSORS_COUNT"       // The goal is about reaching a certain number of sponsors.
	SponsorsGoalKindMonthlySponsorshipAmount SponsorsGoalKind = "MONTHLY_SPONSORSHIP_AMOUNT" // The goal is about getting a certain amount in USD from sponsorships each month.
)

// SponsorsListingFeaturedItemFeatureableType represents the different kinds of records that can be featured on a GitHub Sponsors profile page.
type SponsorsListingFeaturedItemFeatureableType string

// The different kinds of records that can be featured on a GitHub Sponsors profile page.
const (
	SponsorsListingFeaturedItemFeatureableTypeRepository SponsorsListingFeaturedItemFeatureableType = "REPOSITORY" // A repository owned by the user or organization with the GitHub Sponsors profile.
	SponsorsListingFeaturedItemFeatureableTypeUser       SponsorsListingFeaturedItemFeatureableType = "USER"       // A user who belongs to the organization with the GitHub Sponsors profile.
)

// SponsorsTierOrderField represents properties by which Sponsors tiers connections can be ordered.
type SponsorsTierOrderField string

// Properties by which Sponsors tiers connections can be ordered.
const (
	SponsorsTierOrderFieldCreatedAt           SponsorsTierOrderField = "CREATED_AT"             // Order tiers by creation time.
	SponsorsTierOrderFieldMonthlyPriceInCents SponsorsTierOrderField = "MONTHLY_PRICE_IN_CENTS" // Order tiers by their monthly price in cents.
)

// SponsorshipNewsletterOrderField represents properties by which sponsorship update connections can be ordered.
type SponsorshipNewsletterOrderField string

// Properties by which sponsorship update connections can be ordered.
const (
	SponsorshipNewsletterOrderFieldCreatedAt SponsorshipNewsletterOrderField = "CREATED_AT" // Order sponsorship newsletters by when they were created.
)

// SponsorshipOrderField represents properties by which sponsorship connections can be ordered.
type SponsorshipOrderField string

// Properties by which sponsorship connections can be ordered.
const (
	SponsorshipOrderFieldCreatedAt SponsorshipOrderField = "CREATED_AT" // Order sponsorship by creation time.
)

// SponsorshipPaymentSource represents how payment was made for funding a GitHub Sponsors sponsorship.
type SponsorshipPaymentSource string

// How payment was made for funding a GitHub Sponsors sponsorship.
const (
	SponsorshipPaymentSourceGitHub  SponsorshipPaymentSource = "GITHUB"  // Payment was made through GitHub.
	SponsorshipPaymentSourcePatreon SponsorshipPaymentSource = "PATREON" // Payment was made through Patreon.
)

// SponsorshipPrivacy represents the privacy of a sponsorship.
type SponsorshipPrivacy string

// The privacy of a sponsorship.
const (
	SponsorshipPrivacyPublic  SponsorshipPrivacy = "PUBLIC"  // Public.
	SponsorshipPrivacyPrivate SponsorshipPrivacy = "PRIVATE" // Private.
)

// SquashMergeCommitMessage represents the possible default commit messages for squash merges.
type SquashMergeCommitMessage string

// The possible default commit messages for squash merges.
const (
	SquashMergeCommitMessagePrBody         SquashMergeCommitMessage = "PR_BODY"         // Default to the pull request's body.
	SquashMergeCommitMessageCommitMessages SquashMergeCommitMessage = "COMMIT_MESSAGES" // Default to the branch's commit messages.
	SquashMergeCommitMessageBlank          SquashMergeCommitMessage = "BLANK"           // Default to a blank commit message.
)

// SquashMergeCommitTitle represents the possible default commit titles for squash merges.
type SquashMergeCommitTitle string

// The possible default commit titles for squash merges.
const (
	SquashMergeCommitTitlePrTitle         SquashMergeCommitTitle = "PR_TITLE"           // Default to the pull request's title.
	SquashMergeCommitTitleCommitOrPrTitle SquashMergeCommitTitle = "COMMIT_OR_PR_TITLE" // Default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
)

// StarOrderField represents properties by which star connections can be ordered.
type StarOrderField string

// Properties by which star connections can be ordered.
const (
	StarOrderFieldStarredAt StarOrderField = "STARRED_AT" // Allows ordering a list of stars by when they were created.
)

// StatusState represents the possible commit status states.
type StatusState string

// The possible commit status states.
const (
	StatusStateExpected StatusState = "EXPECTED" // Status is expected.
	StatusStateError    StatusState = "ERROR"    // Status is errored.
	StatusStateFailure  StatusState = "FAILURE"  // Status is failing.
	StatusStatePending  StatusState = "PENDING"  // Status is pending.
	StatusStateSuccess  StatusState = "SUCCESS"  // Status is successful.
)

// SubscriptionState represents the possible states of a subscription.
type SubscriptionState string

// The possible states of a subscription.
const (
	SubscriptionStateUnsubscribed SubscriptionState = "UNSUBSCRIBED" // The User is only notified when participating or @mentioned.
	SubscriptionStateSubscribed   SubscriptionState = "SUBSCRIBED"   // The User is notified of all conversations.
	SubscriptionStateIgnored      SubscriptionState = "IGNORED"      // The User is never notified.
)

// TeamDiscussionCommentOrderField represents properties by which team discussion comment connections can be ordered.
type TeamDiscussionCommentOrderField string

// Properties by which team discussion comment connections can be ordered.
const (
	TeamDiscussionCommentOrderFieldNumber TeamDiscussionCommentOrderField = "NUMBER" // Allows sequential ordering of team discussion comments (which is equivalent to chronological ordering).
)

// TeamDiscussionOrderField represents properties by which team discussion connections can be ordered.
type TeamDiscussionOrderField string

// Properties by which team discussion connections can be ordered.
const (
	TeamDiscussionOrderFieldCreatedAt TeamDiscussionOrderField = "CREATED_AT" // Allows chronological ordering of team discussions.
)

// TeamMemberOrderField represents properties by which team member connections can be ordered.
type TeamMemberOrderField string

// Properties by which team member connections can be ordered.
const (
	TeamMemberOrderFieldLogin     TeamMemberOrderField = "LOGIN"      // Order team members by login.
	TeamMemberOrderFieldCreatedAt TeamMemberOrderField = "CREATED_AT" // Order team members by creation time.
)

// TeamMemberRole represents the possible team member roles; either 'maintainer' or 'member'.
type TeamMemberRole string

// The possible team member roles; either 'maintainer' or 'member'.
const (
	TeamMemberRoleMaintainer TeamMemberRole = "MAINTAINER" // A team maintainer has permission to add and remove team members.
	TeamMemberRoleMember     TeamMemberRole = "MEMBER"     // A team member has no administrative permissions on the team.
)

// TeamMembershipType represents defines which types of team members are included in the returned list. Can be one of IMMEDIATE, CHILD_TEAM or ALL.
type TeamMembershipType string

// Defines which types of team members are included in the returned list. Can be one of IMMEDIATE, CHILD_TEAM or ALL.
const (
	TeamMembershipTypeImmediate TeamMembershipType = "IMMEDIATE"  // Includes only immediate members of the team.
	TeamMembershipTypeChildTeam TeamMembershipType = "CHILD_TEAM" // Includes only child team members for the team.
	TeamMembershipTypeAll       TeamMembershipType = "ALL"        // Includes immediate and child team members for the team.
)

// TeamNotificationSetting represents the possible team notification values.
type TeamNotificationSetting string

// The possible team notification values.
const (
	TeamNotificationSettingNotificationsEnabled  TeamNotificationSetting = "NOTIFICATIONS_ENABLED"  // Everyone will receive notifications when the team is @mentioned.
	TeamNotificationSettingNotificationsDisabled TeamNotificationSetting = "NOTIFICATIONS_DISABLED" // No one will receive notifications.
)

// TeamOrderField represents properties by which team connections can be ordered.
type TeamOrderField string

// Properties by which team connections can be ordered.
const (
	TeamOrderFieldName TeamOrderField = "NAME" // Allows ordering a list of teams by name.
)

// TeamPrivacy represents the possible team privacy values.
type TeamPrivacy string

// The possible team privacy values.
const (
	TeamPrivacySecret  TeamPrivacy = "SECRET"  // A secret team can only be seen by its members.
	TeamPrivacyVisible TeamPrivacy = "VISIBLE" // A visible team can be seen and @mentioned by every member of the organization.
)

// TeamRepositoryOrderField represents properties by which team repository connections can be ordered.
type TeamRepositoryOrderField string

// Properties by which team repository connections can be ordered.
const (
	TeamRepositoryOrderFieldCreatedAt  TeamRepositoryOrderField = "CREATED_AT" // Order repositories by creation time.
	TeamRepositoryOrderFieldUpdatedAt  TeamRepositoryOrderField = "UPDATED_AT" // Order repositories by update time.
	TeamRepositoryOrderFieldPushedAt   TeamRepositoryOrderField = "PUSHED_AT"  // Order repositories by push time.
	TeamRepositoryOrderFieldName       TeamRepositoryOrderField = "NAME"       // Order repositories by name.
	TeamRepositoryOrderFieldPermission TeamRepositoryOrderField = "PERMISSION" // Order repositories by permission.
	TeamRepositoryOrderFieldStargazers TeamRepositoryOrderField = "STARGAZERS" // Order repositories by number of stargazers.
)

// TeamReviewAssignmentAlgorithm represents the possible team review assignment algorithms.
type TeamReviewAssignmentAlgorithm string

// The possible team review assignment algorithms.
const (
	TeamReviewAssignmentAlgorithmRoundRobin  TeamReviewAssignmentAlgorithm = "ROUND_ROBIN"  // Alternate reviews between each team member.
	TeamReviewAssignmentAlgorithmLoadBalance TeamReviewAssignmentAlgorithm = "LOAD_BALANCE" // Balance review load across the entire team.
)

// TeamRole represents the role of a user on a team.
type TeamRole string

// The role of a user on a team.
const (
	TeamRoleAdmin  TeamRole = "ADMIN"  // User has admin rights on the team.
	TeamRoleMember TeamRole = "MEMBER" // User is a member of the team.
)

// ThreadSubscriptionFormAction represents the possible states of a thread subscription form action.
type ThreadSubscriptionFormAction string

// The possible states of a thread subscription form action.
const (
	ThreadSubscriptionFormActionNone        ThreadSubscriptionFormAction = "NONE"        // The User cannot subscribe or unsubscribe to the thread.
	ThreadSubscriptionFormActionSubscribe   ThreadSubscriptionFormAction = "SUBSCRIBE"   // The User can subscribe to the thread.
	ThreadSubscriptionFormActionUnsubscribe ThreadSubscriptionFormAction = "UNSUBSCRIBE" // The User can unsubscribe to the thread.
)

// ThreadSubscriptionState represents the possible states of a subscription.
type ThreadSubscriptionState string

// The possible states of a subscription.
const (
	ThreadSubscriptionStateUnavailable              ThreadSubscriptionState = "UNAVAILABLE"                 // The subscription status is currently unavailable.
	ThreadSubscriptionStateDisabled                 ThreadSubscriptionState = "DISABLED"                    // The subscription status is currently disabled.
	ThreadSubscriptionStateIgnoringList             ThreadSubscriptionState = "IGNORING_LIST"               // The User is never notified because they are ignoring the list.
	ThreadSubscriptionStateSubscribedToThreadEvents ThreadSubscriptionState = "SUBSCRIBED_TO_THREAD_EVENTS" // The User is notified because they chose custom settings for this thread.
	ThreadSubscriptionStateIgnoringThread           ThreadSubscriptionState = "IGNORING_THREAD"             // The User is never notified because they are ignoring the thread.
	ThreadSubscriptionStateSubscribedToList         ThreadSubscriptionState = "SUBSCRIBED_TO_LIST"          // The User is notified becuase they are watching the list.
	ThreadSubscriptionStateSubscribedToThreadType   ThreadSubscriptionState = "SUBSCRIBED_TO_THREAD_TYPE"   // The User is notified because they chose custom settings for this thread.
	ThreadSubscriptionStateSubscribedToThread       ThreadSubscriptionState = "SUBSCRIBED_TO_THREAD"        // The User is notified because they are subscribed to the thread.
	ThreadSubscriptionStateNone                     ThreadSubscriptionState = "NONE"                        // The User is not recieving notifications from this thread.
)

// TopicSuggestionDeclineReason represents reason that the suggested topic is declined.
type TopicSuggestionDeclineReason string

// Reason that the suggested topic is declined.
const (
	TopicSuggestionDeclineReasonNotRelevant        TopicSuggestionDeclineReason = "NOT_RELEVANT"        // The suggested topic is not relevant to the repository.
	TopicSuggestionDeclineReasonTooSpecific        TopicSuggestionDeclineReason = "TOO_SPECIFIC"        // The suggested topic is too specific for the repository (e.g. #ruby-on-rails-version-4-2-1).
	TopicSuggestionDeclineReasonPersonalPreference TopicSuggestionDeclineReason = "PERSONAL_PREFERENCE" // The viewer does not like the suggested topic.
	TopicSuggestionDeclineReasonTooGeneral         TopicSuggestionDeclineReason = "TOO_GENERAL"         // The suggested topic is too general for the repository.
)

// TrackedIssueStates represents the possible states of a tracked issue.
type TrackedIssueStates string

// The possible states of a tracked issue.
const (
	TrackedIssueStatesOpen   TrackedIssueStates = "OPEN"   // The tracked issue is open.
	TrackedIssueStatesClosed TrackedIssueStates = "CLOSED" // The tracked issue is closed.
)

// UserBlockDuration represents the possible durations that a user can be blocked for.
type UserBlockDuration string

// The possible durations that a user can be blocked for.
const (
	UserBlockDurationOneDay    UserBlockDuration = "ONE_DAY"    // The user was blocked for 1 day.
	UserBlockDurationThreeDays UserBlockDuration = "THREE_DAYS" // The user was blocked for 3 days.
	UserBlockDurationOneWeek   UserBlockDuration = "ONE_WEEK"   // The user was blocked for 7 days.
	UserBlockDurationOneMonth  UserBlockDuration = "ONE_MONTH"  // The user was blocked for 30 days.
	UserBlockDurationPermanent UserBlockDuration = "PERMANENT"  // The user was blocked permanently.
)

// UserStatusOrderField represents properties by which user status connections can be ordered.
type UserStatusOrderField string

// Properties by which user status connections can be ordered.
const (
	UserStatusOrderFieldUpdatedAt UserStatusOrderField = "UPDATED_AT" // Order user statuses by when they were updated.
)

// VerifiableDomainOrderField represents properties by which verifiable domain connections can be ordered.
type VerifiableDomainOrderField string

// Properties by which verifiable domain connections can be ordered.
const (
	VerifiableDomainOrderFieldDomain    VerifiableDomainOrderField = "DOMAIN"     // Order verifiable domains by the domain name.
	VerifiableDomainOrderFieldCreatedAt VerifiableDomainOrderField = "CREATED_AT" // Order verifiable domains by their creation date.
)

// WorkflowRunOrderField represents properties by which workflow run connections can be ordered.
type WorkflowRunOrderField string

// Properties by which workflow run connections can be ordered.
const (
	WorkflowRunOrderFieldCreatedAt WorkflowRunOrderField = "CREATED_AT" // Order workflow runs by most recently created.
)

// WorkflowState represents the possible states for a workflow.
type WorkflowState string

// The possible states for a workflow.
const (
	WorkflowStateActive             WorkflowState = "ACTIVE"              // The workflow is active.
	WorkflowStateDeleted            WorkflowState = "DELETED"             // The workflow was deleted from the git repository.
	WorkflowStateDisabledFork       WorkflowState = "DISABLED_FORK"       // The workflow was disabled by default on a fork.
	WorkflowStateDisabledInactivity WorkflowState = "DISABLED_INACTIVITY" // The workflow was disabled for inactivity in the repository.
	WorkflowStateDisabledManually   WorkflowState = "DISABLED_MANUALLY"   // The workflow was disabled manually.
)
