// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/billing/v1/cloud_billing.proto

package billing

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A billing account in [GCP Console](https://console.cloud.google.com/).
// You can assign a billing account to one or more projects.
type BillingAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the billing account. The resource name has the form
	// `billingAccounts/{billing_account_id}`. For example,
	// `billingAccounts/012345-567890-ABCDEF` would be the resource name for
	// billing account `012345-567890-ABCDEF`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. True if the billing account is open, and will therefore be charged for any
	// usage on associated projects. False if the billing account is closed, and
	// therefore projects associated with it will be unable to use paid services.
	Open bool `protobuf:"varint,2,opt,name=open,proto3" json:"open,omitempty"`
	// The display name given to the billing account, such as `My Billing
	// Account`. This name is displayed in the GCP Console.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// If this account is a
	// [subaccount](https://cloud.google.com/billing/docs/concepts), then this
	// will be the resource name of the master billing account that it is being
	// resold through.
	// Otherwise this will be empty.
	MasterBillingAccount string `protobuf:"bytes,4,opt,name=master_billing_account,json=masterBillingAccount,proto3" json:"master_billing_account,omitempty"`
}

func (x *BillingAccount) Reset() {
	*x = BillingAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BillingAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BillingAccount) ProtoMessage() {}

func (x *BillingAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BillingAccount.ProtoReflect.Descriptor instead.
func (*BillingAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{0}
}

func (x *BillingAccount) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BillingAccount) GetOpen() bool {
	if x != nil {
		return x.Open
	}
	return false
}

func (x *BillingAccount) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *BillingAccount) GetMasterBillingAccount() string {
	if x != nil {
		return x.MasterBillingAccount
	}
	return ""
}

// Encapsulation of billing information for a GCP Console project. A project
// has at most one associated billing account at a time (but a billing account
// can be assigned to multiple projects).
type ProjectBillingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for the `ProjectBillingInfo`; has the form
	// `projects/{project_id}/billingInfo`. For example, the resource name for the
	// billing information for project `tokyo-rain-123` would be
	// `projects/tokyo-rain-123/billingInfo`. This field is read-only.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The ID of the project that this `ProjectBillingInfo` represents, such as
	// `tokyo-rain-123`. This is a convenience field so that you don't need to
	// parse the `name` field to obtain a project ID. This field is read-only.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The resource name of the billing account associated with the project, if
	// any. For example, `billingAccounts/012345-567890-ABCDEF`.
	BillingAccountName string `protobuf:"bytes,3,opt,name=billing_account_name,json=billingAccountName,proto3" json:"billing_account_name,omitempty"`
	// True if the project is associated with an open billing account, to which
	// usage on the project is charged. False if the project is associated with a
	// closed billing account, or no billing account at all, and therefore cannot
	// use paid services. This field is read-only.
	BillingEnabled bool `protobuf:"varint,4,opt,name=billing_enabled,json=billingEnabled,proto3" json:"billing_enabled,omitempty"`
}

func (x *ProjectBillingInfo) Reset() {
	*x = ProjectBillingInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectBillingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectBillingInfo) ProtoMessage() {}

func (x *ProjectBillingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectBillingInfo.ProtoReflect.Descriptor instead.
func (*ProjectBillingInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{1}
}

func (x *ProjectBillingInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProjectBillingInfo) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ProjectBillingInfo) GetBillingAccountName() string {
	if x != nil {
		return x.BillingAccountName
	}
	return ""
}

func (x *ProjectBillingInfo) GetBillingEnabled() bool {
	if x != nil {
		return x.BillingEnabled
	}
	return false
}

// Request message for `GetBillingAccount`.
type GetBillingAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the billing account to retrieve. For example,
	// `billingAccounts/012345-567890-ABCDEF`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBillingAccountRequest) Reset() {
	*x = GetBillingAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBillingAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBillingAccountRequest) ProtoMessage() {}

func (x *GetBillingAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBillingAccountRequest.ProtoReflect.Descriptor instead.
func (*GetBillingAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{2}
}

func (x *GetBillingAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `ListBillingAccounts`.
type ListBillingAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Requested page size. The maximum page size is 100; this is also the
	// default.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results to return. This should be a
	// `next_page_token` value returned from a previous `ListBillingAccounts`
	// call. If unspecified, the first page of results is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Options for how to filter the returned billing accounts.
	// Currently this only supports filtering for
	// [subaccounts](https://cloud.google.com/billing/docs/concepts) under a
	// single provided reseller billing account.
	// (e.g. "master_billing_account=billingAccounts/012345-678901-ABCDEF").
	// Boolean algebra and other fields are not currently supported.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListBillingAccountsRequest) Reset() {
	*x = ListBillingAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBillingAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBillingAccountsRequest) ProtoMessage() {}

func (x *ListBillingAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBillingAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListBillingAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{3}
}

func (x *ListBillingAccountsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBillingAccountsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBillingAccountsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for `ListBillingAccounts`.
type ListBillingAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of billing accounts.
	BillingAccounts []*BillingAccount `protobuf:"bytes,1,rep,name=billing_accounts,json=billingAccounts,proto3" json:"billing_accounts,omitempty"`
	// A token to retrieve the next page of results. To retrieve the next page,
	// call `ListBillingAccounts` again with the `page_token` field set to this
	// value. This field is empty if there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBillingAccountsResponse) Reset() {
	*x = ListBillingAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBillingAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBillingAccountsResponse) ProtoMessage() {}

func (x *ListBillingAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBillingAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListBillingAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{4}
}

func (x *ListBillingAccountsResponse) GetBillingAccounts() []*BillingAccount {
	if x != nil {
		return x.BillingAccounts
	}
	return nil
}

func (x *ListBillingAccountsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `CreateBillingAccount`.
type CreateBillingAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The billing account resource to create.
	// Currently CreateBillingAccount only supports subaccount creation, so
	// any created billing accounts must be under a provided master billing
	// account.
	BillingAccount *BillingAccount `protobuf:"bytes,1,opt,name=billing_account,json=billingAccount,proto3" json:"billing_account,omitempty"`
}

func (x *CreateBillingAccountRequest) Reset() {
	*x = CreateBillingAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBillingAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBillingAccountRequest) ProtoMessage() {}

func (x *CreateBillingAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBillingAccountRequest.ProtoReflect.Descriptor instead.
func (*CreateBillingAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{5}
}

func (x *CreateBillingAccountRequest) GetBillingAccount() *BillingAccount {
	if x != nil {
		return x.BillingAccount
	}
	return nil
}

// Request message for `UpdateBillingAccount`.
type UpdateBillingAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the billing account resource to be updated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The billing account resource to replace the resource on the server.
	Account *BillingAccount `protobuf:"bytes,2,opt,name=account,proto3" json:"account,omitempty"`
	// The update mask applied to the resource.
	// Only "display_name" is currently supported.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBillingAccountRequest) Reset() {
	*x = UpdateBillingAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBillingAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBillingAccountRequest) ProtoMessage() {}

func (x *UpdateBillingAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBillingAccountRequest.ProtoReflect.Descriptor instead.
func (*UpdateBillingAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateBillingAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateBillingAccountRequest) GetAccount() *BillingAccount {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *UpdateBillingAccountRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for `ListProjectBillingInfo`.
type ListProjectBillingInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the billing account associated with the projects that
	// you want to list. For example, `billingAccounts/012345-567890-ABCDEF`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Requested page size. The maximum page size is 100; this is also the
	// default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results to be returned. This should be a
	// `next_page_token` value returned from a previous `ListProjectBillingInfo`
	// call. If unspecified, the first page of results is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProjectBillingInfoRequest) Reset() {
	*x = ListProjectBillingInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProjectBillingInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProjectBillingInfoRequest) ProtoMessage() {}

func (x *ListProjectBillingInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProjectBillingInfoRequest.ProtoReflect.Descriptor instead.
func (*ListProjectBillingInfoRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{7}
}

func (x *ListProjectBillingInfoRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListProjectBillingInfoRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProjectBillingInfoRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for `ListProjectBillingInfoResponse`.
type ListProjectBillingInfoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of `ProjectBillingInfo` resources representing the projects
	// associated with the billing account.
	ProjectBillingInfo []*ProjectBillingInfo `protobuf:"bytes,1,rep,name=project_billing_info,json=projectBillingInfo,proto3" json:"project_billing_info,omitempty"`
	// A token to retrieve the next page of results. To retrieve the next page,
	// call `ListProjectBillingInfo` again with the `page_token` field set to this
	// value. This field is empty if there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProjectBillingInfoResponse) Reset() {
	*x = ListProjectBillingInfoResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProjectBillingInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProjectBillingInfoResponse) ProtoMessage() {}

func (x *ListProjectBillingInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProjectBillingInfoResponse.ProtoReflect.Descriptor instead.
func (*ListProjectBillingInfoResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{8}
}

func (x *ListProjectBillingInfoResponse) GetProjectBillingInfo() []*ProjectBillingInfo {
	if x != nil {
		return x.ProjectBillingInfo
	}
	return nil
}

func (x *ListProjectBillingInfoResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `GetProjectBillingInfo`.
type GetProjectBillingInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project for which billing information is
	// retrieved. For example, `projects/tokyo-rain-123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProjectBillingInfoRequest) Reset() {
	*x = GetProjectBillingInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProjectBillingInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProjectBillingInfoRequest) ProtoMessage() {}

func (x *GetProjectBillingInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProjectBillingInfoRequest.ProtoReflect.Descriptor instead.
func (*GetProjectBillingInfoRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{9}
}

func (x *GetProjectBillingInfoRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `UpdateProjectBillingInfo`.
type UpdateProjectBillingInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project associated with the billing information
	// that you want to update. For example, `projects/tokyo-rain-123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The new billing information for the project. Read-only fields are ignored;
	// thus, you can leave empty all fields except `billing_account_name`.
	ProjectBillingInfo *ProjectBillingInfo `protobuf:"bytes,2,opt,name=project_billing_info,json=projectBillingInfo,proto3" json:"project_billing_info,omitempty"`
}

func (x *UpdateProjectBillingInfoRequest) Reset() {
	*x = UpdateProjectBillingInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateProjectBillingInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateProjectBillingInfoRequest) ProtoMessage() {}

func (x *UpdateProjectBillingInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateProjectBillingInfoRequest.ProtoReflect.Descriptor instead.
func (*UpdateProjectBillingInfoRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateProjectBillingInfoRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateProjectBillingInfoRequest) GetProjectBillingInfo() *ProjectBillingInfo {
	if x != nil {
		return x.ProjectBillingInfo
	}
	return nil
}

var File_google_cloud_billing_v1_cloud_billing_proto protoreflect.FileDescriptor

var file_google_cloud_billing_v1_cloud_billing_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc7, 0x01, 0x0a, 0x0e, 0x42, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x6f, 0x70, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6f, 0x70, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0xa2, 0x01, 0x0a, 0x12, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a,
	0x0f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x62, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x42, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x70, 0x0a, 0x1a, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x99, 0x01, 0x0a,
	0x1b, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x10,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x0f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x74, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0f, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xea,
	0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa3, 0x01, 0x0a, 0x1d,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xa7, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x12, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x37, 0x0a, 0x1c, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x99, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x5d, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x12, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x32, 0xcb, 0x0e, 0x0a, 0x0c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x12, 0x9c, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xa0, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x1e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x12, 0x13, 0x2f, 0x76, 0x31,
	0x2f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0xda, 0x41, 0x00, 0x12, 0xb3, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x3c, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x27, 0x32, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0xda, 0x41, 0x0c, 0x6e, 0x61, 0x6d,
	0x65, 0x2c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0xb5, 0x01, 0x0a, 0x14, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x2f, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x3a, 0x0f,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0xda,
	0x41, 0x0f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0xbf, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x34, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xad, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xde, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x5b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x1a,
	0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e,
	0x66, 0x6f, 0x3a, 0x14, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0xda, 0x41, 0x19, 0x6e, 0x61, 0x6d, 0x65, 0x2c,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x12, 0x8b, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x95, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x4a,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xc0, 0x01, 0x0a, 0x12, 0x54,
	0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x22, 0x33,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x62, 0x69,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2c, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x4f, 0xca,
	0x41, 0x1b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x72,
	0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_billing_v1_cloud_billing_proto_rawDescOnce sync.Once
	file_google_cloud_billing_v1_cloud_billing_proto_rawDescData = file_google_cloud_billing_v1_cloud_billing_proto_rawDesc
)

func file_google_cloud_billing_v1_cloud_billing_proto_rawDescGZIP() []byte {
	file_google_cloud_billing_v1_cloud_billing_proto_rawDescOnce.Do(func() {
		file_google_cloud_billing_v1_cloud_billing_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_billing_v1_cloud_billing_proto_rawDescData)
	})
	return file_google_cloud_billing_v1_cloud_billing_proto_rawDescData
}

var file_google_cloud_billing_v1_cloud_billing_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_billing_v1_cloud_billing_proto_goTypes = []interface{}{
	(*BillingAccount)(nil),                  // 0: google.cloud.billing.v1.BillingAccount
	(*ProjectBillingInfo)(nil),              // 1: google.cloud.billing.v1.ProjectBillingInfo
	(*GetBillingAccountRequest)(nil),        // 2: google.cloud.billing.v1.GetBillingAccountRequest
	(*ListBillingAccountsRequest)(nil),      // 3: google.cloud.billing.v1.ListBillingAccountsRequest
	(*ListBillingAccountsResponse)(nil),     // 4: google.cloud.billing.v1.ListBillingAccountsResponse
	(*CreateBillingAccountRequest)(nil),     // 5: google.cloud.billing.v1.CreateBillingAccountRequest
	(*UpdateBillingAccountRequest)(nil),     // 6: google.cloud.billing.v1.UpdateBillingAccountRequest
	(*ListProjectBillingInfoRequest)(nil),   // 7: google.cloud.billing.v1.ListProjectBillingInfoRequest
	(*ListProjectBillingInfoResponse)(nil),  // 8: google.cloud.billing.v1.ListProjectBillingInfoResponse
	(*GetProjectBillingInfoRequest)(nil),    // 9: google.cloud.billing.v1.GetProjectBillingInfoRequest
	(*UpdateProjectBillingInfoRequest)(nil), // 10: google.cloud.billing.v1.UpdateProjectBillingInfoRequest
	(*field_mask.FieldMask)(nil),            // 11: google.protobuf.FieldMask
	(*v1.GetIamPolicyRequest)(nil),          // 12: google.iam.v1.GetIamPolicyRequest
	(*v1.SetIamPolicyRequest)(nil),          // 13: google.iam.v1.SetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),    // 14: google.iam.v1.TestIamPermissionsRequest
	(*v1.Policy)(nil),                       // 15: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil),   // 16: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_billing_v1_cloud_billing_proto_depIdxs = []int32{
	0,  // 0: google.cloud.billing.v1.ListBillingAccountsResponse.billing_accounts:type_name -> google.cloud.billing.v1.BillingAccount
	0,  // 1: google.cloud.billing.v1.CreateBillingAccountRequest.billing_account:type_name -> google.cloud.billing.v1.BillingAccount
	0,  // 2: google.cloud.billing.v1.UpdateBillingAccountRequest.account:type_name -> google.cloud.billing.v1.BillingAccount
	11, // 3: google.cloud.billing.v1.UpdateBillingAccountRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 4: google.cloud.billing.v1.ListProjectBillingInfoResponse.project_billing_info:type_name -> google.cloud.billing.v1.ProjectBillingInfo
	1,  // 5: google.cloud.billing.v1.UpdateProjectBillingInfoRequest.project_billing_info:type_name -> google.cloud.billing.v1.ProjectBillingInfo
	2,  // 6: google.cloud.billing.v1.CloudBilling.GetBillingAccount:input_type -> google.cloud.billing.v1.GetBillingAccountRequest
	3,  // 7: google.cloud.billing.v1.CloudBilling.ListBillingAccounts:input_type -> google.cloud.billing.v1.ListBillingAccountsRequest
	6,  // 8: google.cloud.billing.v1.CloudBilling.UpdateBillingAccount:input_type -> google.cloud.billing.v1.UpdateBillingAccountRequest
	5,  // 9: google.cloud.billing.v1.CloudBilling.CreateBillingAccount:input_type -> google.cloud.billing.v1.CreateBillingAccountRequest
	7,  // 10: google.cloud.billing.v1.CloudBilling.ListProjectBillingInfo:input_type -> google.cloud.billing.v1.ListProjectBillingInfoRequest
	9,  // 11: google.cloud.billing.v1.CloudBilling.GetProjectBillingInfo:input_type -> google.cloud.billing.v1.GetProjectBillingInfoRequest
	10, // 12: google.cloud.billing.v1.CloudBilling.UpdateProjectBillingInfo:input_type -> google.cloud.billing.v1.UpdateProjectBillingInfoRequest
	12, // 13: google.cloud.billing.v1.CloudBilling.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	13, // 14: google.cloud.billing.v1.CloudBilling.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	14, // 15: google.cloud.billing.v1.CloudBilling.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	0,  // 16: google.cloud.billing.v1.CloudBilling.GetBillingAccount:output_type -> google.cloud.billing.v1.BillingAccount
	4,  // 17: google.cloud.billing.v1.CloudBilling.ListBillingAccounts:output_type -> google.cloud.billing.v1.ListBillingAccountsResponse
	0,  // 18: google.cloud.billing.v1.CloudBilling.UpdateBillingAccount:output_type -> google.cloud.billing.v1.BillingAccount
	0,  // 19: google.cloud.billing.v1.CloudBilling.CreateBillingAccount:output_type -> google.cloud.billing.v1.BillingAccount
	8,  // 20: google.cloud.billing.v1.CloudBilling.ListProjectBillingInfo:output_type -> google.cloud.billing.v1.ListProjectBillingInfoResponse
	1,  // 21: google.cloud.billing.v1.CloudBilling.GetProjectBillingInfo:output_type -> google.cloud.billing.v1.ProjectBillingInfo
	1,  // 22: google.cloud.billing.v1.CloudBilling.UpdateProjectBillingInfo:output_type -> google.cloud.billing.v1.ProjectBillingInfo
	15, // 23: google.cloud.billing.v1.CloudBilling.GetIamPolicy:output_type -> google.iam.v1.Policy
	15, // 24: google.cloud.billing.v1.CloudBilling.SetIamPolicy:output_type -> google.iam.v1.Policy
	16, // 25: google.cloud.billing.v1.CloudBilling.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	16, // [16:26] is the sub-list for method output_type
	6,  // [6:16] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_billing_v1_cloud_billing_proto_init() }
func file_google_cloud_billing_v1_cloud_billing_proto_init() {
	if File_google_cloud_billing_v1_cloud_billing_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BillingAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProjectBillingInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBillingAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBillingAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBillingAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBillingAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBillingAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProjectBillingInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProjectBillingInfoResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProjectBillingInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_billing_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateProjectBillingInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_billing_v1_cloud_billing_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_billing_v1_cloud_billing_proto_goTypes,
		DependencyIndexes: file_google_cloud_billing_v1_cloud_billing_proto_depIdxs,
		MessageInfos:      file_google_cloud_billing_v1_cloud_billing_proto_msgTypes,
	}.Build()
	File_google_cloud_billing_v1_cloud_billing_proto = out.File
	file_google_cloud_billing_v1_cloud_billing_proto_rawDesc = nil
	file_google_cloud_billing_v1_cloud_billing_proto_goTypes = nil
	file_google_cloud_billing_v1_cloud_billing_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudBillingClient is the client API for CloudBilling service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudBillingClient interface {
	// Gets information about a billing account. The current authenticated user
	// must be a [viewer of the billing
	// account](https://cloud.google.com/billing/docs/how-to/billing-access).
	GetBillingAccount(ctx context.Context, in *GetBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error)
	// Lists the billing accounts that the current authenticated user has
	// permission to
	// [view](https://cloud.google.com/billing/docs/how-to/billing-access).
	ListBillingAccounts(ctx context.Context, in *ListBillingAccountsRequest, opts ...grpc.CallOption) (*ListBillingAccountsResponse, error)
	// Updates a billing account's fields.
	// Currently the only field that can be edited is `display_name`.
	// The current authenticated user must have the `billing.accounts.update`
	// IAM permission, which is typically given to the
	// [administrator](https://cloud.google.com/billing/docs/how-to/billing-access)
	// of the billing account.
	UpdateBillingAccount(ctx context.Context, in *UpdateBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error)
	// Creates a billing account.
	// This method can only be used to create
	// [billing subaccounts](https://cloud.google.com/billing/docs/concepts)
	// by GCP resellers.
	// When creating a subaccount, the current authenticated user must have the
	// `billing.accounts.update` IAM permission on the master account, which is
	// typically given to billing account
	// [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
	// This method will return an error if the master account has not been
	// provisioned as a reseller account.
	CreateBillingAccount(ctx context.Context, in *CreateBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error)
	// Lists the projects associated with a billing account. The current
	// authenticated user must have the `billing.resourceAssociations.list` IAM
	// permission, which is often given to billing account
	// [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
	ListProjectBillingInfo(ctx context.Context, in *ListProjectBillingInfoRequest, opts ...grpc.CallOption) (*ListProjectBillingInfoResponse, error)
	// Gets the billing information for a project. The current authenticated user
	// must have [permission to view the
	// project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ).
	GetProjectBillingInfo(ctx context.Context, in *GetProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error)
	// Sets or updates the billing account associated with a project. You specify
	// the new billing account by setting the `billing_account_name` in the
	// `ProjectBillingInfo` resource to the resource name of a billing account.
	// Associating a project with an open billing account enables billing on the
	// project and allows charges for resource usage. If the project already had a
	// billing account, this method changes the billing account used for resource
	// usage charges.
	//
	// *Note:* Incurred charges that have not yet been reported in the transaction
	// history of the GCP Console might be billed to the new billing
	// account, even if the charge occurred before the new billing account was
	// assigned to the project.
	//
	// The current authenticated user must have ownership privileges for both the
	// [project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ) and the [billing
	// account](https://cloud.google.com/billing/docs/how-to/billing-access).
	//
	// You can disable billing on the project by setting the
	// `billing_account_name` field to empty. This action disassociates the
	// current billing account from the project. Any billable activity of your
	// in-use services will stop, and your application could stop functioning as
	// expected. Any unbilled charges to date will be billed to the previously
	// associated account. The current authenticated user must be either an owner
	// of the project or an owner of the billing account for the project.
	//
	// Note that associating a project with a *closed* billing account will have
	// much the same effect as disabling billing on the project: any paid
	// resources used by the project will be shut down. Thus, unless you wish to
	// disable billing, you should always call this method with the name of an
	// *open* billing account.
	UpdateProjectBillingInfo(ctx context.Context, in *UpdateProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error)
	// Gets the access control policy for a billing account.
	// The caller must have the `billing.accounts.getIamPolicy` permission on the
	// account, which is often given to billing account
	// [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy for a billing account. Replaces any existing
	// policy.
	// The caller must have the `billing.accounts.setIamPolicy` permission on the
	// account, which is often given to billing account
	// [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Tests the access control policy for a billing account. This method takes
	// the resource and a set of permissions as input and returns the subset of
	// the input permissions that the caller is allowed for that resource.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type cloudBillingClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudBillingClient(cc grpc.ClientConnInterface) CloudBillingClient {
	return &cloudBillingClient{cc}
}

func (c *cloudBillingClient) GetBillingAccount(ctx context.Context, in *GetBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error) {
	out := new(BillingAccount)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/GetBillingAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) ListBillingAccounts(ctx context.Context, in *ListBillingAccountsRequest, opts ...grpc.CallOption) (*ListBillingAccountsResponse, error) {
	out := new(ListBillingAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/ListBillingAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) UpdateBillingAccount(ctx context.Context, in *UpdateBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error) {
	out := new(BillingAccount)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/UpdateBillingAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) CreateBillingAccount(ctx context.Context, in *CreateBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error) {
	out := new(BillingAccount)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/CreateBillingAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) ListProjectBillingInfo(ctx context.Context, in *ListProjectBillingInfoRequest, opts ...grpc.CallOption) (*ListProjectBillingInfoResponse, error) {
	out := new(ListProjectBillingInfoResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/ListProjectBillingInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) GetProjectBillingInfo(ctx context.Context, in *GetProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error) {
	out := new(ProjectBillingInfo)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/GetProjectBillingInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) UpdateProjectBillingInfo(ctx context.Context, in *UpdateProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error) {
	out := new(ProjectBillingInfo)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/UpdateProjectBillingInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudBillingServer is the server API for CloudBilling service.
type CloudBillingServer interface {
	// Gets information about a billing account. The current authenticated user
	// must be a [viewer of the billing
	// account](https://cloud.google.com/billing/docs/how-to/billing-access).
	GetBillingAccount(context.Context, *GetBillingAccountRequest) (*BillingAccount, error)
	// Lists the billing accounts that the current authenticated user has
	// permission to
	// [view](https://cloud.google.com/billing/docs/how-to/billing-access).
	ListBillingAccounts(context.Context, *ListBillingAccountsRequest) (*ListBillingAccountsResponse, error)
	// Updates a billing account's fields.
	// Currently the only field that can be edited is `display_name`.
	// The current authenticated user must have the `billing.accounts.update`
	// IAM permission, which is typically given to the
	// [administrator](https://cloud.google.com/billing/docs/how-to/billing-access)
	// of the billing account.
	UpdateBillingAccount(context.Context, *UpdateBillingAccountRequest) (*BillingAccount, error)
	// Creates a billing account.
	// This method can only be used to create
	// [billing subaccounts](https://cloud.google.com/billing/docs/concepts)
	// by GCP resellers.
	// When creating a subaccount, the current authenticated user must have the
	// `billing.accounts.update` IAM permission on the master account, which is
	// typically given to billing account
	// [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
	// This method will return an error if the master account has not been
	// provisioned as a reseller account.
	CreateBillingAccount(context.Context, *CreateBillingAccountRequest) (*BillingAccount, error)
	// Lists the projects associated with a billing account. The current
	// authenticated user must have the `billing.resourceAssociations.list` IAM
	// permission, which is often given to billing account
	// [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
	ListProjectBillingInfo(context.Context, *ListProjectBillingInfoRequest) (*ListProjectBillingInfoResponse, error)
	// Gets the billing information for a project. The current authenticated user
	// must have [permission to view the
	// project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ).
	GetProjectBillingInfo(context.Context, *GetProjectBillingInfoRequest) (*ProjectBillingInfo, error)
	// Sets or updates the billing account associated with a project. You specify
	// the new billing account by setting the `billing_account_name` in the
	// `ProjectBillingInfo` resource to the resource name of a billing account.
	// Associating a project with an open billing account enables billing on the
	// project and allows charges for resource usage. If the project already had a
	// billing account, this method changes the billing account used for resource
	// usage charges.
	//
	// *Note:* Incurred charges that have not yet been reported in the transaction
	// history of the GCP Console might be billed to the new billing
	// account, even if the charge occurred before the new billing account was
	// assigned to the project.
	//
	// The current authenticated user must have ownership privileges for both the
	// [project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ) and the [billing
	// account](https://cloud.google.com/billing/docs/how-to/billing-access).
	//
	// You can disable billing on the project by setting the
	// `billing_account_name` field to empty. This action disassociates the
	// current billing account from the project. Any billable activity of your
	// in-use services will stop, and your application could stop functioning as
	// expected. Any unbilled charges to date will be billed to the previously
	// associated account. The current authenticated user must be either an owner
	// of the project or an owner of the billing account for the project.
	//
	// Note that associating a project with a *closed* billing account will have
	// much the same effect as disabling billing on the project: any paid
	// resources used by the project will be shut down. Thus, unless you wish to
	// disable billing, you should always call this method with the name of an
	// *open* billing account.
	UpdateProjectBillingInfo(context.Context, *UpdateProjectBillingInfoRequest) (*ProjectBillingInfo, error)
	// Gets the access control policy for a billing account.
	// The caller must have the `billing.accounts.getIamPolicy` permission on the
	// account, which is often given to billing account
	// [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy for a billing account. Replaces any existing
	// policy.
	// The caller must have the `billing.accounts.setIamPolicy` permission on the
	// account, which is often given to billing account
	// [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Tests the access control policy for a billing account. This method takes
	// the resource and a set of permissions as input and returns the subset of
	// the input permissions that the caller is allowed for that resource.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedCloudBillingServer can be embedded to have forward compatible implementations.
type UnimplementedCloudBillingServer struct {
}

func (*UnimplementedCloudBillingServer) GetBillingAccount(context.Context, *GetBillingAccountRequest) (*BillingAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBillingAccount not implemented")
}
func (*UnimplementedCloudBillingServer) ListBillingAccounts(context.Context, *ListBillingAccountsRequest) (*ListBillingAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBillingAccounts not implemented")
}
func (*UnimplementedCloudBillingServer) UpdateBillingAccount(context.Context, *UpdateBillingAccountRequest) (*BillingAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBillingAccount not implemented")
}
func (*UnimplementedCloudBillingServer) CreateBillingAccount(context.Context, *CreateBillingAccountRequest) (*BillingAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBillingAccount not implemented")
}
func (*UnimplementedCloudBillingServer) ListProjectBillingInfo(context.Context, *ListProjectBillingInfoRequest) (*ListProjectBillingInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProjectBillingInfo not implemented")
}
func (*UnimplementedCloudBillingServer) GetProjectBillingInfo(context.Context, *GetProjectBillingInfoRequest) (*ProjectBillingInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProjectBillingInfo not implemented")
}
func (*UnimplementedCloudBillingServer) UpdateProjectBillingInfo(context.Context, *UpdateProjectBillingInfoRequest) (*ProjectBillingInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProjectBillingInfo not implemented")
}
func (*UnimplementedCloudBillingServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedCloudBillingServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedCloudBillingServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterCloudBillingServer(s *grpc.Server, srv CloudBillingServer) {
	s.RegisterService(&_CloudBilling_serviceDesc, srv)
}

func _CloudBilling_GetBillingAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBillingAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).GetBillingAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/GetBillingAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).GetBillingAccount(ctx, req.(*GetBillingAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_ListBillingAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBillingAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).ListBillingAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/ListBillingAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).ListBillingAccounts(ctx, req.(*ListBillingAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_UpdateBillingAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBillingAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).UpdateBillingAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/UpdateBillingAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).UpdateBillingAccount(ctx, req.(*UpdateBillingAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_CreateBillingAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBillingAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).CreateBillingAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/CreateBillingAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).CreateBillingAccount(ctx, req.(*CreateBillingAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_ListProjectBillingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProjectBillingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).ListProjectBillingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/ListProjectBillingInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).ListProjectBillingInfo(ctx, req.(*ListProjectBillingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_GetProjectBillingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectBillingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).GetProjectBillingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/GetProjectBillingInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).GetProjectBillingInfo(ctx, req.(*GetProjectBillingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_UpdateProjectBillingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProjectBillingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).UpdateProjectBillingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/UpdateProjectBillingInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).UpdateProjectBillingInfo(ctx, req.(*UpdateProjectBillingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudBilling_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.billing.v1.CloudBilling",
	HandlerType: (*CloudBillingServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBillingAccount",
			Handler:    _CloudBilling_GetBillingAccount_Handler,
		},
		{
			MethodName: "ListBillingAccounts",
			Handler:    _CloudBilling_ListBillingAccounts_Handler,
		},
		{
			MethodName: "UpdateBillingAccount",
			Handler:    _CloudBilling_UpdateBillingAccount_Handler,
		},
		{
			MethodName: "CreateBillingAccount",
			Handler:    _CloudBilling_CreateBillingAccount_Handler,
		},
		{
			MethodName: "ListProjectBillingInfo",
			Handler:    _CloudBilling_ListProjectBillingInfo_Handler,
		},
		{
			MethodName: "GetProjectBillingInfo",
			Handler:    _CloudBilling_GetProjectBillingInfo_Handler,
		},
		{
			MethodName: "UpdateProjectBillingInfo",
			Handler:    _CloudBilling_UpdateProjectBillingInfo_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _CloudBilling_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _CloudBilling_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _CloudBilling_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/billing/v1/cloud_billing.proto",
}
