---
title: pixi workspace export conda-explicit-spec
---
<!--- This file is autogenerated. Do not edit manually! -->
# [pixi](../../../pixi.md) [workspace](../../workspace.md) [export](../export.md) conda-explicit-spec

Export workspace environment to a conda explicit specification file

--8<-- "docs/reference/cli/pixi/workspace/export/conda-explicit-spec_extender:description"

## Usage
```
pixi workspace export conda-explicit-spec [OPTIONS] <OUTPUT_DIR>
```

## Arguments
- <a id="arg-<OUTPUT_DIR>" href="#arg-<OUTPUT_DIR>">`<OUTPUT_DIR>`</a>
:  Output directory for rendered explicit environment spec files
<br>**required**: `true`

## Options
- <a id="arg---environment" href="#arg---environment">`--environment (-e) <ENVIRONMENT>`</a>
:  The environments to render. Can be repeated for multiple environments
<br>May be provided more than once.
- <a id="arg---platform" href="#arg---platform">`--platform (-p) <PLATFORM>`</a>
:  The platform to render. Can be repeated for multiple platforms. Defaults to all platforms available for selected environments
<br>May be provided more than once.
- <a id="arg---ignore-pypi-errors" href="#arg---ignore-pypi-errors">`--ignore-pypi-errors`</a>
:  PyPI dependencies are not supported in the conda explicit spec file
<br>**default**: `false`
- <a id="arg---ignore-source-errors" href="#arg---ignore-source-errors">`--ignore-source-errors`</a>
:  Source dependencies are not supported in the conda explicit spec file
<br>**default**: `false`

## Config Options
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---pinning-strategy" href="#arg---pinning-strategy">`--pinning-strategy <PINNING_STRATEGY>`</a>
:  Set pinning strategy
<br>**options**: `semver`, `minor`, `major`, `latest-up`, `exact-version`, `no-pin`
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---run-post-link-scripts" href="#arg---run-post-link-scripts">`--run-post-link-scripts`</a>
:  Run post-link scripts (insecure)
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---tls-root-certs" href="#arg---tls-root-certs">`--tls-root-certs <TLS_ROOT_CERTS>`</a>
:  Which TLS root certificates to use: 'webpki' (bundled Mozilla roots), 'native' (system store), or 'all' (both)
<br>**env**: `PIXI_TLS_ROOT_CERTS`
- <a id="arg---use-environment-activation-cache" href="#arg---use-environment-activation-cache">`--use-environment-activation-cache`</a>
:  Use environment activation cache (experimental)

## Update Options
- <a id="arg---frozen" href="#arg---frozen">`--frozen`</a>
:  Install the environment as defined in the lockfile, doesn't update lockfile if it isn't up-to-date with the manifest file
<br>**env**: `PIXI_FROZEN`
- <a id="arg---locked" href="#arg---locked">`--locked`</a>
:  Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn't up-to-date with the manifest file
<br>**env**: `PIXI_LOCKED`
- <a id="arg---no-install" href="#arg---no-install">`--no-install`</a>
:  Don't modify the environment, only modify the lock-file

## Global Options
- <a id="arg---manifest-path" href="#arg---manifest-path">`--manifest-path (-m) <MANIFEST_PATH>`</a>
:  The path to `pixi.toml`, `pyproject.toml`, or the workspace directory

--8<-- "docs/reference/cli/pixi/workspace/export/conda-explicit-spec_extender:example"
