/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.trex.classic;

import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.reader.GrammarReader;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.IgnoreState;
import com.sun.msv.reader.RunAwayExpressionChecker;
import com.sun.msv.reader.State;
import com.sun.msv.reader.TerminalState;
import com.sun.msv.reader.datatype.DataTypeVocabulary;
import com.sun.msv.reader.trex.IncludePatternState;
import com.sun.msv.reader.trex.RootState;
import com.sun.msv.reader.trex.TREXBaseReader;
import com.sun.msv.reader.trex.TREXSequencedStringChecker;
import com.sun.msv.reader.trex.classic.ConcurState;
import com.sun.msv.reader.trex.classic.DataState;
import com.sun.msv.reader.trex.classic.DefineState;
import com.sun.msv.reader.trex.classic.StringState;
import com.sun.msv.util.StartTagInfo;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.InputSource;

public class TREXGrammarReader
extends TREXBaseReader {
    protected String currentGrammarURI;
    public static final String TREXNamespace = "http://www.thaiopensource.com/trex";
    private boolean issueObsoletedXMLSchemaNamespace = false;

    public static TREXGrammar parse(String string, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController) {
        TREXGrammarReader tREXGrammarReader = new TREXGrammarReader(grammarReaderController, sAXParserFactory, new ExpressionPool());
        tREXGrammarReader.parse(string);
        return tREXGrammarReader.getResult();
    }

    public static TREXGrammar parse(InputSource inputSource, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController) {
        TREXGrammarReader tREXGrammarReader = new TREXGrammarReader(grammarReaderController, sAXParserFactory, new ExpressionPool());
        tREXGrammarReader.parse(inputSource);
        return tREXGrammarReader.getResult();
    }

    public TREXGrammarReader(GrammarReaderController grammarReaderController) {
        this(grammarReaderController, GrammarReader.createParserFactory(), new ExpressionPool());
    }

    public TREXGrammarReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, ExpressionPool expressionPool) {
        this(grammarReaderController, sAXParserFactory, new StateFactory(), expressionPool);
    }

    public TREXGrammarReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, StateFactory stateFactory, ExpressionPool expressionPool) {
        super(grammarReaderController, sAXParserFactory, expressionPool, stateFactory, new RootState());
    }

    protected String localizeMessage(String string, Object[] objectArray) {
        String string2;
        try {
            string2 = ResourceBundle.getBundle("com.sun.msv.reader.trex.classic.Messages").getString(string);
        }
        catch (Exception exception) {
            return super.localizeMessage(string, objectArray);
        }
        return MessageFormat.format(string2, objectArray);
    }

    protected TREXGrammar getGrammar() {
        return this.grammar;
    }

    protected boolean isGrammarElement(StartTagInfo startTagInfo) {
        if (this.currentGrammarURI == null) {
            if (startTagInfo.namespaceURI.equals(TREXNamespace)) {
                this.currentGrammarURI = TREXNamespace;
                return true;
            }
            if (startTagInfo.namespaceURI.equals("")) {
                this.currentGrammarURI = "";
                return true;
            }
            return false;
        }
        if (this.currentGrammarURI.equals(startTagInfo.namespaceURI)) {
            return true;
        }
        return startTagInfo.containsAttribute(TREXNamespace, "role");
    }

    protected StateFactory getStateFactory() {
        return (StateFactory)this.sfactory;
    }

    private String mapNamespace(String string) {
        if (string.equals("http://www.w3.org/2000/10/XMLSchema") || string.equals("http://www.w3.org/2000/10/XMLSchema-datatypes")) {
            if (!this.issueObsoletedXMLSchemaNamespace) {
                this.reportWarning("TREXGrammarReader.Warning.ObsoletedXMLSchemaNamespace", string);
            }
            this.issueObsoletedXMLSchemaNamespace = true;
            return "http://www.w3.org/2001/XMLSchema-datatypes";
        }
        return string;
    }

    public State createExpressionChildState(State state, StartTagInfo startTagInfo) {
        if (startTagInfo.localName.equals("concur")) {
            return this.getStateFactory().concur(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("anyString")) {
            return this.getStateFactory().anyString(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("string")) {
            return this.getStateFactory().string(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("data")) {
            return this.getStateFactory().data(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("include")) {
            return this.getStateFactory().includePattern(state, startTagInfo);
        }
        String string = startTagInfo.getAttribute(TREXNamespace, "role");
        if ("datatype".equals(string)) {
            String string2 = this.mapNamespace(startTagInfo.namespaceURI);
            DataTypeVocabulary dataTypeVocabulary = this.grammar.dataTypes.get(string2);
            if (dataTypeVocabulary == null) {
                this.reportError("TREXGrammarReader.UnknownDataTypeVocabulary", (Object)startTagInfo.namespaceURI);
                this.grammar.dataTypes.put(startTagInfo.namespaceURI, new UndefinedDataTypeVocabulary());
                return new IgnoreState();
            }
            return dataTypeVocabulary.createTopLevelReaderState(startTagInfo);
        }
        return super.createExpressionChildState(state, startTagInfo);
    }

    public Datatype resolveDataType(String string) {
        String[] stringArray = this.splitQName(string);
        if (stringArray == null) {
            this.reportError("TREXGrammarReader.UndeclaredPrefix", (Object)string);
            return StringType.theInstance;
        }
        stringArray[0] = this.mapNamespace(stringArray[0]);
        DataTypeVocabulary dataTypeVocabulary = this.grammar.dataTypes.get(stringArray[0]);
        if (dataTypeVocabulary == null) {
            this.reportError("TREXGrammarReader.UnknownDataTypeVocabulary", (Object)stringArray[0]);
            this.grammar.dataTypes.put(stringArray[0], new UndefinedDataTypeVocabulary());
        } else {
            try {
                return dataTypeVocabulary.getType(stringArray[1]);
            }
            catch (DatatypeException datatypeException) {
                this.reportError("GrammarReader.UndefinedDataType", (Object)string);
            }
        }
        return StringType.theInstance;
    }

    public void wrapUp() {
        RunAwayExpressionChecker.check(this, this.grammar);
        if (!this.hadError) {
            this.grammar.visit(new TREXSequencedStringChecker(this, false));
        }
    }

    private static class UndefinedDataTypeVocabulary
    implements DataTypeVocabulary {
        private UndefinedDataTypeVocabulary() {
        }

        public State createTopLevelReaderState(StartTagInfo startTagInfo) {
            return new IgnoreState();
        }

        public Datatype getType(String string) {
            return StringType.theInstance;
        }
    }

    public static class StateFactory
    extends TREXBaseReader.StateFactory {
        public State concur(State state, StartTagInfo startTagInfo) {
            return new ConcurState();
        }

        public State anyString(State state, StartTagInfo startTagInfo) {
            return new TerminalState(Expression.anyString);
        }

        public State string(State state, StartTagInfo startTagInfo) {
            return new StringState();
        }

        public State data(State state, StartTagInfo startTagInfo) {
            return new DataState();
        }

        public State define(State state, StartTagInfo startTagInfo) {
            return new DefineState();
        }

        public State includePattern(State state, StartTagInfo startTagInfo) {
            return new IncludePatternState();
        }
    }
}

