/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.controller;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.dbuml.base.controller.ActionsInterface;
import org.dbuml.base.controller.FileOutput;
import org.dbuml.base.controller.Util;
import org.dbuml.base.controller.ui.EntitiesChooserDlg;
import org.dbuml.base.controller.ui.ResultSetTable;
import org.dbuml.base.database.DBMetadata;
import org.dbuml.base.database.DBMetadataCache;
import org.dbuml.base.database.GenericUpdateTransaction;
import org.dbuml.base.database.UpdateTransaction;
import org.dbuml.base.factory.Factory;
import org.dbuml.base.i18n.Translator;
import org.dbuml.base.model.DBElement;
import org.dbuml.base.model.DBModelFacade;
import org.dbuml.base.model.Database;
import org.dbuml.base.model.Schema;
import org.dbuml.base.transform.DBMetadataToDBUML;
import org.dbuml.base.transform.DBUMLToSQL;

public class GenericActions
implements ActionsInterface {
    private static final String GENSQL_FAILURE_TITLE = "GENSQL_FAILURE_TITLE";
    private static final String DB_ASSOCIATION_MUST_EXIST = "DB_ASSOCIATION_MUST_EXIST";
    private static final String UNFOUND_FACTORY = "UNFOUND_FACTORY";
    private static final String UNABLE_TO_LOAD_FACTORY = "UNABLE_TO_LOAD_FACTORY";
    private static final String IMPORT_FAILURE_TITLE = "IMPORT_FAILURE_TITLE";
    private static final String DB_NOT_CONNECTED = "DB_NOT_CONNECTED";
    private static final String METADATA_RETRIEVAL_PROBLEM = "METADATA_RETRIEVAL_PROBLEM";

    public void connect(Object selectedItem) {
        Database database = DBModelFacade.getInstance().getOwningDatabase(selectedItem);
        Factory factory = Factory.getFactory(database.getProperty("Factory"));
        if (factory != null) {
            DBMetadata dbmeta = DBMetadataCache.getDBMetadata(database);
            if (dbmeta == null) {
                try {
                    dbmeta = factory.newDBMetadata(database, factory.getConnectionFactory().getConnection(database));
                    DBMetadataCache.addDBMetadata(dbmeta);
                }
                catch (Exception e) {
                    Util.showMessageDialog(null, Translator.getInstance().localize("CONNECT_FAILURE_MSG", database.getName(), e.getMessage()), Translator.getInstance().localize("CONNECT_FAILURE_TITLE"), 0);
                }
            } else {
                try {
                    factory.getConnectionFactory().closeConnection((Connection)dbmeta.getConnection());
                    DBMetadataCache.removeDBMetadata(dbmeta);
                }
                catch (Exception e) {
                    Util.showMessageDialog(null, Translator.getInstance().localize("DISCONNECT_FAILURE_MSG", database.getName(), e.getMessage()), Translator.getInstance().localize("DISCONNECT_FAILURE_TITLE"), 0);
                }
            }
        } else {
            Util.showMessageDialog(null, Translator.getInstance().localize("DB_FACTORY_NOTFOUND", database.getProperty("Factory")), Translator.getInstance().localize("CONNECT_FAILURE_TITLE"), 0);
        }
    }

    public void connectRegistry(Object selectedItem) {
    }

    public String generateSQL(Object handle, String sDialect) {
        String retVal = null;
        DBElement dbe = DBModelFacade.getInstance().getDBElement(handle);
        if (dbe == null) {
            retVal = Translator.getInstance().localize(GENSQL_FAILURE_TITLE) + Translator.getInstance().localize("NOT_DBUML");
        } else {
            Database database = DBModelFacade.getInstance().getOwningDatabase(handle);
            if (database == null) {
                retVal = Translator.getInstance().localize(GENSQL_FAILURE_TITLE) + Translator.getInstance().localize(DB_ASSOCIATION_MUST_EXIST);
            } else {
                dbe.setOwningDatabase(database);
                String sFactName = database.getProperty("Factory");
                if (sFactName == null) {
                    retVal = Translator.getInstance().localize(GENSQL_FAILURE_TITLE) + Translator.getInstance().localize(UNFOUND_FACTORY);
                } else {
                    Factory factory = Factory.getFactory(sFactName);
                    if (factory == null) {
                        retVal = Translator.getInstance().localize(GENSQL_FAILURE_TITLE) + Translator.getInstance().localize(UNABLE_TO_LOAD_FACTORY);
                    } else {
                        DBUMLToSQL trans = factory.getDBUMLToSQL();
                        retVal = trans.genCreateSQL(dbe, DBModelFacade.getInstance().getDBNamespace(handle), sDialect);
                    }
                }
            }
        }
        return retVal;
    }

    public String generateSQLDeep(Object handle, String sDialect) {
        String sSQL = this.generateSQL(handle, sDialect);
        for (Object child : DBModelFacade.getInstance().getChildrenForUpdate(handle)) {
            sSQL = sSQL + this.generateSQLDeep(child, sDialect);
        }
        return sSQL;
    }

    public void browseInstances(Object selectedItem) {
        Database database = DBModelFacade.getInstance().getOwningDatabase(selectedItem);
        if (database == null) {
            Util.showMessageDialog(null, Translator.getInstance().localize(DB_ASSOCIATION_MUST_EXIST), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
        } else {
            DBMetadata dbmd = DBMetadataCache.getDBMetadata(database);
            if (dbmd == null) {
                Util.showMessageDialog(null, Translator.getInstance().localize(DB_NOT_CONNECTED, database.getName()), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
            } else {
                String sSelect = "SELECT * FROM ";
                String sNS = DBModelFacade.getInstance().getDBNamespace(selectedItem);
                if (sNS != "") {
                    sNS = database.fixName(sNS);
                    sSelect = sSelect + sNS + ".";
                }
                String tableName = DBModelFacade.getInstance().getModelElementName(selectedItem);
                sSelect = sSelect + database.fixName(tableName);
                new ResultSetTable((Connection)dbmd.getConnection(), database, sSelect);
            }
        }
    }

    private static boolean validDB(Database database) {
        boolean status = true;
        if (database == null) {
            String string = Translator.getInstance().localize(DB_ASSOCIATION_MUST_EXIST);
            Translator.getInstance();
            Util.showMessageDialog(null, string, Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
            status = false;
        }
        return status;
    }

    private static boolean connected(DBMetadata dbmd, Database database) {
        boolean status = true;
        if (dbmd == null) {
            Util.showMessageDialog(null, Translator.getInstance().localize(DB_NOT_CONNECTED, database.getName()), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
            status = false;
        }
        return status;
    }

    public void importSchemas(Object selectedItem, String[] choices, boolean batch) {
        DBMetadata dbmd;
        Database database = DBModelFacade.getInstance().getOwningDatabase(selectedItem);
        if (GenericActions.validDB(database) && GenericActions.connected(dbmd = DBMetadataCache.getDBMetadata(database), database)) {
            if (!batch) {
                Object[] oSchemas = null;
                try {
                    oSchemas = dbmd.getSchemas();
                }
                catch (SQLException e) {
                    Util.showMessageDialog(null, Translator.getInstance().localize(METADATA_RETRIEVAL_PROBLEM, database.getName(), e.getMessage()), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
                }
                if (oSchemas != null && oSchemas.length == 0) {
                    Util.showMessageDialog(null, Translator.getInstance().localize("SCHEMAS_NOT_DEFINED", database.getName()), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
                } else {
                    choices = EntitiesChooserDlg.selectData(Translator.getInstance().localize("CHOOSE_SCHEMA"), (String[])oSchemas);
                }
            }
            if (choices != null && choices.length > 0) {
                String sFactName = database.getProperty("Factory");
                if (sFactName == null) {
                    Util.showMessageDialog(null, Translator.getInstance().localize(UNFOUND_FACTORY), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
                } else {
                    Factory factory = Factory.getFactory(sFactName);
                    if (factory == null) {
                        Util.showMessageDialog(null, Translator.getInstance().localize(UNABLE_TO_LOAD_FACTORY, sFactName), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
                    } else {
                        DBMetadataToDBUML trans = factory.getDBMetadataToDBUML();
                        for (int i = 0; i < choices.length; ++i) {
                            Object obj = DBModelFacade.getInstance().findChild(choices[i], database.getModelElement());
                            if (obj == null) {
                                trans.schema(database.getModelElement(), choices[i], dbmd);
                                continue;
                            }
                            trans.updateSchema(obj);
                        }
                    }
                }
            }
        }
    }

    private static String[] getChoices(Database database, Schema schema, DBMetadata dbmd, boolean forView) {
        String[] selected = null;
        Object[] oTables = null;
        String noDataLabel = "NO_TABLE_FOR_SCHEMA";
        String type = "IMPORT_TABLES";
        if (forView) {
            noDataLabel = "NO_VIEW_FOR_SCHEMA";
            type = "IMPORT_VIEWS";
        }
        try {
            oTables = forView ? dbmd.getViewsInSchema(schema.getName()) : dbmd.getTablesInSchema(schema.getName());
        }
        catch (SQLException e) {
            Util.showMessageDialog(null, Translator.getInstance().localize(METADATA_RETRIEVAL_PROBLEM, database.getName(), e.getMessage()), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
        }
        if (oTables != null && oTables.length == 0) {
            Util.showMessageDialog(null, Translator.getInstance().localize(noDataLabel, schema.getName(), database.getName()), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
            selected = null;
        } else {
            selected = EntitiesChooserDlg.selectData(Translator.getInstance().localize(type), (String[])oTables);
        }
        return selected;
    }

    private static void importTables(Object schemaModel, String[] choices, boolean forView, boolean batch) {
        DBMetadata dbmd;
        Schema schema = DBModelFacade.getInstance().getSchema(schemaModel);
        Database database = DBModelFacade.getInstance().getOwningDatabase(schema.getModelElement());
        if (GenericActions.validDB(database) && GenericActions.connected(dbmd = DBMetadataCache.getDBMetadata(database), database)) {
            if (!batch) {
                choices = GenericActions.getChoices(database, schema, dbmd, forView);
            }
            if (choices != null && choices.length > 0) {
                String sFactName = database.getProperty("Factory");
                if (sFactName == null) {
                    Util.showMessageDialog(null, Translator.getInstance().localize(UNFOUND_FACTORY), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
                } else {
                    Factory factory = Factory.getFactory(sFactName);
                    if (factory == null) {
                        Util.showMessageDialog(null, Translator.getInstance().localize(UNABLE_TO_LOAD_FACTORY, sFactName), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
                    } else {
                        DBMetadataToDBUML trans = factory.getDBMetadataToDBUML();
                        for (int i = 0; i < choices.length; ++i) {
                            try {
                                Object objTable = DBModelFacade.getInstance().lookupIn(schema.getModelElement(), choices[i]);
                                if (forView) {
                                    Object objView = objTable;
                                    if (objView == null) {
                                        trans.view(choices[i], schema, dbmd);
                                        continue;
                                    }
                                    trans.updateView(objView, schema.getName(), dbmd);
                                    continue;
                                }
                                if (objTable == null) {
                                    trans.table(choices[i], schema, dbmd);
                                    continue;
                                }
                                trans.updateTable(objTable, schema.getName(), dbmd);
                                continue;
                            }
                            catch (SQLException e) {
                                Util.showMessageDialog(null, Translator.getInstance().localize(METADATA_RETRIEVAL_PROBLEM, database.getName(), e.getMessage()), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
                                break;
                            }
                        }
                    }
                }
            }
        }
    }

    public void importTablesFromCatalog(Object schemaModel, String[] choices, boolean batch) {
        GenericActions.importTables(schemaModel, choices, false, batch);
    }

    public void importViews(Object schemaModel, String[] choices, boolean batch) {
        GenericActions.importTables(schemaModel, choices, true, batch);
    }

    public void importAttributeTypes(Object selectedItem) {
        DBMetadata dbmd;
        Database database = DBModelFacade.getInstance().getOwningDatabase(selectedItem);
        if (GenericActions.validDB(database) && GenericActions.connected(dbmd = DBMetadataCache.getDBMetadata(database), database)) {
            String[] attrNames = null;
            try {
                attrNames = dbmd.getNewTypes();
            }
            catch (SQLException e) {
                Util.showMessageDialog(null, Translator.getInstance().localize(METADATA_RETRIEVAL_PROBLEM, database.getName(), e.getMessage()), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
            }
            if (attrNames != null && attrNames.length == 0) {
                Util.showMessageDialog(null, Translator.getInstance().localize("NO_ATTR_TYPES_IN_DB", database.getName()), Translator.getInstance().localize(IMPORT_FAILURE_TITLE), 0);
            } else {
                String[] choices = EntitiesChooserDlg.selectData(Translator.getInstance().localize("IMPORT_ATTR_TYPES"), attrNames);
                if (choices.length > 0) {
                    DBModelFacade.getInstance().addTypes(choices, database.getDefaultTypesPkgName());
                }
            }
        }
    }

    public void importDatabases(Object selectedItem, String[] choices, boolean batch) {
        Util.showMessageDialog(null, Translator.getInstance().localize("IMPORT_DATABASES"), Translator.getInstance().localize("NOT_IMPLEMENTED"), 0);
    }

    public void updateCatalog(Object selectedItem, boolean update) {
        try {
            if (update) {
                this.updateCatalogUpdate(selectedItem);
            } else {
                this.updateCatalogReplace(selectedItem);
            }
        }
        catch (Exception e) {
            Util.showMessageDialog(null, e.getMessage(), Translator.getInstance().localize("UPDATE_CATALOG_PROBLEM"), 0);
        }
    }

    public void updateCatalogUpdate(Object selectedItem) throws Exception {
        throw new Exception("CatalogUpdate is not yet implemented!");
    }

    public void updateCatalogReplace(Object selectedItem) throws SQLException {
        Database database = DBModelFacade.getInstance().getOwningDatabase(selectedItem);
        DBMetadata dbmd = DBMetadataCache.getDBMetadata(database);
        GenericUpdateTransaction uTrans = new GenericUpdateTransaction((Connection)dbmd.getConnection());
        String sSQL = this.generateSQLDeep(selectedItem, "dropSQLViews");
        sSQL = sSQL + this.generateSQLDeep(selectedItem, "dropSQLTables");
        if (!(sSQL = sSQL + this.generateSQLDeep(selectedItem, "dropSQLSchema")).equals("")) {
            try {
                ((UpdateTransaction)uTrans).executeUpdate(sSQL);
            }
            catch (SQLException e) {
                ((UpdateTransaction)uTrans).rollback();
                throw e;
            }
        }
        sSQL = this.generateSQLDeep(selectedItem, "createSQLSchema");
        sSQL = sSQL + this.generateSQLDeep(selectedItem, "createSQLTables");
        sSQL = sSQL + this.generateSQLDeep(selectedItem, "createSQLViews");
        sSQL = sSQL + this.generateSQLDeep(selectedItem, "createAlterConstraintsSQL");
        if (!(sSQL = sSQL + this.generateSQLDeep(selectedItem, "createAlterFKConstraintsSQL")).equals("")) {
            try {
                ((UpdateTransaction)uTrans).executeUpdate(sSQL);
            }
            catch (SQLException e) {
                ((UpdateTransaction)uTrans).rollback();
                throw e;
            }
            ((UpdateTransaction)uTrans).commit();
        }
    }

    public void generateSource(Object selectedItem, File file) {
        FileOutput fo = new FileOutput("Generate Source", file);
        String sSQL = this.generateSource(selectedItem, true, true);
        try {
            fo.saveData(sSQL);
            fo.setSize(300, 500);
            fo.setVisible(true);
            fo.addText(sSQL);
        }
        catch (Exception e) {
            Util.showMessageDialog(null, e.getMessage(), Translator.getInstance().localize("GENERATE_SOURCE_PROBLEM"), 0);
        }
    }

    public String generateSource(Object selectedItem, boolean includeDrop, boolean includeAlters) {
        StringBuffer buf = new StringBuffer(256);
        if (includeDrop) {
            if (DBModelFacade.getInstance().representsASchema(selectedItem) && !DBModelFacade.getInstance().isDefaultSchema(selectedItem)) {
                buf.append(this.generateSQLDeep(selectedItem, "dropSQLSchema"));
            } else {
                buf.append(this.generateSQLDeep(selectedItem, "dropSQLViews"));
                buf.append(this.generateSQLDeep(selectedItem, "dropSQLTables"));
            }
        }
        buf.append(this.generateSQLDeep(selectedItem, "createSQLSchema"));
        buf.append(this.generateSQLDeep(selectedItem, "createSQLTables"));
        buf.append(this.generateSQLDeep(selectedItem, "createSQLViews"));
        if (includeAlters) {
            buf.append(this.generateSQLDeep(selectedItem, "createAlterConstraintsSQL"));
            buf.append(this.generateSQLDeep(selectedItem, "createAlterFKConstraintsSQL"));
        }
        return buf.toString();
    }
}

