package sts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssumeRoleWithOIDC invokes the sts.AssumeRoleWithOIDC API synchronously
func (client *Client) AssumeRoleWithOIDC(request *AssumeRoleWithOIDCRequest) (response *AssumeRoleWithOIDCResponse, err error) {
	response = CreateAssumeRoleWithOIDCResponse()
	err = client.DoAction(request, response)
	return
}

// AssumeRoleWithOIDCWithChan invokes the sts.AssumeRoleWithOIDC API asynchronously
func (client *Client) AssumeRoleWithOIDCWithChan(request *AssumeRoleWithOIDCRequest) (<-chan *AssumeRoleWithOIDCResponse, <-chan error) {
	responseChan := make(chan *AssumeRoleWithOIDCResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssumeRoleWithOIDC(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssumeRoleWithOIDCWithCallback invokes the sts.AssumeRoleWithOIDC API asynchronously
func (client *Client) AssumeRoleWithOIDCWithCallback(request *AssumeRoleWithOIDCRequest, callback func(response *AssumeRoleWithOIDCResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssumeRoleWithOIDCResponse
		var err error
		defer close(result)
		response, err = client.AssumeRoleWithOIDC(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssumeRoleWithOIDCRequest is the request struct for api AssumeRoleWithOIDC
type AssumeRoleWithOIDCRequest struct {
	*requests.RpcRequest
	RoleArn         string           `position:"Query" name:"RoleArn"`
	RoleSessionName string           `position:"Query" name:"RoleSessionName"`
	OIDCToken       string           `position:"Query" name:"OIDCToken"`
	DurationSeconds requests.Integer `position:"Query" name:"DurationSeconds"`
	OIDCProviderArn string           `position:"Query" name:"OIDCProviderArn"`
	Policy          string           `position:"Query" name:"Policy"`
}

// AssumeRoleWithOIDCResponse is the response struct for api AssumeRoleWithOIDC
type AssumeRoleWithOIDCResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	OIDCTokenInfo   OIDCTokenInfo   `json:"OIDCTokenInfo" xml:"OIDCTokenInfo"`
	AssumedRoleUser AssumedRoleUser `json:"AssumedRoleUser" xml:"AssumedRoleUser"`
	Credentials     Credentials     `json:"Credentials" xml:"Credentials"`
}

// CreateAssumeRoleWithOIDCRequest creates a request to invoke AssumeRoleWithOIDC API
func CreateAssumeRoleWithOIDCRequest() (request *AssumeRoleWithOIDCRequest) {
	request = &AssumeRoleWithOIDCRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sts", "2015-04-01", "AssumeRoleWithOIDC", "", "")
	request.Method = requests.POST
	return
}

// CreateAssumeRoleWithOIDCResponse creates a response to parse from AssumeRoleWithOIDC response
func CreateAssumeRoleWithOIDCResponse() (response *AssumeRoleWithOIDCResponse) {
	response = &AssumeRoleWithOIDCResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
