package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIngress invokes the sae.DeleteIngress API synchronously
func (client *Client) DeleteIngress(request *DeleteIngressRequest) (response *DeleteIngressResponse, err error) {
	response = CreateDeleteIngressResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIngressWithChan invokes the sae.DeleteIngress API asynchronously
func (client *Client) DeleteIngressWithChan(request *DeleteIngressRequest) (<-chan *DeleteIngressResponse, <-chan error) {
	responseChan := make(chan *DeleteIngressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIngress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIngressWithCallback invokes the sae.DeleteIngress API asynchronously
func (client *Client) DeleteIngressWithCallback(request *DeleteIngressRequest, callback func(response *DeleteIngressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIngressResponse
		var err error
		defer close(result)
		response, err = client.DeleteIngress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIngressRequest is the request struct for api DeleteIngress
type DeleteIngressRequest struct {
	*requests.RoaRequest
	IngressId requests.Integer `position:"Query" name:"IngressId"`
}

// DeleteIngressResponse is the response struct for api DeleteIngress
type DeleteIngressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteIngressRequest creates a request to invoke DeleteIngress API
func CreateDeleteIngressRequest() (request *DeleteIngressRequest) {
	request = &DeleteIngressRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DeleteIngress", "/pop/v1/sam/ingress/Ingress", "serverless", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteIngressResponse creates a response to parse from DeleteIngress response
func CreateDeleteIngressResponse() (response *DeleteIngressResponse) {
	response = &DeleteIngressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
