package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableHBaseueBackup invokes the hbase.EnableHBaseueBackup API synchronously
func (client *Client) EnableHBaseueBackup(request *EnableHBaseueBackupRequest) (response *EnableHBaseueBackupResponse, err error) {
	response = CreateEnableHBaseueBackupResponse()
	err = client.DoAction(request, response)
	return
}

// EnableHBaseueBackupWithChan invokes the hbase.EnableHBaseueBackup API asynchronously
func (client *Client) EnableHBaseueBackupWithChan(request *EnableHBaseueBackupRequest) (<-chan *EnableHBaseueBackupResponse, <-chan error) {
	responseChan := make(chan *EnableHBaseueBackupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableHBaseueBackup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableHBaseueBackupWithCallback invokes the hbase.EnableHBaseueBackup API asynchronously
func (client *Client) EnableHBaseueBackupWithCallback(request *EnableHBaseueBackupRequest, callback func(response *EnableHBaseueBackupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableHBaseueBackupResponse
		var err error
		defer close(result)
		response, err = client.EnableHBaseueBackup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableHBaseueBackupRequest is the request struct for api EnableHBaseueBackup
type EnableHBaseueBackupRequest struct {
	*requests.RpcRequest
	ClientToken      string           `position:"Query" name:"ClientToken"`
	HbaseueClusterId string           `position:"Query" name:"HbaseueClusterId"`
	ColdStorageSize  requests.Integer `position:"Query" name:"ColdStorageSize"`
	NodeCount        requests.Integer `position:"Query" name:"NodeCount"`
}

// EnableHBaseueBackupResponse is the response struct for api EnableHBaseueBackup
type EnableHBaseueBackupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ClusterId string `json:"ClusterId" xml:"ClusterId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateEnableHBaseueBackupRequest creates a request to invoke EnableHBaseueBackup API
func CreateEnableHBaseueBackupRequest() (request *EnableHBaseueBackupRequest) {
	request = &EnableHBaseueBackupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "EnableHBaseueBackup", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableHBaseueBackupResponse creates a response to parse from EnableHBaseueBackup response
func CreateEnableHBaseueBackupResponse() (response *EnableHBaseueBackupResponse) {
	response = &EnableHBaseueBackupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
