package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFolder invokes the foas.DeleteFolder API synchronously
func (client *Client) DeleteFolder(request *DeleteFolderRequest) (response *DeleteFolderResponse, err error) {
	response = CreateDeleteFolderResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFolderWithChan invokes the foas.DeleteFolder API asynchronously
func (client *Client) DeleteFolderWithChan(request *DeleteFolderRequest) (<-chan *DeleteFolderResponse, <-chan error) {
	responseChan := make(chan *DeleteFolderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFolder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFolderWithCallback invokes the foas.DeleteFolder API asynchronously
func (client *Client) DeleteFolderWithCallback(request *DeleteFolderRequest, callback func(response *DeleteFolderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFolderResponse
		var err error
		defer close(result)
		response, err = client.DeleteFolder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFolderRequest is the request struct for api DeleteFolder
type DeleteFolderRequest struct {
	*requests.RoaRequest
	Path        string `position:"Query" name:"path"`
	ProjectName string `position:"Path" name:"projectName"`
}

// DeleteFolderResponse is the response struct for api DeleteFolder
type DeleteFolderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFolderRequest creates a request to invoke DeleteFolder API
func CreateDeleteFolderRequest() (request *DeleteFolderRequest) {
	request = &DeleteFolderRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "DeleteFolder", "/api/v2/projects/[projectName]/folders", "foas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteFolderResponse creates a response to parse from DeleteFolder response
func CreateDeleteFolderResponse() (response *DeleteFolderResponse) {
	response = &DeleteFolderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
