package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSynchronizConstants invokes the dbfs.GetSynchronizConstants API synchronously
func (client *Client) GetSynchronizConstants(request *GetSynchronizConstantsRequest) (response *GetSynchronizConstantsResponse, err error) {
	response = CreateGetSynchronizConstantsResponse()
	err = client.DoAction(request, response)
	return
}

// GetSynchronizConstantsWithChan invokes the dbfs.GetSynchronizConstants API asynchronously
func (client *Client) GetSynchronizConstantsWithChan(request *GetSynchronizConstantsRequest) (<-chan *GetSynchronizConstantsResponse, <-chan error) {
	responseChan := make(chan *GetSynchronizConstantsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSynchronizConstants(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSynchronizConstantsWithCallback invokes the dbfs.GetSynchronizConstants API asynchronously
func (client *Client) GetSynchronizConstantsWithCallback(request *GetSynchronizConstantsRequest, callback func(response *GetSynchronizConstantsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSynchronizConstantsResponse
		var err error
		defer close(result)
		response, err = client.GetSynchronizConstants(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSynchronizConstantsRequest is the request struct for api GetSynchronizConstants
type GetSynchronizConstantsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// GetSynchronizConstantsResponse is the response struct for api GetSynchronizConstants
type GetSynchronizConstantsResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Data            string `json:"Data" xml:"Data"`
	PageSize        int64  `json:"PageSize" xml:"PageSize"`
	TotalCount      int64  `json:"TotalCount" xml:"TotalCount"`
	PageNumber      int64  `json:"PageNumber" xml:"PageNumber"`
	RegionData      string `json:"RegionData" xml:"RegionData"`
	ZoneData        string `json:"ZoneData" xml:"ZoneData"`
	OsversionData   string `json:"OsversionData" xml:"OsversionData"`
	ProductCodeData string `json:"ProductCodeData" xml:"ProductCodeData"`
	MasterData      string `json:"MasterData" xml:"MasterData"`
	EndpointData    string `json:"EndpointData" xml:"EndpointData"`
	AccessData      string `json:"AccessData" xml:"AccessData"`
}

// CreateGetSynchronizConstantsRequest creates a request to invoke GetSynchronizConstants API
func CreateGetSynchronizConstantsRequest() (request *GetSynchronizConstantsRequest) {
	request = &GetSynchronizConstantsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "GetSynchronizConstants", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSynchronizConstantsResponse creates a response to parse from GetSynchronizConstants response
func CreateGetSynchronizConstantsResponse() (response *GetSynchronizConstantsResponse) {
	response = &GetSynchronizConstantsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
