package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricOrganization invokes the baas.DescribeFabricOrganization API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganization.html
func (client *Client) DescribeFabricOrganization(request *DescribeFabricOrganizationRequest) (response *DescribeFabricOrganizationResponse, err error) {
	response = CreateDescribeFabricOrganizationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricOrganizationWithChan invokes the baas.DescribeFabricOrganization API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationWithChan(request *DescribeFabricOrganizationRequest) (<-chan *DescribeFabricOrganizationResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricOrganizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricOrganization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricOrganizationWithCallback invokes the baas.DescribeFabricOrganization API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationWithCallback(request *DescribeFabricOrganizationRequest, callback func(response *DescribeFabricOrganizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricOrganizationResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricOrganization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricOrganizationRequest is the request struct for api DescribeFabricOrganization
type DescribeFabricOrganizationRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
}

// DescribeFabricOrganizationResponse is the response struct for api DescribeFabricOrganization
type DescribeFabricOrganizationResponse struct {
	*responses.BaseResponse
	RequestId string                             `json:"RequestId" xml:"RequestId"`
	Success   bool                               `json:"Success" xml:"Success"`
	ErrorCode int                                `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInDescribeFabricOrganization `json:"Result" xml:"Result"`
}

// CreateDescribeFabricOrganizationRequest creates a request to invoke DescribeFabricOrganization API
func CreateDescribeFabricOrganizationRequest() (request *DescribeFabricOrganizationRequest) {
	request = &DescribeFabricOrganizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricOrganization", "baas", "openAPI")
	return
}

// CreateDescribeFabricOrganizationResponse creates a response to parse from DescribeFabricOrganization response
func CreateDescribeFabricOrganizationResponse() (response *DescribeFabricOrganizationResponse) {
	response = &DescribeFabricOrganizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
