package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFabricConsortium invokes the baas.CreateFabricConsortium API synchronously
// api document: https://help.aliyun.com/api/baas/createfabricconsortium.html
func (client *Client) CreateFabricConsortium(request *CreateFabricConsortiumRequest) (response *CreateFabricConsortiumResponse, err error) {
	response = CreateCreateFabricConsortiumResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFabricConsortiumWithChan invokes the baas.CreateFabricConsortium API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricconsortium.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricConsortiumWithChan(request *CreateFabricConsortiumRequest) (<-chan *CreateFabricConsortiumResponse, <-chan error) {
	responseChan := make(chan *CreateFabricConsortiumResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFabricConsortium(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFabricConsortiumWithCallback invokes the baas.CreateFabricConsortium API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricconsortium.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricConsortiumWithCallback(request *CreateFabricConsortiumRequest, callback func(response *CreateFabricConsortiumResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFabricConsortiumResponse
		var err error
		defer close(result)
		response, err = client.CreateFabricConsortium(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFabricConsortiumRequest is the request struct for api CreateFabricConsortium
type CreateFabricConsortiumRequest struct {
	*requests.RpcRequest
	OrderersCount         requests.Integer                      `position:"Body" name:"OrderersCount"`
	ConsortiumName        string                                `position:"Body" name:"ConsortiumName"`
	SpecName              string                                `position:"Body" name:"SpecName"`
	ChannelPolicy         string                                `position:"Body" name:"ChannelPolicy"`
	PaymentDuration       requests.Integer                      `position:"Body" name:"PaymentDuration"`
	Domain                string                                `position:"Body" name:"Domain"`
	ConsortiumDescription string                                `position:"Body" name:"ConsortiumDescription"`
	Organization          *[]CreateFabricConsortiumOrganization `position:"Body" name:"Organization"  type:"Repeated"`
	OrdererType           string                                `position:"Body" name:"OrdererType"`
	ZoneId                string                                `position:"Body" name:"ZoneId"`
	Location              string                                `position:"Body" name:"Location"`
	PaymentDurationUnit   string                                `position:"Body" name:"PaymentDurationUnit"`
	PeersCount            requests.Integer                      `position:"Body" name:"PeersCount"`
}

// CreateFabricConsortiumOrganization is a repeated param struct in CreateFabricConsortiumRequest
type CreateFabricConsortiumOrganization struct {
	OrganizationId string `name:"OrganizationId"`
}

// CreateFabricConsortiumResponse is the response struct for api CreateFabricConsortium
type CreateFabricConsortiumResponse struct {
	*responses.BaseResponse
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Success   bool                           `json:"Success" xml:"Success"`
	ErrorCode int                            `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInCreateFabricConsortium `json:"Result" xml:"Result"`
}

// CreateCreateFabricConsortiumRequest creates a request to invoke CreateFabricConsortium API
func CreateCreateFabricConsortiumRequest() (request *CreateFabricConsortiumRequest) {
	request = &CreateFabricConsortiumRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "CreateFabricConsortium", "baas", "openAPI")
	return
}

// CreateCreateFabricConsortiumResponse creates a response to parse from CreateFabricConsortium response
func CreateCreateFabricConsortiumResponse() (response *CreateFabricConsortiumResponse) {
	response = &CreateFabricConsortiumResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
