package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindDBResourcePoolWithUser invokes the adb.UnbindDBResourcePoolWithUser API synchronously
func (client *Client) UnbindDBResourcePoolWithUser(request *UnbindDBResourcePoolWithUserRequest) (response *UnbindDBResourcePoolWithUserResponse, err error) {
	response = CreateUnbindDBResourcePoolWithUserResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindDBResourcePoolWithUserWithChan invokes the adb.UnbindDBResourcePoolWithUser API asynchronously
func (client *Client) UnbindDBResourcePoolWithUserWithChan(request *UnbindDBResourcePoolWithUserRequest) (<-chan *UnbindDBResourcePoolWithUserResponse, <-chan error) {
	responseChan := make(chan *UnbindDBResourcePoolWithUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindDBResourcePoolWithUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindDBResourcePoolWithUserWithCallback invokes the adb.UnbindDBResourcePoolWithUser API asynchronously
func (client *Client) UnbindDBResourcePoolWithUserWithCallback(request *UnbindDBResourcePoolWithUserRequest, callback func(response *UnbindDBResourcePoolWithUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindDBResourcePoolWithUserResponse
		var err error
		defer close(result)
		response, err = client.UnbindDBResourcePoolWithUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindDBResourcePoolWithUserRequest is the request struct for api UnbindDBResourcePoolWithUser
type UnbindDBResourcePoolWithUserRequest struct {
	*requests.RpcRequest
	PoolName             string           `position:"Query" name:"PoolName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PoolUser             string           `position:"Query" name:"PoolUser"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// UnbindDBResourcePoolWithUserResponse is the response struct for api UnbindDBResourcePoolWithUser
type UnbindDBResourcePoolWithUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindDBResourcePoolWithUserRequest creates a request to invoke UnbindDBResourcePoolWithUser API
func CreateUnbindDBResourcePoolWithUserRequest() (request *UnbindDBResourcePoolWithUserRequest) {
	request = &UnbindDBResourcePoolWithUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "UnbindDBResourcePoolWithUser", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnbindDBResourcePoolWithUserResponse creates a response to parse from UnbindDBResourcePoolWithUser response
func CreateUnbindDBResourcePoolWithUserResponse() (response *UnbindDBResourcePoolWithUserResponse) {
	response = &UnbindDBResourcePoolWithUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
