/*
Author: Jelle Geerts

Usage of the works is permitted provided that this instrument is
retained with the works, so that any entity that uses the works is
notified of this instrument.

DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
*/

#ifndef NOWIDE_H
#define NOWIDE_H

#include <stdexcept>
#include <string>

namespace nowide
{
    class ConversionError : public std::runtime_error
    {
    public:
        explicit ConversionError(const std::string & what_arg);
        explicit ConversionError(const char * what_arg);
    };

    std::string narrow(const std::wstring & s);
    std::string narrow(const wchar_t * s);
    std::wstring widen(const std::string & s);
    std::wstring widen(const char * s);
}

#endif
