/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.CaptchaRejectedException;
import org.asamk.signal.output.OutputWriter;

public class SubmitRateLimitChallengeCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "submitRateLimitChallenge";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Submit a captcha challenge to lift the rate limit. This command should only be necessary when sending fails with a proof required error.");
        subparser.addArgument(new String[]{"--challenge"}).required(true).help("The challenge token taken from the proof required error.");
        subparser.addArgument(new String[]{"--captcha"}).required(true).help("The captcha token from the solved captcha on the signal website.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        String challenge = ns.getString("challenge");
        String captcha = ns.getString("captcha");
        try {
            m.submitRateLimitRecaptchaChallenge(challenge, captcha);
        }
        catch (IOException e) {
            throw new IOErrorException("Submit challenge error: " + e.getMessage(), e);
        }
        catch (CaptchaRejectedException e) {
            throw new UserErrorException("Captcha rejected, it may be outdated, already used or solved from a different IP address.");
        }
    }
}

