/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.provisioning;

import io.reactivex.rxjava3.core.Single;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.Base64;
import org.signal.core.util.StringExtensionsKt;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.registration.proto.RegistrationProvisionMessage;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.provisioning.ProvisioningMessage;
import org.whispersystems.signalservice.api.provisioning.RestoreMethod;
import org.whispersystems.signalservice.api.registration.RestoreMethodBody;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.crypto.PrimaryProvisioningCipher;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/whispersystems/signalservice/api/provisioning/ProvisioningApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "unauthWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;)V", "sendReRegisterDeviceProvisioningMessage", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "deviceIdentifier", "", "deviceKey", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "registrationProvisionMessage", "Lorg/signal/registration/proto/RegistrationProvisionMessage;", "waitForRestoreMethod", "Lorg/whispersystems/signalservice/api/provisioning/RestoreMethod;", "token", "timeout", "", "signal-service-java"})
public final class ProvisioningApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket;

    public ProvisioningApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket, @NotNull SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        Intrinsics.checkNotNullParameter((Object)unauthWebSocket, (String)"unauthWebSocket");
        this.authWebSocket = authWebSocket;
        this.unauthWebSocket = unauthWebSocket;
    }

    @NotNull
    public final NetworkResult<Unit> sendReRegisterDeviceProvisioningMessage(@NotNull String deviceIdentifier, @NotNull ECPublicKey deviceKey, @NotNull RegistrationProvisionMessage registrationProvisionMessage) {
        Intrinsics.checkNotNullParameter((Object)deviceIdentifier, (String)"deviceIdentifier");
        Intrinsics.checkNotNullParameter((Object)deviceKey, (String)"deviceKey");
        Intrinsics.checkNotNullParameter((Object)((Object)registrationProvisionMessage), (String)"registrationProvisionMessage");
        byte[] cipherText = new PrimaryProvisioningCipher(deviceKey).encrypt(registrationProvisionMessage);
        String string = "/v1/provisioning/" + StringExtensionsKt.urlEncode((String)deviceIdentifier);
        Intrinsics.checkNotNull((Object)cipherText);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, string, new ProvisioningMessage(Base64.encodeWithPadding$default((byte[])cipherText, (int)0, (int)0, (int)6, null)), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<RestoreMethod> waitForRestoreMethod(@NotNull String token, int timeout) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/devices/restore_account/" + StringExtensionsKt.urlEncode((String)token) + "?timeout=" + timeout, null, 2, null);
        return NetworkResult.Companion.fromWebSocket(new NetworkResult.LongPollingWebSocketConverter(Reflection.getOrCreateKotlinClass(RestoreMethodBody.class)), () -> ProvisioningApi.waitForRestoreMethod$lambda$0(this, request2, timeout)).map(ProvisioningApi::waitForRestoreMethod$lambda$1);
    }

    public static /* synthetic */ NetworkResult waitForRestoreMethod$default(ProvisioningApi provisioningApi, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 30;
        }
        return provisioningApi.waitForRestoreMethod(string, n);
    }

    private static final Single waitForRestoreMethod$lambda$0(ProvisioningApi this$0, WebSocketRequestMessage $request, int $timeout) {
        return this$0.unauthWebSocket.request-HG0u8IE($request, DurationKt.toDuration((int)$timeout, (DurationUnit)DurationUnit.SECONDS));
    }

    private static final RestoreMethod waitForRestoreMethod$lambda$1(RestoreMethodBody it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RestoreMethod restoreMethod = it.getMethod();
        if (restoreMethod == null) {
            restoreMethod = RestoreMethod.DECLINE;
        }
        return restoreMethod;
    }
}

