/*  MaitreTarot.
 *  (C) 2002 Guillaume Weexsteen <gui.mail@wanadoo.fr>
 *  Modified by Yves Mettier <ymettier@libertysurf.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MAITRETAROT_DEFS_H
#define MAITRETAROT_DEFS_H

#include <glib.h>
#include <maitretarot.h>

#define MT_DEBUG_SIGNAL_ENABLED 1

#define _(a) a

#define WAIT_TIME 5000

typedef enum
{
  MT_PLAYER_READY_NO = 0,
  MT_PLAYER_READY_CLOSED,
  MT_PLAYER_READY_GET_ID,
  MT_PLAYER_READY_SEND_ID,
  MT_PLAYER_READY_SEND_PROTOCOL,
  MT_PLAYER_READY_SEND_PLACE,
  MT_PLAYER_READY_GET_NICK,
  MT_PLAYER_READY_SEND_NICKS,
  MT_PLAYER_READY_DILL_CARDS,
  MT_PLAYER_READY_SEND_BIDS_ONLY,
  MT_PLAYER_READY_SEND_BIDS_AND_ASK_FOR_BID,
  MT_PLAYER_READY_GET_BID,
  MT_PLAYER_READY_SEND_FINAL_BIDS,
  MT_PLAYER_READY_SHOW_CHIEN,
  MT_PLAYER_READY_SEND_OK_FOR_CHIEN,
  MT_PLAYER_READY_SEND_NOK_FOR_CHIEN,
  MT_PLAYER_READY_SEND_ACK_FOR_CHIEN,
  MT_PLAYER_READY_SEND_OK_FOR_CARD,
  MT_PLAYER_READY_SEND_NOK_FOR_CARD,
  MT_PLAYER_READY_GET_CHIEN,
  MT_PLAYER_READY_SEND_TURN_CARDS_ONLY,
  MT_PLAYER_READY_SEND_TURN_CARDS,
  MT_PLAYER_READY_WAIT_FOR_TURN_CARD,
  MT_PLAYER_READY_SEND_LAST_TURN_CARDS,
  MT_PLAYER_READY_SEND_SCORE,
  MT_PLAYER_READY_SHOW_CHIEN_AT_END,
  MT_PLAYER_READY_ACK_REPLAY,
  MT_PLAYER_READY_SEND_REPLAY_ANSWER,
  MT_PLAYER_READY_END
}

mt_player_ready_e;

typedef enum
{
  MT_RULE_ERROR_CARD_IS_NOT_IN_PLAYERS_GAME,
  MT_RULE_ERROR_PLAYER_CAN_PLAY_COLOR,
  MT_RULE_ERROR_PLAYER_CAN_PLAY_TRUMP,
  MT_RULE_ERROR_UNKNOWN_CASE
}

mt_rule_error_e;

typedef struct
{
  gint place;

  /* FIXME: use GString */
  gchar *nicks[MAX_PLAYER];
  gint nicks_len[MAX_PLAYER];

  libmt_bid_e bid[MAX_PLAYER];
  gint chien[MAX_CARD_CHIEN];
  gint card[MAX_HAND_CARD];
  gint turn[8];
  gint turn_card;
  gint score;
  gint all_scores[8];
  libmt_net_t *net_data;
  mt_player_ready_e ready;
  GThread *th_id;
  gint score_total;
  gint is_ok_to_play_again;
}

player_t;

typedef struct
{
  gint sock;
  gint server_id[2];
  gint protocol_version;

  player_t *players[MAX_PLAYER];
  gchar *nicks[MAX_PLAYER];
  gint nicks_len[MAX_PLAYER];
  gint deck[78];
  gint card_status[78];
  gint card_value[78];
  /* card_status[i]: 0->4   : player id 5      : chien 10->14 : owner of the
     turn */

  gint chien[6];
  gint taker_score;
  libmt_bid_e bid;
  libmt_bid_e bids[4];
  gint turn;
  gint players_order[4];
  gint preneur;
  gboolean was_1trump_in_last_turn;
}

game_t;

#endif /* MAITRETAROT_DEFS_H */
