#include "cll1.h"

struct Line
{
 int n;
 list(Line);
} *line;

struct Id
{
 char *str;
 int count;
 struct Line *lines;
 list(Id);
} *id,*ids=NULL;

program
{
 char *ptr;
 char *fname;
 char *c=NULL;
 int l=0;

 arguments
 {
  thisargument(fname);
  nextargument(c);
 }
 else
 {
  puts("Usage: idmap file [c]");
  return 1;
 }

 parse(fname)
 {
  l++;
  while(*_)
  {
   goto_alpha(_);
   ptr=_;
   skip_alnum(_);
   *_=0;
   _++;

   if(*ptr)
   {
    find(id,ids,eq(id->str,ptr))
    {
     id->count++;
     find(line,id->lines,line->n==l);
     else
     {
      create(line,Line);
      line->n=l;
      push(line,id->lines);
     }
    }
    else 
    {
     create(id,Id);
     create(line,Line);
     id->str=ptr;
     id->count=1;
     id->lines=line;
     line->n=l;
     insert(id,ids,sort_by,str);
    }
   }
   if(*_=='"' || *_=='\'' )
   {
    char c=*_;
    _++;
    gotochr(_,c);
   }
  }
 }
 fail
 { 
  perror(argv[1]); 
  exit(-1);
 }
 done;

 if(c)
  sort(id,ids,desc_order_by,count);
  
 every(id,ids)
 { 
  printf("%3dx %s",id->count,id->str);
  every(line,id->lines) printf(" [%d]",line->n);
  printf("\n"); 
 }
}
