/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.repository;

import java.io.IOException;
import java.util.List;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.repository.InstallPlugin;
import org.rundeck.client.tool.commands.repository.UninstallPlugin;
import org.rundeck.client.tool.commands.repository.UploadPlugin;
import org.rundeck.client.tool.extension.BaseCommand;
import picocli.CommandLine;

@CommandLine.Command(name="plugins", description={"Manage Rundeck plugins"}, subcommands={UploadPlugin.class, InstallPlugin.class, UninstallPlugin.class})
public class Plugins
extends BaseCommand {
    @CommandLine.Command(name="list", description={"List plugins"})
    public void list() throws InputError, IOException {
        List repos = (List)this.getRdTool().apiCall(RundeckApi::listPlugins);
        repos.forEach(repo -> {
            this.getRdOutput().output("==" + repo.getRepositoryName() + " Repository==");
            repo.getResults().forEach(plugin -> {
                if (plugin.getInstallId() != null && !plugin.getInstallId().isEmpty()) {
                    String updateable = "";
                    if (plugin.isUpdatable()) {
                        updateable = " (Updatable to " + plugin.getCurrentVersion() + ")";
                    }
                    this.getRdOutput().output(String.format("%s : %s : %s (%sinstalled) %s", plugin.getInstallId(), plugin.getName(), plugin.isInstalled() ? plugin.getInstalledVersion() : plugin.getCurrentVersion(), plugin.isInstalled() ? "" : "not ", updateable));
                }
            });
        });
    }
}

