/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.system_indices.action.GetFeatureUpgradeStatusAction;
import org.elasticsearch.system_indices.action.PostFeatureUpgradeAction;
import org.elasticsearch.system_indices.action.TransportGetFeatureUpgradeStatusAction;
import org.elasticsearch.system_indices.action.TransportPostFeatureUpgradeAction;
import org.elasticsearch.system_indices.rest.RestGetFeatureUpgradeStatusAction;
import org.elasticsearch.system_indices.rest.RestPostFeatureUpgradeAction;
import org.elasticsearch.system_indices.task.FeatureMigrationResults;
import org.elasticsearch.system_indices.task.SystemIndexMigrationExecutor;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.migrate.MigrateTemplateRegistry;
import org.elasticsearch.xpack.migrate.action.CancelReindexDataStreamAction;
import org.elasticsearch.xpack.migrate.action.CancelReindexDataStreamTransportAction;
import org.elasticsearch.xpack.migrate.action.CopyLifecycleIndexMetadataAction;
import org.elasticsearch.xpack.migrate.action.CopyLifecycleIndexMetadataTransportAction;
import org.elasticsearch.xpack.migrate.action.CreateIndexFromSourceAction;
import org.elasticsearch.xpack.migrate.action.CreateIndexFromSourceTransportAction;
import org.elasticsearch.xpack.migrate.action.GetMigrationReindexStatusAction;
import org.elasticsearch.xpack.migrate.action.GetMigrationReindexStatusTransportAction;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamAction;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamIndexAction;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamIndexTransportAction;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamTransportAction;
import org.elasticsearch.xpack.migrate.rest.RestCancelReindexDataStreamAction;
import org.elasticsearch.xpack.migrate.rest.RestCreateIndexFromSourceAction;
import org.elasticsearch.xpack.migrate.rest.RestGetMigrationReindexStatusAction;
import org.elasticsearch.xpack.migrate.rest.RestMigrationReindexAction;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamPersistentTaskExecutor;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamPersistentTaskState;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamStatus;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamTaskParams;

public class MigratePlugin
extends Plugin
implements ActionPlugin,
PersistentTaskPlugin {
    private final SetOnce<SystemIndices> systemIndices = new SetOnce();

    public Collection<?> createComponents(Plugin.PluginServices services) {
        this.systemIndices.set((Object)services.systemIndices());
        MigrateTemplateRegistry registry = new MigrateTemplateRegistry(services.environment().settings(), services.clusterService(), services.threadPool(), services.client(), services.xContentRegistry());
        registry.initialize();
        return List.of(registry);
    }

    public List<RestHandler> getRestHandlers(Settings unused, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new RestMigrationReindexAction());
        handlers.add((RestHandler)new RestGetMigrationReindexStatusAction());
        handlers.add((RestHandler)new RestCancelReindexDataStreamAction());
        handlers.add((RestHandler)new RestCreateIndexFromSourceAction());
        handlers.add((RestHandler)new RestGetFeatureUpgradeStatusAction());
        handlers.add((RestHandler)new RestPostFeatureUpgradeAction());
        return handlers;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler((ActionType)ReindexDataStreamAction.INSTANCE, ReindexDataStreamTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)GetMigrationReindexStatusAction.INSTANCE, GetMigrationReindexStatusTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)CancelReindexDataStreamAction.INSTANCE, CancelReindexDataStreamTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(ReindexDataStreamIndexAction.INSTANCE, ReindexDataStreamIndexTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(CreateIndexFromSourceAction.INSTANCE, CreateIndexFromSourceTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(CopyLifecycleIndexMetadataAction.INSTANCE, CopyLifecycleIndexMetadataTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)GetFeatureUpgradeStatusAction.INSTANCE, TransportGetFeatureUpgradeStatusAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)PostFeatureUpgradeAction.INSTANCE, TransportPostFeatureUpgradeAction.class));
        return actions;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Stream.concat(SystemIndexMigrationExecutor.getNamedXContentParsers().stream(), Stream.of(new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("reindex-data-stream", new String[0]), ReindexDataStreamPersistentTaskState::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("reindex-data-stream", new String[0]), ReindexDataStreamTaskParams::fromXContent))).toList();
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Stream.concat(SystemIndexMigrationExecutor.getNamedWriteables().stream(), Stream.of(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "system_index_migration", FeatureMigrationResults::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "system_index_migration", FeatureMigrationResults::readDiffFrom), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "reindex-data-stream", ReindexDataStreamPersistentTaskState::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "reindex-data-stream", ReindexDataStreamTaskParams::new), new NamedWriteableRegistry.Entry(Task.Status.class, "ReindexDataStreamStatus", ReindexDataStreamStatus::new))).toList();
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        return List.of(new SystemIndexMigrationExecutor(client, clusterService, (SystemIndices)this.systemIndices.get(), settingsModule.getIndexScopedSettings(), threadPool), new ReindexDataStreamPersistentTaskExecutor((Client)new OriginSettingClient(client, "reindex_data_stream"), clusterService, "reindex-data-stream", threadPool));
    }

    public List<Setting<?>> getSettings() {
        ArrayList pluginSettings = new ArrayList();
        pluginSettings.add(ReindexDataStreamPersistentTaskExecutor.MAX_CONCURRENT_INDICES_REINDEXED_PER_DATA_STREAM_SETTING);
        pluginSettings.add(ReindexDataStreamIndexTransportAction.REINDEX_MAX_REQUESTS_PER_SECOND_SETTING);
        return pluginSettings;
    }
}

