/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.elasticsearch.core.SuppressForbidden;

@SuppressForbidden(reason="use of default ChannelFutureListener's CLOSE and CLOSE_ON_FAILURE")
public class Netty4HttpContentSizeHandler
extends ChannelInboundHandlerAdapter {
    static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    static final FullHttpResponse EXPECTATION_FAILED_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER, new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0).add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER, new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0).add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    static final FullHttpResponse TOO_LARGE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER, new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    private final int maxContentLength;
    private final HttpRequestDecoder decoder;
    private int currentContentLength;
    private boolean ignoreContent;

    public Netty4HttpContentSizeHandler(HttpRequestDecoder decoder, int maxContentLength) {
        this.maxContentLength = maxContentLength;
        this.decoder = decoder;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        assert (msg instanceof HttpObject);
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            this.handleRequest(ctx, request);
        } else {
            this.handleContent(ctx, (HttpContent)msg);
        }
    }

    private void handleRequest(ChannelHandlerContext ctx, HttpRequest request) {
        boolean isOversized;
        this.ignoreContent = true;
        if (request.decoderResult().isFailure()) {
            ctx.fireChannelRead((Object)request);
            return;
        }
        String expectValue = request.headers().get((CharSequence)HttpHeaderNames.EXPECT);
        boolean isContinueExpected = false;
        if (expectValue != null) {
            if (HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase(expectValue)) {
                isContinueExpected = true;
            } else {
                ctx.writeAndFlush((Object)EXPECTATION_FAILED_CLOSE.retainedDuplicate()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
        }
        boolean bl = isOversized = HttpUtil.getContentLength((HttpMessage)request, (int)-1) > this.maxContentLength;
        if (isOversized) {
            if (isContinueExpected) {
                this.decoder.reset();
            }
            ctx.writeAndFlush((Object)TOO_LARGE.retainedDuplicate()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        } else {
            this.ignoreContent = false;
            this.currentContentLength = 0;
            if (isContinueExpected) {
                ctx.writeAndFlush((Object)CONTINUE.retainedDuplicate());
                HttpUtil.set100ContinueExpected((HttpMessage)request, (boolean)false);
            }
            ctx.fireChannelRead((Object)request);
        }
    }

    private void handleContent(ChannelHandlerContext ctx, HttpContent msg) {
        if (this.ignoreContent) {
            msg.release();
        } else {
            this.currentContentLength += msg.content().readableBytes();
            if (this.currentContentLength > this.maxContentLength) {
                msg.release();
                ctx.writeAndFlush((Object)TOO_LARGE_CLOSE.retainedDuplicate()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                ctx.fireChannelRead((Object)msg);
            }
        }
    }
}

