/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.calendar;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetCalendarsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_ml/calendars/{" + String.valueOf(Calendar.ID) + "}"), new RestHandler.Route(RestRequest.Method.GET, "/_ml/calendars/"), new RestHandler.Route(RestRequest.Method.POST, "/_ml/calendars/{" + String.valueOf(Calendar.ID) + "}"), new RestHandler.Route(RestRequest.Method.POST, "/_ml/calendars/"));
    }

    public String getName() {
        return "ml_get_calendars_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetCalendarsAction.Request request;
        String calendarId = restRequest.param(Calendar.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            try (XContentParser parser = restRequest.contentOrSourceParamParser();){
                request = GetCalendarsAction.Request.parseRequest((String)calendarId, (XContentParser)parser);
            }
        } else {
            request = new GetCalendarsAction.Request();
            if (!Strings.isNullOrEmpty((String)calendarId)) {
                request.setCalendarId(calendarId);
            }
            if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
                request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            }
        }
        return channel -> client.execute((ActionType)GetCalendarsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

