/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentElasticsearchExtension;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingContext;
import org.elasticsearch.xpack.ml.autoscaling.MlMemoryAutoscalingCapacity;
import org.elasticsearch.xpack.ml.autoscaling.MlMemoryAutoscalingDecider;
import org.elasticsearch.xpack.ml.autoscaling.MlProcessorAutoscalingCapacity;
import org.elasticsearch.xpack.ml.autoscaling.MlProcessorAutoscalingDecider;
import org.elasticsearch.xpack.ml.autoscaling.MlScalingReason;
import org.elasticsearch.xpack.ml.autoscaling.NativeMemoryCapacity;
import org.elasticsearch.xpack.ml.autoscaling.NodeAvailabilityZoneMapper;
import org.elasticsearch.xpack.ml.autoscaling.ScaleTimer;
import org.elasticsearch.xpack.ml.job.NodeLoadDetector;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public final class MlAutoscalingDeciderService
implements AutoscalingDeciderService,
LocalNodeMasterListener {
    private static final Logger logger = LogManager.getLogger(MlAutoscalingDeciderService.class);
    public static final String NAME = "ml";
    public static final Setting<Integer> NUM_ANOMALY_JOBS_IN_QUEUE = Setting.intSetting((String)"num_anomaly_jobs_in_queue", (int)0, (int)0, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> NUM_ANALYTICS_JOBS_IN_QUEUE = Setting.intSetting((String)"num_analytics_jobs_in_queue", (int)0, (int)0, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<TimeValue> DOWN_SCALE_DELAY = Setting.timeSetting((String)"down_scale_delay", (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[0]);
    private final ScaleTimer scaleTimer;
    private final MlMemoryAutoscalingDecider memoryDecider;
    private final MlProcessorAutoscalingDecider processorDecider;
    private volatile boolean isMaster;
    private volatile int allocatedProcessorsScale;

    public MlAutoscalingDeciderService(MlMemoryTracker memoryTracker, Settings settings, NodeAvailabilityZoneMapper nodeAvailabilityZoneMapper, ClusterService clusterService) {
        this(new NodeLoadDetector(memoryTracker), settings, nodeAvailabilityZoneMapper, clusterService, System::currentTimeMillis);
    }

    MlAutoscalingDeciderService(NodeLoadDetector nodeLoadDetector, Settings settings, NodeAvailabilityZoneMapper nodeAvailabilityZoneMapper, ClusterService clusterService, LongSupplier timeSupplier) {
        this.scaleTimer = new ScaleTimer(timeSupplier);
        this.memoryDecider = new MlMemoryAutoscalingDecider(settings, clusterService, nodeAvailabilityZoneMapper, nodeLoadDetector, this.scaleTimer);
        this.processorDecider = new MlProcessorAutoscalingDecider(this.scaleTimer);
        this.allocatedProcessorsScale = (Integer)MachineLearning.ALLOCATED_PROCESSORS_SCALE.get(settings);
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.ALLOCATED_PROCESSORS_SCALE, this::setAllocatedProcessorsScale);
    }

    void setAllocatedProcessorsScale(int scale) {
        this.allocatedProcessorsScale = scale;
    }

    public void onMaster() {
        this.isMaster = true;
    }

    public void offMaster() {
        this.isMaster = false;
    }

    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        if (!this.isMaster) {
            throw new IllegalArgumentException("request for scaling information is only allowed on the master node");
        }
        logger.debug("request to scale received");
        this.scaleTimer.markScale();
        ClusterState clusterState = context.state();
        MlAutoscalingContext mlContext = new MlAutoscalingContext(clusterState);
        NativeMemoryCapacity currentNativeMemoryCapacity = this.memoryDecider.currentScale(mlContext.mlNodes);
        MlMemoryAutoscalingCapacity currentMemoryCapacity = this.memoryDecider.capacityFromNativeMemory(currentNativeMemoryCapacity);
        MlProcessorAutoscalingCapacity currentProcessorCapacity = this.processorDecider.computeCurrentCapacity(mlContext.mlNodes, this.allocatedProcessorsScale);
        MlScalingReason.Builder reasonBuilder = MlScalingReason.builder(mlContext).setCurrentMlCapacity(new AutoscalingCapacity(new AutoscalingCapacity.AutoscalingResources(null, currentMemoryCapacity.tierSize(), currentProcessorCapacity.tierProcessors()), new AutoscalingCapacity.AutoscalingResources(null, currentMemoryCapacity.nodeSize(), currentProcessorCapacity.nodeProcessors()))).setPassedConfiguration(configuration);
        if (mlContext.isEmpty()) {
            return this.downscaleToZero(configuration, context, currentNativeMemoryCapacity, reasonBuilder);
        }
        MlMemoryAutoscalingCapacity memoryCapacity = this.memoryDecider.scale(configuration, context, mlContext, this.allocatedProcessorsScale);
        if (memoryCapacity.isUndetermined()) {
            return new AutoscalingDeciderResult(null, (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason(Strings.format((String)"[memory_decider] %s", (Object[])new Object[]{memoryCapacity.reason()})).build());
        }
        MlProcessorAutoscalingCapacity processorCapacity = this.processorDecider.scale(configuration, context, mlContext, this.allocatedProcessorsScale);
        reasonBuilder.setSimpleReason(Strings.format((String)"[memory_decider] %s; [processor_decider] %s", (Object[])new Object[]{memoryCapacity.reason(), processorCapacity.reason()}));
        return new AutoscalingDeciderResult(new AutoscalingCapacity(new AutoscalingCapacity.AutoscalingResources(null, memoryCapacity.tierSize(), processorCapacity.tierProcessors()), new AutoscalingCapacity.AutoscalingResources(null, memoryCapacity.nodeSize(), processorCapacity.nodeProcessors())), (AutoscalingDeciderResult.Reason)reasonBuilder.build());
    }

    private AutoscalingDeciderResult downscaleToZero(Settings configuration, AutoscalingDeciderContext context, NativeMemoryCapacity currentScale, MlScalingReason.Builder reasonBuilder) {
        if (currentScale.getTierMlNativeMemoryRequirementExcludingOverhead() == 0L && currentScale.getNodeMlNativeMemoryRequirementExcludingOverhead() == 0L) {
            return new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason("Passing currently perceived capacity as no scaling changes are necessary").build());
        }
        long msLeftToScale = this.scaleTimer.markDownScaleAndGetMillisLeftFromDelay(configuration);
        if (msLeftToScale > 0L) {
            return new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason(Strings.format((String)"Passing currently perceived capacity as down scale delay has not been satisfied; configured delay [%s] last detected scale down event [%s]. Will request scale down in approximately [%s]", (Object[])new Object[]{((TimeValue)DOWN_SCALE_DELAY.get(configuration)).getStringRep(), XContentElasticsearchExtension.DEFAULT_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(this.scaleTimer.downScaleDetectedMillis())), TimeValue.timeValueMillis((long)msLeftToScale).getStringRep()})).build());
        }
        return new AutoscalingDeciderResult(AutoscalingCapacity.ZERO, (AutoscalingDeciderResult.Reason)reasonBuilder.setRequiredCapacity(AutoscalingCapacity.ZERO).setSimpleReason("Requesting scale down as tier and/or node size could be smaller").build());
    }

    public String name() {
        return NAME;
    }

    public List<Setting<?>> deciderSettings() {
        return List.of(NUM_ANALYTICS_JOBS_IN_QUEUE, NUM_ANOMALY_JOBS_IN_QUEUE, DOWN_SCALE_DELAY);
    }

    public List<DiscoveryNodeRole> roles() {
        return List.of(DiscoveryNodeRole.ML_ROLE);
    }
}

