/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import java.util.Random;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.Distribution;
import org.ojalgo.random.SampleSet;
import org.ojalgo.type.ComparableNumber;

public abstract class RandomNumber
implements Distribution,
NullaryFunction<Double>,
ComparableNumber<RandomNumber> {
    private final Random myRandom = new Random();

    protected RandomNumber() {
    }

    @Override
    public int compareTo(RandomNumber o) {
        return Double.compare(this.getExpected(), o.getExpected());
    }

    @Override
    public final double doubleValue() {
        return this.generate();
    }

    @Override
    public final float floatValue() {
        return (float)this.generate();
    }

    @Override
    public double getStandardDeviation() {
        return PrimitiveMath.SQRT.invoke(this.getVariance());
    }

    @Override
    public double getVariance() {
        double stdDev = this.getStandardDeviation();
        return stdDev * stdDev;
    }

    @Override
    public final int intValue() {
        return (int)this.longValue();
    }

    @Override
    public final Double invoke() {
        return this.generate();
    }

    @Override
    public final long longValue() {
        return Math.round(this.generate());
    }

    public SampleSet newSampleSet(int numberOfSamples) {
        return SampleSet.make(this, numberOfSamples);
    }

    public void setSeed(long seed) {
        this.myRandom.setSeed(seed);
    }

    public String toString() {
        return this.getExpected() + "\u00b1" + this.getStandardDeviation();
    }

    protected void checkProbabilty(double probabilty) {
        if (probabilty < PrimitiveMath.ZERO || PrimitiveMath.ONE < probabilty) {
            throw new IllegalArgumentException("Probabilty must be [0,1]");
        }
    }

    protected abstract double generate();

    protected final Random random() {
        return this.myRandom;
    }
}

