/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class PrimitiveAggregator
extends AggregatorSet<Double> {
    private static final ThreadLocal<AggregatorFunction<Double>> AVERAGE = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private int myCount = 0;
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue / (double)this.myCount;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    ++this.myCount;
                    this.myValue += anArg;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myCount = 0;
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> CARDINALITY = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private int myCount = 0;

                @Override
                public double doubleValue() {
                    return this.myCount;
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(double anArg) {
                    if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, anArg)) {
                        ++this.myCount;
                    }
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myCount = 0;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> LARGEST = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue = PrimitiveMath.MAX.invoke(this.myValue, PrimitiveMath.ABS.invoke(anArg));
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> MAX = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = Double.NEGATIVE_INFINITY;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue = PrimitiveMath.MAX.invoke(this.myValue, anArg);
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = Double.NEGATIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> MIN = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = Double.POSITIVE_INFINITY;

                @Override
                public double doubleValue() {
                    if (Double.isInfinite(this.myValue)) {
                        return PrimitiveMath.ZERO;
                    }
                    return this.myValue;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue = PrimitiveMath.MIN.invoke(this.myValue, anArg);
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = Double.POSITIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> NORM1 = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue += PrimitiveMath.ABS.invoke(anArg);
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> NORM2 = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return PrimitiveMath.SQRT.invoke(this.myValue);
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue += anArg * anArg;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> PRODUCT = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = PrimitiveMath.ONE;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue *= anArg;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ONE;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> PRODUCT2 = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = PrimitiveMath.ONE;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue *= anArg * anArg;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ONE;
                    return this;
                }
            };
        }
    };
    private static final PrimitiveAggregator SET = new PrimitiveAggregator();
    private static final ThreadLocal<AggregatorFunction<Double>> SMALLEST = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = Double.POSITIVE_INFINITY;

                @Override
                public double doubleValue() {
                    if (Double.isInfinite(this.myValue)) {
                        return PrimitiveMath.ZERO;
                    }
                    return this.myValue;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    double tmpArg = PrimitiveMath.ABS.invoke(anArg);
                    if (NumberContext.compare(tmpArg, PrimitiveMath.ZERO) != 0) {
                        this.myValue = PrimitiveMath.MIN.invoke(this.myValue, tmpArg);
                    }
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = Double.POSITIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> SUM = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue += anArg;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Double>> SUM2 = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new PrimitiveAggregatorFunction(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue += anArg * anArg;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }
            };
        }
    };

    public static PrimitiveAggregator getSet() {
        return SET;
    }

    private PrimitiveAggregator() {
    }

    @Override
    public AggregatorFunction<Double> average() {
        return AVERAGE.get().reset();
    }

    @Override
    public AggregatorFunction<Double> cardinality() {
        return CARDINALITY.get().reset();
    }

    @Override
    public AggregatorFunction<Double> largest() {
        return LARGEST.get().reset();
    }

    @Override
    public AggregatorFunction<Double> maximum() {
        return MAX.get().reset();
    }

    @Override
    public AggregatorFunction<Double> minimum() {
        return MIN.get().reset();
    }

    @Override
    public AggregatorFunction<Double> norm1() {
        return NORM1.get().reset();
    }

    @Override
    public AggregatorFunction<Double> norm2() {
        return NORM2.get().reset();
    }

    @Override
    public AggregatorFunction<Double> product() {
        return PRODUCT.get().reset();
    }

    @Override
    public AggregatorFunction<Double> product2() {
        return PRODUCT2.get().reset();
    }

    @Override
    public AggregatorFunction<Double> smallest() {
        return SMALLEST.get().reset();
    }

    @Override
    public AggregatorFunction<Double> sum() {
        return SUM.get().reset();
    }

    @Override
    public AggregatorFunction<Double> sum2() {
        return SUM2.get().reset();
    }

    static abstract class PrimitiveAggregatorFunction
    implements AggregatorFunction<Double> {
        PrimitiveAggregatorFunction() {
        }

        @Override
        public final Double get() {
            return this.doubleValue();
        }

        @Override
        public final void invoke(Double arg) {
            this.invoke((double)arg);
        }

        @Override
        public final void invoke(float arg) {
            this.invoke((double)arg);
        }

        @Override
        public final Scalar<Double> toScalar() {
            return PrimitiveScalar.of(this.doubleValue());
        }
    }
}

