/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.time.LocalDate;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.data.domain.finance.series.FinanceData;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public final class SourceCache {
    private static final Timer TIMER = new Timer("SourceCache-Daemon", true);
    private final Map<FinanceData, Value> myCache = new ConcurrentHashMap<FinanceData, Value>();
    private final Map<FinanceData, FinanceData> myFallback = new ConcurrentHashMap<FinanceData, FinanceData>();
    private final CalendarDate.Resolution myRefreshInterval;

    public SourceCache(CalendarDateUnit refreshInterval) {
        this.myRefreshInterval = refreshInterval;
        TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                SourceCache.this.cleanUp();
            }
        }, 0L, refreshInterval.toDurationInMillis());
    }

    public synchronized BasicSeries<LocalDate, Double> get(FinanceData key) {
        CalendarDate now = new CalendarDate();
        Value value = this.myCache.computeIfAbsent(key, k -> new Value(k.getSymbol()));
        if (value.used == null || now.millis - value.updated.millis > this.myRefreshInterval.toDurationInMillis()) {
            this.update(value, key, now);
        }
        if (value.series.size() <= 1 && this.myFallback.containsKey(key)) {
            return this.get(this.myFallback.get(key));
        }
        value.used = now;
        return value.series;
    }

    public synchronized void register(FinanceData primary, FinanceData secondary) {
        this.myCache.computeIfAbsent(primary, k -> new Value(k.getSymbol()));
        this.myCache.computeIfAbsent(secondary, k -> new Value(k.getSymbol()));
        this.myFallback.put(primary, secondary);
    }

    private void cleanUp() {
        CalendarDate now = new CalendarDate();
        for (Map.Entry<FinanceData, Value> entry : this.myCache.entrySet()) {
            FinanceData key = entry.getKey();
            Value value = entry.getValue();
            if (value.used != null && now.millis - value.used.millis <= this.myRefreshInterval.toDurationInMillis()) continue;
            value.series.clear();
            this.myCache.remove(key);
        }
    }

    private void update(Value cacheValue, FinanceData cacheKey, CalendarDate now) {
        BasicSeries<LocalDate, Double> priceSeries = cacheKey.getPriceSeries();
        for (Map.Entry entry : priceSeries.entrySet()) {
            cacheValue.series.put((LocalDate)((Comparable)entry.getKey()), (Double)((Comparable)entry.getValue()));
        }
        cacheValue.updated = now;
    }

    private static final class Value {
        final BasicSeries<LocalDate, Double> series;
        CalendarDate updated = new CalendarDate();
        CalendarDate used = null;

        Value(String name) {
            this.series = BasicSeries.LOCAL_DATE.build(Primitive64Array.FACTORY);
            this.series.name(name);
        }
    }
}

