/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata.plain;

import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.LeafPointFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractPointIndexFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexCartesianPointFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.CartesianPointDVLeafFieldData;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianPointValuesSource;

public class CartesianPointIndexFieldData
extends AbstractPointIndexFieldData<CartesianPointValuesSource.MultiCartesianPointValues>
implements IndexCartesianPointFieldData {
    public CartesianPointIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ToScriptFieldFactory<CartesianPointValuesSource.MultiCartesianPointValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, toScriptFieldFactory);
    }

    public LeafPointFieldData<CartesianPointValuesSource.MultiCartesianPointValues> load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.fieldName);
        if (info != null) {
            CartesianPointIndexFieldData.checkCompatible(info);
        }
        return new CartesianPointDVLeafFieldData(reader, this.fieldName, (ToScriptFieldFactory<CartesianPointValuesSource.MultiCartesianPointValues>)this.toScriptFieldFactory);
    }

    public LeafPointFieldData<CartesianPointValuesSource.MultiCartesianPointValues> loadDirect(LeafReaderContext context) {
        return this.load(context);
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != LatLonDocValuesField.TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + String.valueOf(fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + String.valueOf(LatLonDocValuesField.TYPE.docValuesType()) + ", is the field really a LatLonDocValuesField?");
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final ValuesSourceType valuesSourceType;
        private final ToScriptFieldFactory<CartesianPointValuesSource.MultiCartesianPointValues> toScriptFieldFactory;

        public Builder(String name, ValuesSourceType valuesSourceType, ToScriptFieldFactory<CartesianPointValuesSource.MultiCartesianPointValues> toScriptFieldFactory) {
            this.name = name;
            this.valuesSourceType = valuesSourceType;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new CartesianPointIndexFieldData(this.name, this.valuesSourceType, this.toScriptFieldFactory);
        }
    }
}

