/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.SearchInterval;

public class GetDatafeedRunningStateAction
extends ActionType<Response> {
    public static final GetDatafeedRunningStateAction INSTANCE = new GetDatafeedRunningStateAction();
    public static final String NAME = "cluster:internal/xpack/ml/datafeed/running_state";

    private GetDatafeedRunningStateAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse {
        private final Map<String, RunningState> datafeedRunningState;

        public static Response fromResponses(List<Response> responses) {
            return new Response(responses.stream().flatMap(r -> r.datafeedRunningState.entrySet().stream()).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        public static Response fromTaskAndState(String datafeedId, RunningState runningState) {
            return new Response(Map.of(datafeedId, runningState));
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.datafeedRunningState = in.readMap(RunningState::new);
        }

        public Response(Map<String, RunningState> runtimeStateMap) {
            super(null, null);
            this.datafeedRunningState = runtimeStateMap;
        }

        public Optional<RunningState> getRunningState(String datafeedId) {
            return Optional.ofNullable(this.datafeedRunningState.get(datafeedId));
        }

        public Map<String, RunningState> getDatafeedRunningState() {
            return this.datafeedRunningState;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.datafeedRunningState, StreamOutput::writeWriteable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.datafeedRunningState, response.datafeedRunningState);
        }

        public int hashCode() {
            return Objects.hash(this.datafeedRunningState);
        }

        public static class RunningState
        implements Writeable,
        ToXContentObject {
            private final boolean realTimeConfigured;
            private final boolean realTimeRunning;
            @Nullable
            private final SearchInterval searchInterval;

            public RunningState(boolean realTimeConfigured, boolean realTimeRunning, @Nullable SearchInterval searchInterval) {
                this.realTimeConfigured = realTimeConfigured;
                this.realTimeRunning = realTimeRunning;
                this.searchInterval = searchInterval;
            }

            public RunningState(StreamInput in) throws IOException {
                this.realTimeConfigured = in.readBoolean();
                this.realTimeRunning = in.readBoolean();
                this.searchInterval = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_1_0) ? (SearchInterval)in.readOptionalWriteable(SearchInterval::new) : null;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                RunningState that = (RunningState)o;
                return this.realTimeConfigured == that.realTimeConfigured && this.realTimeRunning == that.realTimeRunning && Objects.equals(this.searchInterval, that.searchInterval);
            }

            public int hashCode() {
                return Objects.hash(this.realTimeConfigured, this.realTimeRunning, this.searchInterval);
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeBoolean(this.realTimeConfigured);
                out.writeBoolean(this.realTimeRunning);
                if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_1_0)) {
                    out.writeOptionalWriteable((Writeable)this.searchInterval);
                }
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("real_time_configured", this.realTimeConfigured);
                builder.field("real_time_running", this.realTimeRunning);
                if (this.searchInterval != null) {
                    builder.field("search_interval", (ToXContent)this.searchInterval);
                }
                builder.endObject();
                return builder;
            }
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        private final Set<String> datafeedTaskIds;

        public Request(List<String> datafeedIds) {
            this.datafeedTaskIds = datafeedIds.stream().map(MlTasks::datafeedTaskId).collect(Collectors.toSet());
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.datafeedTaskIds = in.readCollectionAsSet(StreamInput::readString);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringCollection(this.datafeedTaskIds);
        }

        public Set<String> getDatafeedTaskIds() {
            return this.datafeedTaskIds;
        }

        public boolean match(Task task) {
            return task instanceof StartDatafeedAction.DatafeedTaskMatcher && this.datafeedTaskIds.contains(task.getDescription());
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format((String)"get_datafeed_running_state[%s]", (Object[])new Object[]{this.datafeedTaskIds}), parentTaskId, headers);
        }
    }
}

