/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.usage;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.action.admin.cluster.stats.SearchUsageStats;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.usage.SearchUsage;

public final class SearchUsageHolder {
    private final LongAdder totalSearchCount = new LongAdder();
    private final Map<String, LongAdder> queriesUsage = new ConcurrentHashMap<String, LongAdder>();
    private final Map<String, LongAdder> rescorersUsage = new ConcurrentHashMap<String, LongAdder>();
    private final Map<String, LongAdder> sectionsUsage = new ConcurrentHashMap<String, LongAdder>();
    private final Map<String, LongAdder> retrieversUsage = new ConcurrentHashMap<String, LongAdder>();

    SearchUsageHolder() {
    }

    public void updateUsage(SearchUsage searchUsage) {
        this.totalSearchCount.increment();
        for (String section : searchUsage.getSectionsUsage()) {
            this.sectionsUsage.computeIfAbsent(section, q -> new LongAdder()).increment();
        }
        for (String query : searchUsage.getQueryUsage()) {
            this.queriesUsage.computeIfAbsent(query, q -> new LongAdder()).increment();
        }
        for (String rescorer : searchUsage.getRescorerUsage()) {
            this.rescorersUsage.computeIfAbsent(rescorer, q -> new LongAdder()).increment();
        }
        for (String retriever : searchUsage.getRetrieverUsage()) {
            this.retrieversUsage.computeIfAbsent(retriever, q -> new LongAdder()).increment();
        }
    }

    public SearchUsageStats getSearchUsageStats() {
        Map queriesUsageMap = Maps.newMapWithExpectedSize(this.queriesUsage.size());
        this.queriesUsage.forEach((query, adder) -> queriesUsageMap.put(query, adder.longValue()));
        Map sectionsUsageMap = Maps.newMapWithExpectedSize(this.sectionsUsage.size());
        this.sectionsUsage.forEach((query, adder) -> sectionsUsageMap.put(query, adder.longValue()));
        Map rescorersUsageMap = Maps.newMapWithExpectedSize(this.rescorersUsage.size());
        this.rescorersUsage.forEach((query, adder) -> rescorersUsageMap.put(query, adder.longValue()));
        Map retrieversUsageMap = Maps.newMapWithExpectedSize(this.retrieversUsage.size());
        this.retrieversUsage.forEach((retriever, adder) -> retrieversUsageMap.put(retriever, adder.longValue()));
        return new SearchUsageStats(Collections.unmodifiableMap(queriesUsageMap), Collections.unmodifiableMap(rescorersUsageMap), Collections.unmodifiableMap(sectionsUsageMap), Collections.unmodifiableMap(retrieversUsageMap), this.totalSearchCount.longValue());
    }
}

