/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LeafRuntimeField;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractScriptFieldType<LeafFactory>
extends MappedFieldType {
    protected final Script script;
    private final Function<SearchLookup, LeafFactory> factory;
    private final boolean isResultDeterministic;
    protected static final Script DEFAULT_SCRIPT = new Script("");

    protected AbstractScriptFieldType(String name, Function<SearchLookup, LeafFactory> factory, Script script, boolean isResultDeterministic, Map<String, String> meta) {
        super(name, false, false, false, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
        this.factory = factory;
        this.script = Objects.requireNonNull(script);
        this.isResultDeterministic = isResultDeterministic;
    }

    @Override
    public final boolean isSearchable() {
        return true;
    }

    @Override
    public final boolean isAggregatable() {
        return true;
    }

    @Override
    public final Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        if (relation == ShapeRelation.DISJOINT) {
            String message = "Runtime field [%s] of type [%s] does not support DISJOINT ranges";
            throw new IllegalArgumentException(String.format(Locale.ROOT, message, this.name(), this.typeName()));
        }
        return this.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, parser, context);
    }

    protected abstract Query rangeQuery(Object var1, Object var2, boolean var3, boolean var4, ZoneId var5, DateMathParser var6, SearchExecutionContext var7);

    @Override
    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
        throw new IllegalArgumentException(this.unsupported("fuzzy", "keyword and text"));
    }

    @Override
    public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("prefix", "keyword, text and wildcard"));
    }

    @Override
    public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("wildcard", "keyword, text and wildcard"));
    }

    @Override
    public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("regexp", "keyword and text"));
    }

    @Override
    public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("phrase", "text"));
    }

    @Override
    public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("phrase", "text"));
    }

    @Override
    public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("phrase prefix", "text"));
    }

    @Override
    public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("span prefix", "text"));
    }

    private String unsupported(String query, String supported) {
        return String.format(Locale.ROOT, "Can only use %s queries on %s fields - not on [%s] which is a runtime field of type [%s]", query, supported, this.name(), this.typeName());
    }

    protected final void applyScriptContext(SearchExecutionContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("queries cannot be executed against runtime fields while [" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "] is set to [false].", new Object[0]);
        }
        if (!this.isResultDeterministic) {
            context.disableCache();
        }
    }

    @Override
    public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
        return new DocValueFetcher(this.docValueFormat(format, null), (IndexFieldData<?>)context.getForField(this, MappedFieldType.FielddataOperation.SEARCH), StoredFieldsSpec.NEEDS_SOURCE);
    }

    protected final LeafFactory leafFactory(SearchLookup searchLookup) {
        return this.factory.apply(searchLookup);
    }

    protected final LeafFactory leafFactory(SearchExecutionContext context) {
        return this.leafFactory(context.lookup().forkAndTrackFieldReferences(this.name()));
    }

    @Override
    public void validateMatchedRoutingPath(String routingPath) {
        throw new IllegalArgumentException("All fields that match routing_path must be configured with [time_series_dimension: true] or flattened fields with a list of dimensions in [time_series_dimensions] and without the [script] parameter. [" + this.name() + "] was a runtime [" + this.typeName() + "].");
    }

    @Override
    public final boolean fieldHasValue(FieldInfos fieldInfos) {
        return true;
    }

    protected static abstract class Builder<Factory>
    extends RuntimeField.Builder {
        private final ScriptContext<Factory> scriptContext;
        private final FieldMapper.Parameter<Script> script = new FieldMapper.Parameter<Script>("script", true, () -> null, RuntimeField::parseScript, RuntimeField.initializerNotSupported(), XContentBuilder::field, Objects::toString).setSerializerCheck((id, ic, v) -> ic);
        private final FieldMapper.Parameter<OnScriptError> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> m.builderParams.onScriptError(), this.script);

        protected Builder(String name, ScriptContext<Factory> scriptContext) {
            super(name);
            this.scriptContext = scriptContext;
        }

        protected abstract Factory getParseFromSourceFactory();

        protected abstract Factory getCompositeLeafFactory(Function<SearchLookup, CompositeFieldScript.LeafFactory> var1);

        @Override
        protected final RuntimeField createRuntimeField(MappingParserContext parserContext) {
            if (this.script.get() == null) {
                return this.createRuntimeField(this.getParseFromSourceFactory(), parserContext.indexVersionCreated());
            }
            Factory factory = parserContext.scriptCompiler().compile(this.script.getValue(), this.scriptContext);
            return this.createRuntimeField(factory, parserContext.indexVersionCreated());
        }

        @Override
        protected final RuntimeField createChildRuntimeField(MappingParserContext parserContext, String parent, Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory, OnScriptError onScriptError) {
            if (this.script.isConfigured()) {
                throw new IllegalArgumentException("Cannot use [script] parameter on sub-field [" + this.name + "] of composite field [" + parent + "]");
            }
            String fullName = parent + "." + this.name;
            return new LeafRuntimeField(this.name, this.createFieldType(fullName, this.getCompositeLeafFactory(parentScriptFactory), this.getScript(), this.meta(), onScriptError), this.getParameters());
        }

        final RuntimeField createRuntimeField(Factory scriptFactory) {
            return this.createRuntimeField(scriptFactory, IndexVersion.current());
        }

        final RuntimeField createRuntimeField(Factory scriptFactory, IndexVersion indexVersion) {
            AbstractScriptFieldType<?> fieldType = this.createFieldType(this.name, scriptFactory, this.getScript(), this.meta(), indexVersion, this.onScriptError.get());
            return new LeafRuntimeField(this.name, fieldType, this.getParameters());
        }

        protected abstract AbstractScriptFieldType<?> createFieldType(String var1, Factory var2, Script var3, Map<String, String> var4, OnScriptError var5);

        protected AbstractScriptFieldType<?> createFieldType(String name, Factory factory, Script script, Map<String, String> meta, IndexVersion supportedVersion, OnScriptError onScriptError) {
            return this.createFieldType(name, factory, script, meta, onScriptError);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            ArrayList parameters = new ArrayList(super.getParameters());
            parameters.add(this.script);
            parameters.add(this.onScriptError);
            return Collections.unmodifiableList(parameters);
        }

        protected final Script getScript() {
            if (this.script.get() == null) {
                return DEFAULT_SCRIPT;
            }
            return this.script.get();
        }
    }
}

