/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;

public class DataTier {
    public static final String DATA_CONTENT = "data_content";
    public static final String DATA_HOT = "data_hot";
    public static final String DATA_WARM = "data_warm";
    public static final String DATA_COLD = "data_cold";
    public static final String DATA_FROZEN = "data_frozen";
    public static final Set<String> ALL_DATA_TIERS = Set.of("data_content", "data_hot", "data_warm", "data_cold", "data_frozen");
    public static final String ENFORCE_DEFAULT_TIER_PREFERENCE = "cluster.routing.allocation.enforce_default_tier_preference";
    public static final Setting<Boolean> ENFORCE_DEFAULT_TIER_PREFERENCE_SETTING = Setting.boolSetting("cluster.routing.allocation.enforce_default_tier_preference", true, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning);
    public static final String TIER_PREFERENCE = "index.routing.allocation.include._tier_preference";
    private static final Settings DATA_CONTENT_TIER_PREFERENCE_SETTINGS = Settings.builder().put("index.routing.allocation.include._tier_preference", "data_content").build();
    private static final Settings DATA_HOT_TIER_PREFERENCE_SETTINGS = Settings.builder().put("index.routing.allocation.include._tier_preference", "data_hot").build();
    private static final Settings NULL_TIER_PREFERENCE_SETTINGS = Settings.builder().putNull("index.routing.allocation.include._tier_preference").build();
    public static final Setting<String> TIER_PREFERENCE_SETTING = new Setting<String>("index.routing.allocation.include._tier_preference", DataTierSettingValidator::getDefaultTierPreference, Function.identity(), new DataTierSettingValidator(), Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final List<String> ORDERED_FROZEN_TO_HOT_TIERS;
    private static final Map<String, String> PREFERENCE_TIER_CONFIGURATIONS;
    private static final Map<String, Settings> PREFERENCE_TIER_CONFIGURATION_SETTINGS;

    public static boolean validTierName(String tierName) {
        return ALL_DATA_TIERS.contains(tierName);
    }

    public static String getPreferredTiersConfiguration(String targetTier) {
        String res = PREFERENCE_TIER_CONFIGURATIONS.get(targetTier);
        if (res == null) {
            throw new IllegalArgumentException("invalid data tier [" + targetTier + "]");
        }
        return res;
    }

    public static Settings getPreferredTiersConfigurationSettings(String targetTier) {
        Settings res = PREFERENCE_TIER_CONFIGURATION_SETTINGS.get(targetTier);
        if (res == null) {
            throw new IllegalArgumentException("invalid data tier [" + targetTier + "]");
        }
        return res;
    }

    public static boolean isContentNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_CONTENT_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isHotNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_HOT_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isWarmNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_WARM_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isColdNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_COLD_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isFrozenNode(DiscoveryNode discoveryNode) {
        return DataTier.isFrozenNode(discoveryNode.getRoles());
    }

    public static boolean isFrozenNode(Set<DiscoveryNodeRole> roles) {
        return roles.contains(DiscoveryNodeRole.DATA_FROZEN_NODE_ROLE) || roles.contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static List<String> parseTierList(String tiers) {
        if (!Strings.hasText(tiers)) {
            return List.of();
        }
        return List.of(tiers.split(","));
    }

    public static int compare(String tier1, String tier2) {
        if (tier1.equals(DATA_CONTENT)) {
            tier1 = DATA_HOT;
        }
        if (tier2.equals(DATA_CONTENT)) {
            tier2 = DATA_HOT;
        }
        int indexOfTier1 = ORDERED_FROZEN_TO_HOT_TIERS.indexOf(tier1);
        assert (indexOfTier1 >= 0) : "expecting a valid tier to compare but got:" + tier1;
        int indexOfTier2 = ORDERED_FROZEN_TO_HOT_TIERS.indexOf(tier2);
        assert (indexOfTier2 >= 0) : "expecting a valid tier to compare but got:" + tier2;
        if (indexOfTier1 == indexOfTier2) {
            return 0;
        }
        return indexOfTier1 < indexOfTier2 ? -1 : 1;
    }

    static {
        for (String tier : ALL_DATA_TIERS) {
            assert (tier.equals(DATA_FROZEN) || !tier.contains(DATA_FROZEN)) : "can't have two tier names containing [data_frozen] because it would break setting validation optimizations in the data tier allocation decider";
        }
        ORDERED_FROZEN_TO_HOT_TIERS = List.of(DATA_FROZEN, DATA_COLD, DATA_WARM, DATA_HOT);
        HashMap<String, String> tmp = new HashMap<String, String>();
        HashMap<String, Settings> tmpSettings = new HashMap<String, Settings>();
        int ordered_frozen_to_hot_tiersSize = ORDERED_FROZEN_TO_HOT_TIERS.size();
        for (int i = 0; i < ordered_frozen_to_hot_tiersSize; ++i) {
            String tier = ORDERED_FROZEN_TO_HOT_TIERS.get(i);
            if (tier.equals(DATA_FROZEN)) {
                tmp.put(tier, DATA_FROZEN);
                tmpSettings.put(DATA_FROZEN, Settings.builder().put(TIER_PREFERENCE, DATA_FROZEN).build());
                continue;
            }
            String prefTierString = String.join((CharSequence)",", ORDERED_FROZEN_TO_HOT_TIERS.subList(i, ORDERED_FROZEN_TO_HOT_TIERS.size())).intern();
            tmp.put(tier, prefTierString);
            tmpSettings.put(tier, Settings.builder().put(TIER_PREFERENCE, prefTierString).build());
        }
        PREFERENCE_TIER_CONFIGURATIONS = Map.copyOf(tmp);
        PREFERENCE_TIER_CONFIGURATION_SETTINGS = Map.copyOf(tmpSettings);
    }

    static final class DataTierSettingValidator
    implements Setting.Validator<String> {
        private static final Collection<Setting<?>> dependencies = List.of(IndexModule.INDEX_STORE_TYPE_SETTING, SearchableSnapshotsSettings.SNAPSHOT_PARTIAL_SETTING);

        DataTierSettingValidator() {
        }

        public static String getDefaultTierPreference(Settings settings) {
            if (SearchableSnapshotsSettings.isPartialSearchableSnapshotIndex(settings)) {
                return DataTier.DATA_FROZEN;
            }
            return "";
        }

        @Override
        public void validate(String value) {
            if (Strings.hasText(value)) {
                for (String s : DataTier.parseTierList(value)) {
                    if (DataTier.validTierName(s)) continue;
                    throw new IllegalArgumentException("invalid tier names found in [" + value + "] allowed values are " + String.valueOf(ALL_DATA_TIERS));
                }
            }
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings, boolean exists) {
            if (exists && value != null) {
                if (SearchableSnapshotsSettings.isPartialSearchableSnapshotIndex(settings)) {
                    if (!value.equals(DataTier.DATA_FROZEN)) {
                        throw new IllegalArgumentException("only the [data_frozen] tier preference may be used for partial searchable snapshots (got: [" + value + "])");
                    }
                } else if (value.contains(DataTier.DATA_FROZEN)) {
                    throw new IllegalArgumentException("[data_frozen] tier can only be used for partial searchable snapshots");
                }
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            return dependencies.iterator();
        }
    }

    public static class DefaultHotAllocationSettingProvider
    implements IndexSettingProvider {
        private static final Logger logger = LogManager.getLogger(DefaultHotAllocationSettingProvider.class);

        @Override
        public Settings getAdditionalIndexSettings(String indexName, @Nullable String dataStreamName, IndexMode templateIndexMode, Metadata metadata, Instant resolvedAt, Settings indexTemplateAndCreateRequestSettings, List<CompressedXContent> combinedTemplateMappings) {
            Set<String> settings = indexTemplateAndCreateRequestSettings.keySet();
            if (settings.contains(DataTier.TIER_PREFERENCE)) {
                return NULL_TIER_PREFERENCE_SETTINGS;
            }
            if (settings.stream().anyMatch(s -> s.startsWith("index.routing.allocation.require.")) || settings.stream().anyMatch(s -> s.startsWith("index.routing.allocation.exclude.")) || settings.stream().anyMatch(s -> s.startsWith("index.routing.allocation.include."))) {
                logger.debug("index [{}] specifies custom index level routing filtering, skipping tier allocation", (Object)indexName);
                return Settings.EMPTY;
            }
            if (dataStreamName != null) {
                return DATA_HOT_TIER_PREFERENCE_SETTINGS;
            }
            return DATA_CONTENT_TIER_PREFERENCE_SETTINGS;
        }
    }
}

