/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;

public abstract class Attribute
extends NamedExpression {
    protected static final String SYNTHETIC_ATTRIBUTE_NAME_PREFIX = "$$";
    private final Nullability nullability;

    public Attribute(Source source, String name, @Nullable NameId id) {
        this(source, name, Nullability.TRUE, id);
    }

    public Attribute(Source source, String name, Nullability nullability, @Nullable NameId id) {
        this(source, name, nullability, id, false);
    }

    public Attribute(Source source, String name, Nullability nullability, @Nullable NameId id, boolean synthetic) {
        super(source, name, Collections.emptyList(), id, synthetic);
        this.nullability = nullability;
    }

    public static String rawTemporaryName(String ... parts) {
        String name = String.join((CharSequence)"$", parts);
        return name.isEmpty() || name.startsWith(SYNTHETIC_ATTRIBUTE_NAME_PREFIX) ? name : SYNTHETIC_ATTRIBUTE_NAME_PREFIX + name;
    }

    @Override
    public final Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    @Override
    public Nullability nullable() {
        return this.nullability;
    }

    @Override
    public AttributeSet references() {
        return AttributeSet.of(this);
    }

    public Attribute withLocation(Source source) {
        return Objects.equals(this.source(), source) ? this : this.clone(source, this.name(), this.dataType(), this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withName(String name) {
        return Objects.equals(this.name(), name) ? this : this.clone(this.source(), name, this.dataType(), this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withNullability(Nullability nullability) {
        return Objects.equals((Object)this.nullable(), (Object)nullability) ? this : this.clone(this.source(), this.name(), this.dataType(), nullability, this.id(), this.synthetic());
    }

    public Attribute withId(NameId id) {
        return this.clone(this.source(), this.name(), this.dataType(), this.nullable(), id, this.synthetic());
    }

    public Attribute withDataType(DataType type) {
        return Objects.equals((Object)this.dataType(), (Object)type) ? this : this.clone(this.source(), this.name(), type, this.nullable(), this.id(), this.synthetic());
    }

    protected abstract Attribute clone(Source var1, String var2, DataType var3, Nullability var4, NameId var5, boolean var6);

    @Override
    public Attribute toAttribute() {
        return this;
    }

    @Override
    public int semanticHash() {
        return this.id().hashCode();
    }

    @Override
    public boolean semanticEquals(Expression other) {
        return other instanceof Attribute ? this.id().equals(((Attribute)other).id()) : false;
    }

    @Override
    protected Expression canonicalize() {
        return this.clone(Source.EMPTY, this.name(), this.dataType(), this.nullability, this.id(), this.synthetic());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.nullability});
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Attribute other = (Attribute)obj;
            return Objects.equals((Object)this.nullability, (Object)other.nullability);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.name() + "{" + this.label() + (this.synthetic() ? "$" : "") + "}#" + String.valueOf(this.id());
    }

    @Override
    public String nodeString() {
        return this.toString();
    }

    protected abstract String label();
}

