/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.scheduling;

import java.time.Duration;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.transform.Transform;

public final class TransformSchedulingUtils {
    private static final long MIN_DELAY_MILLIS = Duration.ofSeconds(5L).toMillis();
    private static final long MAX_DELAY_MILLIS = Duration.ofHours(1L).toMillis();

    public static long calculateNextScheduledTime(Long lastTriggeredTimeMillis, TimeValue frequency, int failureCount) {
        long baseTime;
        long l = baseTime = lastTriggeredTimeMillis != null ? lastTriggeredTimeMillis : System.currentTimeMillis();
        if (failureCount == 0) {
            return baseTime + (frequency != null ? frequency : Transform.DEFAULT_TRANSFORM_FREQUENCY).millis();
        }
        long delayMillis = Math.min(Math.max((1L << Math.min(failureCount, 32)) * 1000L, MIN_DELAY_MILLIS), MAX_DELAY_MILLIS);
        return baseTime + delayMillis;
    }
}

