/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformStatePersistenceException;

public class IndexBasedTransformConfigManager
implements TransformConfigManager {
    private static final Logger logger = LogManager.getLogger(IndexBasedTransformConfigManager.class);
    private static final int MAX_RESULTS_WINDOW = 10000;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    public IndexBasedTransformConfigManager(ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, Client client, NamedXContentRegistry xContentRegistry) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    public void putTransformCheckpoint(TransformCheckpoint checkpoint, ActionListener<Boolean> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot store Transform while the Transform feature is upgrading."));
            return;
        }
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            XContentBuilder source = checkpoint.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(TO_XCONTENT_PARAMS));
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(".transform-internal-007").opType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(TransformCheckpoint.documentId((String)checkpoint.getTransformId(), (long)checkpoint.getCheckpoint())).source(source);
            this.executeAsyncWithOrigin(TransportIndexAction.TYPE, indexRequest, listener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)true)));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    @Override
    public void putTransformConfiguration(TransformConfig transformConfig, ActionListener<Boolean> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot store Transform while the Transform feature is upgrading."));
            return;
        }
        this.putTransformConfiguration(transformConfig, DocWriteRequest.OpType.CREATE, null, listener);
    }

    @Override
    public void updateTransformConfiguration(TransformConfig transformConfig, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ActionListener<Boolean> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot update Transform while the Transform feature is upgrading."));
            return;
        }
        if (this.isLatestTransformIndex(seqNoPrimaryTermAndIndex.getIndex())) {
            this.putTransformConfiguration(transformConfig, DocWriteRequest.OpType.INDEX, seqNoPrimaryTermAndIndex, listener);
        } else {
            this.putTransformConfiguration(transformConfig, DocWriteRequest.OpType.CREATE, null, listener);
        }
    }

    @Override
    public boolean isLatestTransformIndex(String indexName) {
        if (".transform-internal-007".equals(indexName)) {
            return true;
        }
        Metadata metadata = this.clusterService.state().metadata();
        Set indicesForAlias = metadata.aliasedIndices(".transform-internal-007");
        IndexMetadata index = metadata.index(indexName);
        return index != null && indicesForAlias.contains(index.getIndex());
    }

    @Override
    public void deleteOldTransformConfigurations(String transformId, ActionListener<Boolean> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot delete Transform while the Transform feature is upgrading."));
            return;
        }
        DeleteByQueryRequest deleteByQueryRequest = IndexBasedTransformConfigManager.createDeleteByQueryRequest();
        deleteByQueryRequest.indices(new String[]{".transform-internal-*", ".data-frame-internal-*"});
        deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"_index", (String)".transform-internal-007")).filter((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)TransformConfig.documentId((String)transformId)))));
        this.executeAsyncWithOrigin((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, (ActionListener)listener.delegateFailureAndWrap((l, response) -> {
            if (!(response.getBulkFailures().isEmpty() && response.getSearchFailures().isEmpty())) {
                Tuple<RestStatus, Throwable> statusAndReason = IndexBasedTransformConfigManager.getStatusAndReason(response);
                l.onFailure((Exception)new ElasticsearchStatusException(((Throwable)statusAndReason.v2()).getMessage(), (RestStatus)statusAndReason.v1(), (Throwable)statusAndReason.v2(), new Object[0]));
                return;
            }
            l.onResponse((Object)true);
        }));
    }

    @Override
    public void deleteOldTransformStoredDocuments(String transformId, ActionListener<Long> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot delete Transform while the Transform feature is upgrading."));
            return;
        }
        DeleteByQueryRequest deleteByQueryRequest = IndexBasedTransformConfigManager.createDeleteByQueryRequest();
        deleteByQueryRequest.indices(new String[]{".transform-internal-*", ".data-frame-internal-*"});
        deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"_index", (String)".transform-internal-007")).filter((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)TransformStoredDoc.documentId((String)transformId)))));
        this.deleteByQuery(listener, deleteByQueryRequest);
    }

    @Override
    public void deleteOldCheckpoints(String transformId, long deleteCheckpointsBelow, long deleteOlderThan, ActionListener<Long> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot delete checkpoints while the Transform feature is upgrading."));
            return;
        }
        DeleteByQueryRequest deleteByQueryRequest = IndexBasedTransformConfigManager.createDeleteByQueryRequest();
        deleteByQueryRequest.indices(new String[]{".transform-internal-*", ".data-frame-internal-*"});
        deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.ID.getPreferredName(), (String)transformId)).filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_checkpoint")).filter((QueryBuilder)QueryBuilders.rangeQuery((String)TransformCheckpoint.CHECKPOINT.getPreferredName()).lt((Object)deleteCheckpointsBelow)).filter((QueryBuilder)QueryBuilders.rangeQuery((String)TransformField.TIMESTAMP_MILLIS.getPreferredName()).lt((Object)deleteOlderThan).format("epoch_millis")));
        logger.debug("Deleting old checkpoints using {}", (Object)deleteByQueryRequest.getSearchRequest());
        this.deleteByQuery(listener, deleteByQueryRequest);
    }

    private void deleteByQuery(ActionListener<Long> listener, DeleteByQueryRequest deleteByQueryRequest) {
        this.executeAsyncWithOrigin((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, (ActionListener)listener.delegateFailureAndWrap((l, response) -> {
            if (!(response.getBulkFailures().isEmpty() && response.getSearchFailures().isEmpty())) {
                Tuple<RestStatus, Throwable> statusAndReason = IndexBasedTransformConfigManager.getStatusAndReason(response);
                l.onFailure((Exception)new ElasticsearchStatusException(((Throwable)statusAndReason.v2()).getMessage(), (RestStatus)statusAndReason.v1(), (Throwable)statusAndReason.v2(), new Object[0]));
                return;
            }
            l.onResponse((Object)response.getDeleted());
        }));
    }

    @Override
    public void deleteOldIndices(ActionListener<Boolean> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot delete internal indices while the Transform feature is upgrading."));
            return;
        }
        ClusterState state = this.clusterService.state();
        HashSet<String> indicesToDelete = new HashSet<String>();
        try (ThreadContext.StoredContext ctx = this.client.threadPool().getThreadContext().stashWithOrigin("transform");){
            indicesToDelete.addAll(Arrays.asList(this.indexNameExpressionResolver.concreteIndexNames(state, IndicesOptions.lenientExpandHidden(), new String[]{".transform-internal-*"})));
            indicesToDelete.addAll(Arrays.asList(this.indexNameExpressionResolver.concreteIndexNames(state, IndicesOptions.lenientExpandHidden(), new String[]{".data-frame-internal-*"})));
            indicesToDelete.remove(".transform-internal-007");
        }
        if (indicesToDelete.isEmpty()) {
            listener.onResponse((Object)true);
            return;
        }
        DeleteIndexRequest deleteRequest = new DeleteIndexRequest(indicesToDelete.toArray(new String[0])).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        this.executeAsyncWithOrigin(TransportDeleteIndexAction.TYPE, deleteRequest, listener.delegateFailureAndWrap((l, response) -> {
            if (!response.isAcknowledged()) {
                l.onFailure((Exception)new ElasticsearchStatusException("Failed to delete internal indices", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                return;
            }
            l.onResponse((Object)true);
        }));
    }

    private void putTransformConfiguration(TransformConfig transformConfig, DocWriteRequest.OpType opType, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ActionListener<Boolean> listener) {
        assert (DocWriteRequest.OpType.CREATE.equals((Object)opType) || DocWriteRequest.OpType.INDEX.equals((Object)opType));
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            XContentBuilder source = transformConfig.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(TO_XCONTENT_PARAMS));
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(".transform-internal-007").opType(opType).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(TransformConfig.documentId((String)transformConfig.getId())).source(source);
            if (seqNoPrimaryTermAndIndex != null) {
                indexRequest.setIfSeqNo(seqNoPrimaryTermAndIndex.getSeqNo()).setIfPrimaryTerm(seqNoPrimaryTermAndIndex.getPrimaryTerm());
            }
            this.executeAsyncWithOrigin(TransportIndexAction.TYPE, indexRequest, ActionListener.wrap(r -> listener.onResponse((Object)true), e -> {
                if (e instanceof VersionConflictEngineException) {
                    if (DocWriteRequest.OpType.CREATE.equals((Object)opType)) {
                        listener.onFailure((Exception)new ResourceAlreadyExistsException(TransformMessages.getMessage((String)"Transform with id [{0}] already exists", (Object[])new Object[]{transformConfig.getId()}), new Object[0]));
                    } else {
                        listener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Cannot update transform id [{0}] due to a concurrent update conflict. Please retry.", (Object[])new Object[]{transformConfig.getId()}), RestStatus.CONFLICT, new Object[0]));
                    }
                } else {
                    listener.onFailure((Exception)new RuntimeException("Failed to persist transform configuration", (Throwable)e));
                }
            }));
        }
        catch (IOException e2) {
            listener.onFailure((Exception)new ElasticsearchParseException(TransformMessages.getMessage((String)"Failed to serialise transform [{0}]", (Object[])new Object[]{transformConfig.getId()}), (Throwable)e2, new Object[0]));
        }
    }

    @Override
    public void getTransformCheckpoint(String transformId, long checkpoint, ActionListener<TransformCheckpoint> resultListener) {
        TermQueryBuilder queryBuilder = QueryBuilders.termQuery((String)"_id", (String)TransformCheckpoint.documentId((String)transformId, (long)checkpoint));
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setQuery((QueryBuilder)queryBuilder).addSort("_index", SortOrder.DESC).setSize(1).setAllowPartialSearchResults(false).request();
        this.executeAsyncWithOrigin(TransportSearchAction.TYPE, searchRequest, resultListener.delegateFailureAndWrap((l, searchResponse) -> {
            if (searchResponse.getHits().getHits().length == 0) {
                logger.trace("found no checkpoint for transform [{}], returning empty checkpoint", (Object)transformId);
                l.onResponse((Object)TransformCheckpoint.EMPTY);
                return;
            }
            BytesReference source = searchResponse.getHits().getHits()[0].getSourceRef();
            this.parseCheckpointsLenientlyFromSource(source, transformId, (ActionListener<TransformCheckpoint>)l);
        }));
    }

    @Override
    public void getTransformCheckpointForUpdate(String transformId, long checkpoint, ActionListener<Tuple<TransformCheckpoint, SeqNoPrimaryTermAndIndex>> checkpointAndVersionListener) {
        TermQueryBuilder queryBuilder = QueryBuilders.termQuery((String)"_id", (String)TransformCheckpoint.documentId((String)transformId, (long)checkpoint));
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setQuery((QueryBuilder)queryBuilder).addSort("_index", SortOrder.DESC).setSize(1).seqNoAndPrimaryTerm(true).setAllowPartialSearchResults(false).request();
        this.executeAsyncWithOrigin(TransportSearchAction.TYPE, searchRequest, checkpointAndVersionListener.delegateFailureAndWrap((l, searchResponse) -> {
            if (searchResponse.getHits().getHits().length == 0) {
                l.onResponse(null);
                return;
            }
            SearchHit hit = searchResponse.getHits().getHits()[0];
            BytesReference source = searchResponse.getHits().getHits()[0].getSourceRef();
            this.parseCheckpointsLenientlyFromSource(source, transformId, (ActionListener<TransformCheckpoint>)l.delegateFailureAndWrap((ll, parsedCheckpoint) -> ll.onResponse((Object)Tuple.tuple((Object)parsedCheckpoint, (Object)new SeqNoPrimaryTermAndIndex(hit.getSeqNo(), hit.getPrimaryTerm(), hit.getIndex())))));
        }));
    }

    @Override
    public void getTransformConfiguration(String transformId, ActionListener<TransformConfig> resultListener) {
        TermQueryBuilder queryBuilder = QueryBuilders.termQuery((String)"_id", (String)TransformConfig.documentId((String)transformId));
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setQuery((QueryBuilder)queryBuilder).addSort("_index", SortOrder.DESC).setSize(1).setAllowPartialSearchResults(false).request();
        this.executeAsyncWithOrigin(TransportSearchAction.TYPE, searchRequest, resultListener.delegateFailureAndWrap((l, searchResponse) -> {
            if (searchResponse.getHits().getHits().length == 0) {
                l.onFailure((Exception)new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{transformId}), new Object[0]));
                return;
            }
            BytesReference source = searchResponse.getHits().getHits()[0].getSourceRef();
            this.parseTransformLenientlyFromSource(source, transformId, (ActionListener<TransformConfig>)l);
        }));
    }

    @Override
    public void getTransformConfigurationForUpdate(String transformId, ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>> configAndVersionListener) {
        TermQueryBuilder queryBuilder = QueryBuilders.termQuery((String)"_id", (String)TransformConfig.documentId((String)transformId));
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setQuery((QueryBuilder)queryBuilder).addSort("_index", SortOrder.DESC).setSize(1).setAllowPartialSearchResults(false).seqNoAndPrimaryTerm(true).request();
        this.executeAsyncWithOrigin(TransportSearchAction.TYPE, searchRequest, configAndVersionListener.delegateFailureAndWrap((l, searchResponse) -> {
            if (searchResponse.getHits().getHits().length == 0) {
                l.onFailure((Exception)new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{transformId}), new Object[0]));
                return;
            }
            SearchHit hit = searchResponse.getHits().getHits()[0];
            BytesReference source = hit.getSourceRef();
            this.parseTransformLenientlyFromSource(source, transformId, (ActionListener<TransformConfig>)l.delegateFailureAndWrap((ll, config) -> ll.onResponse((Object)Tuple.tuple((Object)config, (Object)new SeqNoPrimaryTermAndIndex(hit.getSeqNo(), hit.getPrimaryTerm(), hit.getIndex())))));
        }));
    }

    @Override
    public void expandTransformIds(String transformIdsExpression, PageParams pageParams, TimeValue timeout, boolean allowNoMatch, ActionListener<Tuple<Long, Tuple<List<String>, List<TransformConfig>>>> foundConfigsListener) {
        String[] idTokens = ExpandedIdsMatcher.tokenizeExpression((String)transformIdsExpression);
        QueryBuilder queryBuilder = IndexBasedTransformConfigManager.buildQueryFromTokenizedIds(idTokens, "data_frame_transform_config");
        SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).addSort(TransformField.ID.getPreferredName(), SortOrder.ASC).addSort("_index", SortOrder.DESC).setFrom(pageParams.getFrom()).setTrackTotalHits(true).setSize(pageParams.getSize()).setTimeout(timeout).setQuery(queryBuilder).request();
        ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(idTokens, allowNoMatch);
        this.executeAsyncWithOrigin(request, foundConfigsListener.delegateFailureAndWrap((l, searchResponse) -> {
            long totalHits = searchResponse.getHits().getTotalHits().value();
            LinkedHashSet ids = Sets.newLinkedHashSetWithExpectedSize((int)searchResponse.getHits().getHits().length);
            LinkedHashSet configs = Sets.newLinkedHashSetWithExpectedSize((int)searchResponse.getHits().getHits().length);
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                try (XContentParser parser = this.createParser(hit);){
                    TransformConfig config = TransformConfig.fromXContent((XContentParser)parser, null, (boolean)true);
                    if (!ids.add(config.getId())) continue;
                    configs.add(config);
                }
                catch (IOException e) {
                    l.onFailure((Exception)new ElasticsearchParseException("failed to parse search hit for ids", (Throwable)e, new Object[0]));
                    return;
                }
            }
            requiredMatches.filterMatchedIds((Collection)ids);
            if (requiredMatches.hasUnmatchedIds()) {
                l.onFailure((Exception)new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{requiredMatches.unmatchedIdsString()}), new Object[0]));
                return;
            }
            if (requiredMatches.isOnlyExact()) {
                l.onResponse((Object)new Tuple((Object)ids.size(), (Object)Tuple.tuple(new ArrayList(ids), new ArrayList(configs))));
            } else {
                l.onResponse((Object)new Tuple((Object)totalHits, (Object)Tuple.tuple(new ArrayList(ids), new ArrayList(configs))));
            }
        }), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private XContentParser createParser(BytesReference source) throws IOException {
        return XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG.withRegistry(this.xContentRegistry), (BytesReference)source, (XContentType)XContentType.JSON);
    }

    private XContentParser createParser(SearchHit hit) throws IOException {
        return this.createParser(hit.getSourceRef());
    }

    @Override
    public void getAllTransformIds(TimeValue timeout, ActionListener<Set<String>> listener) {
        this.expandAllTransformIds(false, 10000, timeout, (ActionListener<Tuple<Long, Set<String>>>)listener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)((Set)r.v2()))));
    }

    @Override
    public void getAllOutdatedTransformIds(TimeValue timeout, ActionListener<Tuple<Long, Set<String>>> listener) {
        this.expandAllTransformIds(true, 10000, timeout, listener);
    }

    @Override
    public void resetTransform(String transformId, ActionListener<Boolean> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot reset Transform while the Transform feature is upgrading."));
            return;
        }
        ActionListener deleteListener = ActionListener.wrap(dbqResponse -> listener.onResponse((Object)true), e -> {
            if (e.getClass() == IndexNotFoundException.class) {
                listener.onFailure((Exception)new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{transformId}), new Object[0]));
            } else {
                listener.onFailure(e);
            }
        });
        SearchRequest searchRequest = new SearchRequest().indices(new String[]{".transform-internal-*", ".data-frame-internal-*"}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)TransformField.ID.getPreferredName(), (String)transformId)).trackTotalHitsUpTo(1));
        this.executeAsyncWithOrigin(TransportSearchAction.TYPE, searchRequest, deleteListener.delegateFailureAndWrap((l, searchResponse) -> {
            if (searchResponse.getHits().getTotalHits().value() == 0L) {
                listener.onFailure((Exception)new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{transformId}), new Object[0]));
                return;
            }
            ConstantScoreQueryBuilder dbqQuery = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.ID.getPreferredName(), (String)transformId)).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)TransformConfig.documentId((String)transformId))));
            DeleteByQueryRequest dbqRequest = (DeleteByQueryRequest)IndexBasedTransformConfigManager.createDeleteByQueryRequest().indices(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setQuery((QueryBuilder)dbqQuery).setRefresh(true);
            this.executeAsyncWithOrigin((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)dbqRequest, (ActionListener)l);
        }));
    }

    @Override
    public void deleteTransform(String transformId, ActionListener<Boolean> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot delete Transform while the Transform feature is upgrading."));
            return;
        }
        DeleteByQueryRequest request = IndexBasedTransformConfigManager.createDeleteByQueryRequest();
        request.indices(new String[]{".transform-internal-*", ".data-frame-internal-*"});
        TermQueryBuilder query = QueryBuilders.termQuery((String)TransformField.ID.getPreferredName(), (String)transformId);
        request.setQuery((QueryBuilder)query);
        request.setRefresh(true);
        this.executeAsyncWithOrigin((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(deleteResponse -> {
            if (deleteResponse.getDeleted() == 0L) {
                listener.onFailure((Exception)new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{transformId}), new Object[0]));
                return;
            }
            listener.onResponse((Object)true);
        }, e -> {
            if (e.getClass() == IndexNotFoundException.class) {
                listener.onFailure((Exception)new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{transformId}), new Object[0]));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    @Override
    public void putOrUpdateTransformStoredDoc(TransformStoredDoc storedDoc, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ActionListener<SeqNoPrimaryTermAndIndex> listener) {
        if (this.isUpgrading()) {
            listener.onFailure(this.conflictStatusException("Cannot store Transform while the Transform feature is upgrading."));
            return;
        }
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            XContentBuilder source = storedDoc.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(TO_XCONTENT_PARAMS));
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(".transform-internal-007").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(TransformStoredDoc.documentId((String)storedDoc.getId())).source(source);
            if (seqNoPrimaryTermAndIndex != null) {
                indexRequest.opType(DocWriteRequest.OpType.INDEX);
                if (this.isLatestTransformIndex(seqNoPrimaryTermAndIndex.getIndex())) {
                    indexRequest.setIfSeqNo(seqNoPrimaryTermAndIndex.getSeqNo()).setIfPrimaryTerm(seqNoPrimaryTermAndIndex.getPrimaryTerm());
                }
            } else {
                indexRequest.opType(DocWriteRequest.OpType.CREATE);
            }
            this.executeAsyncWithOrigin(TransportIndexAction.TYPE, indexRequest, ActionListener.wrap(r -> listener.onResponse((Object)SeqNoPrimaryTermAndIndex.fromIndexResponse(r)), e -> listener.onFailure((Exception)new TransformStatePersistenceException(TransformMessages.getMessage((String)"Failed to persist transform statistics for transform [{0}]", (Object[])new Object[]{storedDoc.getId()}), (Throwable)e))));
        }
        catch (IOException e2) {
            listener.onFailure((Exception)new ElasticsearchParseException(TransformMessages.getMessage((String)"Failed to persist transform statistics for transform [{0}]", (Object[])new Object[]{storedDoc.getId()}), (Throwable)e2, new Object[0]));
        }
    }

    @Override
    public void getTransformStoredDoc(String transformId, boolean allowNoMatch, ActionListener<Tuple<TransformStoredDoc, SeqNoPrimaryTermAndIndex>> resultListener) {
        TermQueryBuilder queryBuilder = QueryBuilders.termQuery((String)"_id", (String)TransformStoredDoc.documentId((String)transformId));
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setQuery((QueryBuilder)queryBuilder).addSort("_index", SortOrder.DESC).setSize(1).setAllowPartialSearchResults(false).seqNoAndPrimaryTerm(true).request();
        this.executeAsyncWithOrigin(TransportSearchAction.TYPE, searchRequest, resultListener.delegateFailureAndWrap((l, searchResponse) -> {
            if (searchResponse.getHits().getHits().length == 0) {
                if (allowNoMatch) {
                    l.onResponse(null);
                } else {
                    l.onFailure((Exception)new ResourceNotFoundException(TransformMessages.getMessage((String)"Statistics for transform [{0}] could not be found", (Object[])new Object[]{transformId}), new Object[0]));
                }
                return;
            }
            SearchHit searchHit = searchResponse.getHits().getHits()[0];
            try (XContentParser parser = this.createParser(searchHit);){
                resultListener.onResponse((Object)Tuple.tuple((Object)TransformStoredDoc.fromXContent((XContentParser)parser), (Object)SeqNoPrimaryTermAndIndex.fromSearchHit(searchHit)));
            }
            catch (Exception e) {
                logger.error(TransformMessages.getMessage((String)"Failed to parse transform statistics for transform [{0}]", (Object[])new Object[]{transformId}), (Throwable)e);
                resultListener.onFailure(e);
            }
        }));
    }

    @Override
    public void getTransformStoredDocs(Collection<String> transformIds, TimeValue timeout, ActionListener<List<TransformStoredDoc>> listener) {
        ConstantScoreQueryBuilder builder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)TransformField.ID.getPreferredName(), transformIds)).filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_state_and_stats")));
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).addSort(TransformField.ID.getPreferredName(), SortOrder.ASC).addSort("_index", SortOrder.DESC).setQuery((QueryBuilder)builder).setSize(Math.min(transformIds.size(), 10000)).setTimeout(timeout).request();
        this.executeAsyncWithOrigin(searchRequest, listener.delegateFailureAndWrap((l, searchResponse) -> {
            ArrayList<TransformStoredDoc> stats = new ArrayList<TransformStoredDoc>();
            String previousId = null;
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                if (hit.getId().equals(previousId)) continue;
                previousId = hit.getId();
                try (XContentParser parser = this.createParser(hit);){
                    stats.add(TransformStoredDoc.fromXContent((XContentParser)parser));
                }
                catch (IOException e) {
                    l.onFailure((Exception)new ElasticsearchParseException("failed to parse transform stats from search hit", (Throwable)e, new Object[0]));
                    return;
                }
            }
            l.onResponse(stats);
        }), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    @Override
    public void refresh(ActionListener<Boolean> listener) {
        this.executeAsyncWithOrigin(new RefreshRequest(new String[]{".transform-internal-007"}), listener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)true)), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).refresh(arg_0, arg_1));
    }

    private <Request, Response> void executeAsyncWithOrigin(Request request, ActionListener<Response> listener, BiConsumer<Request, ActionListener<Response>> consumer) {
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"transform", request, listener, consumer);
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void executeAsyncWithOrigin(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", action, request, listener);
    }

    private void parseTransformLenientlyFromSource(BytesReference source, String transformId, ActionListener<TransformConfig> transformListener) {
        try (XContentParser parser = this.createParser(source);){
            transformListener.onResponse((Object)TransformConfig.fromXContent((XContentParser)parser, (String)transformId, (boolean)true));
        }
        catch (Exception e) {
            logger.error(TransformMessages.getMessage((String)"Failed to parse transform configuration for transform [{0}]", (Object[])new Object[]{transformId}), (Throwable)e);
            transformListener.onFailure(e);
        }
    }

    private void parseCheckpointsLenientlyFromSource(BytesReference source, String transformId, ActionListener<TransformCheckpoint> transformListener) {
        try (XContentParser parser = this.createParser(source);){
            transformListener.onResponse((Object)TransformCheckpoint.fromXContent((XContentParser)parser, (boolean)true));
        }
        catch (Exception e) {
            logger.error(TransformMessages.getMessage((String)"Failed to parse transform checkpoints for [{0}]", (Object[])new Object[]{transformId}), (Throwable)e);
            transformListener.onFailure(e);
        }
    }

    private static QueryBuilder buildQueryFromTokenizedIds(String[] idTokens, String resourceName) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)resourceName));
        if (!Strings.isAllOrWildcard((String[])idTokens)) {
            ArrayList<String> terms = new ArrayList<String>();
            BoolQueryBuilder shouldQueries = new BoolQueryBuilder();
            for (String token : idTokens) {
                if (Regex.isSimpleMatchPattern((String)token)) {
                    shouldQueries.should((QueryBuilder)QueryBuilders.wildcardQuery((String)TransformField.ID.getPreferredName(), (String)token));
                    continue;
                }
                terms.add(token);
            }
            if (!terms.isEmpty()) {
                shouldQueries.should((QueryBuilder)QueryBuilders.termsQuery((String)TransformField.ID.getPreferredName(), terms));
            }
            if (!shouldQueries.should().isEmpty()) {
                queryBuilder.filter((QueryBuilder)shouldQueries);
            }
        }
        return QueryBuilders.constantScoreQuery((QueryBuilder)queryBuilder);
    }

    void expandAllTransformIds(boolean filterForOutdated, int maxResultWindow, TimeValue timeout, ActionListener<Tuple<Long, Set<String>>> listener) {
        PageParams startPage = new PageParams(0, maxResultWindow);
        HashSet<String> collectedIds = new HashSet<String>();
        this.recursiveExpandAllTransformIds(collectedIds, 0L, filterForOutdated, maxResultWindow, null, startPage, timeout, listener);
    }

    private void recursiveExpandAllTransformIds(Set<String> collectedIds, long total, boolean filterForOutdated, int maxResultWindow, String lastId, PageParams page, TimeValue timeout, ActionListener<Tuple<Long, Set<String>>> listener) {
        SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).addSort(TransformField.ID.getPreferredName(), SortOrder.ASC).addSort("_index", SortOrder.DESC).setFrom(page.getFrom()).setSize(page.getSize()).setTimeout(timeout).setFetchSource(false).addDocValueField(TransformField.ID.getPreferredName()).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_config"))).request();
        this.executeAsyncWithOrigin(request, listener.delegateFailureAndWrap((l, searchResponse) -> {
            long totalHits = total;
            String idOfLastHit = lastId;
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                String id = (String)hit.field(TransformField.ID.getPreferredName()).getValue();
                if (Strings.isNullOrEmpty((String)id)) continue;
                if (filterForOutdated && hit.getIndex().equals(".transform-internal-007")) {
                    ++totalHits;
                } else if (!id.equals(idOfLastHit) && collectedIds.add(id)) {
                    ++totalHits;
                }
                idOfLastHit = id;
            }
            if (searchResponse.getHits().getHits().length == page.getSize()) {
                PageParams nextPage = new PageParams(page.getFrom() + page.getSize(), maxResultWindow);
                this.recursiveExpandAllTransformIds(collectedIds, totalHits, filterForOutdated, maxResultWindow, idOfLastHit, nextPage, timeout, (ActionListener<Tuple<Long, Set<String>>>)l);
                return;
            }
            l.onResponse((Object)new Tuple((Object)totalHits, (Object)collectedIds));
        }), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private boolean isUpgrading() {
        return TransformMetadata.upgradeMode((ClusterState)this.clusterService.state());
    }

    private Exception conflictStatusException(String message) {
        return new ElasticsearchStatusException(message, RestStatus.CONFLICT, new Object[0]);
    }

    private static Tuple<RestStatus, Throwable> getStatusAndReason(BulkByScrollResponse response) {
        RestStatus status = RestStatus.OK;
        Throwable reason = new Exception("Unknown error");
        for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
            if (failure.getStatus().getStatus() <= status.getStatus()) continue;
            status = failure.getStatus();
            reason = failure.getCause();
        }
        for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
            RestStatus failureStatus = ExceptionsHelper.status((Throwable)failure.getReason());
            if (failureStatus.getStatus() <= status.getStatus()) continue;
            status = failureStatus;
            reason = failure.getReason();
        }
        return new Tuple((Object)status, (Object)reason);
    }

    private static DeleteByQueryRequest createDeleteByQueryRequest() {
        DeleteByQueryRequest deleteByQuery = new DeleteByQueryRequest();
        ((DeleteByQueryRequest)((DeleteByQueryRequest)deleteByQuery.setAbortOnVersionConflict(false)).setSlices(0)).setIndicesOptions(IndicesOptions.lenientExpandOpen());
        deleteByQuery.getSearchRequest().source().sort("_doc");
        return deleteByQuery;
    }
}

