/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class MatchQuery
extends Query {
    private static final Map<String, BiConsumer<MatchQueryBuilder, Object>> BUILDER_APPLIERS = Map.ofEntries(Map.entry(MatchQueryBuilder.ANALYZER_FIELD.getPreferredName(), (qb, s) -> qb.analyzer(s.toString())), Map.entry(MatchQueryBuilder.GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), (qb, b) -> qb.autoGenerateSynonymsPhraseQuery(((Boolean)b).booleanValue())), Map.entry(Fuzziness.FIELD.getPreferredName(), (qb, s) -> qb.fuzziness(Fuzziness.fromString((String)s.toString()))), Map.entry(AbstractQueryBuilder.BOOST_FIELD.getPreferredName(), (qb, s) -> qb.boost(((Float)s).floatValue())), Map.entry(MatchQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), (qb, s) -> qb.fuzzyTranspositions(((Boolean)s).booleanValue())), Map.entry(MatchQueryBuilder.FUZZY_REWRITE_FIELD.getPreferredName(), (qb, s) -> qb.fuzzyRewrite(s.toString())), Map.entry(MatchQueryBuilder.LENIENT_FIELD.getPreferredName(), (qb, s) -> qb.lenient(((Boolean)s).booleanValue())), Map.entry(MatchQueryBuilder.MAX_EXPANSIONS_FIELD.getPreferredName(), (qb, s) -> qb.maxExpansions(((Integer)s).intValue())), Map.entry(MatchQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), (qb, s) -> qb.minimumShouldMatch(s.toString())), Map.entry(MatchQueryBuilder.OPERATOR_FIELD.getPreferredName(), (qb, s) -> qb.operator(Operator.fromString((String)s.toString()))), Map.entry(MatchQueryBuilder.PREFIX_LENGTH_FIELD.getPreferredName(), (qb, s) -> qb.prefixLength(((Integer)s).intValue())));
    private final String name;
    private final Object text;
    private final Double boost;
    private final Fuzziness fuzziness;
    private final Map<String, Object> options;

    public MatchQuery(Source source, String name, Object text) {
        this(source, name, text, Map.of());
    }

    public MatchQuery(Source source, String name, Object text, Map<String, Object> options) {
        super(source);
        assert (options != null);
        this.name = name;
        this.text = text;
        this.options = options;
        this.boost = null;
        this.fuzziness = null;
    }

    protected QueryBuilder asBuilder() {
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)this.name, (Object)this.text);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal match option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, v);
        });
        if (this.boost != null) {
            queryBuilder.boost(this.boost.floatValue());
        }
        if (this.fuzziness != null) {
            queryBuilder.fuzziness(this.fuzziness);
        }
        return queryBuilder;
    }

    public String name() {
        return this.name;
    }

    public Object text() {
        return this.text;
    }

    public int hashCode() {
        return Objects.hash(this.text, this.name, this.options, this.boost, this.fuzziness);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MatchQuery other = (MatchQuery)((Object)obj);
        return Objects.equals(this.text, other.text) && Objects.equals(this.name, other.name) && Objects.equals(this.options, other.options) && Objects.equals(this.boost, other.boost) && Objects.equals(this.fuzziness, other.fuzziness);
    }

    protected String innerToString() {
        return this.name + ":" + String.valueOf(this.text);
    }

    public Map<String, Object> options() {
        return this.options;
    }

    public boolean scorable() {
        return true;
    }
}

