/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.local;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.PotentiallyUnmappedKeywordEsField;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;

public class ReplaceMissingFieldWithNull
extends ParameterizedRule<LogicalPlan, LogicalPlan, LocalLogicalOptimizerContext> {
    @Override
    public LogicalPlan apply(LogicalPlan plan, LocalLogicalOptimizerContext localLogicalOptimizerContext) {
        AttributeSet.Builder lookupFieldsBuilder = AttributeSet.builder();
        plan.forEachUp(EsRelation.class, esRelation -> {
            if (esRelation.indexMode() == IndexMode.LOOKUP) {
                lookupFieldsBuilder.addAll(esRelation.output());
            }
        });
        Predicate<FieldAttribute> shouldBeRetained = f -> f.field() instanceof PotentiallyUnmappedKeywordEsField || localLogicalOptimizerContext.searchStats().exists(f.fieldName()) || lookupFieldsBuilder.contains(f);
        return (LogicalPlan)plan.transformUp(p -> this.missingToNull((LogicalPlan)((Object)p), shouldBeRetained));
    }

    private LogicalPlan missingToNull(LogicalPlan plan, Predicate<FieldAttribute> shouldBeRetained) {
        if (plan instanceof EsRelation) {
            EsRelation relation = (EsRelation)plan;
            List<Attribute> relationOutput = relation.output();
            LinkedHashMap nullLiterals = Maps.newLinkedHashMapWithExpectedSize((int)DataType.types().size());
            ArrayList<Attribute> newProjections = new ArrayList<Attribute>(relationOutput.size());
            int size = relationOutput.size();
            for (int i = 0; i < size; ++i) {
                Attribute projection;
                FieldAttribute f2;
                Attribute attr = relationOutput.get(i);
                if (attr instanceof FieldAttribute && !shouldBeRetained.test(f2 = (FieldAttribute)attr)) {
                    DataType dt = f2.dataType();
                    Alias nullAlias = (Alias)nullLiterals.get(dt);
                    if (nullAlias == null) {
                        Alias alias = new Alias(f2.source(), f2.name(), (Expression)Literal.of((Expression)f2, null), f2.id());
                        nullLiterals.put(dt, alias);
                        projection = alias.toAttribute();
                    } else {
                        projection = new Alias(f2.source(), f2.name(), (Expression)nullAlias.toAttribute(), f2.id());
                    }
                } else {
                    projection = attr;
                }
                newProjections.add(projection);
            }
            if (nullLiterals.size() == 0) {
                return plan;
            }
            Eval eval = new Eval(plan.source(), relation, new ArrayList<Alias>(nullLiterals.values()));
            return new Project(plan.source(), eval, newProjections);
        }
        if (plan instanceof Eval || plan instanceof Filter || plan instanceof OrderBy || plan instanceof RegexExtract || plan instanceof TopN) {
            return (LogicalPlan)((Object)plan.transformExpressionsOnlyUp(FieldAttribute.class, f -> shouldBeRetained.test((FieldAttribute)f) ? f : Literal.of((Expression)f, null)));
        }
        return plan;
    }
}

