/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.nulls;

import java.util.List;
import java.util.stream.IntStream;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;

abstract sealed class CoalesceIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    protected final DriverContext driverContext;
    protected final List<EvalOperator.ExpressionEvaluator> evaluators;

    static EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator, List<Expression> children) {
        final List<EvalOperator.ExpressionEvaluator.Factory> childEvaluators = children.stream().map(toEvaluator::apply).toList();
        if (childEvaluators.stream().allMatch(EvalOperator.ExpressionEvaluator.Factory::eagerEvalSafeInLazy)) {
            return new EvalOperator.ExpressionEvaluator.Factory(){

                public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                    return new CoalesceIntEagerEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
                }

                public String toString() {
                    return "CoalesceIntEagerEvaluator[values=" + String.valueOf(childEvaluators) + "]";
                }
            };
        }
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                return new CoalesceIntLazyEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
            }

            public String toString() {
                return "CoalesceIntLazyEvaluator[values=" + String.valueOf(childEvaluators) + "]";
            }
        };
    }

    protected CoalesceIntEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
        this.driverContext = driverContext;
        this.evaluators = evaluators;
    }

    public final IntBlock eval(Page page) {
        return this.entireBlock(page);
    }

    private IntBlock entireBlock(Page page) {
        IntBlock lastFullBlock;
        int lastFullBlockIdx = 0;
        while (true) {
            lastFullBlock = (IntBlock)this.evaluators.get(lastFullBlockIdx++).eval(page);
            if (lastFullBlockIdx == this.evaluators.size() || lastFullBlock.asVector() != null) {
                return lastFullBlock;
            }
            if (!lastFullBlock.areAllValuesNull()) break;
            lastFullBlock.close();
        }
        return this.perPosition(page, lastFullBlock, lastFullBlockIdx);
    }

    protected abstract IntBlock perPosition(Page var1, IntBlock var2, int var3);

    public final String toString() {
        return this.getClass().getSimpleName() + "[values=" + String.valueOf(this.evaluators) + "]";
    }

    public final void close() {
        Releasables.closeExpectNoException(() -> Releasables.close(this.evaluators));
    }

    static final class CoalesceIntLazyEvaluator
    extends CoalesceIntEvaluator {
        CoalesceIntLazyEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected IntBlock perPosition(Page page, IntBlock lastFullBlock, int firstToEvaluate) {
            int positionCount = page.getPositionCount();
            try {
                IntBlock intBlock;
                block25: {
                    IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);
                    try {
                        block19: for (int p = 0; p < positionCount; ++p) {
                            if (!lastFullBlock.isNull(p)) {
                                result.copyFrom(lastFullBlock, p, p + 1);
                                continue;
                            }
                            int[] positions = new int[]{p};
                            Page limited = new Page(1, (Block[])IntStream.range(0, page.getBlockCount()).mapToObj(b -> page.getBlock(b).filter(positions)).toArray(Block[]::new));
                            try (Releasable ignored = () -> ((Page)limited).releaseBlocks();){
                                for (int e = firstToEvaluate; e < this.evaluators.size(); ++e) {
                                    try (IntBlock block = (IntBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(e)).eval(limited);){
                                        if (block.isNull(0)) continue;
                                        result.copyFrom(block, 0);
                                        continue block19;
                                    }
                                }
                                result.appendNull();
                                continue;
                            }
                        }
                        intBlock = result.build();
                        if (result == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return intBlock;
            }
            finally {
                lastFullBlock.close();
            }
        }
    }

    static final class CoalesceIntEagerEvaluator
    extends CoalesceIntEvaluator {
        CoalesceIntEagerEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected IntBlock perPosition(Page page, IntBlock lastFullBlock, int firstToEvaluate) {
            int positionCount = page.getPositionCount();
            IntBlock[] flatten = new IntBlock[this.evaluators.size() - firstToEvaluate + 1];
            try {
                IntBlock intBlock;
                block12: {
                    flatten[0] = lastFullBlock;
                    for (int f = 1; f < flatten.length; ++f) {
                        flatten[f] = (IntBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(firstToEvaluate + f - 1)).eval(page);
                    }
                    IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);
                    try {
                        block9: for (int p = 0; p < positionCount; ++p) {
                            for (IntBlock f : flatten) {
                                if (f.isNull(p)) continue;
                                result.copyFrom(f, p);
                                continue block9;
                            }
                            result.appendNull();
                        }
                        intBlock = result.build();
                        if (result == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return intBlock;
            }
            finally {
                Releasables.close((Releasable[])flatten);
            }
        }
    }
}

