/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;

public final class ToUnsignedLongFromBooleanEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private final EvalOperator.ExpressionEvaluator bool;

    public ToUnsignedLongFromBooleanEvaluator(Source source, EvalOperator.ExpressionEvaluator bool, DriverContext driverContext) {
        super(driverContext, source);
        this.bool = bool;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.bool;
    }

    @Override
    public Block evalVector(Vector v) {
        BooleanVector vector = (BooleanVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantLongBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendLong(this.evalValue(vector, p));
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private long evalValue(BooleanVector container, int index) {
        boolean value = container.getBoolean(index);
        return ToUnsignedLong.fromBoolean(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BooleanBlock block = (BooleanBlock)b;
        int positionCount = block.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    long value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendLong(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private long evalValue(BooleanBlock container, int index) {
        boolean value = container.getBoolean(index);
        return ToUnsignedLong.fromBoolean(value);
    }

    public String toString() {
        return "ToUnsignedLongFromBooleanEvaluator[bool=" + String.valueOf(this.bool) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.bool);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory bool;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory bool) {
            this.source = source;
            this.bool = bool;
        }

        public ToUnsignedLongFromBooleanEvaluator get(DriverContext context) {
            return new ToUnsignedLongFromBooleanEvaluator(this.source, this.bool.get(context), context);
        }

        public String toString() {
            return "ToUnsignedLongFromBooleanEvaluator[bool=" + String.valueOf(this.bool) + "]";
        }
    }
}

