# Fedora RPM packaging

There are instructions on how to build the RPM.

# 1. Gofed

Grab gofed from https://github.com/gofed/gofed

Choose which version of the repo you want to build. For kompose it was 0.3.0 and the commit was 135165b39c55d29a5426479ded81eddd56bfbaf4

Run the following to generate spec file:

```sh
gofed repo2spec --detect github.com/kubernetes/kompose --commit 135165b39c55d29a5426479ded81eddd56bfbaf4 --with-extra --with-build -f
```

The spec file is now located at:

```sh
$HOME/gofed/golang-github-kubernetes-incubator-kompose/golang-github-kubernetes-incubator-kompose.spec
```

# 2. Dependencies

Now we need to go through and fix some things.

Generate bundled dependencies by using parsedeps.go

Go to the kompose source folder and then run:

```sh
go run parsedeps.go
```

In the future this will possibly done by `gofed`, see: https://github.com/gofed/gofed/issues/42

# 3. Building a source RPM locally on CentOS

First, follow instructions to do local setup https://wiki.centos.org/HowTos/SetupRpmBuildEnvironment

Source: https://wiki.centos.org/HowTos/RebuildSRPM

Second, checkout the source to the release commit

Copy the kompose code directory with name `kompose-135165b39c55d29a5426479ded81eddd56bfbaf4`

Tar the `kompose-135165b39c55d29a5426479ded81eddd56bfbaf4` code directory as `kompose-135165b.tar.gz` and copy it to `$HOME/rpmbuild/SOURCES/`

Run following command:

```sh
rpmbuild -ba kompose.spec
```

Find the srpm in `$HOME/rpmbuild/SRPMS`

Find the RPM in `$HOME/rpmbuild/RPM/arch/`

Check that the dependencies are proper:

```sh
rpm -qpR RPMS/x86_64/kompose-0.3.0-0.1.git135165b.el7.centos.x86_64.rpm
```

# 4. Running in on Koji (build system)

First, setup your environment in order to run Koji: https://fedoraproject.org/wiki/Using_the_Koji_build_system

Example setup:

```sh
fedora-packager-setup
kinit <username>@FEDORAPROJECT.ORG
```

To build it on koji run:

```
koji build --scratch rawhide kompose-0.3.0-0.1.git135165b.el7.centos.src.rpm
```
