# Agent plugin: NodeAttestor "tpm_devid"

*Must be used in conjunction with the server-side tpm_devid plugin*

The `tpm_devid` plugin provides attestation data for a node that owns a TPM
and that has been provisioned with a LDevID certificate through an out-of-band
mechanism.

The plugin responds to two challenges requested by the server:

1. A proof-of-possession challenge: The agent receives and signs a random nonce
to prove it is in possession of the private key that corresponds to the LDevID
certificate presented to the server.

2. A proof-of-residency challenge: The agent receives and solves a
specially-crafted, encrypted challenge to prove to the server that the LDevID
keypair was generated and resides in a TPM of a trusted vendor.

The proof-of-residency verification involves the creation of a temporary
attestation key. Currently, this attestation key is always an RSA key independent
of whether the DevID is using an ECC or RSA key type.

The SPIFFE ID produced by the server-side `tpm_devid` plugin is based on the
LDevID certificate fingerprint, where the fingerprint is defined as the SHA1 hash
of the ASN.1 DER encoding of the identity certificate.

The SPIFFE ID has the form:

```xml
spiffe://<trust_domain>/spire/agent/tpm_devid/<fingerprint>
```

| Configuration                    | Description                                                                          | Default                                                   |
|----------------------------------|--------------------------------------------------------------------------------------|-----------------------------------------------------------|
| `tpm_device_path`                | The path to a TPM 2.0 device. It is not used when running on windows.                | If unset, the plugin will try to autodetect the TPM path  |
| `devid_cert_path`                | The path to the DevID certificate on disk in PEM format.                             |                                                           |
| `devid_priv_path`                | The path to the private key blob generated by the TPM.                               |                                                           |
| `devid_pub_path`                 | The path to the public key blob generated by the TPM.                                |                                                           |
| `endorsement_hierarchy_password` | TPM endorsement hierarchy password.                                                  |   ""                                                      |
| `owner_hierarchy_password`       | TPM owner hierarchy password.                                                        |   ""                                                      |
| `devid_password`                 | DevID keys password (must be the same than the one used in the provisioning process) |   ""                                                      |

A sample configuration:

```hcl
    NodeAttestor "tpm_devid" {
        plugin_data {
            devid_cert_path = "/opt/spire/conf/agent/devid.crt.pem"
            devid_priv_path = "/opt/spire/conf/agent/devid.priv.blob"
            devid_pub_path = "/opt/spire/conf/agent/devid.pub.blob"
        }
    }
```

## Compatibility considerations

+ This plugin is designed to work with TPM 2.0, TPM 1.2 is not supported.
+ Only local device identities (LDevIDs) are supported. Attestation using
IDevIDs is not supported.
