// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Hubble

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v6.31.1
// source: peer/peer.proto

package peer

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ChangeNotificationType defines the peer change notification type.
type ChangeNotificationType int32

const (
	ChangeNotificationType_UNKNOWN      ChangeNotificationType = 0
	ChangeNotificationType_PEER_ADDED   ChangeNotificationType = 1
	ChangeNotificationType_PEER_DELETED ChangeNotificationType = 2
	ChangeNotificationType_PEER_UPDATED ChangeNotificationType = 3
)

// Enum value maps for ChangeNotificationType.
var (
	ChangeNotificationType_name = map[int32]string{
		0: "UNKNOWN",
		1: "PEER_ADDED",
		2: "PEER_DELETED",
		3: "PEER_UPDATED",
	}
	ChangeNotificationType_value = map[string]int32{
		"UNKNOWN":      0,
		"PEER_ADDED":   1,
		"PEER_DELETED": 2,
		"PEER_UPDATED": 3,
	}
)

func (x ChangeNotificationType) Enum() *ChangeNotificationType {
	p := new(ChangeNotificationType)
	*p = x
	return p
}

func (x ChangeNotificationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChangeNotificationType) Descriptor() protoreflect.EnumDescriptor {
	return file_peer_peer_proto_enumTypes[0].Descriptor()
}

func (ChangeNotificationType) Type() protoreflect.EnumType {
	return &file_peer_peer_proto_enumTypes[0]
}

func (x ChangeNotificationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChangeNotificationType.Descriptor instead.
func (ChangeNotificationType) EnumDescriptor() ([]byte, []int) {
	return file_peer_peer_proto_rawDescGZIP(), []int{0}
}

type NotifyRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NotifyRequest) Reset() {
	*x = NotifyRequest{}
	mi := &file_peer_peer_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotifyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotifyRequest) ProtoMessage() {}

func (x *NotifyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_peer_peer_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotifyRequest.ProtoReflect.Descriptor instead.
func (*NotifyRequest) Descriptor() ([]byte, []int) {
	return file_peer_peer_proto_rawDescGZIP(), []int{0}
}

// ChangeNotification indicates a change regarding a hubble peer.
type ChangeNotification struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name is the name of the peer, typically the hostname. The name includes
	// the cluster name if a value other than default has been specified.
	// This value can be used to uniquely identify the host.
	// When the cluster name is not the default, the cluster name is prepended
	// to the peer name and a forward slash is added.
	//
	// Examples:
	//   - runtime1
	//   - testcluster/runtime1
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Address is the address of the peer's gRPC service.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// ChangeNotificationType indicates the type of change, ie whether the peer
	// was added, deleted or updated.
	Type ChangeNotificationType `protobuf:"varint,3,opt,name=type,proto3,enum=peer.ChangeNotificationType" json:"type,omitempty"`
	// TLS provides information to connect to the Address with TLS enabled.
	// If not set, TLS shall be assumed to be disabled.
	Tls           *TLS `protobuf:"bytes,4,opt,name=tls,proto3" json:"tls,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChangeNotification) Reset() {
	*x = ChangeNotification{}
	mi := &file_peer_peer_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeNotification) ProtoMessage() {}

func (x *ChangeNotification) ProtoReflect() protoreflect.Message {
	mi := &file_peer_peer_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeNotification.ProtoReflect.Descriptor instead.
func (*ChangeNotification) Descriptor() ([]byte, []int) {
	return file_peer_peer_proto_rawDescGZIP(), []int{1}
}

func (x *ChangeNotification) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChangeNotification) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ChangeNotification) GetType() ChangeNotificationType {
	if x != nil {
		return x.Type
	}
	return ChangeNotificationType_UNKNOWN
}

func (x *ChangeNotification) GetTls() *TLS {
	if x != nil {
		return x.Tls
	}
	return nil
}

// TLS provides information to establish a TLS connection to the peer.
type TLS struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ServerName is used to verify the hostname on the returned certificate.
	ServerName    string `protobuf:"bytes,1,opt,name=server_name,json=serverName,proto3" json:"server_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TLS) Reset() {
	*x = TLS{}
	mi := &file_peer_peer_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLS) ProtoMessage() {}

func (x *TLS) ProtoReflect() protoreflect.Message {
	mi := &file_peer_peer_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLS.ProtoReflect.Descriptor instead.
func (*TLS) Descriptor() ([]byte, []int) {
	return file_peer_peer_proto_rawDescGZIP(), []int{2}
}

func (x *TLS) GetServerName() string {
	if x != nil {
		return x.ServerName
	}
	return ""
}

var File_peer_peer_proto protoreflect.FileDescriptor

const file_peer_peer_proto_rawDesc = "" +
	"\n" +
	"\x0fpeer/peer.proto\x12\x04peer\"\x0f\n" +
	"\rNotifyRequest\"\x91\x01\n" +
	"\x12ChangeNotification\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aaddress\x18\x02 \x01(\tR\aaddress\x120\n" +
	"\x04type\x18\x03 \x01(\x0e2\x1c.peer.ChangeNotificationTypeR\x04type\x12\x1b\n" +
	"\x03tls\x18\x04 \x01(\v2\t.peer.TLSR\x03tls\"&\n" +
	"\x03TLS\x12\x1f\n" +
	"\vserver_name\x18\x01 \x01(\tR\n" +
	"serverName*Y\n" +
	"\x16ChangeNotificationType\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\x0e\n" +
	"\n" +
	"PEER_ADDED\x10\x01\x12\x10\n" +
	"\fPEER_DELETED\x10\x02\x12\x10\n" +
	"\fPEER_UPDATED\x10\x032C\n" +
	"\x04Peer\x12;\n" +
	"\x06Notify\x12\x13.peer.NotifyRequest\x1a\x18.peer.ChangeNotification\"\x000\x01B&Z$github.com/cilium/cilium/api/v1/peerb\x06proto3"

var (
	file_peer_peer_proto_rawDescOnce sync.Once
	file_peer_peer_proto_rawDescData []byte
)

func file_peer_peer_proto_rawDescGZIP() []byte {
	file_peer_peer_proto_rawDescOnce.Do(func() {
		file_peer_peer_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_peer_peer_proto_rawDesc), len(file_peer_peer_proto_rawDesc)))
	})
	return file_peer_peer_proto_rawDescData
}

var file_peer_peer_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_peer_peer_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_peer_peer_proto_goTypes = []any{
	(ChangeNotificationType)(0), // 0: peer.ChangeNotificationType
	(*NotifyRequest)(nil),       // 1: peer.NotifyRequest
	(*ChangeNotification)(nil),  // 2: peer.ChangeNotification
	(*TLS)(nil),                 // 3: peer.TLS
}
var file_peer_peer_proto_depIdxs = []int32{
	0, // 0: peer.ChangeNotification.type:type_name -> peer.ChangeNotificationType
	3, // 1: peer.ChangeNotification.tls:type_name -> peer.TLS
	1, // 2: peer.Peer.Notify:input_type -> peer.NotifyRequest
	2, // 3: peer.Peer.Notify:output_type -> peer.ChangeNotification
	3, // [3:4] is the sub-list for method output_type
	2, // [2:3] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_peer_peer_proto_init() }
func file_peer_peer_proto_init() {
	if File_peer_peer_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_peer_peer_proto_rawDesc), len(file_peer_peer_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_peer_peer_proto_goTypes,
		DependencyIndexes: file_peer_peer_proto_depIdxs,
		EnumInfos:         file_peer_peer_proto_enumTypes,
		MessageInfos:      file_peer_peer_proto_msgTypes,
	}.Build()
	File_peer_peer_proto = out.File
	file_peer_peer_proto_goTypes = nil
	file_peer_peer_proto_depIdxs = nil
}
