/* SPDX-License-Identifier: GPL-2.0-only */

#include <assert.h>
#include <commonlib/helpers.h>
#include <device/mmio.h>
#include <types.h>
#include <soc/socinfo.h>
#include <soc/addressmap.h>

#define JTAG_OFFSET	0xB1014

static struct chipinfo chipinfolut[] = {
	{ CHIPINFO_ID_SM_KODIAK, CHIPINFO_PARTNUM_SM_KODIAK, CHIPINFO_MODEM_SUPPORTED},
	{ CHIPINFO_ID_SC_KODIAK_CHROME, CHIPINFO_PARTNUM_SC_KODIAK_CHROME,
		CHIPINFO_MODEM_SUPPORTED },
	{ CHIPINFO_ID_SC_KODIAK_WINDOWS, CHIPINFO_PARTNUM_SC_KODIAK_WINDOWS,
		CHIPINFO_MODEM_SUPPORTED},
	{ CHIPINFO_ID_QCM_KODIAK, CHIPINFO_PARTNUM_QCM_KODIAK, CHIPINFO_MODEM_SUPPORTED },
	{ CHIPINFO_ID_QCS_KODIAK, CHIPINFO_PARTNUM_QCS_KODIAK, CHIPINFO_MODEM_UNKNOWN },
	{ CHIPINFO_ID_SMP_KODIAK, CHIPINFO_PARTNUM_SMP_KODIAK, CHIPINFO_MODEM_UNKNOWN },
	{ CHIPINFO_ID_SM_KODIAK_LTE_ONLY, CHIPINFO_PARTNUM_SM_KODIAK_LTE_ONLY,
		CHIPINFO_MODEM_SUPPORTED },
	{ CHIPINFO_ID_SCP_KODIAK, CHIPINFO_PARTNUM_SCP_KODIAK, CHIPINFO_MODEM_UNKNOWN },
	{ CHIPINFO_ID_SC_8CGEN3, CHIPINFO_PARTNUM_SC_8CGEN3, CHIPINFO_MODEM_SUPPORTED },
	{ CHIPINFO_ID_SCP_8CGEN3, CHIPINFO_PARTNUM_SCP_8CGEN3, CHIPINFO_MODEM_UNKNOWN },
	{ CHIPINFO_ID_KODIAK_SCP_7CGEN3, CHIPINFO_PARTNUM_KODIAK_SCP_7CGEN3,
		CHIPINFO_MODEM_UNKNOWN },
	{ CHIPINFO_ID_QCS_KODIAK_LITE, CHIPINFO_PARTNUM_QCS_KODIAK_LITE,
		CHIPINFO_MODEM_UNKNOWN },
	{ CHIPINFO_ID_QCM_KODIAK_LITE, CHIPINFO_PARTNUM_QCM_KODIAK_LITE,
		CHIPINFO_MODEM_UNKNOWN },
};

bool socinfo_modem_supported(void)
{
	uint32_t jtagid;
	int i;

	jtagid = read32((void *)(TLMM_TILE_BASE + JTAG_OFFSET)) & DEVICE_ID;

	for (i = 0; i < ARRAY_SIZE(chipinfolut); i++)
		if (chipinfolut[i].jtagid == jtagid)
			return chipinfolut[i].modem;

	return false;
}
