#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 not installed"},
    {TR_NO_PATCH_MESSAGE,
        "Your Caesar 3 installation does not have the 1.0.1.0 patch installed. "
        "You can download the patch from:\n"
        URL_PATCHES "\n"
        "Continue at your own risk."},
    {TR_MISSING_FONTS_TITLE, "Missing fonts"},
    {TR_MISSING_FONTS_MESSAGE,
        "Your Caesar 3 installation requires extra font files. "
        "You can download them for your language from:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Editor not installed"},
    {TR_NO_EDITOR_MESSAGE,
        "Your Caesar 3 installation does not contain the editor files. "
        "You can download them from:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Invalid language directory"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "The directory you selected does not contain a valid language pack. "
        "Please check the log for errors."},
    {TR_BUILD_ALL_TEMPLES, "All"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Cancel"},
    {TR_BUTTON_RESET_DEFAULTS, "Reset defaults"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Hotkeys"},
    {TR_CONFIG_ARE_YOU_SURE, "Reset to defaults?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "You will lose all your custom configs."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "You will lose all your custom hotkeys."},
    {TR_CONFIG_TITLE, "Augustus configuration options"},
    {TR_CONFIG_HEADER_GENERAL, "General Settings"},
    {TR_CONFIG_HEADER_UI_CHANGES, "User Interface"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Difficulty"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "City Management"},
    {TR_CONFIG_LANGUAGE_LABEL, "Language:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(default)"},
    {TR_CONFIG_GAME_SPEED, "Game speed:"},
    {TR_CONFIG_VIDEO, "Video Options"},
    {TR_CONFIG_FULLSCREEN, "Fullscreen"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Windowed resolution:"},
    {TR_CONFIG_DISPLAY_SCALE, "Display scale:"},
    {TR_CONFIG_CURSOR_SCALE, "Cursor scale:"},
    {TR_CONFIG_USE_COLOR_CURSORS, "Use colored cursors"},
    {TR_CONFIG_AUDIO, "Audio Options"},
    {TR_CONFIG_VOLUME, "Volume"},
    {TR_CONFIG_ENABLE_AUDIO, "Enable audio"},
    {TR_CONFIG_MUSIC, "Enable music"},
    {TR_CONFIG_SPEECH, "Enable speech"},
    {TR_CONFIG_EFFECTS, "Enable sound effects"},
    {TR_CONFIG_CITY_SOUNDS, "Enable city sounds"},
    {TR_CONFIG_VIDEO_SOUND, "Enable video sound"},
    {TR_CONFIG_SCROLL_SPEED, "Scroll speed:"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Play intro videos"},
    {TR_CONFIG_SIDEBAR_INFO, "Extra information in the control panel"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Enable smooth scrolling"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Disable map scrolling on window edge"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Disable dragging with right mouse button"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Improve visual feedback when clearing land"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Allow building each temple in succession"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Show range when building reservoirs, fountains and wells"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Show draggable construction size"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Highlight legion on cursor hover"},
    {TR_CONFIG_ROTATE_MANUALLY, "Rotate Gatehouse and Triumph Arch by hotkey"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Enable military sidebar"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Fix immigration bug on very hard"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Fix 100-year-old ghosts"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Fix Emperor change and survival time in custom missions"},
    {TR_CONFIG_DRAW_WALKER_WAYPOINTS, "Draw walker waypoints on overlay after right clicking on a building"},
    {TR_CONFIG_ENABLE_ZOOM, "Enable city zoom (can be slow, uses more RAM and GPU memory)"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Fix uncompleted rating columns on low targets"},
    {TR_CONFIG_GRANDFESTIVAL, "Grand festivals allow extra blessing from a god"},
    {TR_CONFIG_DIFFICULTY, "Difficulty:"},
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Maximum number of grand temples per city:"},
    {TR_CONFIG_INFINITE, "Infinite"},
    {TR_CONFIG_GODS_EFFECTS, "Enable god curses/blessings"},
    {TR_CONFIG_JEALOUS_GODS, "Disable jealousness of gods"},
    {TR_CONFIG_GLOBAL_LABOUR, "Enable global labour pool"},
    {TR_CONFIG_SCHOOL_WALKERS, "Extend school walkers range"},
    {TR_CONFIG_RETIRE_AT_60, "Change citizens' retirement age from 50 to 60"},
    {TR_CONFIG_FIXED_WORKERS, "Fixed worker pool - 38% of plebeian population"},
    {TR_CONFIG_EXTRA_FORTS, "Allow building 4 extra forts"},
    {TR_CONFIG_WOLVES_BLOCK, "Block building around wolves"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Block unconnected granary roads"},
    {TR_CONFIG_MORE_STOCKPILE, "Houses stockpile more goods from market"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Buying market ladies don't distribute goods"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Immediately destroy buildings"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Cart pushers from getting granaries can go offroad"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Double the capacity of cart pushers from getting granaries"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Allow traders to export food from granaries"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Tower sentries don't need road access from barracks"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Farms and wharves deliver only to nearby granaries"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Food isn't delivered to getting granaries"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "All houses merge"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Open trade route count as providing different wine type"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Randomly collapsing clay pits and iron mines take some money instead"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Allow building multiple barracks" },
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Warehouses and granaries don't accept anything when built"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Houses don't expand into gardens"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Roaming walkers don't skip corners"},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_TITLE, "City zoom could not be enabled"},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_MESSAGE,
        "Your system does not have enough graphics memory to enable city zoom.\n"
        "City zoom has not been enabled."},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Display max attainable prosperity rating with current housing"},
    {TR_HOTKEY_TITLE, "Augustus hotkey configuration"},
    {TR_HOTKEY_LABEL, "Hotkey"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternative"},
    {TR_HOTKEY_HEADER_ARROWS, "Arrow keys"},
    {TR_HOTKEY_HEADER_GLOBAL, "Global hotkeys"},
    {TR_HOTKEY_HEADER_CITY, "City hotkeys"},
    {TR_HOTKEY_HEADER_ADVISORS, "Advisors"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Overlays"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "City map bookmarks"},
    {TR_HOTKEY_HEADER_EDITOR, "Editor"},
    {TR_HOTKEY_HEADER_BUILD, "Construction hotkeys"},
    {TR_HOTKEY_ARROW_UP, "Up"},
    {TR_HOTKEY_ARROW_DOWN, "Down"},
    {TR_HOTKEY_ARROW_LEFT, "Left"},
    {TR_HOTKEY_ARROW_RIGHT, "Right"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Toggle fullscreen"},
    {TR_HOTKEY_CENTER_WINDOW, "Center window"},
    {TR_HOTKEY_RESIZE_TO_640, "Resize window to 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Resize window to 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Resize window to 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Save screenshot"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Save full city screenshot"},
    {TR_HOTKEY_BUILD_CLONE, "Clone building under cursor"},
    {TR_HOTKEY_LOAD_FILE, "Load file"},
    {TR_HOTKEY_SAVE_FILE, "Save file"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Increase game speed"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Decrease game speed"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Toggle pause"},
    {TR_HOTKEY_CYCLE_LEGION, "Cycle through legions"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Rotate map left"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Rotate map right"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Labor advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Military advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Imperial advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Ratings advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Trade advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Population advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Health advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Education advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Entertainment advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Religion advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Financial advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Chief advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Housing advisor"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Toggle current overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Show relative overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Show water overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Show fire overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Damage overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Crime overlay"},
    {TR_HOTKEY_ROTATE_BUILDING, "Next building rotation"},
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Previous building rotation"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Problems overlay"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Go to bookmark 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Go to bookmark 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Go to bookmark 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Go to bookmark 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Set bookmark 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Set bookmark 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Set bookmark 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Set bookmark 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Toggle battle info"},
    {TR_HOTKEY_EDIT_TITLE, "Press new hotkey"},
    {TR_BUILDING_ROADBLOCK, "Roadblock"},
    {TR_BUILDING_ROADBLOCK_DESC, "Roadblock stops loitering citizens."},
    {TR_BUILDING_ARCHITECT_GUILD, "Architects' guild" },
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Architects here work tirelessly to construct monuments for the glory of Rome." },
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Bestow epithet on temple" },
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Ceres grand temple" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Neptune grand temple" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Mercury grand temple" },
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Mars grand Temple" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Venus grand Temple" },
    {TR_BUILDING_PANTHEON, "Pantheon" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Grand temple of Ceres" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Grand temple of Neptune" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Grand temple of Mercury" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Grand temple of Mars" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Grand temple of Venus" },
    {TR_BUILDING_PANTHEON_DESC, "Pantheon" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Cartpushers from farms move 50% faster." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Grants +1 range for fountains and wells and +2 for reservoirs. Water services labor is reduced by 50%. Trading ships travel 25% faster." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Land and sea traders have an additional 50% capacity. Land traders move 25% faster." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Trains soldiers like a barracks. Four extra forts may be built." },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "City gardens, statues, and temples glow with increased beauty, increasing their desirability. Houses stock more goods and devolve more slowly." },
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Provides access to all gods. Holds annual festivals and reduces religious and cultural building levies by 25%." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Priests reduce food consumption by 20%." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Temples produce charioteers for the hippodrome." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Priests reduce pottery and furniture consumption by 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Temples generate food, in an amount based on the number of houses they cover, and deliver it to the supply post. Fort levies reduced by 25%." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "The Grand temple produces wine in a quantity scaled to city population with Venus temple access. Temples collect and distribute it to houses and taverns." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Priests collect and distribute both oil and one food type from city storage." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Priests expand housing capacity by 5%. Grand temple provides water like a filled reservoir." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Priests reduce oil and wine consumption by 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Priests reduce consumption of all goods by 10%." },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Priests provide entertainment and beautify houses themselves, increasing the attractiveness of the neighborhood without additional decoration." },
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "All the temples in the city send priests to Pantheon, spreading the faith and blessings of their gods." },
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Houses with access to the Pantheon can evolve one additional step." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Temple of Ceres Fecunda" }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Temple of Ceres Frugifera" }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Temple of Neptunus Equester" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Temple of Neptunus Adiutor" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Temple of Mercurius Fortunus" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Temple of Mercurius Mercator" }, // Note to translators: This one changed from the previous versions, please update.
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Temple of Mars Ultor" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Temple of Mars Quirinus" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Temple of Venus Verticordia" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Temple of Venus Genetrix" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna" },
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Grand temple" },
    {TR_BUILDING_WORK_CAMP, "Work camp" },
    {TR_BUILDING_WORK_CAMP_DESC, "Laborers gather here to transport materials to construction sites." },
    {TR_HEADER_HOUSING, "Housing"},
    {TR_ADVISOR_HOUSING_ROOM, "City housing has room available for"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "There is no room available in city housing."},
    {TR_ADVISOR_RESIDENCES_DEMANDING_POTTERY, "Residences demanding pottery"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_FURNITURE, "Residences demanding furniture"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_OIL, "Residences demanding oil"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_WINE, "Residences demanding wine"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Total residences:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Available capacity:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Total capacity:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Population - Housing"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Graphs"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Housing prosperity rating is"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Percentage of your population in villas and palaces is"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Percentage of your population in tents and shacks is"},
    {TR_ADVISOR_AVERAGE_TAX, "Average tax income per residence is"},
    {TR_ADVISOR_AVERAGE_AGE, "Average age of your population is"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Percentage of your population in the workforce is"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Births last year:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Deaths last year:"},
    {TR_ADVISOR_TOTAL_POPULATION, "residents total"},
    {TR_ADVISOR_IN_STORAGE, "in storage"},
    {TR_ADVISOR_FROM_GRANARIES, "from granaries"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Dispatching food from granaries"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Are you sure?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Keep stockpiling resource"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "Max Prosperity for the current housing level is"},
    {TR_REQUIRED_RESOURCES, "Resources delivered for current phase:"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "Constructing grand temples requires material stored in a warehouse, laborers from a work camp, and architects from an architects' guild."},
    {TR_CONSTRUCTION_PHASE, "Construction phase:"},
    {TR_ADD_MODULE, "Rededicate temple?"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Epithet bestowed."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "First Ceres taught the laboring hind to plow\nThe pregnant Earth, and quickening seed to sow.\nShe first for Man did wholesome food provide\nAnd with just laws the wicked world supplied.\n-Ovid, the Metamorphoses, Book V" },
    {TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "The billows fall, while Neptune lays his mace\nOn the rough sea,and smooths its furrowed face.\nAlready Triton, at his call, appears Above the waves;\na Tyrian robe he wears;\nAnd in his hand a crooked trumpet bears.\n-Ovid, the Metamorphoses, Book I"},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Cattle and fat sheep can all be had for the raiding,\ntripods for the trading, and tawny headed stallions.\nBut a mans's lifebreath cannot come back again-\nno raiders in force, no trading brings it back, \nonce it slips through a man's clenched teeth.\n-Homer, The Iliad, Book IX"},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "For Mars, repair his broken axletrees and blunted war,\nAnd send him forth again with furbished arms,\nTo wake the lazy war with trumpets' loud alarms.\n-Virgil, the Aeneid, Book VIII" },
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "By winged Cupid, and Venus, his tender mother,\nhow great the joy I had!\nHow clearly passion touched me!\nHow my whole heart melted where I lay!\n-Ovid, the Metamorphoses, Book IX" },
    {TR_BUILDING_PANTHEON_QUOTE, "The gates of heaven unfold: Jupiter summons all\nThe gods to council in the common hall.\nSublimely seated, he surveys from far\nThe fields, the camp, the fortune of the war,\nAnd all the inferior world. From first to last,\nThe sovereign senate in degrees are placed.\n-Virgil, The Aeneid, Book X" },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Laborers are constructing the podium that will elevate the temple and provide a solid foundation to weather the passage of time." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Artisans are crafting the portico, which bears the temple's sacrificial altar." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Engineers are crafting the cella, the temple interior that houses the sacred images." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Work on the temple praecinctum has begun, where worshippers will gather outdoors for public ceremonies." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "With the temple nearly complete, priests gather to perform the rites of consecration." },
    {TR_BUILDING_MENU_TREES, "Trees" },
    {TR_BUILDING_MENU_PATHS, "Paths" },
    {TR_BUILDING_MENU_PARKS, "Parks"},
    {TR_BUILDING_SMALL_POND, "Small pond"},
    {TR_BUILDING_LARGE_POND, "Large pond"},
    {TR_BUILDING_PINE_TREE, "Pine tree"},
    {TR_BUILDING_FIR_TREE, "Fir tree" },
    {TR_BUILDING_OAK_TREE, "Oak tree" },
    {TR_BUILDING_ELM_TREE, "Elm tree" },
    {TR_BUILDING_FIG_TREE, "Fig tree" },
    {TR_BUILDING_PLUM_TREE, "Plum tree" },
    {TR_BUILDING_PALM_TREE, "Palm tree" },
    {TR_BUILDING_DATE_TREE, "Date tree" },
    {TR_BUILDING_PINE_PATH, "Pine path" },
    {TR_BUILDING_FIR_PATH, "Fir path" },
    {TR_BUILDING_OAK_PATH, "Oak path" },
    {TR_BUILDING_ELM_PATH, "Elm path" },
    {TR_BUILDING_FIG_PATH, "Fig path" },
    {TR_BUILDING_PLUM_PATH, "Plum path" },
    {TR_BUILDING_PALM_PATH, "Palm path" },
    {TR_BUILDING_DATE_PATH, "Date path" },
    {TR_BUILDING_BLUE_PAVILION, "Pavilion" },
    {TR_BUILDING_RED_PAVILION, "Red pavilion"},
    {TR_BUILDING_ORANGE_PAVILION, "Orange pavilion"},
    {TR_BUILDING_YELLOW_PAVILION, "Yellow pavilion"},
    {TR_BUILDING_GREEN_PAVILION, "Green pavilion" },
    {TR_BUILDING_SMALL_STATUE_ALT, "Goddess statue" },
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Senator statue"},
    {TR_BUILDING_OBELISK, "Obelisk" },
    {TR_BUILDING_POND_DESC, "Ponds fill from city reservoirs and provide water for plants and animals and a cool, relaxing oasis for people. All citizens would love to live near a pond." },
    {TR_BUILDING_WINDOW_POND, "Pond"},
    {TR_BUILDING_OBELISK_DESC, "A prestigious monument, the work of an ancient king of the Nile. The Egyptians weren't using it."},
    {TR_ADVISOR_FINANCE_LEVIES, "Building levies"},
    {TR_CONFIRM_DELETE_MONUMENT, "Demolishing this monument"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Select epithet to bestow"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Bestowing an epithet will permanently dedicate your temple to one aspect of its deity, imbuing priests with divine power." },
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/month"},
    {TR_BUILDING_MESS_HALL, "Supply post"},
    {TR_BUILDING_MESS_HALL_DESC, "The supply post collects food from city granaries to feed soldiers stationed at city forts. A poorly supplied supply post will slow recruitment and damage morale."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Last month's food supply:"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Soldiers are: " },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Well-fed" },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Fed"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Hungry"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Very hungry"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Starving"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "The varied diet of your soldiers greatly increases morale."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "The diverse, nutritious diet enjoyed by your soldiers greatly increases morale."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "You have no soldiers to feed." },
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Months of food stored:" },
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Supply post instructions"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "Food shortages at your supply post are slowing soldier recruitment."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Critical food shortages at your supply post are crippling soldier recruitment." },
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "Recent food shortage decreased morale"},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "Recent food shortage greatly decreased morale"},
    {TR_BUILDING_LEGION_STARVING, "Food shortage" },
    {TR_ADVISOR_TRADE_MAX, "Max"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "max"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importable"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Exportable"},
    {TR_ADVISOR_TRADE_NO_BUYERS, "No buyers for this resource"},
    {TR_ADVISOR_TRADE_NO_SELLERS, "No sellers for this resource"},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "Not importing"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "Not exporting"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Open trade route to import"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Open trade route to export"},
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Your soldiers have all the food they require."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Your soldiers need more food." },
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "Your soldiers are starving!"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Months of food stored at supply post:" },
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Hungry soldiers" },
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Your supply post is critically low on food, and the morale of your troops wanes. Ensure your supply post can access a well-stocked granary."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Your city has lost its supply post, and your troops starve. Construct a supply post immediately."},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Market instructions"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Dock instructions"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Temple instructions"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Tavern instructions"},
    {TR_WARNING_NO_MESS_HALL, "You must first build a supply post to feed your soldiers." },
    {TR_WARNING_MAX_GRAND_TEMPLES, "No more Grand temples can be built." },
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Grand temple completed"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Priests and worshippers flock to the new grand temple for the rites of dedication. Your people stand in awe of the majesty of your works, and your chosen deity showers you with favor."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "A blessing from Mercury" },
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Delighted by your devotion, Mercury has blessed your industry, uncovering raw materials for your craftsmen."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Foreman"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Hauler"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Architect"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Quartermaster"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Camp-servant"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "The grand temple organizes priests of Ceres to aid in distributing food and oil to your hungry citizens."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "The grand temple allows priests of Venus to supply sacred wine to your citizens." },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "The grand temple organizes priests of Mars to supply food to your supply post."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Temple of Ceres"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Temple of Neptune"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Temple of Mercury"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Temple of Mars"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Temple of Venus"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Priest" },
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Cities with opened sea trade:" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "There are no open sea trade routes." },
    // Transcription of mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"I'll do what I can to calm these barbarians down. I'm sure they'll stop attacking the city when I've had a word with them.\"" },
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "An annual festival"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "The faithful flock to temples for the celebration of Cerealia, in honor of Ceres. Farmers offer sacrifices for rich harvests in the coming years."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Today is the festival of Neptunalia, in honor of Neptune. The faithful build huts of branch and foliage and make merry under the blazing heat of the midsummer sun."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Traders and merchants turn out in droves to celebrate Mercuralia. Sacred water is sprinkled on ships and warehouses in hopes of divine protection from the god Mercury."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Citizens gather outside the city for the celebration of Equirria, to seek the favor of Mars. The air is filled with the thunder of hooves and the creaking of chariots as the faithful race in honor of their god."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "The faithful gather for the celebration of Veneralia, a day sacred to Venus. Your citizens beseech her for good fortune in matters of the heart."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Delete read messages"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Disable this building"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Enable this building"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Allow market ladies to buy from here"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Allow caravans to trade here"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Allow trade ships to trade here"},
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Halt resource to workshops or granaries"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, " Enable stockpiling to a warehouse"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Disable stockpiling"},
    {TR_BUILDING_LIGHTHOUSE, "Lighthouse"},
    {TR_BUILDING_CARAVANSERAI, "Caravanserai"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Merchant caravans shelter here to rest and feed their animals. Land trade disruptions last half as long."},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Caravanserai instructions"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Foundation)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Engineers lay the foundation of a shelter for traders."},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Caravanserai supplier" },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Caravanserai collector" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Land trade policy" },
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "No land trade policy." },
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Select a land trade policy for your city. You can change to another policy at any time." },
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Landed seller's policy: Land exports earn 20% more, but land imports are 10% more expensive." },
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium emptor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Landed buyer's policy: Land imports are 20% cheaper, but land exports earn 10% less." },
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Landed quantity policy: Trade caravans carry 4 additional goods, but the Caravanserai consumes 20% more food." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Foundation)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Pedestal)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Tower)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Crown)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Engineers are laying a strong foundation to hold the weight of a great tower of stone." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Masons are constructing the pedestal that will raise the lighthouse's flame far above the horizon." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "The lighthouse rises higher each day, as masons lay successive courses of the great tower." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Engineers are performing final touches to the lighthouse. Soon it will shine for miles, guiding ships home." },
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Constructing the lighthouse requires material stored in a warehouse, laborers from a work camp, and architects from an architects' guild." },
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "The light atop this great tower guides ships from the far reaches of the world safely to your city. Fishing ships now move 10% faster, and sea storms last half as long." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Sea trade policy" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "No sea trade policy." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Select a sea trade policy for your city. You can change to another policy at any time." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Maritime seller's policy: Sea exports earn 20% more, but sea imports are 10% more expensive." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Maritime buyer's policy: Sea imports are 20% cheaper, but sea exports earn 10% less." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" }, // XXX "quantitatis"? Can anybody double check?
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Maritime quantity policy: Trade ships carry 4 additional goods, but the Lighthouse consumes 20% more timber." },
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monuments"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "The completed lighthouse; a mighty tower of stone, looms over the horizon. May its firey beacon guide ships safely home until the end of time." },
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "The Pantheon is completed. It stands unrivaled as a monument to the awesome power of the gods and people of Rome." },
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monument completed" },
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "A blessing from Neptune"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Rewarding your city's devotion, Neptune grants smooth passage to traders for twelve months, during which your exports will earn an extra 50%."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "A blessing from Venus" },
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Delighted by the joyful reverence shown to her, Venus grants youthfulness, health, and happiness to your people, increasing the size of your working population. The mood in your city lifts at Venus' smile." },
    {TR_BUILDING_MENU_STATUES, "Statues" },
    {TR_BUILDING_MENU_GOV_RES, "Governor's mansions" },
    {TR_OVERLAY_ROADS, "Roads" },
    {TR_NO_EXTRA_ASSETS_TITLE, "Extra assets couldn't be loaded" },
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "The extra Augustus assets could not be loaded.\n"
        "This can be due to a missing or old 'assets' directory.\n"
        "Please ensure you have the most up-to-date 'assets' directory, which can obtained from GitHub." },
    {TR_WARNING_WATER_NEEDED_FOR_LIGHTHOUSE, "Lighthouse must be placed near water"},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "This house has access to all five gods from the Pantheon"},
    {TR_BUILDING_LEGION_FOOD_BONUS, "Plentiful food is boosting morale" },
    {TR_BUILDING_LEGION_FOOD_STATUS, "Food status"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Allow quartermaster to get food here"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "You cannot obtain the needed materials"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Completed grand temples grant +6 culture rating"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Disable infinite wolves spawning"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Exit to main menu" },
    {TR_LABEL_PAUSE_MENU, "Pause" },
    {TR_OVERLAY_LEVY, "Levies" },
    {TR_TOOLTIP_OVERLAY_LEVY, " denarii paid monthly in levies." },
    {TR_MAP_EDITOR_OPTIONS, "Scenario settings" },
    {TR_BUILDING_TAVERN, "Tavern" },
    {TR_BUILDING_GRAND_GARDEN, "Grand garden" },
    {TR_BUILDING_TAVERN_DESC_1, "This tavern has no workers, and cannot open for business." },
    {TR_BUILDING_TAVERN_DESC_2, "This tavern has no wine, and cannot open for business." },
    {TR_BUILDING_TAVERN_DESC_3, "This tavern provides entertainment as long as the wine keeps flowing. A supply of meat would increase its appeal." },
    {TR_BUILDING_TAVERN_DESC_4, "Plentiful wine and the smell of roasted meat draw a lively crowd to this tavern for gambling, music, and merriment." },
    {TR_FIGURE_TYPE_BARKEEP, "Barkeep" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Tavern supplier" },
    {TR_OVERLAY_TAVERN, "Tavern" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "This house has no access to a tavern, or its tavern has run dry of wine." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "No barkeep has passed for a while. This house will soon lose access to its tavern." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "This house was passed by a barkeep from a tavern with wine." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "This house was passed by a barkeep from a tavern with wine and meat." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "This house was recently passed by a barkeep from a tavern with wine." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "This house was recently passed by a barkeep from a tavern with wine and meat. Let merriment commence!" },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Residents loathe your very name."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Residents are very angry with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Residents are angry with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Residents are very upset with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Residents are upset with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Residents are annoyed with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Residents are indifferent to you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Residents are pleased with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Residents are very pleased with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Residents are extremely pleased with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Residents love you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Residents idolize you as a god." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Residents are upset about high taxation." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Residents are upset about low wages." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Residents are upset about the lack of jobs." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Residents are despondent about their poor housing." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Residents would appreciate more entertainment." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Residents would appreciate a more varied diet." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Residents would appreciate more desirability." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Residents have their spirits lifted by a recent event." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Residents lose heart due to a recent event." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Taverns" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Games" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Sponsor Great Games at your Colosseum, costing personal funds and resources from your city." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Hold games" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Preparations for the Great Games are underway." },
    {TR_SELECT_GAMES_HEADER, "Games" },
    {TR_SELECT_GAMES_TEXT, "Games will be held at the Colosseum, costing personal funds and resources from your city." },
    {TR_BUILDING_ARENA, "Arena" },
    {TR_BUILDING_HORSE_STATUE, "Equestrian statue" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Dolphin fountain" },
    {TR_BUILDING_HEDGE_DARK, "Verdant hedge" },
    {TR_BUILDING_HEDGE_LIGHT, "Sunlit hedge" },
    {TR_BUILDING_GARDEN_WALL, "Looped garden wall" },
    {TR_BUILDING_LEGION_STATUE, "Legionary statue" },
    {TR_BUILDING_DECORATIVE_COLUMN, "Marble column" },
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Hypogeum)" },
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Foundation)" },
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arcade)" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Gallery)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Workers are digging the underground hypogeum - tunnels and machinery from which grand spectacles will spring." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "The walls of the Colosseum take shape as tiers of seating for both commoners and emperors are lain." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Graceful arches rise to the heavens, to hold the mighty Colosseum aloft." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "As the Colosseum reaches skyward, its walls are clad in gleaming marble and statuary." },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Track)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Foundation)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Stands)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Facade)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "This massive site is being painstakingly surveyed and cleared for a project of unprecedented scale." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Accessways and support structures are being constructed around the track." },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Masons are carving stone seating for tens of thousands." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "More than a mere racetrack, artisans are crafting a monument worthy of the gods and people of Rome." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "Constructing the monument requires material stored in a warehouse, laborers from a work camp, and architects from an architects' guild." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Construction halted." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arenas" },
    {TR_BUILDING_INFO_TOURISM, "(travellers)" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "The Colosseum is complete! Let the games commence!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "The Hippodrome is completed. Your citizens eagerly await your command for the races to begin!" },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Inaugural games" },
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Races begin" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "The inaugural games for your Colosseum have begun. At your command, this monument will be consecrated with the blood of the valiant!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Your city empties as teeming throngs flock to the Hippodrome for the inaugural chariot races. A deafening cheer fills the air as the gates swing open!" },
    {TR_WINDOW_GAMES_OPTION_1, "Hold Naval Games" },
    {TR_WINDOW_GAMES_OPTION_2, "Hold Animal Games" },
    {TR_WINDOW_GAMES_OPTION_3, "Hold Kalends of Januarius" },
    {TR_WINDOW_GAMES_OPTION_4, "Hold Olympic Games" },
    {TR_WINDOW_GAMES_OPTION_5, "Hold Roman Games" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "The Colosseum will be flooded to re-enact a great naval battle. The movement speed of your troops and their strength in distant battles will be increased for the next year." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "The Colosseum will host gruesome animal hunts and executions by wild beasts, delighting the plebeian masses. Crime, riots, and revolts will be suppressed for the next year. Gladiators will help defend the city from the next invasion." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "The Colosseum will host games in honor of the gods on the first day of next year, beseeching fortune and prosperity. Trade quotas will be doubled next year." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "The Hippodrome will host the Olympic Games. Your city will host throngs of visitors, and if your athletes honor your city well you will gain a permanent increase in tourism and favor." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "The Colosseum will host the Roman Games, with people travelling to your city from across the empire to compete. Such a grand spectacle will surely earn you the favor of both the Emperor and the common people for the next year." },
    {TR_WINDOW_GAMES_COST, "Cost:" },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(personal funds)" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Not enough personal funds." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Not enough resources stored." },
    {TR_WINDOW_GAMES_NO_VENUE, "Venue is not built, or has no workers." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Construction)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Masons and engineers are constructing this sacred structure from gleaming marble." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Constructing this temple will require material stored in a warehouse, laborers from a work camp, and architects from an architects' guild." },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "Water from your city's reservoirs is slowly filling the Colosseum. Carpenters begin to assemble lifelike miniature ships of war as gladiators train in waterborne combat. Soon the Naval Games will begin!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "The Colosseum has become a man-made lake, as gladiators re-enact great Roman victories at sea. Blood and water mix as the crowd roars its approval. The Naumachia - the Naval Games - have begun!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "A long cleanup process begins for the Colosseum as it is drained and made ready for normal use. Your people will be talking about this great watery spectacle for years to come." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Strange cargo begins to appear in your city as traders from the far reaches of the earth deliver terrifying beasts to the cages beneath the Colosseum. Soon a gruesome spectacle will delight your people." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Condemned criminals and gladiators seeking ultimate glory face death in the form of tooth and claw. With a blast of trumpets, the Animal Games have begun!" },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "The last of the wild beasts lie slain in the sands of the Colosseum, their blood mingling with that of the condemned. The Animal Games have come to an end." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "We will greet the new year with a glorious games in honor of the gods. In return, we ask for fortune, prosperity, and blessings in matters of commerce." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "The Games begin at sunrise on the Kalends of Ianuarius. Priests conduct animal sacrifices as gladiators gird their arms to die seeking the favor of the divine."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Auguries suggest that the gods were well pleased by our great games, and the sacrifices and reverance shown to them. We can expect a very profitable year!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "All eyes will be on your city as the Olympic Games bring travellers, competitors, and Roman dignitaries from across the world. It will take no less than a full year to see every possible preparation made."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "All long last, the day has come. The sacred flame is lit, and your city streets lie deserted as citizens pack into the great hippodrome. Let the games begin!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "The sacred flame is doused, and travellers and citizens trickle home in weary exultation. Eternal glory is yours for successfully hosting this ancient and sacred celebration of mortal strength and honor." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "With the announcement of Roman Games, people from the furthest reaches flock to your city, many hoping to win the upcoming competitions. It will take no less than a full year to see every possible preparation made." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "The solemn procession begins, and with it, the Roman Games. May Jupiter himself select the champions of the races, wrestling matches, and other contests of stamina and agility. The Colosseum is filled to the brim with citizens awaiting the games and the customary gifts of wheat and olive oil. Let the games begin!" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "The final day of Roman Games comes to an end. Brimming with excitement, and with full bellies, every citizen has tasted the greatness of Roman life. Glory to the gods, glory to the victorious, and glory to the governor!" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "The Great Games"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Months until new Games can be held: " },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Months until the Naval Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "The Naval Games are underway. The splash of water, creaking of timbers, and battle cries of gladiators add to the roar of the crowd." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Months until the Animal Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "The Animal Games are underway. Shoulder to shoulder, the mob screams itself hoarse as the wild beasts stalk their human prey." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Months until the Kalends Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "The Kalends Games are underway. The smell of animal sacrifices and incense overpowers even the pungent blood and sweat of the arena." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Months until the Olympic Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "The Olympic Games are underway. The sacred fire burns day and night as athletes compete for immortal glory." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Months until the Roman Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "The Roman Games are underway. Each participant spills their blood, sweat and tears to prove themself the finest Roman." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Great Games will continue for another" }, // ...XX Days,
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Great Games were held recently." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "The Great Games are underway! Your city throngs with travellers and revelry." },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "The arena is closed. Birds make nests in the empty seats." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "This arena hosts neither lions nor gladiators, and provides little entertainment." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "This arena hosts gladiators and animal hunts, to the delight of the locals." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Regular gladiator shows keep the mob entertained, but lions would elevate the spectacle." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Hungry beasts prowl the arena in search of prey, but a lack of trained gladiators makes for brief shows." },
    {TR_OVERLAY_ARENA_COL, "Arena" },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "This house has no access to an arena or the Colosseum." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "This house has access to an arena with one show." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "This house has access to an arena with two shows." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "This house has access to the Colosseum, with one show." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "This house has access to the Colosseum, with two shows." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Workers on strike" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "No water access" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Waiting for the cartpusher" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "No resources available" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Building mothballed" },
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Too many buildings of this type-- travellers avoid this place." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Income from travellers this year:" },
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Your Trade Advisor ordered a halt to fish production."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tribute/interest"},
    {TR_WINDOW_ADVISOR_TOURISM, "Miscellaneous"},
    {TR_WINDOW_FIGURE_TOURIST, "This traveller has spent: "},
    {TR_FIGURE_TYPE_TOURIST,  "Traveller"},
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Incompatible savegame version" },
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "The savegame you're trying to load is for a more recent version of Augustus.\nPlease update Augustus to the most recent version." },
    {TR_BUILDING_COLONNADE, "Colonnade" },
    {TR_BUILDING_LARARIUM, "Lararium" },
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "This small shrine is dedicated to the Lares - the ancestral spirits of the Roman people. Small sacrifices and prayers may be made here."},
    {TR_BUILDING_WATCHTOWER, "Watchtower"},
    {TR_BUILDING_WATCHTOWER_DESC, "Archers on the battlements of this tower keep a vigilant watch for invaders, while watchmen patrol the streets below." },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "This tower needs a sentry from the barracks before it can protect our city."},
    {TR_BUILDING_NYMPHAEUM, "Nymphaeum"},
    {TR_BUILDING_NYMPHAEUM_DESC, "This great temple is dedicated to the water nymphs - minor deities of springs, rivers and seas. It promises beauty and plenty to the surrounding land and divine favor to the city." },
    {TR_BUILDING_SMALL_MAUSOLEUM, "Small Mausoleum"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "This building is the final resting place of past generations of your city's proud families, and the envy of many amongst the living." },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Large Mausoleum"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "The polished marble walls and statues of this magnificent structure reflect the great deeds of the patricians who earned the privilege of resting here." },
    {TR_FIGURE_TYPE_WATCHMAN, "Watchman" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "This temple will collect food for your supply post, once one is constructed." },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Toggle prefects and engineers access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Toggle priests access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Toggle market supplier access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Toggle entertainer access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Toggle education walker access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Toggle health walker access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Toggle tax collector access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Toggle labor seekers access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Toggle missionary access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Toggle watchmen access" },
    {TR_HOTKEY_DUPLICATE_TITLE, "Hotkey already used"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "This key combination is already assigned to the following action:"},
    {TR_BUILDING_GARDEN_PATH, "Garden Path" },
    {TR_BUTTON_GO_TO_SITE, "Go to the site" },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Halt construction" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Resume construction" },
    {TR_RESOURCE_FISH, "Fish" },
    {TR_WARNING_VARIANT_TOGGLE, "Press the rotation key to cycle variants of this building"},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "This school is operational. Local development allowed your citizens to expand the building, providing space for more children."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "This theater is operational. Local development allowed your citizens to expand the building, providing more seating." },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "This library is operational. Local development allowed your citizens to expand the building, providing additional scrolls and reading nooks." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "This monument construction site has no road access and cannot recieve materials. Connect a road to one of the middle tiles."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Due to low city sentiment, the plebians of this workshop have declared secession and refuse to work!" },
    {TR_CITY_WARNING_SECESSION, "Plebians are refusing to work!" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "A warehouse was looted!" },
    {TR_CITY_WARNING_GRANARY_BREAKIN, "A granary was looted!" },
    {TR_CITY_WARNING_THEFT, "Funds were stolen from a forum or senate!" },
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Looting in the city!"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "A warehouse or granary was looted by angry citizens and goods were stolen! Low sentiment makes these incidents more likely."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Invasions" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasion underway" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "No invasions" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasion imminent" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Enemies closing" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Enemies distant" },
    {TR_SIDEBAR_EXTRA_GODS, "Gods" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "View all" },
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Small force"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Average force"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Large force"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Send request"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Store"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Stop storing"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Go to population graphs" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Visit your Housing Advisor" },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "This monument has all the materials needed for this phase. Workers await a skilled architect from an architects' guild to oversee further construction." },
    {TR_RETURN_ALL_TO_FORT, "Return all" },
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Games information" },
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "This statue would look even grander with its fountain working. Provide it with water access." },
    {TR_OPTION_MENU_APPLY, "Apply" },
    {TR_OPTION_MENU_COST, "This will cost" },
    {TR_FIGURE_TYPE_LOOTER, "Looter" },
    {TR_FIGURE_TYPE_ROBBER, "Robber" },
    {TR_OVERLAY_SENTIMENT, "Sentiment" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Nobody" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Everyone" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Select a land trade policy"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "A Caravanserai is required to set a land trade policy"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Select a sea trade policy"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "A Lighthouse is required to set a sea trade policy"},
    {TR_TOOLTIP_HOLD_GAME, "Hold the Games"},
    {TR_TOOLTIP_NO_GAME, "Do not hold the Games"},
    {TR_WARNING_NEARBY_WOLF, "Cannot build when wolves are nearby" },
    {TR_MARKET_TRADING, "Trading"},
    {TR_MARKET_NOT_TRADING, "Not trading"},
    {TR_TEMPLE_DISTRIBUTING, "Distributing"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Not distributing"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Squalid housing and slums prevent immigration"},
    {TR_CITY_MESSAGE_SQUALOR, "Squalid housing and slums are a problem"},
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Lighthouse keeper" },
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "Venue doesn't have access to a reservoir." },
    {TR_HOTKEY_COPY_SETTINGS, "Copy building settings" },
    {TR_HOTKEY_PASTE_SETTINGS, "Paste building settings" },
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Lararia in the city" },
    {TR_WINDOW_RACE_BET_BUTTON, "Bet on a horse"},
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Race in progress..."},
    {TR_WINDOW_RACE_BET_TITLE, "Place a bet on a horse"},
    {TR_WINDOW_RACE_BET_AMOUNT, "Amount"},
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Bet an amount of your personal funds on the chariot team of your choice, and double your stake if your horse wins. Your earnings will even be quadrupled during the Colosseum Games!"},
    {TR_WARNING_BET_VICTORY, "Your horse won the race at your city's Hippodrome"},
    {TR_WARNING_BET_DEFEAT, "Your horse lost the race at your city's Hippodrome"},
    {TR_PERSONAL_SAVINGS, "Savings :"},
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Bet on the blue horse"},
    {TR_WINDOW_RACE_BET_RED_HORSE, "Bet on the red horse"},
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Bet on the white horse"},
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Bet on the green horse"},
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "Without a full staff of priests and attendants, this temple cannot perform all the sacred rites and celebrations. Until that changes, you should not expect divine favour. "},
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "The Colosseum is understaffed. More workers are needed to ensure all of your citizens enjoy the games."},
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "The Hippodrome is understaffed. More workers are needed to provide spectacular entertainment for all of your citizens."},
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "The Lighthouse is understaffed, and cannot keep the fire going. Ships struggle to find the way to your city's docks."},
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "The Caravanserai is understaffed, and cannot keep up support to all the incoming caravans."},
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Roofed garden wall"},
    {TR_BUILDING_GARDEN_WALL_GATE, "Garden gate"},
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "This small gate controls the movement of people in and out of your city's most secluded spots."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "The cart pusher is on his way to get the goods from another warehouse."},
    {TR_BUILDING_PALISADE, "Palisade" },
    {TR_BUILDING_PALISADE_DESC, "This earthen bank, topped by a high wall of sharpened wooden stakes, will keep your city safe from invaders and hostile animals."},
    {TR_OVERLAY_MOTHBALL, "Mothballed"},
    {TR_OVERLAY_ENEMY, "Enemies"},
    {TR_BUILDING_TAVERN_DESC_5, "Citizens love visiting this establishment in their free time to socialize over fine food and wine." },
    {TR_OVERLAY_WAREHOUSES, "Warehouses" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "The Blue team - favourites of Neptune. These are the most promising of Rome's young charioteers who wish to prove themselves." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "The Red team - known as the team of the most successful charioteer in the history of Rome - a former oarsman and saviour of a Roman consul." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "The White team - founded by former gladiators. They have combat in their blood, and even as free men they live for the challenge." },
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "The Green team - descendants of the 'Celeres' horsemen from the time of the Kingdom of Rome. They still claim to be the best of the best." },
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Resume resource delivery"},
    {TR_CONFIG_DIGIT_SEPARATOR, "Separate digits"},
};

void translation_english(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
