/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.scala.jnr;

import eu.geekplace.scala.jnr.Linux$;
import eu.geekplace.scala.jnr.LinuxRtc$;
import eu.geekplace.scala.jnr.linux.rtc.RtcWkalrm;
import eu.geekplace.scala.jnr.linux.rtc.RtcWkalrm$;
import eu.geekplace.scala.jnr.linux.rtc.package$package$;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import jnr.constants.platform.OpenFlags;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logging;
import org.apache.logging.log4j.spi.ExtendedLogger;
import os.Path;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class LinuxRtc
implements AutoCloseable,
Logging {
    private ExtendedLogger logger;
    private final Path rtcDev;
    private final int fd;
    private final ZoneId rtcZone;
    private boolean fdValid;

    public static Path $lessinit$greater$default$1() {
        return LinuxRtc$.MODULE$.$lessinit$greater$default$1();
    }

    public static boolean $lessinit$greater$default$2() {
        return LinuxRtc$.MODULE$.$lessinit$greater$default$2();
    }

    public LinuxRtc(Path rtcDev, boolean rtcInUtc) {
        this.rtcDev = rtcDev;
        Logging.$init$(this);
        this.fd = Linux$.MODULE$.posix().open(rtcDev.toString(), OpenFlags.O_RDONLY.intValue() | OpenFlags.O_CLOEXEC.intValue(), 0);
        if (this.fd() < 0) {
            throw new Exception(new StringBuilder(20).append("Could not open ").append(rtcDev).append(": ").append(Linux$.MODULE$.getErrnoInfoString()).append(" (").append(this.fd()).append(")").toString());
        }
        this.rtcZone = rtcInUtc ? ZoneId.of("UTC") : ZoneId.systemDefault();
        this.fdValid = true;
        Statics.releaseFence();
    }

    @Override
    public ExtendedLogger logger() {
        return this.logger;
    }

    @Override
    public void org$apache$logging$log4j$scala$Logging$_setter_$logger_$eq(ExtendedLogger x$0) {
        this.logger = x$0;
    }

    public int fd() {
        return this.fd;
    }

    public ZoneId rtcZone() {
        return this.rtcZone;
    }

    public boolean fdValid() {
        return this.fdValid;
    }

    public void fdValid_$eq(boolean x$1) {
        this.fdValid = x$1;
    }

    public void setAlarm(Instant when) {
        if (!this.fdValid()) {
            throw new Exception(new StringBuilder(35).append("File descriptor for ").append(this.rtcDev).append(" already closed").toString());
        }
        LocalDateTime rtcDateTime = LocalDateTime.ofInstant(when, this.rtcZone());
        RtcWkalrm rtcWkarlm = RtcWkalrm$.MODULE$.apply(rtcDateTime, RtcWkalrm$.MODULE$.apply$default$2(), RtcWkalrm$.MODULE$.apply$default$3());
        int res = Linux$.MODULE$.libc().ioctl(this.fd(), package$package$.MODULE$.RTC_WKALM_SET(), rtcWkarlm);
        if (res < 0) {
            throw new Exception(new StringBuilder(29).append("Could not set ").append(this.rtcDev).append(" alarm to ").append(when).append(": ").append(Linux$.MODULE$.getErrnoInfoString()).append(" (").append(res).append(")").toString());
        }
    }

    @Override
    public void close() {
        if (this.fdValid()) {
            int res;
            this.fdValid_$eq(false);
            ExtendedLogger Logger_this = this.logger();
            if (Logger_this.isEnabled(Level.DEBUG)) {
                Logger_this.log(Level.DEBUG, "Closing file descriptor {} for {}".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger(this.fd()), this.rtcDev}), Object.class));
            }
            if ((res = Linux$.MODULE$.posix().close(this.fd())) < 0) {
                throw new Exception(new StringBuilder(40).append("Failed to close ").append(this.rtcDev).append("'s file descriptor ").append(this.fd()).append(": ").append(Linux$.MODULE$.getErrnoInfoString()).append(" (").append(res).append(")").toString());
            }
            return;
        }
    }
}

