/*
  gmorgan - a ryhthm station software

  gmorgan.fileIO.Cc  -  Most file activity
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modified by Josep Andreu
   modified by Robert Vogel (7/11/2015)
*/

#include "GMorgan.h"
#include "Chord.h"
#include <fstream>
#include <iostream>
#include <algorithm>
#include <vector>
#include <string> 
#include <stdio.h>
#include <stdlib.h>

using namespace std;
extern CHORD zing;

void
GMO::loadpatt (char *filename)
{

  FILE *fs;
  char temp[128];
  int NumRit, i, j, k;
  int w, haymas, contemp, NumMiCont, NumMiDr;
  haymas = 1;
  bzero (temp, sizeof (temp));
  cout << "loading patterns from " << filename << endl;
  if ((fs = fopen (filename, "r")) != NULL)
    {
      for (NumRit = prime; NumRit < ulti; NumRit++)
	{
	  patternclear (NumRit);
	  PonCeroDrum ();
	  PonCeroControl ();

	  bzero (Rt[NumRit].Nom, sizeof (Rt[NumRit].Nom));
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  for (i = 0; i <= (int) strlen (temp) - 2; i++)
	    Rt[NumRit].Nom[i] = temp[i];
	  if (strcmp (Rt[NumRit].Nom, "Empty") != 0)
	    {

	      bzero (Rt[NumRit].Nfile, sizeof (Rt[NumRit].Nfile));
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      for (i = 0; i <= (int) strlen (temp) - 2; i++)
		Rt[NumRit].Nfile[i] = temp[i];
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",
		      &Rt[NumRit].bars, &Rt[NumRit].blackn,
		      &Rt[NumRit].octavate, &Rt[NumRit].acc2mode,
		      &Rt[NumRit].swing, &Rt[NumRit].acc3mode,
		      &Rt[NumRit].acc4mode, &Rt[NumRit].acc5mode,
		      &Rt[NumRit].octavate4, &Rt[NumRit].terceras4,
		      &Rt[NumRit].sextas4);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d,%d,%d", &Rt[NumRit].dron,
		      &Rt[NumRit].drpc, &Rt[NumRit].drvol, &Rt[NumRit].drpan,
		      &Rt[NumRit].drrev, &Rt[NumRit].drcho);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Rt[NumRit].drocta,
		      &Rt[NumRit].drBankM, &Rt[NumRit].drpon,
		      &Rt[NumRit].drptime);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d,%d,%d", &Rt[NumRit].basson,
		      &Rt[NumRit].basspc, &Rt[NumRit].bassvol,
		      &Rt[NumRit].basspan, &Rt[NumRit].bassrev,
		      &Rt[NumRit].basscho);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Rt[NumRit].bassocta,
		      &Rt[NumRit].bassBankM, &Rt[NumRit].basspon,
		      &Rt[NumRit].bassptime);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d,%d,%d", &Rt[NumRit].acc1on,
		      &Rt[NumRit].acc1pc, &Rt[NumRit].acc1vol,
		      &Rt[NumRit].acc1pan, &Rt[NumRit].acc1rev,
		      &Rt[NumRit].acc1cho);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Rt[NumRit].acc1octa,
		      &Rt[NumRit].acc1BankM, &Rt[NumRit].acc1pon,
		      &Rt[NumRit].acc1ptime);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d,%d,%d", &Rt[NumRit].acc2on,
		      &Rt[NumRit].acc2pc, &Rt[NumRit].acc2vol,
		      &Rt[NumRit].acc2pan, &Rt[NumRit].acc2rev,
		      &Rt[NumRit].acc2cho);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Rt[NumRit].acc2octa,
		      &Rt[NumRit].acc2BankM, &Rt[NumRit].acc2pon,
		      &Rt[NumRit].acc2ptime);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d,%d,%d", &Rt[NumRit].acc3on,
		      &Rt[NumRit].acc3pc, &Rt[NumRit].acc3vol,
		      &Rt[NumRit].acc3pan, &Rt[NumRit].acc3rev,
		      &Rt[NumRit].acc3cho);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Rt[NumRit].acc3octa,
		      &Rt[NumRit].acc3BankM, &Rt[NumRit].acc3pon,
		      &Rt[NumRit].acc3ptime);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d,%d,%d", &Rt[NumRit].acc4on,
		      &Rt[NumRit].acc4pc, &Rt[NumRit].acc4vol,
		      &Rt[NumRit].acc4pan, &Rt[NumRit].acc4rev,
		      &Rt[NumRit].acc4cho);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Rt[NumRit].acc4octa,
		      &Rt[NumRit].acc4BankM, &Rt[NumRit].acc4pon,
		      &Rt[NumRit].acc4ptime);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d,%d,%d", &Rt[NumRit].acc5on,
		      &Rt[NumRit].acc5pc, &Rt[NumRit].acc5vol,
		      &Rt[NumRit].acc5pan, &Rt[NumRit].acc5rev,
		      &Rt[NumRit].acc5cho);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Rt[NumRit].acc5octa,
		      &Rt[NumRit].acc5BankM, &Rt[NumRit].acc5pon,
		      &Rt[NumRit].acc5ptime);
	      NumMiDr = 0;
	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 1; j < 62; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      fgets (temp, sizeof temp, fs);
		      sscanf (temp, "%d,%d,%d,%d", &Edr[j][w + 1],
			      &Edr[j][w + 2], &Edr[j][w + 3], &Edr[j][w + 4]);
		      for (k = 1; k <= 4; k++)
			{
			  if (Edr[j][w + k] != 0)
			    {
			      Rt[NumRit].EvDr[NumMiDr].posicion = w + k;
			      Rt[NumRit].EvDr[NumMiDr].nota = j;
			      Rt[NumRit].EvDr[NumMiDr].valor = Edr[j][w + k];
			      NumMiDr++;
			    }
			}

		    }
		}
	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      fgets (temp, sizeof temp, fs);
		      sscanf (temp, "%d,%d,%d,%d", &Rt[NumRit].basn[j][w + 1],
			      &Rt[NumRit].basn[j][w + 2],
			      &Rt[NumRit].basn[j][w + 3],
			      &Rt[NumRit].basn[j][w + 4]);
		    }
		}
	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 2; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      fgets (temp, sizeof temp, fs);
		      sscanf (temp, "%d,%d,%d,%d",
			      &Rt[NumRit].acc1n[j][w + 1],
			      &Rt[NumRit].acc1n[j][w + 2],
			      &Rt[NumRit].acc1n[j][w + 3],
			      &Rt[NumRit].acc1n[j][w + 4]);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      fgets (temp, sizeof temp, fs);
		      sscanf (temp, "%d,%d,%d,%d",
			      &Rt[NumRit].acc2n[j][w + 1],
			      &Rt[NumRit].acc2n[j][w + 2],
			      &Rt[NumRit].acc2n[j][w + 3],
			      &Rt[NumRit].acc2n[j][w + 4]);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      fgets (temp, sizeof temp, fs);
		      sscanf (temp, "%d,%d,%d,%d",
			      &Rt[NumRit].acc3n[j][w + 1],
			      &Rt[NumRit].acc3n[j][w + 2],
			      &Rt[NumRit].acc3n[j][w + 3],
			      &Rt[NumRit].acc3n[j][w + 4]);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      fgets (temp, sizeof temp, fs);
		      sscanf (temp, "%d,%d,%d,%d",
			      &Rt[NumRit].acc4n[j][w + 1],
			      &Rt[NumRit].acc4n[j][w + 2],
			      &Rt[NumRit].acc4n[j][w + 3],
			      &Rt[NumRit].acc4n[j][w + 4]);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      fgets (temp, sizeof temp, fs);
		      sscanf (temp, "%d,%d,%d,%d",
			      &Rt[NumRit].acc5n[j][w + 1],
			      &Rt[NumRit].acc5n[j][w + 2],
			      &Rt[NumRit].acc5n[j][w + 3],
			      &Rt[NumRit].acc5n[j][w + 4]);
		    }
		}

	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d,%d,%d,%d,%d", &Rt[NumRit].terceras,
		      &Rt[NumRit].sextas, &Rt[NumRit].bassstlt,
		      &Rt[NumRit].acc1stlt, &Rt[NumRit].acc2stlt,
		      &Rt[NumRit].acc3stlt, &Rt[NumRit].acc4stlt,
		      &Rt[NumRit].acc5stlt);

	      haymas = 1;
	      NumMiCont = 1;

	      while (haymas == 1)
		{
		  bzero (temp, sizeof (temp));
		  fgets (temp, sizeof temp, fs);
		  if (temp[0] != '-')
		    {
		      if (NumMiCont < 1000)
			{
			  sscanf (temp, "%d,%d,%d,%d", &j, &k, &w, &contemp);
			  Rt[NumRit].EvMidCon[NumMiCont].pista = j;
			  Rt[NumRit].EvMidCon[NumMiCont].controlador = k;
			  Rt[NumRit].EvMidCon[NumMiCont].posicion = w;
			  Rt[NumRit].EvMidCon[NumMiCont].valor = contemp;
			  NumMiCont++;
			}
		    }
		  else
		    haymas = 0;
		}

	      for (i = 1; i <= 5; i++)
		{
		  bzero (temp, sizeof (temp));
		  fgets (temp, sizeof temp, fs);
		}

	    }
	}
	fclose (fs);
    }
};

void
GMO::loadfile (char *filename)
{
  FILE *fs;
  char temp[128];
  int i;
  int j;
  int k;
  bzero (temp, sizeof (temp));
  cout << " loading file " << filename << endl;
  if ((fs = fopen (filename, "r")) != NULL)
    {
      for (i = prime; i <= ulti; i++)
	{
	  bzero (Prog[i].Nom, sizeof (Prog[i].Nom));
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  for (k = 0; k <= (int) strlen (temp) - 2; k++)
	    Prog[i].Nom[k] = temp[k];
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d,%d", &Prog[i].style, &Prog[i].pattern,
		  &Prog[i].bpm, &Prog[i].transpose);
/*
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d,%d", &v1lowVelocity, &v1highVelocity,
		  &v1lowMidi, &v1highMidi);
	  cout << "loading sound " << i << " lownote " << v1lowMidi << " hinote " << v1highMidi << endl;
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d,%d", &v2lowVelocity, &v2highVelocity,
		  &v2lowMidi, &v2highMidi);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d,%d", &v3lowVelocity, &v3highVelocity,
		  &v3lowMidi, &v3highMidi);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d,%d", &v4lowVelocity, &v4highVelocity,
		  &v4lowMidi, &v4highMidi);
*/
	  int dummy1, dummy2;
	  for (j = 1; j <= 4; j++)
	    {
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Prog[i].progch[j],
		      &Prog[i].volume[j], &Prog[i].BankLSB[j],
		      &Prog[i].BankMSB[j]);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Prog[i].pan[j], &Prog[i].Pon[j],
		      &Prog[i].reverb[j], &Prog[i].chorus[j]);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d", &Prog[i].Ptime[j], &Prog[i].OnOff[j],
		      &Prog[i].octa[j]);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d,%d,%d", &Prog[i].lowvel[j], &Prog[i].hivel[j],
		       &Prog[i].lonote[j], &Prog[i].hinote[j]);
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      sscanf (temp, "%d,%d", &dummy1, &dummy2);
	    }
	}
        fclose (fs);
    }
};

void
GMO::loadstyl (char *filename)
{
  FILE *fs;
  char temp[128];
  int i, k;
  bzero (temp, sizeof (temp));
  if ((fs = fopen (filename, "r")) != NULL)
    {
      for (i = prime; i <= ulti; i++)
	{
	  bzero (Styl[i].Nom, sizeof (Styl[i].Nom));
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  for (k = 0; k <= (int) strlen (temp) - 2; k++)
	    Styl[i].Nom[k] = temp[k];
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d,%d", &Styl[i].Intro, &Styl[i].Var1,
		  &Styl[i].Var2, &Styl[i].Fill1);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d,%d,%d", &Styl[i].Fill2, &Styl[i].Ending,
		  &Styl[i].programa, &Styl[i].bpm, &Styl[i].startP);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	}
        fclose (fs);
    }
};


void
GMO::savestyl (char *filename)
{

  FILE *fs;
  char temp[128];
  int i;
  bzero (temp, sizeof (temp));

  if ((fs = fopen (filename, "w")) != NULL)
    {
      for (i = prime; i <= ulti; i++)
	{
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", Styl[i].Nom);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d\n", Styl[i].Intro, Styl[i].Var1,
		   Styl[i].Var2, Styl[i].Fill1);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d,%d\n", Styl[i].Fill2, Styl[i].Ending,
		   Styl[i].programa, Styl[i].bpm, Styl[i].startP);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n");
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n");
	  fputs (temp, fs);
	}
      fclose (fs);
    }
};


void
GMO::savevelo (char *filename)
{
  FILE *fs;
  char temp[128];
  int i;
  bzero (temp, sizeof (temp));

  if ((fs = fopen (filename, "w")) != NULL)
    {
      for (i = 1; i <= 61; i++)
	{

	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d\n", veloplus[i]);
	  fputs (temp, fs);
	}
      fclose (fs);
    }
};

void
GMO::loadvelo (char *filename)
{
  FILE *fs;
  char temp[128];
  int i;
  bzero (temp, sizeof (temp));
  if ((fs = fopen (filename, "r")) != NULL)
    {
      for (i = 1; i <= 61; i++)
	{
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d", &veloplus[i]);
	}
        fclose (fs);
    }
};

void
GMO::loadsong (char *filename)
{
  FILE *fs;
  char temp[128];
  int i, k;
  cout << "loading: " << filename << endl;
  bzero (temp, sizeof (temp));
  if ((fs = fopen (filename, "r")) != NULL)
    {
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (k = 0; k <= (int) strlen (temp) - 2; k++)
	  NombreSong[k] = temp[k];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      sscanf (temp, "%d,%d,%d", &TempoSong, &SNomi, &InvMode);
      for (i = 1; i <= 128; i++)
	{
	  bzero (S[i].ch1, sizeof (S[i].ch1));
	  bzero (S[i].ch2, sizeof (S[i].ch2));
	  bzero (S[i].ch3, sizeof (S[i].ch3));
	  bzero (S[i].ch4, sizeof (S[i].ch4));
	  bzero (S[i].go_to, sizeof (S[i].go_to));
	  bzero (S[i].go_af, sizeof (S[i].go_af));
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  if (strlen (temp) > 0)
	    sscanf (temp, "%s", (char *) S[i].ch1);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  if (strlen (temp) > 0)
	    sscanf (temp, "%s", (char *) S[i].ch2);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  if (strlen (temp) > 0)
	    sscanf (temp, "%s", (char *) S[i].ch3);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  if (strlen (temp) > 0)
	    sscanf (temp, "%s", (char *) S[i].ch4);

	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d", &S[i].a, &S[i].b,
		  &S[i].c, &S[i].d, &S[i].e, &S[i].f, &S[i].g, &S[i].h,
		  &S[i].fin);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  if (strlen (temp) > 0)
	    sscanf (temp, "%s", (char *) S[i].go_to);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  if (strlen (temp) > 0)
	    sscanf (temp, "%s", (char *) S[i].go_af);
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d,%d,%d", &S[i].times, &S[i].atimes,
		  &S[i].pattern, &S[i].ar8, &S[i].ar16);
	}
      i = 1;
      while (!feof (fs))
	{
	  bzero (temp, sizeof (temp));
	  fgets (temp, sizeof temp, fs);
	  sscanf (temp, "%d,%d,%d", &TemT[i].bar, &TemT[i].black,
		  &TemT[i].tempo);
	  i++;
	}
      if (S[1].pattern == 0)
	{
	  cout << "Please provide a pattern for this song...making it 7. " << endl;
	  S[1].pattern = 7;
	}
      cout << " setting pattern to " << S[1].pattern << endl;
      MeteMixerMidi (S[1].pattern);
      cambiapat = 1;
      fclose (fs);
    }
};
// make a lilypond lead sheet file.
// To actually print, install lilypond.
void
GMO::printsong (char *filename)
{
  FILE *fs;
  char temp[128];
  int i,j;
  std::string currentchord;
  std::string lastchord;
// Write headings for lilypond file.
  std::string prologue = "\\version ";
  prologue.append ( "\"2.16.0\"");
  std::string headerly = "\\header{";
  std::string startchord = "harmonies = \\chordmode {";
  std::string hugefont = "\\huge";
  cout << "creating lilypond file: " << filename << endl;
	ofstream file;
    file.open (filename);
    streambuf* sbuf = cout.rdbuf();
    cout.rdbuf(file.rdbuf());
    cout << prologue << endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << headerly << endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "title = \"" << NombreSong << "\"" << endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "}" << endl;
    cout.rdbuf(sbuf);

    cout.rdbuf(file.rdbuf());
    cout << startchord << endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << hugefont << endl;
    cout.rdbuf(sbuf);
    cout << " time signature " << SNomi << endl;	
/*
      bzero (temp, sizeof (temp));
      sprintf (temp, "%d,%d,%d\n", TempoSong, SNomi, InvMode);
      fputs (temp, fs);
	bzero (temp, sizeof (temp));
//	  sprintf (temp, "%d,%d,%d,%d,%d\n", S[i].times, S[i].atimes,
//		   S[i].pattern, S[i].ar8, S[i].ar16);
*/
      for (i = 1; i <= 128; i++)
	{
          if (S[i].fin == 1) break;	
//	  bzero (temp, sizeof (temp));
//	  sprintf (temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d\n", S[i].a, S[i].b,
//		   S[i].c, S[i].d, S[i].e, S[i].f, S[i].g, S[i].h, S[i].fin);
//	  fputs (temp, fs);
	cout << "enter bar " << i << " beats = " << SNomi << endl;
	std::vector<std::string> lilystring;
	std::vector<int> dur;
	std::vector<std::string> chordmod;
	std::string beatstring;
// ***********************************
// determine string for each chord in this measure.		
// ***********************************
	lastchord = "";
	for (j = 1; j <= SNomi; j++)
	{
	cout << " switch " << j << " bar " << i << endl;
	currentchord = "";
	 switch (j)
	    {
		    case 1:     // first beat of the measure 
		      {
			beatstring = "1";
			currentchord.assign(S[i].ch1);
			cout << "Measure: " << i << "chord 1 - " << currentchord << endl;
//	For some reason, Lilypond doesn't accept the same chord twice in a row. 
			if ((currentchord.length () > 0) && (lastchord != currentchord))
			  {
			  vector < int >midinotes = zing.Chordsym2Midi (currentchord, 1);
//			  cout << " Bar " << i << " beat " << j << " = " << currentchord << " root " << zing.root << " mod " << zing.chordtype << endl;
			  std::string rootbase = zing.root;
			  if (midinotes.at (0) == 12)
		                {
		                  cout << "Bar #" << i <<
		                    " Beat 1: Unrecognized Chord: " << currentchord <<
		                    " rejected " << endl;
				dur.push_back(0);
// try to fix it ?
				currentchord.assign(" ");
				break;
		                }
			  else
				{
				cout << "push back 1 " << endl;
				dur.push_back(1);
				}
			  }
			  else
				{
				dur.push_back(0);
				}
			cout << " beat 1 size of dur: " << int (dur.size()) << endl;
			break;
		      }
		    case 2:                 
			{
			beatstring = "2";
			currentchord.assign(S[i].ch2);
			cout << "Measure: " << i << "chord 2 - " << currentchord << endl;
//	For some reason, Lilypond doesn't accept the same chord twice in a row. 
			if ((currentchord.length () > 0) && (lastchord != currentchord))
			  {
			  vector < int >midinotes = zing.Chordsym2Midi (currentchord, 1);
//			  cout << " Bar " << i << " beat " << j << " = " << currentchord << " root " << zing.root << " mod " << zing.chordtype << endl;
			  std::string rootbase = zing.root;
			  if (midinotes.at (0) == 12)
		                {
		                  cout << "Bar #" << i <<
		                    " Beat 1: Unrecognized Chord: " << currentchord <<
		                    " rejected " << endl;
				dur.push_back(0);
// try to fix it ?
				currentchord.assign(" ");
				break;
		                }
				else
				{
				if (dur.at(0) !=0) dur.at(0) = 4;
				if (SNomi > 2  )
					{
					dur.push_back(SNomi-1);
					}
				else
					{
					dur.push_back(4);
					}
				}
			}	
			else
				{
				dur.push_back(0);
				}
			break;
			}
		    case 3:                 
			{
			beatstring = "3";
			currentchord.assign(S[i].ch3);
			cout << " start beat 3 size of dur: " << int (dur.size());
			cout << " Measure: " << i << "chord 3 - " << currentchord << endl;
//	For some reason, Lilypond doesn't accept the same chord twice in a row. 
			if ((currentchord.length () > 0) && (lastchord != currentchord))
			  {
			  vector < int >midinotes = zing.Chordsym2Midi (currentchord, 1);
//			  cout << " Bar " << i << " beat " << j << " = " << currentchord << " root " << zing.root << " mod " << zing.chordtype << endl;
			  std::string rootbase = zing.root;
			  if (midinotes.at (0) == 12)
		                {
		                  cout << "Bar #" << i <<
		                    " Beat 3: Unrecognized Chord: " << currentchord <<
		                    " rejected " << endl;
				dur.push_back(0);
// try to fix it ?
				currentchord.assign(" ");
				break;
		                }
				else	
				{
					if (dur.at(0) == 1) dur.at(0) = 2; 
					if (dur.at(1) != 0) dur.at(1) = 4;
					if (SNomi > 3)
						dur.push_back(SNomi-2);
					else
						dur.push_back(0);
				}
			}
			else
				{
				dur.push_back(0);
				}	
			break;
			}
		    case 4:                 
			{
			if (SNomi > 3)
			{
				beatstring = "4";
				currentchord.assign(S[i].ch4);
				cout << " start beat 4 size of dur: " << int (dur.size());
				cout << " Measure: " << i << "chord 4 - " << currentchord << endl;
//	For some reason, Lilypond doesn't accept the same chord twice in a row. 
				if ((currentchord.length () > 0) && (lastchord != currentchord))
				  {
				  vector < int >midinotes = zing.Chordsym2Midi (currentchord, 1);
//				  cout << " Bar " << i << " beat " << j << " = " << currentchord << " root " << zing.root << " mod " << zing.chordtype << endl;
				  std::string rootbase = zing.root;
				  if (midinotes.at (0) == 12)
		              	 	 {
		                  cout << "Bar #" << i <<
		                    " Beat 4: Unrecognized Chord: " << currentchord <<
		                    " rejected " << endl;
					dur.push_back(0);
// try to fix it ?
					currentchord.assign(" ");
					break;
		               		 }
					else
					{
					if (dur.at(0) == 1) dur.at(0) = 3;
					if (dur.at(1) == 3) dur.at(1) = 2;
					if (dur.at(2) == 2)
						{
						dur.at(2) = 4;
						}
					dur.push_back(4);
					}
				}
				else
					{
					dur.push_back(0);
					}	
				}
				break;
			}
		}
// convert to lilypond chord notation;
	  cout << "  continue with currentchord: " << currentchord << endl;
//   don't need this.
/*
	if ((currentchord.length () > 0) && (lastchord != currentchord))
	  {
	  lastchord = currentchord;
	  vector < int >midinotes = zing.Chordsym2Midi (currentchord, 1);
	  cout << " Bar " << i << " beat " << j << " = " << currentchord << " root " << zing.root << " mod " << zing.chordtype << endl;
	  std::string rootbase = zing.root;
	  if (midinotes.at (0) == 12)
                {
                  cout << "Bar #" << i <<
                    " ==>Unrecognized Chord: " << currentchord <<
                    " rejected " << endl;
		  lilystring.push_back ("?");
//		  chordmod.push_back(beatstring);
                }
	  else
*/
	if (currentchord.length () > 0)
		{
		  lastchord = currentchord;
		  std::string rootbase = zing.root;
		std::transform(rootbase.begin(), rootbase.end(), rootbase.begin(), ::tolower);
//	Convert root to lilypond notation.
		std::string lilyroot;
		lilyroot.assign (rootbase,0,1);
  		if (rootbase.length () > 1)
			{
			if (rootbase.at (1) == 'b') lilyroot.append("es");
			if (rootbase.at (1) == '#') lilyroot.append ("is");	
			}
//			
		lilystring.push_back(lilyroot);
// **************************************************************************************************************************
// note: translate from chordtype to lilypond modifier..
// Lilypond Chord modifiers are detailed at http://www.lilypond.org/doc/v2.18/Documentation/notation/common-chord-modifiers
// **************************************************************************************************************************
		cout << "changing chordmod from " << zing.chordtype << " bar " << i << " beat " << j << endl;
		std::string chordtyp;
		chordtyp = zing.chordtype;
		cout << " chordtyp " << chordtyp << " # " << beatstring << endl;
		if (chordtyp.at (0) == 'M')
			{
			if (chordtyp.length () > 1)
				{
				chordtyp.assign (chordtyp.begin () + 1, chordtyp.end ());
				if (chordtyp.at (0) == '7')
					chordmod.push_back("maj7"); 
				else
					chordmod.push_back("maj7"); 
				}
			else
				chordmod.push_back("maj");
			}
		else
			{
			if (chordtyp.at (0) == 'm')
				{
				if (chordtyp.length () > 1)
					{
					chordtyp.assign (chordtyp.begin () + 1, chordtyp.end ());
					if (chordtyp.at (0) == '7')
						chordmod.push_back("m7"); 
					else
						chordmod.push_back("m");
					}
				}
			else
				{
				if (chordtyp.at (0) == '7')
					{
					chordmod.push_back("7");
					cout << " it's a 7 " << endl;
					}
				else
					if (chordtyp.at (0) == 'o')
						{
						chordmod.push_back("dim7");
						cout << " it's a dim7 " << endl;
						}
					else
						chordmod.push_back("6");
				}
			}
	  }
	  else
		{
	  	chordmod.push_back(" ");
		}
	}	
// unpack vectors, put strings together, then write them.
	cout << "done with measure " << i << endl;
	int y = 0;
	int z = 0;
	for (int k = 1; k <= (dur.size()); k++)
	{
	cout << " bar ==== " << i << " beat " << k << " dur " << dur.at(k-1);
	cout << " size of dur: " << int (dur.size()) << endl;
//	cout << " lilystring " << y << " = " << lilystring.at(y) << " size of lilystring " << lilystring.size() << endl;
	if (dur.at(k-1) != 0)
		{
		if (dur.at(k-1) == 1) lilystring.at(y).append("1");
		if (dur.at(k-1) == 2) lilystring.at(y).append("2");
		if (dur.at(k-1) == 3) lilystring.at(y).append("2.");
		if (dur.at(k-1) == 4) lilystring.at(y).append("4");
		lilystring.at(y).append(":");
		lilystring.at(y).append(chordmod.at(k-1));
//		cout << " writing: " << lilystring.at(y) << " y= " << y << " z= " << z << " k-1= " << k-1 << endl;
		cout.rdbuf(file.rdbuf());
		cout << lilystring.at(y) << std::endl;
		cout.rdbuf(sbuf);
		z++;
		y++;
		}
/*
	else
		{
		cout << "writing 4 rest " << endl;
		cout.rdbuf(file.rdbuf());
		cout << " r4 "<< std::endl;
		cout.rdbuf(sbuf);
		}
*/
	}
	if (y == 0)
		{
		cout << "writing empty measure " << endl;
		cout.rdbuf(file.rdbuf());
		cout << " r1 "<< std::endl;
		cout.rdbuf(sbuf);
		}
// *************************************************************** loop drops out here when measure is complete. 
	cout << " | " << std::endl;
	cout.rdbuf(sbuf);
// break every 4 bars.
	if ((i%4) == 0)
		{
		cout.rdbuf(file.rdbuf());
		cout << "\\break" << std::endl;
		cout.rdbuf(sbuf);
		}
    }
    cout << " there are " << i << "measures" << std::endl;
    cout.rdbuf(file.rdbuf());
    cout << "}" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "melody = \\relative c' {" << std::endl;
    cout.rdbuf(sbuf);
    for (int nomo = 1; nomo <= i; nomo++)
	{
	    cout.rdbuf(file.rdbuf());
	    cout << "r1" << std::endl;
	    cout.rdbuf(sbuf);
	}
    cout.rdbuf(file.rdbuf());
    cout << "}" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "\\score {" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "<<" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "\\new ChordNames {" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "\\set chordChanges = ##t" <<std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "\\harmonies" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "}" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "\\new Staff \\melody" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << ">>" << std::endl;
    cout.rdbuf(file.rdbuf());
    cout << "\\layout{ }" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "\\midi { }" << std::endl;
    cout.rdbuf(sbuf);
    cout.rdbuf(file.rdbuf());
    cout << "}" << std::endl;
    cout.rdbuf(sbuf);
//	file.close;
};

void
GMO::savesong (char *filename)
{
  FILE *fs;
  char temp[128];
  int i;
  cout << "saving: " << filename << endl;
  bzero (temp, sizeof (temp));
  if ((fs = fopen (filename, "w")) != NULL)
    {
      sprintf (temp, "%s\n", NombreSong);
      fputs (temp, fs);
      bzero (temp, sizeof (temp));
      sprintf (temp, "%d,%d,%d\n", TempoSong, SNomi, InvMode);
      fputs (temp, fs);
      for (i = 1; i <= 128; i++)
	{
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", S[i].ch1);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", S[i].ch2);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", S[i].ch3);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", S[i].ch4);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d\n", S[i].a, S[i].b,
		   S[i].c, S[i].d, S[i].e, S[i].f, S[i].g, S[i].h, S[i].fin);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", S[i].go_to);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", S[i].go_af);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d,%d\n", S[i].times, S[i].atimes,
		   S[i].pattern, S[i].ar8, S[i].ar16);
	  fputs (temp, fs);
	}
      i = 1;
      while (TemT[i].bar != 0)
	{
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d\n", TemT[i].bar, TemT[i].black,
		   TemT[i].tempo);
	  fputs (temp, fs);
	  i++;
	}
      fclose (fs);
    }
};

void
GMO::savefile (char *filename)
{
  FILE *fs;
  char temp[128];
  int i, j;
  bzero (temp, sizeof (temp));
  cout << "saving file: shouldn't be used !!!!! " << filename << endl;
  if ((fs = fopen (filename, "w")) != NULL)
    {
      for (i = prime; i <= ulti; i++)
	{

	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", Prog[i].Nom);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d\n", Prog[i].style, Prog[i].pattern,
		   Prog[i].bpm, Prog[i].transpose);
	  fputs (temp, fs);
	  for (j = 1; j <= 4; j++)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Prog[i].progch[j],
		       Prog[i].volume[j], Prog[i].BankLSB[j],
		       Prog[i].BankMSB[j]);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Prog[i].pan[j], Prog[i].Pon[j],
		       Prog[i].reverb[j], Prog[i].chorus[j]);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d\n", Prog[i].Ptime[j], Prog[i].OnOff[j],
		       Prog[i].octa[j]);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d,%d,%d\n", 0, 0, 0, 0, 0, 0);
	      fputs (temp, fs);
	    }
	}
      fclose (fs);
    }

};

void
GMO::savesoundfile (int soundno, char *filename)
{
  FILE *fs;
  char temp[128];
  int i, j;
  GetCombiM (soundno);
  bzero (temp, sizeof (temp));
  cout << " saving soundfile : " << filename << endl;
  if ((fs = fopen (filename, "w")) != NULL)
    {
      for (i = prime; i <= ulti; i++)
	{
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", Prog[i].Nom);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d\n", Prog[i].style, Prog[i].pattern,
		   Prog[i].bpm, Prog[i].transpose);
	  fputs (temp, fs);
/*
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d\n", v1lowVelocity, v1highVelocity,
		   v1lowMidi, v1highMidi);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d\n", v2lowVelocity, v2highVelocity,
		   v2lowMidi, v2highMidi);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d\n", v3lowVelocity, v3highVelocity,
		   v3lowMidi, v3highMidi);
	  fputs (temp, fs);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d\n", v4lowVelocity, v4highVelocity,
		   v4lowMidi, v4highMidi);
	  fputs (temp, fs);
*/
	  for (j = 1; j <= 4; j++)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Prog[i].progch[j],
		       Prog[i].volume[j], Prog[i].BankLSB[j],
		       Prog[i].BankMSB[j]);
//         sprintf(temp,"%d,%d,%d,%d\n",progch[j],Prog[i].volume[j],Prog[i].BankLSB[j],Prog[i].BankMSB[j]);
	      fputs (temp, fs);

	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Prog[i].pan[j], Prog[i].Pon[j],
		       Prog[i].reverb[j], Prog[i].chorus[j]);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d\n", Prog[i].Ptime[j], Prog[i].OnOff[j],
		       Prog[i].octa[j]);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Prog[i].lowvel[j], Prog[i].hivel[j],
		       Prog[i].lonote[j], Prog[i].hinote[j]);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d\n", 0, 0);
	      fputs (temp, fs);
		
	    }
	}
      fclose (fs);
    }

};


void
GMO::savepatt (char *filename)
{
  FILE *fs;
  char temp[128];
  int w = 0;
  int NumRit, i, j;
  bzero (temp, sizeof (temp));
  cout << " saving pattern file: " << filename << endl;
  if ((fs = fopen (filename, "w")) != NULL)
    {
      for (NumRit = prime; NumRit < ulti; NumRit++)
	{
	  PonDrumTemp (NumRit);
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%s\n", Rt[NumRit].Nom);
	  fputs (temp, fs);
	  if (strcmp (Rt[NumRit].Nom, "Empty") != 0)
	    {
	      if (Rt[NumRit].drBankM == 128)
		Rt[NumRit].drBankM = 1;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%s\n", Rt[NumRit].Nfile);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",
		       Rt[NumRit].bars, Rt[NumRit].blackn,
		       Rt[NumRit].octavate, Rt[NumRit].acc2mode,
		       Rt[NumRit].swing, Rt[NumRit].acc3mode,
		       Rt[NumRit].acc4mode, Rt[NumRit].acc5mode,
		       Rt[NumRit].octavate4, Rt[NumRit].terceras4,
		       Rt[NumRit].sextas4);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d,%d,%d\n", Rt[NumRit].dron,
		       Rt[NumRit].drpc, Rt[NumRit].drvol, Rt[NumRit].drpan,
		       Rt[NumRit].drrev, Rt[NumRit].drcho);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Rt[NumRit].drocta,
		       Rt[NumRit].drBankM, Rt[NumRit].drpon,
		       Rt[NumRit].drptime);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d,%d,%d\n", Rt[NumRit].basson,
		       Rt[NumRit].basspc, Rt[NumRit].bassvol,
		       Rt[NumRit].basspan, Rt[NumRit].bassrev,
		       Rt[NumRit].basscho);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Rt[NumRit].bassocta,
		       Rt[NumRit].bassBankM, Rt[NumRit].basspon,
		       Rt[NumRit].bassptime);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d,%d,%d\n", Rt[NumRit].acc1on,
		       Rt[NumRit].acc1pc, Rt[NumRit].acc1vol,
		       Rt[NumRit].acc1pan, Rt[NumRit].acc1rev,
		       Rt[NumRit].acc1cho);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Rt[NumRit].acc1octa,
		       Rt[NumRit].acc1BankM, Rt[NumRit].acc1pon,
		       Rt[NumRit].acc1ptime);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
//       Rt[NumRit].acc2on = 0;
	      sprintf (temp, "%d,%d,%d,%d,%d,%d\n", Rt[NumRit].acc2on,
		       Rt[NumRit].acc2pc, Rt[NumRit].acc2vol,
		       Rt[NumRit].acc2pan, Rt[NumRit].acc2rev,
		       Rt[NumRit].acc2cho);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Rt[NumRit].acc2octa,
		       Rt[NumRit].acc2BankM, Rt[NumRit].acc2pon,
		       Rt[NumRit].acc2ptime);
	      fputs (temp, fs);

	      bzero (temp, sizeof (temp));
//       Rt[NumRit].acc3on = 0;
	      sprintf (temp, "%d,%d,%d,%d,%d,%d\n", Rt[NumRit].acc3on,
		       Rt[NumRit].acc3pc, Rt[NumRit].acc3vol,
		       Rt[NumRit].acc3pan, Rt[NumRit].acc3rev,
		       Rt[NumRit].acc3cho);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Rt[NumRit].acc3octa,
		       Rt[NumRit].acc3BankM, Rt[NumRit].acc3pon,
		       Rt[NumRit].acc3ptime);
	      fputs (temp, fs);

	      bzero (temp, sizeof (temp));
//       Rt[NumRit].acc4on = 0;
	      sprintf (temp, "%d,%d,%d,%d,%d,%d\n", Rt[NumRit].acc4on,
		       Rt[NumRit].acc4pc, Rt[NumRit].acc4vol,
		       Rt[NumRit].acc4pan, Rt[NumRit].acc4rev,
		       Rt[NumRit].acc4cho);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Rt[NumRit].acc4octa,
		       Rt[NumRit].acc4BankM, Rt[NumRit].acc4pon,
		       Rt[NumRit].acc4ptime);
	      fputs (temp, fs);

	      bzero (temp, sizeof (temp));
//       Rt[NumRit].acc5on = 0;
	      sprintf (temp, "%d,%d,%d,%d,%d,%d\n", Rt[NumRit].acc5on,
		       Rt[NumRit].acc5pc, Rt[NumRit].acc5vol,
		       Rt[NumRit].acc5pan, Rt[NumRit].acc5rev,
		       Rt[NumRit].acc5cho);
	      fputs (temp, fs);
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%d,%d,%d,%d\n", Rt[NumRit].acc5octa,
		       Rt[NumRit].acc5BankM, Rt[NumRit].acc5pon,
		       Rt[NumRit].acc5ptime);
	      fputs (temp, fs);


	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 1; j < 62; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      sprintf (temp, "%d,%d,%d,%d\n", Edr[j][w + 1],
			       Edr[j][w + 2], Edr[j][w + 3], Edr[j][w + 4]);
		      fputs (temp, fs);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      sprintf (temp, "%d,%d,%d,%d\n",
			       Rt[NumRit].basn[j][w + 1],
			       Rt[NumRit].basn[j][w + 2],
			       Rt[NumRit].basn[j][w + 3],
			       Rt[NumRit].basn[j][w + 4]);
		      fputs (temp, fs);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 2; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      sprintf (temp, "%d,%d,%d,%d\n",
			       Rt[NumRit].acc1n[j][w + 1],
			       Rt[NumRit].acc1n[j][w + 2],
			       Rt[NumRit].acc1n[j][w + 3],
			       Rt[NumRit].acc1n[j][w + 4]);
		      fputs (temp, fs);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      sprintf (temp, "%d,%d,%d,%d\n",
			       Rt[NumRit].acc2n[j][w + 1],
			       Rt[NumRit].acc2n[j][w + 2],
			       Rt[NumRit].acc2n[j][w + 3],
			       Rt[NumRit].acc2n[j][w + 4]);
		      fputs (temp, fs);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      sprintf (temp, "%d,%d,%d,%d\n",
			       Rt[NumRit].acc3n[j][w + 1],
			       Rt[NumRit].acc3n[j][w + 2],
			       Rt[NumRit].acc3n[j][w + 3],
			       Rt[NumRit].acc3n[j][w + 4]);
		      fputs (temp, fs);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      sprintf (temp, "%d,%d,%d,%d\n",
			       Rt[NumRit].acc4n[j][w + 1],
			       Rt[NumRit].acc4n[j][w + 2],
			       Rt[NumRit].acc4n[j][w + 3],
			       Rt[NumRit].acc4n[j][w + 4]);
		      fputs (temp, fs);
		    }
		}

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 0; j < 3; j++)
		    {
		      w = i * 4;
		      bzero (temp, sizeof (temp));
		      sprintf (temp, "%d,%d,%d,%d\n",
			       Rt[NumRit].acc5n[j][w + 1],
			       Rt[NumRit].acc5n[j][w + 2],
			       Rt[NumRit].acc5n[j][w + 3],
			       Rt[NumRit].acc5n[j][w + 4]);
		      fputs (temp, fs);
		    }
		}

	      bzero (temp, sizeof (temp));

	      sprintf (temp, "%d,%d,%d,%d,%d,%d,%d,%d\n", Rt[NumRit].terceras,
		       Rt[NumRit].sextas, Rt[NumRit].bassstlt,
		       Rt[NumRit].acc1stlt, Rt[NumRit].acc2stlt,
		       Rt[NumRit].acc3stlt, Rt[NumRit].acc4stlt,
		       Rt[NumRit].acc5stlt);
	      fputs (temp, fs);

	      for (i = 0; i < Rt[NumRit].bars * Rt[NumRit].blackn; i++)
		{
		  for (j = 1; j < 1000; j++)
		    {
		      if (Rt[NumRit].EvMidCon[j].posicion != 0)
			{
			  bzero (temp, sizeof (temp));
			  sprintf (temp, "%d,%d,%d,%d\n",
				   Rt[NumRit].EvMidCon[j].pista,
				   Rt[NumRit].EvMidCon[j].controlador,
				   Rt[NumRit].EvMidCon[j].posicion,
				   Rt[NumRit].EvMidCon[j].valor);
			  fputs (temp, fs);
			}
		    }
		}
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "-\n");
	      fputs (temp, fs);


	      for (j = 1; j <= 5; j++)
		{
		  bzero (temp, sizeof (temp));
		  sprintf (temp, "0\n");
		  fputs (temp, fs);
		}
	    }
	}
      fclose (fs);
    }
};


void
GMO::loadgmpl (char *filename)
{
  int i;
  FILE *fs;
  if ((fs = fopen (filename, "rb")) != NULL)
    {
      while (!feof (fs))
	{
	  i = fread (&GP, sizeof (GP), 1, fs);
	}
      fclose (fs);
    }
};


void
GMO::savegmpl (char *filename)
{
  FILE *fs;
  if ((fs = fopen (filename, "wb")) != NULL)
    {
      fwrite (&GP, sizeof (GP), 1, fs);
      fclose (fs);
    }
};


void
GMO::savesongplay (char *filename)
{
  FILE *fs;
  char temp[128];
  int i;
  bzero (temp, sizeof (temp));

  if ((fs = fopen (filename, "w")) != NULL)
    {
      bzero (temp, sizeof (temp));
      sprintf (temp, "%d\n", bpm);
      fputs (temp, fs);

      for (i = 1; i <= grabaconta; i++)
	{
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d\n", EG[i].tipo,
		   EG[i].tick, EG[i].nota, EG[i].canal, EG[i].velocity,
		   EG[i].length, 0, 0, 0);
	  fputs (temp, fs);
	}
      fclose (fs);
    }
};



void
GMO::loadsongplay (char *filename)
{
  FILE *fs;
  char temp[128];
  int r;
  int i = 1;

  bzero (temp, sizeof (temp));

  if ((fs = fopen (filename, "r")) != NULL)
    {
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      sscanf (temp, "%d", &bpm);
      bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fs) != NULL)
	{
	  sscanf (temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d\n", &EG[i].tipo,
		  &EG[i].tick, &EG[i].nota, &EG[i].canal, &EG[i].velocity,
		  &EG[i].length, &r, &r, &r);
	  bzero (temp, sizeof (temp));
	  i++;
	}
      grabaconta = i - 1;
      fclose (fs);
    }
};

void
GMO::loadpreset (char *filename)
{
  int i = 0, j = 0;
  for (i = 0; i <= 127; i++)
    {
      for (j = 0; j <= 127; j++)
	{
	  PresetList[i].Banco = i;
	  PresetList[i].PBanco[i].Prog = j;
	}
    }
  FILE *fp;
  char temp[256];
  int bb = 0, pp = 0;
  char nn[80];
  if ((fp = fopen (filename, "r")) != NULL)
    {

      bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fp) != NULL)
	{
	  sscanf (temp, "%d %d %[^]]c", &bb, &pp, (char *) nn);
	  for (i = 0; i <= (int) strlen (temp); i++)
	    PresetList[bb].PBanco[pp].ProgName[i] = nn[i];
	}
        fclose (fp);
    }
};

void
GMO::loaddrumset (char *filename)
{
  int i = 0, j = 0, bb = 0, pp = 0;
  FILE *fp;
  char temp[256];
  char nn[80];
  for (i = 0; i <= 59; i++)
    {
      for (j = 27; j <= 88; j++)
	{
	  PD[i].ProgD = i;
	  PD[i].DNN[i].Note = j;
	}
    }
  bb = 0;
  pp = 0;
  bzero (nn, sizeof (nn));
  if ((fp = fopen (filename, "r")) != NULL)
    {
      bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fp) != NULL)
	{
	  sscanf (temp, "%d %d %[^]]c", &bb, &pp, (char *) nn);
	  for (i = 0; i <= (int) strlen (temp); i++)
	    PD[bb].DNN[pp].Nom[i] = nn[i];
	}
        fclose (fp);
    }
};

void
GMO::grabalib ()
{
  FILE *fs;
  char *filename;
  filename = strdup (LibStylesFilename);

  if ((fs = fopen (filename, "ab")) != NULL)
    {
      fwrite (&Register, sizeof (Register), 1, fs);
      fclose (fs);
    }

};

void
GMO::GrabaSettings ()
{
  FILE *fn;
  int i;
  char *temp;
  char t1[4];
  char nomfile[256];
  sprintf (nomfile, "%s%s", getenv ("HOME"), "/.gmorgan");
  fn = fopen (nomfile, "w");
  temp = MidiInPuerto[1].SMidiIn;
  if (temp == NULL)
    temp = strdup (gettext ("Not Connected"));
  fputs (temp, fn);
  fputs ("\n", fn);
  temp = MidiOutPuerto[1].SMidiOut;
  if (temp == NULL)
    temp = strdup (gettext ("Not Connected"));
  fputs (temp, fn);
  fputs ("\n", fn);
  temp = SoundsFilename;
  if (temp == NULL)
    temp = strdup ("0");
  fputs (temp, fn);
  fputs ("\n", fn);
  temp = PatternsFilename;
  if (temp == NULL)
    temp = strdup ("0");
  fputs (temp, fn);
  fputs ("\n", fn);
  temp = StylesFilename;
  if (temp == NULL)
    temp = strdup ("0");
  fputs (temp, fn);
  fputs ("\n", fn);
  temp = PresetFilename;
  if (temp == NULL)
    temp = strdup ("0");
  fputs (temp, fn);
  fputs ("\n", fn);
  temp = DrumNoteFilename;
  if (temp == NULL)
    temp = strdup ("0");
  fputs (temp, fn);
  fputs ("\n", fn);
  temp = SkinFilename;
  if (temp == NULL)
    temp = strdup ("0");
  fputs (temp, fn);
  fputs ("\n", fn);
  temp = SkinNombre;
  if (temp == NULL)
    temp = strdup ("0");
  fputs (temp, fn);
  fputs ("\n", fn);
  sprintf (t1, "%d", MutesOnOff);
  fputs (t1, fn);
  fputs ("\n", fn);
  temp = HelpFilename;
  if (temp == NULL)
    temp = strdup ("0");
  fputs (temp, fn);
  fputs ("\n", fn);
  temp = LibStylesFilename;
  if (temp == NULL)
    temp = strdup ("0");
  fputs (temp, fn);
  fputs ("\n", fn);
  for (i = 0; i <= 31; i++)
    fputs ("0\n", fn);
  fclose (fn);
}
