// Code generated by protoc-gen-go. DO NOT EDIT.
// source: protoc-gen-swagger/options/openapiv2.proto

package options

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	_struct "github.com/golang/protobuf/ptypes/struct"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Swagger_SwaggerScheme int32

const (
	Swagger_UNKNOWN Swagger_SwaggerScheme = 0
	Swagger_HTTP    Swagger_SwaggerScheme = 1
	Swagger_HTTPS   Swagger_SwaggerScheme = 2
	Swagger_WS      Swagger_SwaggerScheme = 3
	Swagger_WSS     Swagger_SwaggerScheme = 4
)

var Swagger_SwaggerScheme_name = map[int32]string{
	0: "UNKNOWN",
	1: "HTTP",
	2: "HTTPS",
	3: "WS",
	4: "WSS",
}

var Swagger_SwaggerScheme_value = map[string]int32{
	"UNKNOWN": 0,
	"HTTP":    1,
	"HTTPS":   2,
	"WS":      3,
	"WSS":     4,
}

func (x Swagger_SwaggerScheme) String() string {
	return proto.EnumName(Swagger_SwaggerScheme_name, int32(x))
}

func (Swagger_SwaggerScheme) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{0, 0}
}

type JSONSchema_JSONSchemaSimpleTypes int32

const (
	JSONSchema_UNKNOWN JSONSchema_JSONSchemaSimpleTypes = 0
	JSONSchema_ARRAY   JSONSchema_JSONSchemaSimpleTypes = 1
	JSONSchema_BOOLEAN JSONSchema_JSONSchemaSimpleTypes = 2
	JSONSchema_INTEGER JSONSchema_JSONSchemaSimpleTypes = 3
	JSONSchema_NULL    JSONSchema_JSONSchemaSimpleTypes = 4
	JSONSchema_NUMBER  JSONSchema_JSONSchemaSimpleTypes = 5
	JSONSchema_OBJECT  JSONSchema_JSONSchemaSimpleTypes = 6
	JSONSchema_STRING  JSONSchema_JSONSchemaSimpleTypes = 7
)

var JSONSchema_JSONSchemaSimpleTypes_name = map[int32]string{
	0: "UNKNOWN",
	1: "ARRAY",
	2: "BOOLEAN",
	3: "INTEGER",
	4: "NULL",
	5: "NUMBER",
	6: "OBJECT",
	7: "STRING",
}

var JSONSchema_JSONSchemaSimpleTypes_value = map[string]int32{
	"UNKNOWN": 0,
	"ARRAY":   1,
	"BOOLEAN": 2,
	"INTEGER": 3,
	"NULL":    4,
	"NUMBER":  5,
	"OBJECT":  6,
	"STRING":  7,
}

func (x JSONSchema_JSONSchemaSimpleTypes) String() string {
	return proto.EnumName(JSONSchema_JSONSchemaSimpleTypes_name, int32(x))
}

func (JSONSchema_JSONSchemaSimpleTypes) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{9, 0}
}

// The type of the security scheme. Valid values are "basic",
// "apiKey" or "oauth2".
type SecurityScheme_Type int32

const (
	SecurityScheme_TYPE_INVALID SecurityScheme_Type = 0
	SecurityScheme_TYPE_BASIC   SecurityScheme_Type = 1
	SecurityScheme_TYPE_API_KEY SecurityScheme_Type = 2
	SecurityScheme_TYPE_OAUTH2  SecurityScheme_Type = 3
)

var SecurityScheme_Type_name = map[int32]string{
	0: "TYPE_INVALID",
	1: "TYPE_BASIC",
	2: "TYPE_API_KEY",
	3: "TYPE_OAUTH2",
}

var SecurityScheme_Type_value = map[string]int32{
	"TYPE_INVALID": 0,
	"TYPE_BASIC":   1,
	"TYPE_API_KEY": 2,
	"TYPE_OAUTH2":  3,
}

func (x SecurityScheme_Type) String() string {
	return proto.EnumName(SecurityScheme_Type_name, int32(x))
}

func (SecurityScheme_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{12, 0}
}

// The location of the API key. Valid values are "query" or "header".
type SecurityScheme_In int32

const (
	SecurityScheme_IN_INVALID SecurityScheme_In = 0
	SecurityScheme_IN_QUERY   SecurityScheme_In = 1
	SecurityScheme_IN_HEADER  SecurityScheme_In = 2
)

var SecurityScheme_In_name = map[int32]string{
	0: "IN_INVALID",
	1: "IN_QUERY",
	2: "IN_HEADER",
}

var SecurityScheme_In_value = map[string]int32{
	"IN_INVALID": 0,
	"IN_QUERY":   1,
	"IN_HEADER":  2,
}

func (x SecurityScheme_In) String() string {
	return proto.EnumName(SecurityScheme_In_name, int32(x))
}

func (SecurityScheme_In) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{12, 1}
}

// The flow used by the OAuth2 security scheme. Valid values are
// "implicit", "password", "application" or "accessCode".
type SecurityScheme_Flow int32

const (
	SecurityScheme_FLOW_INVALID     SecurityScheme_Flow = 0
	SecurityScheme_FLOW_IMPLICIT    SecurityScheme_Flow = 1
	SecurityScheme_FLOW_PASSWORD    SecurityScheme_Flow = 2
	SecurityScheme_FLOW_APPLICATION SecurityScheme_Flow = 3
	SecurityScheme_FLOW_ACCESS_CODE SecurityScheme_Flow = 4
)

var SecurityScheme_Flow_name = map[int32]string{
	0: "FLOW_INVALID",
	1: "FLOW_IMPLICIT",
	2: "FLOW_PASSWORD",
	3: "FLOW_APPLICATION",
	4: "FLOW_ACCESS_CODE",
}

var SecurityScheme_Flow_value = map[string]int32{
	"FLOW_INVALID":     0,
	"FLOW_IMPLICIT":    1,
	"FLOW_PASSWORD":    2,
	"FLOW_APPLICATION": 3,
	"FLOW_ACCESS_CODE": 4,
}

func (x SecurityScheme_Flow) String() string {
	return proto.EnumName(SecurityScheme_Flow_name, int32(x))
}

func (SecurityScheme_Flow) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{12, 2}
}

// `Swagger` is a representation of OpenAPI v2 specification's Swagger object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#swaggerObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_swagger.options.openapiv2_swagger) = {
//    info: {
//      title: "Echo API";
//      version: "1.0";
//      description: ";
//      contact: {
//        name: "gRPC-Gateway project";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway";
//        email: "none@example.com";
//      };
//      license: {
//        name: "BSD 3-Clause License";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway/blob/master/LICENSE.txt";
//      };
//    };
//    schemes: HTTPS;
//    consumes: "application/json";
//    produces: "application/json";
//  };
//
type Swagger struct {
	// Specifies the Swagger Specification version being used. It can be
	// used by the Swagger UI and other clients to interpret the API listing. The
	// value MUST be "2.0".
	Swagger string `protobuf:"bytes,1,opt,name=swagger,proto3" json:"swagger,omitempty"`
	// Provides metadata about the API. The metadata can be used by the
	// clients if needed.
	Info *Info `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// The host (name or ip) serving the API. This MUST be the host only and does
	// not include the scheme nor sub-paths. It MAY include a port. If the host is
	// not included, the host serving the documentation is to be used (including
	// the port). The host does not support path templating.
	Host string `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	// The base path on which the API is served, which is relative to the host. If
	// it is not included, the API is served directly under the host. The value
	// MUST start with a leading slash (/). The basePath does not support path
	// templating.
	// Note that using `base_path` does not change the endpoint paths that are
	// generated in the resulting Swagger file. If you wish to use `base_path`
	// with relatively generated Swagger paths, the `base_path` prefix must be
	// manually removed from your `google.api.http` paths and your code changed to
	// serve the API from the `base_path`.
	BasePath string `protobuf:"bytes,4,opt,name=base_path,json=basePath,proto3" json:"base_path,omitempty"`
	// The transfer protocol of the API. Values MUST be from the list: "http",
	// "https", "ws", "wss". If the schemes is not included, the default scheme to
	// be used is the one used to access the Swagger definition itself.
	Schemes []Swagger_SwaggerScheme `protobuf:"varint,5,rep,packed,name=schemes,proto3,enum=grpc.gateway.protoc_gen_swagger.options.Swagger_SwaggerScheme" json:"schemes,omitempty"`
	// A list of MIME types the APIs can consume. This is global to all APIs but
	// can be overridden on specific API calls. Value MUST be as described under
	// Mime Types.
	Consumes []string `protobuf:"bytes,6,rep,name=consumes,proto3" json:"consumes,omitempty"`
	// A list of MIME types the APIs can produce. This is global to all APIs but
	// can be overridden on specific API calls. Value MUST be as described under
	// Mime Types.
	Produces []string `protobuf:"bytes,7,rep,name=produces,proto3" json:"produces,omitempty"`
	// An object to hold responses that can be used across operations. This
	// property does not define global responses for all operations.
	Responses map[string]*Response `protobuf:"bytes,10,rep,name=responses,proto3" json:"responses,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Security scheme definitions that can be used across the specification.
	SecurityDefinitions *SecurityDefinitions `protobuf:"bytes,11,opt,name=security_definitions,json=securityDefinitions,proto3" json:"security_definitions,omitempty"`
	// A declaration of which security schemes are applied for the API as a whole.
	// The list of values describes alternative security schemes that can be used
	// (that is, there is a logical OR between the security requirements).
	// Individual operations can override this definition.
	Security []*SecurityRequirement `protobuf:"bytes,12,rep,name=security,proto3" json:"security,omitempty"`
	// Additional external documentation.
	ExternalDocs         *ExternalDocumentation    `protobuf:"bytes,14,opt,name=external_docs,json=externalDocs,proto3" json:"external_docs,omitempty"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,15,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Swagger) Reset()         { *m = Swagger{} }
func (m *Swagger) String() string { return proto.CompactTextString(m) }
func (*Swagger) ProtoMessage()    {}
func (*Swagger) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{0}
}

func (m *Swagger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Swagger.Unmarshal(m, b)
}
func (m *Swagger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Swagger.Marshal(b, m, deterministic)
}
func (m *Swagger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Swagger.Merge(m, src)
}
func (m *Swagger) XXX_Size() int {
	return xxx_messageInfo_Swagger.Size(m)
}
func (m *Swagger) XXX_DiscardUnknown() {
	xxx_messageInfo_Swagger.DiscardUnknown(m)
}

var xxx_messageInfo_Swagger proto.InternalMessageInfo

func (m *Swagger) GetSwagger() string {
	if m != nil {
		return m.Swagger
	}
	return ""
}

func (m *Swagger) GetInfo() *Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Swagger) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Swagger) GetBasePath() string {
	if m != nil {
		return m.BasePath
	}
	return ""
}

func (m *Swagger) GetSchemes() []Swagger_SwaggerScheme {
	if m != nil {
		return m.Schemes
	}
	return nil
}

func (m *Swagger) GetConsumes() []string {
	if m != nil {
		return m.Consumes
	}
	return nil
}

func (m *Swagger) GetProduces() []string {
	if m != nil {
		return m.Produces
	}
	return nil
}

func (m *Swagger) GetResponses() map[string]*Response {
	if m != nil {
		return m.Responses
	}
	return nil
}

func (m *Swagger) GetSecurityDefinitions() *SecurityDefinitions {
	if m != nil {
		return m.SecurityDefinitions
	}
	return nil
}

func (m *Swagger) GetSecurity() []*SecurityRequirement {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *Swagger) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

func (m *Swagger) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `Operation` is a representation of OpenAPI v2 specification's Operation object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#operationObject
//
// Example:
//
//  service EchoService {
//    rpc Echo(SimpleMessage) returns (SimpleMessage) {
//      option (google.api.http) = {
//        get: "/v1/example/echo/{id}"
//      };
//
//      option (grpc.gateway.protoc_gen_swagger.options.openapiv2_operation) = {
//        summary: "Get a message.";
//        operation_id: "getMessage";
//        tags: "echo";
//        responses: {
//          key: "200"
//            value: {
//            description: "OK";
//          }
//        }
//      };
//    }
//  }
type Operation struct {
	// A list of tags for API documentation control. Tags can be used for logical
	// grouping of operations by resources or any other qualifier.
	Tags []string `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// A short summary of what the operation does. For maximum readability in the
	// swagger-ui, this field SHOULD be less than 120 characters.
	Summary string `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	// A verbose explanation of the operation behavior. GFM syntax can be used for
	// rich text representation.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Additional external documentation for this operation.
	ExternalDocs *ExternalDocumentation `protobuf:"bytes,4,opt,name=external_docs,json=externalDocs,proto3" json:"external_docs,omitempty"`
	// Unique string used to identify the operation. The id MUST be unique among
	// all operations described in the API. Tools and libraries MAY use the
	// operationId to uniquely identify an operation, therefore, it is recommended
	// to follow common programming naming conventions.
	OperationId string `protobuf:"bytes,5,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// A list of MIME types the operation can consume. This overrides the consumes
	// definition at the Swagger Object. An empty value MAY be used to clear the
	// global definition. Value MUST be as described under Mime Types.
	Consumes []string `protobuf:"bytes,6,rep,name=consumes,proto3" json:"consumes,omitempty"`
	// A list of MIME types the operation can produce. This overrides the produces
	// definition at the Swagger Object. An empty value MAY be used to clear the
	// global definition. Value MUST be as described under Mime Types.
	Produces []string `protobuf:"bytes,7,rep,name=produces,proto3" json:"produces,omitempty"`
	// The list of possible responses as they are returned from executing this
	// operation.
	Responses map[string]*Response `protobuf:"bytes,9,rep,name=responses,proto3" json:"responses,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The transfer protocol for the operation. Values MUST be from the list:
	// "http", "https", "ws", "wss". The value overrides the Swagger Object
	// schemes definition.
	Schemes []string `protobuf:"bytes,10,rep,name=schemes,proto3" json:"schemes,omitempty"`
	// Declares this operation to be deprecated. Usage of the declared operation
	// should be refrained. Default value is false.
	Deprecated bool `protobuf:"varint,11,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// A declaration of which security schemes are applied for this operation. The
	// list of values describes alternative security schemes that can be used
	// (that is, there is a logical OR between the security requirements). This
	// definition overrides any declared top-level security. To remove a top-level
	// security declaration, an empty array can be used.
	Security             []*SecurityRequirement    `protobuf:"bytes,12,rep,name=security,proto3" json:"security,omitempty"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,13,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{1}
}

func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (m *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(m, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Operation) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *Operation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Operation) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

func (m *Operation) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *Operation) GetConsumes() []string {
	if m != nil {
		return m.Consumes
	}
	return nil
}

func (m *Operation) GetProduces() []string {
	if m != nil {
		return m.Produces
	}
	return nil
}

func (m *Operation) GetResponses() map[string]*Response {
	if m != nil {
		return m.Responses
	}
	return nil
}

func (m *Operation) GetSchemes() []string {
	if m != nil {
		return m.Schemes
	}
	return nil
}

func (m *Operation) GetDeprecated() bool {
	if m != nil {
		return m.Deprecated
	}
	return false
}

func (m *Operation) GetSecurity() []*SecurityRequirement {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *Operation) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `Header` is a representation of OpenAPI v2 specification's Header object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#headerObject
//
type Header struct {
	// `Description` is a short description of the header.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// The type of the object. The value MUST be one of "string", "number", "integer", or "boolean". The "array" type is not supported.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// `Format` The extending format for the previously mentioned type.
	Format string `protobuf:"bytes,3,opt,name=format,proto3" json:"format,omitempty"`
	// `Default` Declares the value of the header that the server will use if none is provided.
	// See: https://tools.ietf.org/html/draft-fge-json-schema-validation-00#section-6.2.
	// Unlike JSON Schema this value MUST conform to the defined type for the header.
	Default string `protobuf:"bytes,6,opt,name=default,proto3" json:"default,omitempty"`
	// 'Pattern' See https://tools.ietf.org/html/draft-fge-json-schema-validation-00#section-5.2.3.
	Pattern              string   `protobuf:"bytes,13,opt,name=pattern,proto3" json:"pattern,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Header) Reset()         { *m = Header{} }
func (m *Header) String() string { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()    {}
func (*Header) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{2}
}

func (m *Header) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Header.Unmarshal(m, b)
}
func (m *Header) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Header.Marshal(b, m, deterministic)
}
func (m *Header) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Header.Merge(m, src)
}
func (m *Header) XXX_Size() int {
	return xxx_messageInfo_Header.Size(m)
}
func (m *Header) XXX_DiscardUnknown() {
	xxx_messageInfo_Header.DiscardUnknown(m)
}

var xxx_messageInfo_Header proto.InternalMessageInfo

func (m *Header) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Header) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Header) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *Header) GetDefault() string {
	if m != nil {
		return m.Default
	}
	return ""
}

func (m *Header) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

// `Response` is a representation of OpenAPI v2 specification's Response object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#responseObject
//
type Response struct {
	// `Description` is a short description of the response.
	// GFM syntax can be used for rich text representation.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// `Schema` optionally defines the structure of the response.
	// If `Schema` is not provided, it means there is no content to the response.
	Schema *Schema `protobuf:"bytes,2,opt,name=schema,proto3" json:"schema,omitempty"`
	// `Headers` A list of headers that are sent with the response.
	// `Header` name is expected to be a string in the canonical format of the MIME header key
	// See: https://golang.org/pkg/net/textproto/#CanonicalMIMEHeaderKey
	Headers map[string]*Header `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// `Examples` gives per-mimetype response examples.
	// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#example-object
	Examples             map[string]string         `protobuf:"bytes,4,rep,name=examples,proto3" json:"examples,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,5,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Response) Reset()         { *m = Response{} }
func (m *Response) String() string { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()    {}
func (*Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{3}
}

func (m *Response) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Response.Unmarshal(m, b)
}
func (m *Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Response.Marshal(b, m, deterministic)
}
func (m *Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Response.Merge(m, src)
}
func (m *Response) XXX_Size() int {
	return xxx_messageInfo_Response.Size(m)
}
func (m *Response) XXX_DiscardUnknown() {
	xxx_messageInfo_Response.DiscardUnknown(m)
}

var xxx_messageInfo_Response proto.InternalMessageInfo

func (m *Response) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Response) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *Response) GetHeaders() map[string]*Header {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *Response) GetExamples() map[string]string {
	if m != nil {
		return m.Examples
	}
	return nil
}

func (m *Response) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `Info` is a representation of OpenAPI v2 specification's Info object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#infoObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_swagger.options.openapiv2_swagger) = {
//    info: {
//      title: "Echo API";
//      version: "1.0";
//      description: ";
//      contact: {
//        name: "gRPC-Gateway project";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway";
//        email: "none@example.com";
//      };
//      license: {
//        name: "BSD 3-Clause License";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway/blob/master/LICENSE.txt";
//      };
//    };
//    ...
//  };
//
type Info struct {
	// The title of the application.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// A short description of the application. GFM syntax can be used for rich
	// text representation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The Terms of Service for the API.
	TermsOfService string `protobuf:"bytes,3,opt,name=terms_of_service,json=termsOfService,proto3" json:"terms_of_service,omitempty"`
	// The contact information for the exposed API.
	Contact *Contact `protobuf:"bytes,4,opt,name=contact,proto3" json:"contact,omitempty"`
	// The license information for the exposed API.
	License *License `protobuf:"bytes,5,opt,name=license,proto3" json:"license,omitempty"`
	// Provides the version of the application API (not to be confused
	// with the specification version).
	Version              string                    `protobuf:"bytes,6,opt,name=version,proto3" json:"version,omitempty"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,7,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Info) Reset()         { *m = Info{} }
func (m *Info) String() string { return proto.CompactTextString(m) }
func (*Info) ProtoMessage()    {}
func (*Info) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{4}
}

func (m *Info) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Info.Unmarshal(m, b)
}
func (m *Info) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Info.Marshal(b, m, deterministic)
}
func (m *Info) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Info.Merge(m, src)
}
func (m *Info) XXX_Size() int {
	return xxx_messageInfo_Info.Size(m)
}
func (m *Info) XXX_DiscardUnknown() {
	xxx_messageInfo_Info.DiscardUnknown(m)
}

var xxx_messageInfo_Info proto.InternalMessageInfo

func (m *Info) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Info) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Info) GetTermsOfService() string {
	if m != nil {
		return m.TermsOfService
	}
	return ""
}

func (m *Info) GetContact() *Contact {
	if m != nil {
		return m.Contact
	}
	return nil
}

func (m *Info) GetLicense() *License {
	if m != nil {
		return m.License
	}
	return nil
}

func (m *Info) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Info) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `Contact` is a representation of OpenAPI v2 specification's Contact object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#contactObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_swagger.options.openapiv2_swagger) = {
//    info: {
//      ...
//      contact: {
//        name: "gRPC-Gateway project";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway";
//        email: "none@example.com";
//      };
//      ...
//    };
//    ...
//  };
//
type Contact struct {
	// The identifying name of the contact person/organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The URL pointing to the contact information. MUST be in the format of a
	// URL.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// The email address of the contact person/organization. MUST be in the format
	// of an email address.
	Email                string   `protobuf:"bytes,3,opt,name=email,proto3" json:"email,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Contact) Reset()         { *m = Contact{} }
func (m *Contact) String() string { return proto.CompactTextString(m) }
func (*Contact) ProtoMessage()    {}
func (*Contact) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{5}
}

func (m *Contact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Contact.Unmarshal(m, b)
}
func (m *Contact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Contact.Marshal(b, m, deterministic)
}
func (m *Contact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Contact.Merge(m, src)
}
func (m *Contact) XXX_Size() int {
	return xxx_messageInfo_Contact.Size(m)
}
func (m *Contact) XXX_DiscardUnknown() {
	xxx_messageInfo_Contact.DiscardUnknown(m)
}

var xxx_messageInfo_Contact proto.InternalMessageInfo

func (m *Contact) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Contact) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Contact) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

// `License` is a representation of OpenAPI v2 specification's License object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#licenseObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_swagger.options.openapiv2_swagger) = {
//    info: {
//      ...
//      license: {
//        name: "BSD 3-Clause License";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway/blob/master/LICENSE.txt";
//      };
//      ...
//    };
//    ...
//  };
//
type License struct {
	// The license name used for the API.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A URL to the license used for the API. MUST be in the format of a URL.
	Url                  string   `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *License) Reset()         { *m = License{} }
func (m *License) String() string { return proto.CompactTextString(m) }
func (*License) ProtoMessage()    {}
func (*License) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{6}
}

func (m *License) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_License.Unmarshal(m, b)
}
func (m *License) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_License.Marshal(b, m, deterministic)
}
func (m *License) XXX_Merge(src proto.Message) {
	xxx_messageInfo_License.Merge(m, src)
}
func (m *License) XXX_Size() int {
	return xxx_messageInfo_License.Size(m)
}
func (m *License) XXX_DiscardUnknown() {
	xxx_messageInfo_License.DiscardUnknown(m)
}

var xxx_messageInfo_License proto.InternalMessageInfo

func (m *License) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *License) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// `ExternalDocumentation` is a representation of OpenAPI v2 specification's
// ExternalDocumentation object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#externalDocumentationObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_swagger.options.openapiv2_swagger) = {
//    ...
//    external_docs: {
//      description: "More about gRPC-Gateway";
//      url: "https://github.com/grpc-ecosystem/grpc-gateway";
//    }
//    ...
//  };
//
type ExternalDocumentation struct {
	// A short description of the target documentation. GFM syntax can be used for
	// rich text representation.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// The URL for the target documentation. Value MUST be in the format
	// of a URL.
	Url                  string   `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExternalDocumentation) Reset()         { *m = ExternalDocumentation{} }
func (m *ExternalDocumentation) String() string { return proto.CompactTextString(m) }
func (*ExternalDocumentation) ProtoMessage()    {}
func (*ExternalDocumentation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{7}
}

func (m *ExternalDocumentation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExternalDocumentation.Unmarshal(m, b)
}
func (m *ExternalDocumentation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExternalDocumentation.Marshal(b, m, deterministic)
}
func (m *ExternalDocumentation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalDocumentation.Merge(m, src)
}
func (m *ExternalDocumentation) XXX_Size() int {
	return xxx_messageInfo_ExternalDocumentation.Size(m)
}
func (m *ExternalDocumentation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalDocumentation.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalDocumentation proto.InternalMessageInfo

func (m *ExternalDocumentation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ExternalDocumentation) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// `Schema` is a representation of OpenAPI v2 specification's Schema object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
//
type Schema struct {
	JsonSchema *JSONSchema `protobuf:"bytes,1,opt,name=json_schema,json=jsonSchema,proto3" json:"json_schema,omitempty"`
	// Adds support for polymorphism. The discriminator is the schema property
	// name that is used to differentiate between other schema that inherit this
	// schema. The property name used MUST be defined at this schema and it MUST
	// be in the required property list. When used, the value MUST be the name of
	// this schema or any schema that inherits it.
	Discriminator string `protobuf:"bytes,2,opt,name=discriminator,proto3" json:"discriminator,omitempty"`
	// Relevant only for Schema "properties" definitions. Declares the property as
	// "read only". This means that it MAY be sent as part of a response but MUST
	// NOT be sent as part of the request. Properties marked as readOnly being
	// true SHOULD NOT be in the required list of the defined schema. Default
	// value is false.
	ReadOnly bool `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	// Additional external documentation for this schema.
	ExternalDocs *ExternalDocumentation `protobuf:"bytes,5,opt,name=external_docs,json=externalDocs,proto3" json:"external_docs,omitempty"`
	// A free-form property to include an example of an instance for this schema.
	// Deprecated, please use example_string instead.
	Example *any.Any `protobuf:"bytes,6,opt,name=example,proto3" json:"example,omitempty"` // Deprecated: Do not use.
	// A free-form property to include a JSON example of this field. This is copied
	// verbatim to the output swagger.json. Quotes must be escaped.
	ExampleString        string   `protobuf:"bytes,7,opt,name=example_string,json=exampleString,proto3" json:"example_string,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Schema) Reset()         { *m = Schema{} }
func (m *Schema) String() string { return proto.CompactTextString(m) }
func (*Schema) ProtoMessage()    {}
func (*Schema) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{8}
}

func (m *Schema) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Schema.Unmarshal(m, b)
}
func (m *Schema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Schema.Marshal(b, m, deterministic)
}
func (m *Schema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Schema.Merge(m, src)
}
func (m *Schema) XXX_Size() int {
	return xxx_messageInfo_Schema.Size(m)
}
func (m *Schema) XXX_DiscardUnknown() {
	xxx_messageInfo_Schema.DiscardUnknown(m)
}

var xxx_messageInfo_Schema proto.InternalMessageInfo

func (m *Schema) GetJsonSchema() *JSONSchema {
	if m != nil {
		return m.JsonSchema
	}
	return nil
}

func (m *Schema) GetDiscriminator() string {
	if m != nil {
		return m.Discriminator
	}
	return ""
}

func (m *Schema) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *Schema) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

// Deprecated: Do not use.
func (m *Schema) GetExample() *any.Any {
	if m != nil {
		return m.Example
	}
	return nil
}

func (m *Schema) GetExampleString() string {
	if m != nil {
		return m.ExampleString
	}
	return ""
}

// `JSONSchema` represents properties from JSON Schema taken, and as used, in
// the OpenAPI v2 spec.
//
// This includes changes made by OpenAPI v2.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
//
// See also: https://cswr.github.io/JsonSchema/spec/basic_types/,
// https://github.com/json-schema-org/json-schema-spec/blob/master/schema.json
//
// Example:
//
//  message SimpleMessage {
//    option (grpc.gateway.protoc_gen_swagger.options.openapiv2_schema) = {
//      json_schema: {
//        title: "SimpleMessage"
//        description: "A simple message."
//        required: ["id"]
//      }
//    };
//
//    // Id represents the message identifier.
//    string id = 1; [
//        (grpc.gateway.protoc_gen_swagger.options.openapiv2_field) = {
//          {description: "The unique identifier of the simple message."
//        }];
//  }
//
type JSONSchema struct {
	// Ref is used to define an external reference to include in the message.
	// This could be a fully qualified proto message reference, and that type must
	// be imported into the protofile. If no message is identified, the Ref will
	// be used verbatim in the output.
	// For example:
	//  `ref: ".google.protobuf.Timestamp"`.
	Ref string `protobuf:"bytes,3,opt,name=ref,proto3" json:"ref,omitempty"`
	// The title of the schema.
	Title string `protobuf:"bytes,5,opt,name=title,proto3" json:"title,omitempty"`
	// A short description of the schema.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	Default     string `protobuf:"bytes,7,opt,name=default,proto3" json:"default,omitempty"`
	ReadOnly    bool   `protobuf:"varint,8,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	// A free-form property to include a JSON example of this field. This is copied
	// verbatim to the output swagger.json. Quotes must be escaped.
	// This property is the same for 2.0 and 3.0.0 https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/3.0.0.md#schemaObject  https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
	Example    string  `protobuf:"bytes,9,opt,name=example,proto3" json:"example,omitempty"`
	MultipleOf float64 `protobuf:"fixed64,10,opt,name=multiple_of,json=multipleOf,proto3" json:"multiple_of,omitempty"`
	// Maximum represents an inclusive upper limit for a numeric instance. The
	// value of MUST be a number,
	Maximum          float64 `protobuf:"fixed64,11,opt,name=maximum,proto3" json:"maximum,omitempty"`
	ExclusiveMaximum bool    `protobuf:"varint,12,opt,name=exclusive_maximum,json=exclusiveMaximum,proto3" json:"exclusive_maximum,omitempty"`
	// minimum represents an inclusive lower limit for a numeric instance. The
	// value of MUST be a number,
	Minimum          float64  `protobuf:"fixed64,13,opt,name=minimum,proto3" json:"minimum,omitempty"`
	ExclusiveMinimum bool     `protobuf:"varint,14,opt,name=exclusive_minimum,json=exclusiveMinimum,proto3" json:"exclusive_minimum,omitempty"`
	MaxLength        uint64   `protobuf:"varint,15,opt,name=max_length,json=maxLength,proto3" json:"max_length,omitempty"`
	MinLength        uint64   `protobuf:"varint,16,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	Pattern          string   `protobuf:"bytes,17,opt,name=pattern,proto3" json:"pattern,omitempty"`
	MaxItems         uint64   `protobuf:"varint,20,opt,name=max_items,json=maxItems,proto3" json:"max_items,omitempty"`
	MinItems         uint64   `protobuf:"varint,21,opt,name=min_items,json=minItems,proto3" json:"min_items,omitempty"`
	UniqueItems      bool     `protobuf:"varint,22,opt,name=unique_items,json=uniqueItems,proto3" json:"unique_items,omitempty"`
	MaxProperties    uint64   `protobuf:"varint,24,opt,name=max_properties,json=maxProperties,proto3" json:"max_properties,omitempty"`
	MinProperties    uint64   `protobuf:"varint,25,opt,name=min_properties,json=minProperties,proto3" json:"min_properties,omitempty"`
	Required         []string `protobuf:"bytes,26,rep,name=required,proto3" json:"required,omitempty"`
	// Items in 'array' must be unique.
	Array []string                           `protobuf:"bytes,34,rep,name=array,proto3" json:"array,omitempty"`
	Type  []JSONSchema_JSONSchemaSimpleTypes `protobuf:"varint,35,rep,packed,name=type,proto3,enum=grpc.gateway.protoc_gen_swagger.options.JSONSchema_JSONSchemaSimpleTypes" json:"type,omitempty"`
	// `Format`
	Format string `protobuf:"bytes,36,opt,name=format,proto3" json:"format,omitempty"`
	// Items in `enum` must be unique https://tools.ietf.org/html/draft-fge-json-schema-validation-00#section-5.5.1
	Enum                 []string `protobuf:"bytes,46,rep,name=enum,proto3" json:"enum,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JSONSchema) Reset()         { *m = JSONSchema{} }
func (m *JSONSchema) String() string { return proto.CompactTextString(m) }
func (*JSONSchema) ProtoMessage()    {}
func (*JSONSchema) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{9}
}

func (m *JSONSchema) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JSONSchema.Unmarshal(m, b)
}
func (m *JSONSchema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JSONSchema.Marshal(b, m, deterministic)
}
func (m *JSONSchema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JSONSchema.Merge(m, src)
}
func (m *JSONSchema) XXX_Size() int {
	return xxx_messageInfo_JSONSchema.Size(m)
}
func (m *JSONSchema) XXX_DiscardUnknown() {
	xxx_messageInfo_JSONSchema.DiscardUnknown(m)
}

var xxx_messageInfo_JSONSchema proto.InternalMessageInfo

func (m *JSONSchema) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

func (m *JSONSchema) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *JSONSchema) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *JSONSchema) GetDefault() string {
	if m != nil {
		return m.Default
	}
	return ""
}

func (m *JSONSchema) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *JSONSchema) GetExample() string {
	if m != nil {
		return m.Example
	}
	return ""
}

func (m *JSONSchema) GetMultipleOf() float64 {
	if m != nil {
		return m.MultipleOf
	}
	return 0
}

func (m *JSONSchema) GetMaximum() float64 {
	if m != nil {
		return m.Maximum
	}
	return 0
}

func (m *JSONSchema) GetExclusiveMaximum() bool {
	if m != nil {
		return m.ExclusiveMaximum
	}
	return false
}

func (m *JSONSchema) GetMinimum() float64 {
	if m != nil {
		return m.Minimum
	}
	return 0
}

func (m *JSONSchema) GetExclusiveMinimum() bool {
	if m != nil {
		return m.ExclusiveMinimum
	}
	return false
}

func (m *JSONSchema) GetMaxLength() uint64 {
	if m != nil {
		return m.MaxLength
	}
	return 0
}

func (m *JSONSchema) GetMinLength() uint64 {
	if m != nil {
		return m.MinLength
	}
	return 0
}

func (m *JSONSchema) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

func (m *JSONSchema) GetMaxItems() uint64 {
	if m != nil {
		return m.MaxItems
	}
	return 0
}

func (m *JSONSchema) GetMinItems() uint64 {
	if m != nil {
		return m.MinItems
	}
	return 0
}

func (m *JSONSchema) GetUniqueItems() bool {
	if m != nil {
		return m.UniqueItems
	}
	return false
}

func (m *JSONSchema) GetMaxProperties() uint64 {
	if m != nil {
		return m.MaxProperties
	}
	return 0
}

func (m *JSONSchema) GetMinProperties() uint64 {
	if m != nil {
		return m.MinProperties
	}
	return 0
}

func (m *JSONSchema) GetRequired() []string {
	if m != nil {
		return m.Required
	}
	return nil
}

func (m *JSONSchema) GetArray() []string {
	if m != nil {
		return m.Array
	}
	return nil
}

func (m *JSONSchema) GetType() []JSONSchema_JSONSchemaSimpleTypes {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *JSONSchema) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *JSONSchema) GetEnum() []string {
	if m != nil {
		return m.Enum
	}
	return nil
}

// `Tag` is a representation of OpenAPI v2 specification's Tag object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#tagObject
//
type Tag struct {
	// A short description for the tag. GFM syntax can be used for rich text
	// representation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Additional external documentation for this tag.
	ExternalDocs         *ExternalDocumentation `protobuf:"bytes,3,opt,name=external_docs,json=externalDocs,proto3" json:"external_docs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Tag) Reset()         { *m = Tag{} }
func (m *Tag) String() string { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()    {}
func (*Tag) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{10}
}

func (m *Tag) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tag.Unmarshal(m, b)
}
func (m *Tag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tag.Marshal(b, m, deterministic)
}
func (m *Tag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tag.Merge(m, src)
}
func (m *Tag) XXX_Size() int {
	return xxx_messageInfo_Tag.Size(m)
}
func (m *Tag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tag.DiscardUnknown(m)
}

var xxx_messageInfo_Tag proto.InternalMessageInfo

func (m *Tag) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Tag) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

// `SecurityDefinitions` is a representation of OpenAPI v2 specification's
// Security Definitions object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityDefinitionsObject
//
// A declaration of the security schemes available to be used in the
// specification. This does not enforce the security schemes on the operations
// and only serves to provide the relevant details for each scheme.
type SecurityDefinitions struct {
	// A single security scheme definition, mapping a "name" to the scheme it
	// defines.
	Security             map[string]*SecurityScheme `protobuf:"bytes,1,rep,name=security,proto3" json:"security,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SecurityDefinitions) Reset()         { *m = SecurityDefinitions{} }
func (m *SecurityDefinitions) String() string { return proto.CompactTextString(m) }
func (*SecurityDefinitions) ProtoMessage()    {}
func (*SecurityDefinitions) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{11}
}

func (m *SecurityDefinitions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityDefinitions.Unmarshal(m, b)
}
func (m *SecurityDefinitions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityDefinitions.Marshal(b, m, deterministic)
}
func (m *SecurityDefinitions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityDefinitions.Merge(m, src)
}
func (m *SecurityDefinitions) XXX_Size() int {
	return xxx_messageInfo_SecurityDefinitions.Size(m)
}
func (m *SecurityDefinitions) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityDefinitions.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityDefinitions proto.InternalMessageInfo

func (m *SecurityDefinitions) GetSecurity() map[string]*SecurityScheme {
	if m != nil {
		return m.Security
	}
	return nil
}

// `SecurityScheme` is a representation of OpenAPI v2 specification's
// Security Scheme object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securitySchemeObject
//
// Allows the definition of a security scheme that can be used by the
// operations. Supported schemes are basic authentication, an API key (either as
// a header or as a query parameter) and OAuth2's common flows (implicit,
// password, application and access code).
type SecurityScheme struct {
	// The type of the security scheme. Valid values are "basic",
	// "apiKey" or "oauth2".
	Type SecurityScheme_Type `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Type" json:"type,omitempty"`
	// A short description for security scheme.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The name of the header or query parameter to be used.
	// Valid for apiKey.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The location of the API key. Valid values are "query" or
	// "header".
	// Valid for apiKey.
	In SecurityScheme_In `protobuf:"varint,4,opt,name=in,proto3,enum=grpc.gateway.protoc_gen_swagger.options.SecurityScheme_In" json:"in,omitempty"`
	// The flow used by the OAuth2 security scheme. Valid values are
	// "implicit", "password", "application" or "accessCode".
	// Valid for oauth2.
	Flow SecurityScheme_Flow `protobuf:"varint,5,opt,name=flow,proto3,enum=grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Flow" json:"flow,omitempty"`
	// The authorization URL to be used for this flow. This SHOULD be in
	// the form of a URL.
	// Valid for oauth2/implicit and oauth2/accessCode.
	AuthorizationUrl string `protobuf:"bytes,6,opt,name=authorization_url,json=authorizationUrl,proto3" json:"authorization_url,omitempty"`
	// The token URL to be used for this flow. This SHOULD be in the
	// form of a URL.
	// Valid for oauth2/password, oauth2/application and oauth2/accessCode.
	TokenUrl string `protobuf:"bytes,7,opt,name=token_url,json=tokenUrl,proto3" json:"token_url,omitempty"`
	// The available scopes for the OAuth2 security scheme.
	// Valid for oauth2.
	Scopes               *Scopes                   `protobuf:"bytes,8,opt,name=scopes,proto3" json:"scopes,omitempty"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,9,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *SecurityScheme) Reset()         { *m = SecurityScheme{} }
func (m *SecurityScheme) String() string { return proto.CompactTextString(m) }
func (*SecurityScheme) ProtoMessage()    {}
func (*SecurityScheme) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{12}
}

func (m *SecurityScheme) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityScheme.Unmarshal(m, b)
}
func (m *SecurityScheme) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityScheme.Marshal(b, m, deterministic)
}
func (m *SecurityScheme) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityScheme.Merge(m, src)
}
func (m *SecurityScheme) XXX_Size() int {
	return xxx_messageInfo_SecurityScheme.Size(m)
}
func (m *SecurityScheme) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityScheme.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityScheme proto.InternalMessageInfo

func (m *SecurityScheme) GetType() SecurityScheme_Type {
	if m != nil {
		return m.Type
	}
	return SecurityScheme_TYPE_INVALID
}

func (m *SecurityScheme) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *SecurityScheme) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SecurityScheme) GetIn() SecurityScheme_In {
	if m != nil {
		return m.In
	}
	return SecurityScheme_IN_INVALID
}

func (m *SecurityScheme) GetFlow() SecurityScheme_Flow {
	if m != nil {
		return m.Flow
	}
	return SecurityScheme_FLOW_INVALID
}

func (m *SecurityScheme) GetAuthorizationUrl() string {
	if m != nil {
		return m.AuthorizationUrl
	}
	return ""
}

func (m *SecurityScheme) GetTokenUrl() string {
	if m != nil {
		return m.TokenUrl
	}
	return ""
}

func (m *SecurityScheme) GetScopes() *Scopes {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *SecurityScheme) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `SecurityRequirement` is a representation of OpenAPI v2 specification's
// Security Requirement object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityRequirementObject
//
// Lists the required security schemes to execute this operation. The object can
// have multiple security schemes declared in it which are all required (that
// is, there is a logical AND between the schemes).
//
// The name used for each property MUST correspond to a security scheme
// declared in the Security Definitions.
type SecurityRequirement struct {
	// Each name must correspond to a security scheme which is declared in
	// the Security Definitions. If the security scheme is of type "oauth2",
	// then the value is a list of scope names required for the execution.
	// For other security scheme types, the array MUST be empty.
	SecurityRequirement  map[string]*SecurityRequirement_SecurityRequirementValue `protobuf:"bytes,1,rep,name=security_requirement,json=securityRequirement,proto3" json:"security_requirement,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                                 `json:"-"`
	XXX_unrecognized     []byte                                                   `json:"-"`
	XXX_sizecache        int32                                                    `json:"-"`
}

func (m *SecurityRequirement) Reset()         { *m = SecurityRequirement{} }
func (m *SecurityRequirement) String() string { return proto.CompactTextString(m) }
func (*SecurityRequirement) ProtoMessage()    {}
func (*SecurityRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{13}
}

func (m *SecurityRequirement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityRequirement.Unmarshal(m, b)
}
func (m *SecurityRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityRequirement.Marshal(b, m, deterministic)
}
func (m *SecurityRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityRequirement.Merge(m, src)
}
func (m *SecurityRequirement) XXX_Size() int {
	return xxx_messageInfo_SecurityRequirement.Size(m)
}
func (m *SecurityRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityRequirement proto.InternalMessageInfo

func (m *SecurityRequirement) GetSecurityRequirement() map[string]*SecurityRequirement_SecurityRequirementValue {
	if m != nil {
		return m.SecurityRequirement
	}
	return nil
}

// If the security scheme is of type "oauth2", then the value is a list of
// scope names required for the execution. For other security scheme types,
// the array MUST be empty.
type SecurityRequirement_SecurityRequirementValue struct {
	Scope                []string `protobuf:"bytes,1,rep,name=scope,proto3" json:"scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecurityRequirement_SecurityRequirementValue) Reset() {
	*m = SecurityRequirement_SecurityRequirementValue{}
}
func (m *SecurityRequirement_SecurityRequirementValue) String() string {
	return proto.CompactTextString(m)
}
func (*SecurityRequirement_SecurityRequirementValue) ProtoMessage() {}
func (*SecurityRequirement_SecurityRequirementValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{13, 0}
}

func (m *SecurityRequirement_SecurityRequirementValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Unmarshal(m, b)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Marshal(b, m, deterministic)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Merge(m, src)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_Size() int {
	return xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Size(m)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityRequirement_SecurityRequirementValue proto.InternalMessageInfo

func (m *SecurityRequirement_SecurityRequirementValue) GetScope() []string {
	if m != nil {
		return m.Scope
	}
	return nil
}

// `Scopes` is a representation of OpenAPI v2 specification's Scopes object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#scopesObject
//
// Lists the available scopes for an OAuth2 security scheme.
type Scopes struct {
	// Maps between a name of a scope to a short description of it (as the value
	// of the property).
	Scope                map[string]string `protobuf:"bytes,1,rep,name=scope,proto3" json:"scope,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Scopes) Reset()         { *m = Scopes{} }
func (m *Scopes) String() string { return proto.CompactTextString(m) }
func (*Scopes) ProtoMessage()    {}
func (*Scopes) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{14}
}

func (m *Scopes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Scopes.Unmarshal(m, b)
}
func (m *Scopes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Scopes.Marshal(b, m, deterministic)
}
func (m *Scopes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Scopes.Merge(m, src)
}
func (m *Scopes) XXX_Size() int {
	return xxx_messageInfo_Scopes.Size(m)
}
func (m *Scopes) XXX_DiscardUnknown() {
	xxx_messageInfo_Scopes.DiscardUnknown(m)
}

var xxx_messageInfo_Scopes proto.InternalMessageInfo

func (m *Scopes) GetScope() map[string]string {
	if m != nil {
		return m.Scope
	}
	return nil
}

func init() {
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.Swagger_SwaggerScheme", Swagger_SwaggerScheme_name, Swagger_SwaggerScheme_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.JSONSchema_JSONSchemaSimpleTypes", JSONSchema_JSONSchemaSimpleTypes_name, JSONSchema_JSONSchemaSimpleTypes_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Type", SecurityScheme_Type_name, SecurityScheme_Type_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.SecurityScheme_In", SecurityScheme_In_name, SecurityScheme_In_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Flow", SecurityScheme_Flow_name, SecurityScheme_Flow_value)
	proto.RegisterType((*Swagger)(nil), "grpc.gateway.protoc_gen_swagger.options.Swagger")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.Swagger.ExtensionsEntry")
	proto.RegisterMapType((map[string]*Response)(nil), "grpc.gateway.protoc_gen_swagger.options.Swagger.ResponsesEntry")
	proto.RegisterType((*Operation)(nil), "grpc.gateway.protoc_gen_swagger.options.Operation")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.Operation.ExtensionsEntry")
	proto.RegisterMapType((map[string]*Response)(nil), "grpc.gateway.protoc_gen_swagger.options.Operation.ResponsesEntry")
	proto.RegisterType((*Header)(nil), "grpc.gateway.protoc_gen_swagger.options.Header")
	proto.RegisterType((*Response)(nil), "grpc.gateway.protoc_gen_swagger.options.Response")
	proto.RegisterMapType((map[string]string)(nil), "grpc.gateway.protoc_gen_swagger.options.Response.ExamplesEntry")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.Response.ExtensionsEntry")
	proto.RegisterMapType((map[string]*Header)(nil), "grpc.gateway.protoc_gen_swagger.options.Response.HeadersEntry")
	proto.RegisterType((*Info)(nil), "grpc.gateway.protoc_gen_swagger.options.Info")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.Info.ExtensionsEntry")
	proto.RegisterType((*Contact)(nil), "grpc.gateway.protoc_gen_swagger.options.Contact")
	proto.RegisterType((*License)(nil), "grpc.gateway.protoc_gen_swagger.options.License")
	proto.RegisterType((*ExternalDocumentation)(nil), "grpc.gateway.protoc_gen_swagger.options.ExternalDocumentation")
	proto.RegisterType((*Schema)(nil), "grpc.gateway.protoc_gen_swagger.options.Schema")
	proto.RegisterType((*JSONSchema)(nil), "grpc.gateway.protoc_gen_swagger.options.JSONSchema")
	proto.RegisterType((*Tag)(nil), "grpc.gateway.protoc_gen_swagger.options.Tag")
	proto.RegisterType((*SecurityDefinitions)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityDefinitions")
	proto.RegisterMapType((map[string]*SecurityScheme)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityDefinitions.SecurityEntry")
	proto.RegisterType((*SecurityScheme)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityScheme")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityScheme.ExtensionsEntry")
	proto.RegisterType((*SecurityRequirement)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityRequirement")
	proto.RegisterMapType((map[string]*SecurityRequirement_SecurityRequirementValue)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityRequirement.SecurityRequirementEntry")
	proto.RegisterType((*SecurityRequirement_SecurityRequirementValue)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityRequirement.SecurityRequirementValue")
	proto.RegisterType((*Scopes)(nil), "grpc.gateway.protoc_gen_swagger.options.Scopes")
	proto.RegisterMapType((map[string]string)(nil), "grpc.gateway.protoc_gen_swagger.options.Scopes.ScopeEntry")
}

func init() {
	proto.RegisterFile("protoc-gen-swagger/options/openapiv2.proto", fileDescriptor_ba35ad8af024fb48)
}

var fileDescriptor_ba35ad8af024fb48 = []byte{
	// 2081 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x59, 0xcf, 0x73, 0xdb, 0xc6,
	0xf5, 0x0f, 0x48, 0x90, 0x5c, 0x3e, 0xfe, 0xd0, 0x7a, 0x2d, 0xfb, 0x8b, 0x30, 0xb6, 0xbf, 0x0a,
	0x1b, 0x4f, 0x35, 0x76, 0x4d, 0x25, 0xca, 0xa1, 0x99, 0xb4, 0x4d, 0x4b, 0x49, 0x8c, 0x4d, 0x58,
	0x26, 0x59, 0x90, 0x8a, 0xe3, 0x76, 0x3c, 0x2c, 0x04, 0x2e, 0x29, 0xc4, 0x04, 0xc0, 0x00, 0xa0,
	0x24, 0xf6, 0x2f, 0xe8, 0xb1, 0xd3, 0xe9, 0xb5, 0xff, 0x47, 0xcf, 0xfd, 0x0b, 0x7a, 0xec, 0xa5,
	0xe7, 0xde, 0xdb, 0xe9, 0xbd, 0xb3, 0x3f, 0x40, 0x02, 0x22, 0xed, 0x92, 0x72, 0xdc, 0x1e, 0x7a,
	0xe2, 0xee, 0x7b, 0xfb, 0x3e, 0xbb, 0x6f, 0xdf, 0x4f, 0x2c, 0xe1, 0xc1, 0xc4, 0xf7, 0x42, 0xcf,
	0x7a, 0x34, 0xa2, 0xee, 0xa3, 0xe0, 0xc2, 0x1c, 0x8d, 0xa8, 0xbf, 0xe7, 0x4d, 0x42, 0xdb, 0x73,
	0x83, 0x3d, 0x6f, 0x42, 0x5d, 0x73, 0x62, 0x9f, 0xef, 0xd7, 0xf8, 0x22, 0xf2, 0xfd, 0x91, 0x3f,
	0xb1, 0x6a, 0x23, 0x33, 0xa4, 0x17, 0xe6, 0x4c, 0xd0, 0xac, 0xfe, 0x88, 0xba, 0x7d, 0x29, 0x58,
	0x93, 0x82, 0x95, 0xf7, 0x47, 0x9e, 0x37, 0x1a, 0xd3, 0x3d, 0xbe, 0xe4, 0x74, 0x3a, 0xdc, 0x33,
	0x5d, 0xb9, 0xbe, 0x72, 0xe7, 0x2a, 0x2b, 0x08, 0xfd, 0xa9, 0x15, 0x0a, 0x6e, 0xf5, 0x8f, 0x08,
	0x72, 0x5d, 0x01, 0x46, 0x34, 0xc8, 0x49, 0x5c, 0x4d, 0xd9, 0x51, 0x76, 0xf3, 0x46, 0x34, 0x25,
	0x75, 0x50, 0x6d, 0x77, 0xe8, 0x69, 0xa9, 0x1d, 0x65, 0xb7, 0xb0, 0xff, 0xa8, 0xb6, 0xe6, 0xb1,
	0x6a, 0x4d, 0x77, 0xe8, 0x19, 0x5c, 0x94, 0x10, 0x50, 0xcf, 0xbc, 0x20, 0xd4, 0xd2, 0x1c, 0x99,
	0x8f, 0xc9, 0x07, 0x90, 0x3f, 0x35, 0x03, 0xda, 0x9f, 0x98, 0xe1, 0x99, 0xa6, 0x72, 0x06, 0x62,
	0x84, 0x8e, 0x19, 0x9e, 0x91, 0xaf, 0x21, 0x17, 0x58, 0x67, 0xd4, 0xa1, 0x81, 0x96, 0xd9, 0x49,
	0xef, 0x96, 0xf7, 0xbf, 0x58, 0x7b, 0x5b, 0xa9, 0x50, 0xf4, 0xdb, 0xe5, 0x30, 0x46, 0x04, 0x47,
	0x2a, 0x80, 0x2c, 0xcf, 0x0d, 0xa6, 0x0c, 0x3a, 0xbb, 0x93, 0x66, 0xbb, 0x46, 0x73, 0xc6, 0x9b,
	0xf8, 0xde, 0x60, 0x6a, 0xd1, 0x40, 0xcb, 0x09, 0x5e, 0x34, 0x27, 0x2f, 0x21, 0xef, 0xd3, 0x60,
	0xe2, 0xb9, 0x01, 0x0d, 0x34, 0xd8, 0x49, 0xef, 0x16, 0xf6, 0x7f, 0xba, 0xf1, 0x99, 0x8c, 0x08,
	0xa1, 0xe1, 0x86, 0xfe, 0xcc, 0x58, 0x20, 0x12, 0x0f, 0xb6, 0x03, 0x6a, 0x4d, 0x7d, 0x3b, 0x9c,
	0xf5, 0x07, 0x74, 0x68, 0xbb, 0x36, 0x97, 0xd4, 0x0a, 0xfc, 0xd2, 0x7f, 0xbc, 0xfe, 0x4e, 0x12,
	0xe4, 0x68, 0x81, 0x61, 0xdc, 0x0c, 0x96, 0x89, 0xe4, 0x6b, 0x40, 0x11, 0x59, 0x2b, 0x72, 0x75,
	0x36, 0xdf, 0xc4, 0xa0, 0xdf, 0x4e, 0x6d, 0x9f, 0x3a, 0xd4, 0x0d, 0x8d, 0x39, 0x1a, 0xb1, 0xa0,
	0x44, 0x2f, 0x43, 0xea, 0xbb, 0xe6, 0xb8, 0x3f, 0xf0, 0xac, 0x40, 0x2b, 0x73, 0x1d, 0xd6, 0xb7,
	0x60, 0x43, 0x4a, 0x1f, 0x79, 0xd6, 0x94, 0x61, 0x9b, 0x8c, 0x6c, 0x14, 0xe9, 0x82, 0x1c, 0x90,
	0x5f, 0x01, 0xb0, 0xb9, 0x1b, 0xf0, 0x5b, 0xda, 0xe2, 0x0a, 0xfc, 0x6c, 0x63, 0x7b, 0x34, 0xe6,
	0x10, 0xc2, 0x20, 0x31, 0xcc, 0x8a, 0x07, 0xe5, 0xa4, 0xb9, 0x08, 0x86, 0xf4, 0x2b, 0x3a, 0x93,
	0xe1, 0xc1, 0x86, 0xe4, 0x31, 0x64, 0xce, 0xcd, 0xf1, 0x94, 0xca, 0xd8, 0xf8, 0x64, 0xed, 0x03,
	0x44, 0xc8, 0x86, 0x90, 0xff, 0x3c, 0xf5, 0x99, 0x52, 0x39, 0x81, 0xad, 0x2b, 0xe7, 0x59, 0xb1,
	0xe3, 0x0f, 0x92, 0x3b, 0xde, 0xae, 0x89, 0x00, 0xaf, 0x45, 0x01, 0x5e, 0xfb, 0x8a, 0x71, 0x63,
	0xb0, 0xd5, 0x03, 0x28, 0x25, 0x42, 0x81, 0x14, 0x20, 0x77, 0xd2, 0x7a, 0xda, 0x6a, 0x3f, 0x6f,
	0xe1, 0xf7, 0x08, 0x02, 0xf5, 0x49, 0xaf, 0xd7, 0xc1, 0x0a, 0xc9, 0x43, 0x86, 0x8d, 0xba, 0x38,
	0x45, 0xb2, 0x90, 0x7a, 0xde, 0xc5, 0x69, 0x92, 0x83, 0xf4, 0xf3, 0x6e, 0x17, 0xab, 0xba, 0x8a,
	0x10, 0xce, 0xeb, 0x2a, 0xca, 0x63, 0xd0, 0x55, 0x54, 0xc2, 0xe5, 0xea, 0x9f, 0xb2, 0x90, 0x6f,
	0x4f, 0xa8, 0xcf, 0x6d, 0xc3, 0xe2, 0x3b, 0x34, 0x47, 0x81, 0xa6, 0xf0, 0xa0, 0xe1, 0x63, 0x9e,
	0x50, 0xa6, 0x8e, 0x63, 0xfa, 0x33, 0x7e, 0x56, 0x96, 0x50, 0xc4, 0x94, 0xec, 0x40, 0x61, 0x40,
	0x03, 0xcb, 0xb7, 0xf9, 0x65, 0xc8, 0xa4, 0x10, 0x27, 0x2d, 0xbb, 0x90, 0xfa, 0x0e, 0x5c, 0xe8,
	0x43, 0x28, 0x7a, 0x91, 0x06, 0x7d, 0x7b, 0xa0, 0x65, 0xc4, 0x39, 0xe6, 0xb4, 0xe6, 0xe0, 0xda,
	0xc9, 0xa2, 0x1f, 0x4f, 0x16, 0x79, 0xee, 0x9c, 0xf5, 0xb5, 0xcf, 0x3e, 0xbf, 0xd6, 0x37, 0xa4,
	0x0b, 0x6d, 0x91, 0x1f, 0x81, 0xef, 0x3d, 0xcf, 0x6f, 0xf7, 0x00, 0x06, 0x74, 0xe2, 0x53, 0xcb,
	0x0c, 0xe9, 0x80, 0xa7, 0x0f, 0x64, 0xc4, 0x28, 0xef, 0x30, 0xee, 0x4f, 0x13, 0x21, 0x59, 0xe2,
	0xd8, 0x07, 0xd7, 0xd0, 0xfa, 0x7f, 0x20, 0x28, 0x45, 0x40, 0x55, 0xff, 0xa2, 0x40, 0xf6, 0x09,
	0x35, 0x07, 0xd4, 0xbf, 0x1a, 0x13, 0xca, 0x72, 0x4c, 0xb0, 0x18, 0x9b, 0x4d, 0xa8, 0x0c, 0x26,
	0x3e, 0x26, 0xb7, 0x21, 0x3b, 0xf4, 0x7c, 0xc7, 0x8c, 0x2a, 0xab, 0x9c, 0x31, 0xf7, 0x18, 0xd0,
	0xa1, 0x39, 0x1d, 0x87, 0x5a, 0x56, 0xc4, 0x9e, 0x9c, 0x32, 0xce, 0xc4, 0x0c, 0x59, 0x14, 0x68,
	0x25, 0xc1, 0x91, 0x53, 0x5d, 0x45, 0x2a, 0xce, 0xe8, 0x2a, 0xca, 0xe0, 0xac, 0xae, 0xa2, 0x1c,
	0x46, 0x57, 0xa2, 0x1e, 0x70, 0x41, 0x57, 0x51, 0x01, 0x17, 0x75, 0x15, 0x15, 0x71, 0x49, 0x57,
	0x51, 0x19, 0x6f, 0xe9, 0x2a, 0xda, 0xc2, 0x58, 0x57, 0x11, 0xc6, 0x37, 0x74, 0x15, 0xdd, 0xc0,
	0x44, 0x57, 0x11, 0xc1, 0x37, 0xab, 0xbf, 0xcd, 0x00, 0x8a, 0xee, 0x73, 0x0d, 0xe5, 0x1e, 0x43,
	0x96, 0x3b, 0xb0, 0x29, 0xaf, 0x70, 0x6f, 0x7d, 0x9f, 0xe4, 0x62, 0x86, 0x14, 0x67, 0x8d, 0xc3,
	0x19, 0xbf, 0xd1, 0x40, 0x4b, 0x73, 0x0f, 0xfc, 0x62, 0x63, 0xf3, 0xd7, 0x84, 0x49, 0xa4, 0xf7,
	0x45, 0x70, 0xe4, 0x97, 0x80, 0xe8, 0xa5, 0xe9, 0x4c, 0xc6, 0x94, 0xa5, 0xa3, 0xcd, 0xea, 0xff,
	0x1c, 0xba, 0x21, 0x11, 0x04, 0xf6, 0x1c, 0x90, 0x98, 0x89, 0xd8, 0xc9, 0x6c, 0x98, 0x31, 0x62,
	0xf0, 0xaf, 0x0f, 0x9d, 0x57, 0x50, 0x8c, 0x2b, 0xb6, 0xc2, 0x8d, 0x1b, 0x49, 0x37, 0x5e, 0xdf,
	0x06, 0x02, 0x37, 0x1e, 0x36, 0x3f, 0x82, 0x52, 0x42, 0xd5, 0x15, 0xbb, 0x6d, 0xc7, 0x77, 0xcb,
	0xff, 0x07, 0x0a, 0xe1, 0x9f, 0xd3, 0xa0, 0xb2, 0x9e, 0x94, 0xed, 0x1c, 0xda, 0xe1, 0x98, 0x4a,
	0x38, 0x31, 0xb9, 0xea, 0xa4, 0xa9, 0x65, 0x27, 0xdd, 0x05, 0x1c, 0x52, 0xdf, 0x09, 0xfa, 0xde,
	0xb0, 0x1f, 0x50, 0xff, 0xdc, 0xb6, 0xa8, 0x8c, 0xbb, 0x32, 0xa7, 0xb7, 0x87, 0x5d, 0x41, 0x25,
	0x3a, 0xe4, 0x2c, 0xcf, 0x0d, 0x4d, 0x2b, 0x94, 0x95, 0xeb, 0xe3, 0xb5, 0xef, 0xf2, 0x50, 0xc8,
	0x19, 0x11, 0x00, 0xc3, 0x1a, 0xdb, 0x16, 0x75, 0x03, 0xca, 0x2b, 0xd4, 0x26, 0x58, 0xc7, 0x42,
	0xce, 0x88, 0x00, 0x58, 0xf4, 0x9f, 0x53, 0x9f, 0xdd, 0x6b, 0x94, 0x17, 0xe4, 0x94, 0xbc, 0x4c,
	0x38, 0x60, 0x8e, 0x3b, 0xe0, 0x4f, 0x36, 0x6a, 0xf5, 0xdf, 0xe8, 0x7c, 0xef, 0xc8, 0xa4, 0x0d,
	0xc8, 0xc9, 0xfb, 0x62, 0xe9, 0xd1, 0x35, 0x9d, 0xc8, 0xa6, 0x7c, 0xcc, 0xb6, 0x98, 0xfa, 0x63,
	0x69, 0x4a, 0x36, 0x64, 0xa6, 0xa7, 0x8e, 0x69, 0x8f, 0xa5, 0xdd, 0xc4, 0xa4, 0xba, 0x07, 0x39,
	0x79, 0x55, 0xeb, 0xc1, 0x54, 0x9f, 0xc2, 0xad, 0x95, 0x1d, 0xc6, 0x1a, 0x99, 0x6e, 0x19, 0xec,
	0x6f, 0x29, 0xc8, 0x8a, 0x2c, 0x46, 0x7a, 0x50, 0xf8, 0x26, 0xf0, 0xdc, 0xbe, 0xcc, 0x85, 0x0a,
	0xbf, 0x87, 0x4f, 0xd7, 0x36, 0x83, 0xde, 0x6d, 0xb7, 0x64, 0x3e, 0x04, 0x86, 0x23, 0x51, 0x3f,
	0x82, 0xd2, 0xc0, 0x66, 0x27, 0x70, 0x6c, 0xd7, 0x0c, 0x3d, 0x5f, 0x6e, 0x9e, 0x24, 0xb2, 0xef,
	0x31, 0x9f, 0x9a, 0x83, 0xbe, 0xe7, 0x8e, 0x67, 0xfc, 0x7a, 0x90, 0x81, 0x18, 0xa1, 0xed, 0x8e,
	0x57, 0xf4, 0xf4, 0x99, 0x77, 0xd0, 0x90, 0xed, 0x43, 0x4e, 0x26, 0x44, 0xee, 0x9d, 0x85, 0xfd,
	0xed, 0x25, 0x0f, 0xa8, 0xbb, 0xb3, 0x83, 0x94, 0xa6, 0x18, 0xd1, 0x42, 0x72, 0x1f, 0xca, 0x72,
	0xd8, 0x0f, 0x42, 0xdf, 0x76, 0x47, 0x5a, 0x4e, 0x28, 0x27, 0xa9, 0x5d, 0x4e, 0x14, 0xc5, 0xad,
	0xfa, 0xd7, 0x1c, 0xc0, 0xe2, 0x8e, 0x98, 0x29, 0x7c, 0x3a, 0x94, 0xae, 0xc0, 0x86, 0x8b, 0xcc,
	0x90, 0x79, 0x43, 0x66, 0xc8, 0x2e, 0x1b, 0x35, 0x56, 0x6f, 0x73, 0xc9, 0x7a, 0x9b, 0xb8, 0x55,
	0x74, 0xe5, 0x56, 0xb5, 0x85, 0xc2, 0x79, 0x21, 0x16, 0xa9, 0xf5, 0xff, 0x50, 0x70, 0xa6, 0xe3,
	0xd0, 0x66, 0x7a, 0x79, 0x43, 0x0d, 0x76, 0x94, 0x5d, 0xc5, 0x80, 0x88, 0xd4, 0x1e, 0x32, 0x51,
	0xc7, 0xbc, 0xb4, 0x9d, 0xa9, 0xc3, 0x7b, 0x3c, 0xc5, 0x88, 0xa6, 0xe4, 0x21, 0xdc, 0xa0, 0x97,
	0xd6, 0x78, 0x1a, 0xd8, 0xe7, 0xb4, 0x1f, 0xad, 0x29, 0xf2, 0x9d, 0xf1, 0x9c, 0xf1, 0x4c, 0x2e,
	0x66, 0x30, 0xb6, 0xcb, 0x97, 0x94, 0x24, 0x8c, 0x98, 0x5e, 0x81, 0x91, 0x6b, 0xca, 0x57, 0x61,
	0xe4, 0xe2, 0xbb, 0x00, 0x8e, 0x79, 0xd9, 0x1f, 0x53, 0x77, 0x14, 0x9e, 0x69, 0x5b, 0x3b, 0xca,
	0xae, 0x6a, 0xe4, 0x1d, 0xf3, 0xf2, 0x98, 0x13, 0x38, 0xdb, 0x76, 0x23, 0x36, 0x96, 0x6c, 0xdb,
	0x95, 0xec, 0x58, 0x4f, 0x72, 0x23, 0xd1, 0x93, 0xb0, 0xdb, 0x63, 0xb8, 0x76, 0x48, 0x9d, 0x40,
	0xdb, 0xe6, 0x72, 0xc8, 0x31, 0x2f, 0x9b, 0x6c, 0xce, 0x99, 0xb6, 0x2b, 0x99, 0xb7, 0x24, 0xd3,
	0x76, 0x05, 0xf3, 0x43, 0x28, 0x4e, 0x5d, 0xfb, 0xdb, 0x29, 0x95, 0xfc, 0xdb, 0xfc, 0xe4, 0x05,
	0x41, 0x13, 0x4b, 0xee, 0x43, 0x99, 0x81, 0x4f, 0x7c, 0xd6, 0xf1, 0x87, 0x36, 0x0d, 0x34, 0x8d,
	0x83, 0x94, 0x1c, 0xf3, 0xb2, 0x33, 0x27, 0xf2, 0x65, 0xb6, 0x1b, 0x5f, 0xf6, 0xbe, 0x5c, 0x66,
	0xbb, 0xb1, 0x65, 0x15, 0x40, 0xbe, 0x68, 0x8b, 0x07, 0x5a, 0x45, 0x7c, 0x0e, 0x44, 0x73, 0xe6,
	0x56, 0xa6, 0xef, 0x9b, 0x33, 0xad, 0xca, 0x19, 0x62, 0x42, 0x5e, 0xca, 0x86, 0xee, 0x7b, 0xfc,
	0x81, 0xa3, 0x79, 0x8d, 0x28, 0x8f, 0x0d, 0xbb, 0x36, 0xf3, 0x9b, 0xde, 0x6c, 0x42, 0x83, 0xa5,
	0xde, 0xf0, 0xa3, 0x44, 0x6f, 0x48, 0x40, 0xa5, 0xee, 0xd4, 0xd1, 0x6a, 0xe2, 0x5b, 0x8d, 0x8d,
	0xab, 0x17, 0x70, 0x6b, 0x25, 0x54, 0xf2, 0x5b, 0x31, 0x0f, 0x99, 0xba, 0x61, 0xd4, 0x5f, 0x60,
	0x85, 0xd1, 0x0f, 0xda, 0xed, 0xe3, 0x46, 0xbd, 0x85, 0x53, 0x6c, 0xd2, 0x6c, 0xf5, 0x1a, 0x8f,
	0x1b, 0x06, 0x4e, 0xb3, 0x0f, 0xca, 0xd6, 0xc9, 0xf1, 0x31, 0x56, 0x09, 0x40, 0xb6, 0x75, 0xf2,
	0xec, 0xa0, 0x61, 0xe0, 0x0c, 0x1b, 0xb7, 0x0f, 0xf4, 0xc6, 0x61, 0x0f, 0x67, 0xd9, 0xb8, 0xdb,
	0x33, 0x9a, 0xad, 0xc7, 0x38, 0xa7, 0xab, 0x48, 0xc1, 0x29, 0x5d, 0x45, 0x29, 0x9c, 0x9e, 0x37,
	0xa0, 0x04, 0xdf, 0xd4, 0x55, 0x74, 0x13, 0x6f, 0xeb, 0x2a, 0xfa, 0x3f, 0xac, 0xe9, 0x2a, 0xfa,
	0x00, 0xdf, 0xd1, 0x55, 0x74, 0x07, 0xdf, 0xd5, 0x55, 0x74, 0x17, 0xdf, 0xd3, 0x55, 0x74, 0x0f,
	0x57, 0x75, 0x15, 0xdd, 0xc7, 0x0f, 0x74, 0x15, 0x3d, 0xc0, 0x0f, 0x75, 0x15, 0x3d, 0xc4, 0xb5,
	0xea, 0xef, 0x14, 0x48, 0xf7, 0xcc, 0xd1, 0x1a, 0xa5, 0x7c, 0x29, 0x9f, 0xa5, 0xbf, 0xfb, 0x7c,
	0x26, 0x94, 0xab, 0xfe, 0x43, 0x81, 0x9b, 0x2b, 0x5e, 0x65, 0xc8, 0x30, 0xf6, 0x21, 0xa6, 0xf0,
	0x7a, 0xab, 0xbf, 0xcd, 0x2b, 0xcf, 0x9c, 0x26, 0x5b, 0xcb, 0x08, 0xbb, 0x12, 0x42, 0x29, 0xc1,
	0x5a, 0x51, 0x78, 0x9f, 0x25, 0x0b, 0xef, 0x0f, 0x37, 0x3e, 0x87, 0x7c, 0x64, 0x8b, 0x55, 0xe6,
	0x7f, 0x66, 0xa1, 0x9c, 0xe4, 0x92, 0x8e, 0xf4, 0x77, 0xb6, 0x71, 0xf9, 0x1a, 0x5f, 0x9d, 0x02,
	0xa6, 0xc6, 0x1c, 0x53, 0xba, 0xf8, 0xbf, 0xb7, 0x73, 0x54, 0xce, 0xd3, 0xb1, 0x72, 0xae, 0x43,
	0xca, 0x76, 0x79, 0x5f, 0x56, 0xde, 0xff, 0xfc, 0xba, 0xa7, 0x68, 0xba, 0x46, 0xca, 0x76, 0x99,
	0x4e, 0xc3, 0xb1, 0x77, 0xc1, 0xeb, 0xc5, 0x5b, 0xe8, 0xf4, 0xe5, 0xd8, 0xbb, 0x30, 0x38, 0x12,
	0xcb, 0xbb, 0xe6, 0x34, 0x3c, 0xf3, 0x7c, 0xfb, 0xd7, 0xe2, 0x65, 0x82, 0x75, 0x0b, 0xa2, 0xe4,
	0xe0, 0x04, 0xe3, 0xc4, 0x1f, 0xb3, 0x14, 0x18, 0x7a, 0xaf, 0xa8, 0x58, 0x24, 0x2a, 0x0f, 0xe2,
	0x04, 0xc6, 0xe4, 0xdf, 0x54, 0xde, 0x84, 0x06, 0xbc, 0xee, 0x6c, 0xf6, 0x4d, 0xc5, 0xc4, 0x0c,
	0x29, 0x4e, 0x46, 0x89, 0xde, 0x50, 0x3c, 0x67, 0x3c, 0xbe, 0xae, 0xaa, 0xff, 0x85, 0x2e, 0xf1,
	0x29, 0xa8, 0xcc, 0x69, 0x08, 0x86, 0x62, 0xef, 0x45, 0xa7, 0xd1, 0x6f, 0xb6, 0xbe, 0xaa, 0x1f,
	0x37, 0x8f, 0xf0, 0x7b, 0xa4, 0x0c, 0xc0, 0x29, 0x07, 0xf5, 0x6e, 0xf3, 0x10, 0x2b, 0xf3, 0x15,
	0xf5, 0x4e, 0xb3, 0xff, 0xb4, 0xf1, 0x02, 0xa7, 0xc8, 0x16, 0x14, 0x38, 0xa5, 0x5d, 0x3f, 0xe9,
	0x3d, 0xd9, 0xc7, 0xe9, 0xea, 0x27, 0x90, 0x6a, 0xba, 0x4c, 0xb0, 0xd9, 0x8a, 0x01, 0x15, 0x01,
	0x35, 0x5b, 0xfd, 0x9f, 0x9f, 0x34, 0x0c, 0x96, 0x1d, 0x4b, 0x90, 0x6f, 0xb6, 0xfa, 0x4f, 0x1a,
	0xf5, 0xa3, 0x86, 0x81, 0x53, 0xd5, 0x6f, 0x40, 0x65, 0x06, 0x66, 0xe8, 0x5f, 0x1e, 0xb7, 0x9f,
	0xc7, 0xc4, 0x6e, 0x40, 0x49, 0x50, 0x9e, 0x75, 0x8e, 0x9b, 0x87, 0xcd, 0x1e, 0x56, 0xe6, 0xa4,
	0x4e, 0xbd, 0xdb, 0x7d, 0xde, 0x36, 0x8e, 0x70, 0x8a, 0x6c, 0x03, 0xe6, 0xa4, 0x7a, 0x87, 0xad,
	0xaa, 0xf7, 0x9a, 0xed, 0x16, 0x4e, 0x2f, 0xa8, 0x87, 0x87, 0x8d, 0x6e, 0xb7, 0x7f, 0xd8, 0x3e,
	0x6a, 0x60, 0xb5, 0xfa, 0xf7, 0xd4, 0x22, 0xdb, 0xc4, 0x9e, 0x69, 0xc8, 0x6f, 0x94, 0xd8, 0x03,
	0xb3, 0xbf, 0x60, 0xc8, 0xd4, 0x73, 0xf2, 0x36, 0x6f, 0x40, 0xab, 0x68, 0xc2, 0xb8, 0xf3, 0x97,
	0xe7, 0x18, 0xa7, 0xf2, 0x31, 0x68, 0x2b, 0x04, 0xb8, 0xd5, 0x58, 0xa5, 0xe4, 0x4e, 0x27, 0x5f,
	0x12, 0xc5, 0xa4, 0xf2, 0x07, 0x65, 0xa5, 0xc8, 0xeb, 0x3c, 0xe4, 0x55, 0xd2, 0x43, 0xbe, 0x73,
	0xdd, 0x96, 0x1c, 0xec, 0xf7, 0x0a, 0xeb, 0xe0, 0x79, 0xac, 0x74, 0xe2, 0x0a, 0x14, 0x36, 0xc9,
	0x2f, 0x5c, 0x5e, 0xfc, 0x88, 0xcb, 0x93, 0xca, 0x7f, 0x06, 0xb0, 0x20, 0x6e, 0xf2, 0x1d, 0x7d,
	0x70, 0xf8, 0x8b, 0xfa, 0xc8, 0x0e, 0xcf, 0xa6, 0xa7, 0x35, 0xcb, 0x73, 0xf6, 0xd8, 0x41, 0x1e,
	0x51, 0xcb, 0x0b, 0x66, 0x41, 0x48, 0xe5, 0x54, 0x9e, 0x6b, 0xef, 0xf5, 0xff, 0x4a, 0x9d, 0x66,
	0x39, 0xef, 0xd3, 0x7f, 0x05, 0x00, 0x00, 0xff, 0xff, 0x2f, 0xcd, 0x75, 0x32, 0xba, 0x1a, 0x00,
	0x00,
}
