/***************************************************************************
                       menu.cpp  -  menu object class
                             -------------------
    begin                : Tue Oct 14 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cob.hxx"

//	**************************************************************************************************************************
//
//                                             Create a Menu Object
//
//	**************************************************************************************************************************

MenuObject::MenuObject(int y,char *opts)
{
    rc.Top = 484+y*60;rc.Bottom = rc.Top+60;
    rc.Left = 256;rc.Right = 768;
    Options = opts;
    selected = 0;
    selcount = 1;
    while (*opts != '\0')
        if (*opts++ == ':') selcount++;
}

//	**************************************************************************************************************************
//
//                                             Paint a menu object
//
//	**************************************************************************************************************************

void MenuObject::Paint(void)
{
    DisplaySurface disp;
    Rect rs;
    char Buffer[64];
    GetItem(Buffer,selected);
    disp.SetColour(0,0,0);disp.FillRect(rc);
    rs.Top = rc.Top+8;rs.Bottom = rc.Bottom-4;
    rs.Left = 512-strlen(Buffer)*16;
    rs.Right = 512+strlen(Buffer)*16;
    disp.SetColour(255,255,0);disp.String(rs,Buffer);
    disp.Flip();
}

//	**************************************************************************************************************************
//
//                                    Get text associated with a menu entry
//
//	**************************************************************************************************************************

void MenuObject::GetItem(char *buffer,int selected)
{
    char *p = Options;
    char *s = buffer;
    while (selected-- > 0)
    {
        while (*p != ':' && *p != '\0') p++;
        if (*p == ':') p++;
    }
    while (*p != ':' && *p != '\0')
        *buffer++ = *p++;
    *buffer = '\0';
}

//	**************************************************************************************************************************
//
//                                             Click on a menu object
//
//	**************************************************************************************************************************

int MenuObject::Click(int x,int y)
{
    if (x < rc.Left || x > rc.Right) return 0;
    if (y < rc.Top || y > rc.Bottom) return 0;
    selected++;
    if (selected == selcount) selected = 0;
    return 1;
}
